/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;

public class TrimStrideWrapper
extends AbstractDataSet {
    QDataSet ds;
    int[] offset;
    int[] len;
    int[] stride;
    int[] qube;

    public TrimStrideWrapper(QDataSet ds) {
        this.ds = ds;
        this.len = DataSetUtil.qubeDims(ds);
        this.qube = DataSetUtil.qubeDims(ds);
        this.offset = new int[ds.rank()];
        this.stride = new int[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            this.stride[i] = 1;
        }
        if (DataSetUtil.isQube(ds)) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
        DataSetUtil.copyDimensionProperties(ds, this);
    }

    public void setTrim(int dim, Number start, Number stop, Number stride) {
        int sstop;
        if (this.isImmutable()) {
            throw new IllegalArgumentException("data set is immutable");
        }
        this.stride[dim] = stride == null ? 1 : stride.intValue();
        int step1 = this.stride[dim];
        int dftStart = step1 >= 0 ? 0 : -1;
        int dftStop = step1 >= 0 ? this.qube[dim] : -1 - this.qube[dim];
        int sstart = start == null ? dftStart : start.intValue();
        int n = sstop = stop == null ? dftStop : stop.intValue();
        if (sstop > this.qube[dim]) {
            throw new IndexOutOfBoundsException("stop is greater than qube dimension: " + stop + ">" + this.qube[dim]);
        }
        if (sstop < 0) {
            sstop = this.qube[dim] + sstop;
        }
        if (sstart < 0) {
            sstart = this.qube[dim] + sstart;
        }
        this.offset[dim] = sstart;
        this.len[dim] = (int)Math.ceil(1.0 * (double)(sstop - sstart) / (double)this.stride[dim]);
        QDataSet dep = (QDataSet)this.ds.property("DEPEND_" + dim);
        if (dep != null) {
            TrimStrideWrapper depw;
            if (dep.rank() == 1) {
                depw = new TrimStrideWrapper(dep);
                depw.setTrim(0, start, stop, stride);
                this.putProperty("DEPEND_" + dim, depw);
            } else if (dep.rank() == 2) {
                if (dim == 0) {
                    depw = new TrimStrideWrapper(dep);
                    depw.setTrim(0, start, stop, stride);
                    this.putProperty("DEPEND_" + dim, depw);
                } else {
                    depw = new TrimStrideWrapper(dep);
                    depw.setTrim(1, start, stop, stride);
                    this.putProperty("DEPEND_" + dim, depw);
                }
            } else if (dep.rank() > 2) {
                depw = new TrimStrideWrapper(dep);
                depw.setTrim(dim, start, stop, stride);
                this.putProperty("DEPEND_" + dim, depw);
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (i == dim) continue;
            QDataSet depi = (QDataSet)this.ds.property("DEPEND_" + i);
            if (depi != null) {
                if (depi.rank() > 2) {
                    TrimStrideWrapper depw = new TrimStrideWrapper(depi);
                    depw.setTrim(dim, start, stop, stride);
                    depi = depw;
                }
                this.putProperty("DEPEND_" + i, depi);
            }
            if ((depi = (QDataSet)this.ds.property("BUNDLE_" + i)) != null) {
                this.putProperty("BUNDLE_" + i, depi);
            }
            if ((depi = (QDataSet)this.ds.property("BINS_" + i)) == null) continue;
            this.putProperty("BINS_" + i, depi);
        }
    }

    @Override
    public int rank() {
        return this.ds.rank();
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.ds.value(this.offset[0] + this.stride[0] * i0, this.offset[1] + this.stride[1] * i1, this.offset[2] + this.stride[2] * i2, this.offset[3] + this.stride[3] * i3);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.ds.value(this.offset[0] + this.stride[0] * i0, this.offset[1] + this.stride[1] * i1, this.offset[2] + this.stride[2] * i2);
    }

    @Override
    public double value(int i0, int i1) {
        return this.ds.value(this.offset[0] + this.stride[0] * i0, this.offset[1] + this.stride[1] * i1);
    }

    @Override
    public double value(int i0) {
        return this.ds.value(this.offset[0] + this.stride[0] * i0);
    }

    @Override
    public int length(int i, int j, int k) {
        return this.len[3];
    }

    @Override
    public int length(int i, int j) {
        return this.len[2];
    }

    @Override
    public int length(int i) {
        return this.len[1];
    }

    @Override
    public int length() {
        return this.len[0];
    }

    @Override
    public Object property(String name) {
        if (name.startsWith("PLANE_")) {
            QDataSet plane = (QDataSet)this.ds.property(name);
            if (plane == null) {
                return null;
            }
            TrimStrideWrapper wrap = new TrimStrideWrapper(plane);
            wrap.setTrim(0, this.offset[0], this.len[0], this.stride[0]);
            return wrap;
        }
        return super.property(name);
    }
}

