/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.buffer;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.CacheTag;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.BDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FDataSet;
import org.das2.qds.IDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.AsciiDataSet;
import org.das2.qds.buffer.ByteDataSet;
import org.das2.qds.buffer.DoubleDataSet;
import org.das2.qds.buffer.FloatDataSet;
import org.das2.qds.buffer.Int24DataSet;
import org.das2.qds.buffer.IntDataSet;
import org.das2.qds.buffer.LongDataSet;
import org.das2.qds.buffer.NybbleDataSet;
import org.das2.qds.buffer.ShortDataSet;
import org.das2.qds.buffer.TimeDataSet;
import org.das2.qds.buffer.TruncatedFloatDataSet;
import org.das2.qds.buffer.UByteDataSet;
import org.das2.qds.buffer.UInt24DataSet;
import org.das2.qds.buffer.UIntDataSet;
import org.das2.qds.buffer.UShortDataSet;
import org.das2.qds.buffer.VaxFloatDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public abstract class BufferDataSet
extends AbstractDataSet
implements WritableDataSet {
    protected static final Logger logger = LoggerManager.getLogger((String)"qdataset.bufferdataset");
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    int reclen;
    int recStride;
    int recoffset;
    private int fieldLen;
    private int fieldStride;
    Object type;
    protected ByteBuffer back;
    private static final boolean RANGE_CHECK = true;
    public static final Object DOUBLE = "double";
    public static final Object FLOAT = "float";
    public static final Object TRUNCATEDFLOAT = "truncatedfloat";
    public static final Object VAX_FLOAT = "vaxfloat";
    public static final Object INT24 = "int24";
    public static final Object UINT24 = "uint24";
    public static final Object NYBBLE = "nybble";
    public static final Object LONG = "long";
    public static final Object INT = "int";
    public static final Object INTEGER = "integer";
    public static final Object UINT = "uint";
    public static final Object SHORT = "short";
    public static final Object USHORT = "ushort";
    public static final Object BYTE = "byte";
    public static final Object UBYTE = "ubyte";
    public static final Object BYTES = "bytes";
    public static final Object BITS = "bits";
    private static long gcCounter = 0L;
    private static int allocateDirect = -1;

    public static int bitCount(Object type) {
        if (type.equals(NYBBLE)) {
            return 4;
        }
        return BufferDataSet.byteCount(type) * 8;
    }

    public static int byteCount(Object type) {
        if (type.equals(DOUBLE)) {
            return 8;
        }
        if (type.equals(FLOAT)) {
            return 4;
        }
        if (type.equals(VAX_FLOAT)) {
            return 4;
        }
        if (type.equals(NYBBLE)) {
            throw new IllegalArgumentException("NYBBLE must be used with bitCount and makeDataSetBits");
        }
        if (type.equals(INT24)) {
            return 3;
        }
        if (type.equals(UINT24)) {
            return 3;
        }
        if (type.equals(LONG)) {
            return 8;
        }
        if (type.equals(INT)) {
            return 4;
        }
        if (type.equals(INTEGER)) {
            return 4;
        }
        if (type.equals(UINT)) {
            return 4;
        }
        if (type.equals(TRUNCATEDFLOAT)) {
            return 2;
        }
        if (type.equals(SHORT)) {
            return 2;
        }
        if (type.equals(USHORT)) {
            return 2;
        }
        if (type.equals(BYTE)) {
            return 1;
        }
        if (type.equals(UBYTE)) {
            return 1;
        }
        if (type.toString().startsWith("time")) {
            return Integer.parseInt(type.toString().substring(4));
        }
        if (type.toString().startsWith("ascii")) {
            return Integer.parseInt(type.toString().substring(5));
        }
        throw new IllegalArgumentException("bad type: " + type);
    }

    public static BufferDataSet makeDataSetBits(int rank, int reclenbits, int recoffsbits, int len0, int len1, int len2, int len3, ByteBuffer buf, Object type) {
        if (rank == 1 && len1 > 1) {
            throw new IllegalArgumentException("rank is 1, but len1 is not 1");
        }
        int nperRec = len1 * len2 * len3;
        if (reclenbits < BufferDataSet.bitCount(type)) {
            throw new IllegalArgumentException("reclenbits " + reclenbits + " is smaller than length of type " + type);
        }
        if (reclenbits < nperRec * BufferDataSet.bitCount(type)) {
            throw new IllegalArgumentException("reclenbits " + reclenbits + " is smaller than length of " + nperRec + " type " + type);
        }
        if ((long)reclenbits * (long)len0 / 8L > (long)buf.limit()) {
            throw new IllegalArgumentException(String.format("buffer length (%d bytes) is too small to contain data (%d %d-bit records)", buf.limit(), len0, reclenbits));
        }
        if (!type.equals(NYBBLE)) {
            return BufferDataSet.makeDataSet(rank, reclenbits / 8, recoffsbits / 8, len0, len1, len2, len3, buf, type);
        }
        NybbleDataSet result = new NybbleDataSet(rank, reclenbits, recoffsbits, len0, len1, len2, len3, buf);
        return result;
    }

    public static BufferDataSet makeDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, ByteBuffer buf, Object type) {
        BufferDataSet result;
        if (rank == 1 && len1 > 1) {
            throw new IllegalArgumentException("rank is 1, but len1 is not 1");
        }
        int nperRec = len1 * len2 * len3;
        if (reclen * 8 < BufferDataSet.bitCount(type)) {
            throw new IllegalArgumentException("reclen " + reclen + " is smaller than length of type " + type);
        }
        if (reclen * 8 < nperRec * BufferDataSet.bitCount(type)) {
            throw new IllegalArgumentException("reclen " + reclen + " is smaller than length of " + nperRec + " type " + type);
        }
        if ((long)reclen * (long)len0 > (long)buf.limit()) {
            throw new IllegalArgumentException(String.format("buffer length (%d bytes) is too small to contain data (%d %d-byte records)", buf.limit(), len0, reclen));
        }
        if (type.equals(DOUBLE)) {
            result = new DoubleDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(FLOAT)) {
            result = new FloatDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(VAX_FLOAT)) {
            result = new VaxFloatDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(INT24)) {
            result = new Int24DataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(UINT24)) {
            result = new UInt24DataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(NYBBLE)) {
            result = new NybbleDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(LONG)) {
            result = new LongDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(INT) || type.equals(INTEGER)) {
            result = new IntDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(UINT)) {
            result = new UIntDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(SHORT)) {
            result = new ShortDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(USHORT)) {
            result = new UShortDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(TRUNCATEDFLOAT)) {
            result = new TruncatedFloatDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(BYTE)) {
            result = new ByteDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(UBYTE)) {
            result = new UByteDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.toString().startsWith("time")) {
            result = new TimeDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf, type);
        } else if (type.toString().startsWith("ascii")) {
            result = new AsciiDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf, type);
        } else {
            throw new IllegalArgumentException("bad data type: " + type);
        }
        return result;
    }

    public static BufferDataSet makeDataSet(int rank, int reclen, int recoffs, int[] qube, ByteBuffer buf, Object type) {
        int len0 = 1;
        int len1 = 1;
        int len2 = 1;
        int len3 = 1;
        if (rank > 0) {
            len0 = qube[0];
        }
        if (rank > 1) {
            len1 = qube[1];
        }
        if (rank > 2) {
            len2 = qube[2];
        }
        if (rank > 3) {
            len3 = qube[3];
        }
        return BufferDataSet.makeDataSet(rank, reclen, recoffs, len0, len1, len2, len3, buf, type);
    }

    public BufferDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, Object type, ByteBuffer back) {
        this(rank, reclen, recoffs, len0, len1, len2, 11, type, back);
    }

    public BufferDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, Object type, ByteBuffer back) {
        if (rank < 0) {
            throw new IllegalArgumentException("rank cannot be negative");
        }
        if (rank == 1 && len1 > 1) {
            throw new IllegalArgumentException("rank is 1, but len1 is not 1");
        }
        if (reclen < BufferDataSet.byteCount(type)) {
            throw new IllegalArgumentException("reclen " + reclen + " is smaller that length of type " + type);
        }
        if (reclen > 0 && reclen * len0 > back.limit()) {
            throw new IllegalArgumentException("buffer is too short (len=" + back.limit() + ") to contain data (" + len0 + " " + reclen + " byte records)");
        }
        if (len0 < 0) {
            throw new IllegalArgumentException("len0 is negative: " + len0);
        }
        this.back = back;
        this.rank = rank;
        this.recStride = this.reclen = reclen;
        this.recoffset = recoffs;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        this.type = type;
        this.fieldStride = this.fieldLen = BufferDataSet.byteCount(type);
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
        if (reclen > 0 && this.fieldLen > reclen) {
            logger.warning(String.format("field length (%d) is greater than record length (%d) for len0=%d.", this.fieldLen, reclen, len0));
        }
    }

    public void setFieldStride(int bytes) {
        if (this.isImmutable()) {
            throw new IllegalArgumentException("dataset is immutable");
        }
        this.fieldStride = bytes;
    }

    public int getFieldStride() {
        return this.fieldStride;
    }

    public void setRecordStride(int bytes) {
        if (this.isImmutable()) {
            throw new IllegalArgumentException("dataset is immutable");
        }
        this.recStride = bytes;
    }

    public int getRecordStride() {
        return this.recStride;
    }

    public void setLength(int len0) {
        if (this.isImmutable()) {
            throw new IllegalArgumentException("dataset is immutable");
        }
        this.len0 = len0;
    }

    public void setLength1(int len1) {
        if (this.isImmutable()) {
            throw new IllegalArgumentException("dataset is immutable");
        }
        this.len1 = len1;
    }

    public BufferDataSet(int rank, int reclen, int recoffs, Object bitByte, int len0, int len1, int len2, int len3, Object type, ByteBuffer back) {
        int n;
        if (rank < 0) {
            throw new IllegalArgumentException("rank cannot be negative");
        }
        if (rank == 1 && len1 > 1) {
            throw new IllegalArgumentException("rank is 1, but len1 is not 1");
        }
        if (bitByte.equals(BITS)) {
            if (reclen < BufferDataSet.bitCount(type)) {
                throw new IllegalArgumentException("reclen " + reclen + " bytes is smaller that length of type " + type);
            }
            if (reclen * len0 / 8 > back.limit()) {
                throw new IllegalArgumentException("buffer is too short (len=" + back.limit() + ") to contain data (" + len0 + " " + reclen + " bit records)");
            }
        } else {
            if (reclen < BufferDataSet.byteCount(type)) {
                throw new IllegalArgumentException("reclen " + reclen + " is smaller that length of type " + type);
            }
            if (reclen * len0 > back.limit()) {
                throw new IllegalArgumentException("buffer is too short (len=" + back.limit() + ") to contain data (" + len0 + " " + reclen + " byte records)");
            }
        }
        this.back = back;
        this.rank = rank;
        this.reclen = reclen;
        this.recoffset = recoffs;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        this.type = type;
        this.fieldLen = BufferDataSet.bitCount(type) / 8;
        if (reclen > 0 && this.fieldLen > reclen) {
            logger.warning(String.format("field length (%d) is greater than record length (%d) for len0=%d.", this.fieldLen, reclen, len0));
        }
        int n2 = n = bitByte == BITS ? 8 : 1;
        if (reclen > 0 && back.remaining() < reclen * len0 / n) {
            logger.warning(String.format("back buffer is too short (len=%d) for %d records each reclen=%d.", back.remaining(), len0, reclen));
        }
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    public static BufferDataSet create(int rank, Object type, int len0, int[] size) {
        switch (rank) {
            case 0: {
                return BufferDataSet.createRank0(type);
            }
            case 1: {
                return BufferDataSet.createRank1(type, len0);
            }
            case 2: {
                return BufferDataSet.createRank2(type, len0, size[0]);
            }
            case 3: {
                return BufferDataSet.createRank3(type, len0, size[0], size[1]);
            }
            case 4: {
                return BufferDataSet.createRank4(type, len0, size[0], size[1], size[2]);
            }
        }
        throw new IllegalArgumentException("rank error: " + rank);
    }

    public static BufferDataSet createRank0(Object type) {
        int typeLen = BufferDataSet.byteCount(type);
        ByteBuffer buf = BufferDataSet.checkedAllocateDirect(typeLen);
        int recLen = typeLen;
        return BufferDataSet.makeDataSet(0, recLen, 0, 1, 1, 1, 1, buf, type);
    }

    public static BufferDataSet createRank1(Object type, int len0) {
        int typeLen = BufferDataSet.byteCount(type);
        if ((long)typeLen * (long)len0 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("request is too large to allocate (>2147483647)");
        }
        ByteBuffer buf = BufferDataSet.checkedAllocateDirect(typeLen * len0);
        int recLen = typeLen;
        return BufferDataSet.makeDataSet(1, recLen, 0, len0, 1, 1, 1, buf, type);
    }

    public static BufferDataSet createRank2(Object type, int len0, int len1) {
        int typeLen = BufferDataSet.byteCount(type);
        if ((long)typeLen * (long)len0 * (long)len1 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("request is too large to allocate (>2147483647)");
        }
        ByteBuffer buf = BufferDataSet.checkedAllocateDirect(typeLen * len0 * len1);
        int recLen = typeLen * len1;
        return BufferDataSet.makeDataSet(2, recLen, 0, len0, len1, 1, 1, buf, type);
    }

    public static BufferDataSet createRank3(Object type, int len0, int len1, int len2) {
        int typeLen = BufferDataSet.byteCount(type);
        if ((long)typeLen * (long)len0 * (long)len1 * (long)len2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("request is too large to allocate (>2147483647)");
        }
        ByteBuffer buf = BufferDataSet.checkedAllocateDirect(typeLen * len0 * len1 * len2);
        int recLen = typeLen * len1 * len2;
        return BufferDataSet.makeDataSet(3, recLen, 0, len0, len1, len2, 1, buf, type);
    }

    public static BufferDataSet createRank4(Object type, int len0, int len1, int len2, int len3) {
        int typeLen = BufferDataSet.byteCount(type);
        if ((long)typeLen * (long)len0 * (long)len1 * (long)len2 * (long)len3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("request is too large to allocate (>2147483647)");
        }
        ByteBuffer buf = BufferDataSet.checkedAllocateDirect(typeLen * len0 * len1 * len2 * len3);
        int recLen = typeLen * len1 * len2 * len3;
        return BufferDataSet.makeDataSet(4, recLen, 0, len0, len1, len2, len3, buf, type);
    }

    private static BufferDataSet ddcopy(BufferDataSet ds) {
        ds = ds.compact();
        ByteBuffer newback = BufferDataSet.checkedAllocateDirect(ds.back.limit());
        newback.order(ds.back.order());
        ds.copyTo(newback);
        newback.flip();
        newback.limit(newback.capacity());
        BufferDataSet result = BufferDataSet.makeDataSet(ds.rank, ds.reclen, ds.recoffset, ds.len0, ds.len1, ds.len2, ds.len3, newback, ds.type);
        result.properties.putAll(Ops.copyProperties(ds));
        return result;
    }

    public static BufferDataSet copy(QDataSet ds) {
        if (ds instanceof BufferDataSet) {
            return BufferDataSet.ddcopy((BufferDataSet)ds);
        }
        return BufferDataSet.copy(BufferDataSet.guessBackingStore(ds), ds);
    }

    public static Object guessBackingStore(QDataSet ds) {
        if (ds instanceof BDataSet || ds instanceof ByteDataSet) {
            return BYTE;
        }
        if (ds instanceof SDataSet || ds instanceof ShortDataSet) {
            return SHORT;
        }
        if (ds instanceof IDataSet || ds instanceof IntDataSet) {
            return INT;
        }
        if (ds instanceof FDataSet || ds instanceof FloatDataSet) {
            return FLOAT;
        }
        return DOUBLE;
    }

    public static BufferDataSet maybeCopy(QDataSet ds) {
        if (ds instanceof BufferDataSet) {
            return (BufferDataSet)ds;
        }
        return BufferDataSet.copy(ds);
    }

    public boolean canAppend(BufferDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (this.getType() != ds.getType()) {
            String s1 = "" + this.getType();
            String s2 = "" + ds.getType();
            throw new IllegalArgumentException("backing type mismatch: " + s2 + "[" + ds.length() + ",*] can't be appended to " + s1 + "[" + this.length() + ",*]");
        }
        int trec = this.back.capacity() / (BufferDataSet.byteCount(this.type) * this.len1 * this.len2 * this.len3);
        return trec > ds.length() + this.len0;
    }

    public static int shouldAllocateDirect() {
        boolean moreThanHalfOfGig;
        String s = System.getProperty("sun.arch.data.model");
        long maxMemoryBytes = Runtime.getRuntime().maxMemory();
        boolean bl = moreThanHalfOfGig = maxMemoryBytes > 500000000L;
        int result = s == null ? ((s = System.getProperty("os.arch")).contains("64") ? 1 : (moreThanHalfOfGig ? 0 : 1)) : (s.equals("32") ? (moreThanHalfOfGig ? 0 : 1) : 1);
        return result;
    }

    private static ByteBuffer checkedAllocateDirect(int capacity) {
        if (allocateDirect == -1) {
            allocateDirect = BufferDataSet.shouldAllocateDirect();
        }
        if (allocateDirect == 0) {
            return ByteBuffer.allocate(capacity);
        }
        gcCounter += (long)capacity;
        try {
            ByteBuffer result = ByteBuffer.allocateDirect(capacity);
            return result;
        }
        catch (OutOfMemoryError ex) {
            logger.log(Level.FINE, "out of memory error handled: gcCounter={0}", gcCounter);
            System.gc();
            gcCounter = capacity;
            try {
                ByteBuffer result = ByteBuffer.allocate(capacity);
                return result;
            }
            catch (OutOfMemoryError ex2) {
                logger.warning("out of memory fall back to heap allocate");
                ByteBuffer result = ByteBuffer.allocate(capacity);
                return result;
            }
        }
    }

    public synchronized void append(BufferDataSet ds) {
        Units u2;
        Units u1;
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (this.type != ds.type) {
            throw new IllegalArgumentException("backing type mismatch");
        }
        int elementSizeBytes = BufferDataSet.byteCount(this.type);
        int myLength = elementSizeBytes * this.len0 * this.len1 * this.len2 * this.len3;
        int dsLength = elementSizeBytes * ds.len0 * ds.len1 * ds.len2 * ds.len3;
        if (this.len1 * this.len2 * this.len3 * elementSizeBytes < this.reclen) {
            throw new IllegalArgumentException("dataset must be compact");
        }
        if (ds.len1 * ds.len2 * ds.len3 * elementSizeBytes < ds.reclen) {
            BufferDataSet ds2;
            ds = ds2 = ds.compact();
        }
        if (this.back.capacity() < this.recoffset + myLength + dsLength) {
            throw new IllegalArgumentException("unable to append dataset, not enough room");
        }
        this.back.limit(this.recoffset + myLength + dsLength);
        ByteBuffer dsBuffer = ds.back.duplicate();
        int recLenBytes = ds.len1 * ds.len2 * ds.len3 * elementSizeBytes;
        if (this.reclen < ds.reclen || this.recoffset != 0 || ds.recoffset != 0) {
            ByteBuffer lback = ds.back.duplicate();
            this.back.position(this.recoffset + myLength);
            this.back.limit(this.recoffset + myLength + dsLength);
            for (int i = 0; i < this.len0; ++i) {
                int recStartBytes = ds.offset(i);
                lback.limit(recStartBytes + recLenBytes);
                lback.position(recStartBytes);
                this.back.put(lback);
            }
        } else {
            this.back.position(this.recoffset + myLength);
            this.back.limit(this.recoffset + myLength + dsLength);
            dsBuffer.position(ds.recoffset);
            this.back.put(dsBuffer);
            this.back.flip();
        }
        QDataSet weights = null;
        if (Ops.fillIsDifferent(this, ds)) {
            int i;
            QDataSet r;
            WritableDataSet valid2;
            WritableDataSet v1 = Ops.copy(Ops.valid(this));
            WritableDataSet v2 = Ops.copy(Ops.valid(ds));
            WritableDataSet valid1 = v1.rank() == 1 ? v1 : Ops.reform(v1, new int[]{myLength / elementSizeBytes});
            QDataSet qDataSet = valid2 = v2.rank() == 1 ? v2 : Ops.reform(v2, new int[]{dsLength / elementSizeBytes});
            if (this.type == Double.TYPE) {
                r = Ops.where(Ops.eq((Object)valid1, 0));
                for (i = 0; i < r.length(); ++i) {
                    dsBuffer.putDouble((int)r.value(i) * elementSizeBytes, Double.NaN);
                }
                r = Ops.where(Ops.eq((Object)valid2, 0));
                for (i = 0; i < r.length(); ++i) {
                    dsBuffer.putDouble(myLength + (int)r.value(i) * elementSizeBytes, Double.NaN);
                }
            } else if (this.type == Float.TYPE) {
                r = Ops.where(Ops.eq((Object)valid1, 0));
                for (i = 0; i < r.length(); ++i) {
                    dsBuffer.putFloat((int)r.value(i) * elementSizeBytes, Float.NaN);
                }
                r = Ops.where(Ops.eq((Object)valid2, 0));
                for (i = 0; i < r.length(); ++i) {
                    dsBuffer.putFloat(myLength + (int)r.value(i) * elementSizeBytes, Float.NaN);
                }
            } else {
                weights = Ops.append(Ops.valid(this), Ops.valid(ds));
            }
        }
        if ((u1 = SemanticOps.getUnits(this)) != (u2 = SemanticOps.getUnits(ds))) {
            if (u1 instanceof EnumerationUnits && u2 instanceof EnumerationUnits) {
                for (int i = myLength; i < myLength + dsLength; ++i) {
                    double d = this.back.getDouble(i * elementSizeBytes);
                    d = ((EnumerationUnits)u1).createDatum((Object)u2.createDatum(d).toString()).doubleValue(u1);
                    this.back.putDouble(i * elementSizeBytes, d);
                }
            } else {
                UnitsConverter uc = UnitsConverter.getConverter((Units)u2, (Units)u1);
                for (int i = myLength; i < myLength + dsLength; ++i) {
                    Double nv = uc.convert(ds.value(i));
                    this.putValue(i, nv);
                }
            }
        }
        this.len0 += ds.len0;
        this.properties.putAll(BufferDataSet.joinProperties(this, ds));
        if (weights != null) {
            this.properties.put("WEIGHTS", weights);
        }
    }

    public static BufferDataSet append(BufferDataSet ths, BufferDataSet ds) {
        Units u2;
        Units u1;
        Units u;
        if (ths == null) {
            return ds;
        }
        if (ds == null) {
            throw new NullPointerException("ds is null");
        }
        if (ths.rank() == ds.rank() - 1) {
            u = SemanticOps.getUnits(ths);
            ths = BufferDataSet.makeDataSet(ths.rank() + 1, ths.reclen * ths.len0, 0, 1, ths.len0, ths.len1, ths.len2, ths.back, ths.type);
            ths.putProperty("UNITS", u);
        }
        if (ths.rank() - 1 == ds.rank()) {
            u = SemanticOps.getUnits(ds);
            ds = BufferDataSet.makeDataSet(ds.rank() + 1, ds.reclen * ds.len0, 0, 1, ds.len0, ds.len1, ds.len2, ds.back, ds.type);
            ds.putProperty("UNITS", u);
        }
        if (ds.rank() != ths.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != ths.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != ths.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != ths.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (!ths.getType().equals(ds.getType())) {
            throw new IllegalArgumentException("backing type mismatch");
        }
        if (ths.back.order() != ds.back.order()) {
            throw new IllegalArgumentException("byte order (endianness) must be the same");
        }
        int elementSizeBytes = BufferDataSet.byteCount(ths.type);
        int myLength = ths.len0 * ths.len1 * ths.len2 * ths.len3 * elementSizeBytes;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3 * elementSizeBytes;
        if (ths.len1 * ths.len2 * ths.len3 * elementSizeBytes < ths.reclen) {
            ths = ths.compact();
        }
        if (ds.len1 * ds.len2 * ds.len3 * elementSizeBytes < ds.reclen) {
            ds = ds.compact();
        }
        ByteBuffer newback = BufferDataSet.checkedAllocateDirect(myLength + dsLength);
        newback.order(ths.back.order());
        ByteBuffer back2 = ths.back.duplicate();
        back2.limit(ths.recoffset + myLength);
        back2.position(ths.recoffset);
        newback.put(back2);
        ByteBuffer ds2 = ds.back.duplicate();
        ds2.limit(ds.recoffset + dsLength);
        ds2.position(ds.recoffset);
        newback.put(ds2);
        newback.flip();
        BufferDataSet result = BufferDataSet.makeDataSet(ths.rank, ths.reclen, 0, ths.len0 + ds.len0, ths.len1, ths.len2, ths.len3, newback, ths.type);
        QDataSet weights = null;
        if (Ops.fillIsDifferent(ths, ds)) {
            int i;
            QDataSet r;
            WritableDataSet valid2;
            WritableDataSet v1 = Ops.copy(Ops.valid(ths));
            WritableDataSet v2 = Ops.copy(Ops.valid(ds));
            WritableDataSet valid1 = v1.rank() == 1 ? v1 : Ops.reform(v1, new int[]{myLength / elementSizeBytes});
            QDataSet qDataSet = valid2 = v2.rank() == 1 ? v2 : Ops.reform(v2, new int[]{dsLength / elementSizeBytes});
            if (ths.type == Double.TYPE) {
                r = Ops.where(Ops.eq((Object)valid1, 0));
                for (i = 0; i < r.length(); ++i) {
                    newback.putDouble((int)r.value(i) * elementSizeBytes, Double.NaN);
                }
                r = Ops.where(Ops.eq((Object)valid2, 0));
                for (i = 0; i < r.length(); ++i) {
                    newback.putDouble(myLength + (int)r.value(i) * elementSizeBytes, Double.NaN);
                }
            } else if (ths.type == Float.TYPE) {
                r = Ops.where(Ops.eq((Object)valid1, 0));
                for (i = 0; i < r.length(); ++i) {
                    newback.putFloat((int)r.value(i) * elementSizeBytes, Float.NaN);
                }
                r = Ops.where(Ops.eq((Object)valid2, 0));
                for (i = 0; i < r.length(); ++i) {
                    newback.putFloat(myLength + (int)r.value(i) * elementSizeBytes, Float.NaN);
                }
            } else {
                weights = Ops.append(Ops.valid(ths), Ops.valid(ds));
            }
        }
        if ((u1 = SemanticOps.getUnits(ths)) != (u2 = SemanticOps.getUnits(ds))) {
            if (u1 instanceof EnumerationUnits && u2 instanceof EnumerationUnits) {
                for (int i = myLength; i < myLength + dsLength; ++i) {
                    double d = ths.value(i);
                    d = ((EnumerationUnits)u1).createDatum((Object)u2.createDatum(d).toString()).doubleValue(u1);
                    ths.putValue(i, d);
                }
            } else {
                UnitsConverter uc = UnitsConverter.getConverter((Units)u2, (Units)u1);
                for (int i = myLength; i < myLength + dsLength; ++i) {
                    Double nv = uc.convert(ds.value(i));
                    ths.putValue(i, nv);
                }
            }
        }
        result.properties.putAll(BufferDataSet.joinProperties(ths, ds));
        result.properties.put("UNITS", u1);
        if (weights != null) {
            result.properties.put("WEIGHTS", weights);
        }
        result.fieldStride = ths.fieldStride;
        result.recStride = ths.recStride;
        return result;
    }

    protected static Map<String, Object> joinProperties(BufferDataSet ths, BufferDataSet ds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < ds.rank(); ++i) {
            QDataSet thatDep = (QDataSet)ds.property("DEPEND_" + i);
            if (thatDep != null && (i == 0 || thatDep.rank() > 1)) {
                QDataSet thisDep = (QDataSet)ths.property("DEPEND_" + i);
                QDataSet djoin = Ops.append(thisDep, thatDep);
                result.put("DEPEND_" + i, djoin);
            } else if (thatDep != null && thatDep.rank() == 1 && result.get("DEPEND_" + i) == null) {
                result.put("DEPEND_" + i, thatDep);
            }
            QDataSet thatBundle = (QDataSet)ds.property("BUNDLE_" + i);
            QDataSet thisBundle = (QDataSet)ths.property("BUNDLE_" + i);
            if (i <= 0 || thatBundle == null || thisBundle == null) continue;
            if (thisBundle.length() != thatBundle.length()) {
                throw new IllegalArgumentException("BUNDLE_" + i + " should be the same length to append, but they are not");
            }
            for (int j = 0; j < thatBundle.length(); ++j) {
                Units thatu = (Units)thatBundle.property("UNITS", j);
                Units thisu = (Units)thisBundle.property("UNITS", j);
                if (thisu == thatu) continue;
                throw new IllegalArgumentException("units in BUNDLE_" + i + " change...");
            }
            result.put("BUNDLE_" + i, thatBundle);
        }
        String[] props = DataSetUtil.correlativeProperties();
        for (int iprop = -1; iprop < props.length; ++iprop) {
            String prop = iprop == -1 ? "PLANE_0" : props[iprop];
            QDataSet w1 = (QDataSet)ds.property(prop);
            if (w1 == null) continue;
            QDataSet dep0 = (QDataSet)ths.property(prop);
            if (dep0 != null) {
                BufferDataSet djoin = BufferDataSet.copy(dep0);
                BufferDataSet dd1 = BufferDataSet.maybeCopy(w1);
                djoin = (BufferDataSet)Ops.append(djoin, dd1);
                result.put(prop, djoin);
                continue;
            }
            logger.log(Level.INFO, "dataset doesn''t have property \"{0}\" but other dataset does: {1}", new Object[]{prop, ths});
        }
        for (String prop : props = DataSetUtil.dimensionProperties()) {
            Object value = ths.property(prop);
            if (value == null || !value.equals(ds.property(prop))) continue;
            result.put(prop, ths.property(prop));
        }
        for (String prop : props = new String[]{"CADENCE", "BINS_1"}) {
            Object o = ths.property(prop);
            if (o == null || !o.equals(ds.property(prop))) continue;
            result.put(prop, o);
        }
        Boolean m = (Boolean)ths.property("MONOTONIC");
        if (m != null && m.equals(Boolean.TRUE) && m.equals(ds.property("MONOTONIC"))) {
            try {
                int[] fl1 = DataSetUtil.rangeOfMonotonic(ths);
                int[] fl2 = DataSetUtil.rangeOfMonotonic(ds);
                Units u1 = SemanticOps.getUnits(ds);
                Units u2 = SemanticOps.getUnits(ths);
                UnitsConverter uc = u2.getConverter(u1);
                if (ds.value(fl2[0]) - uc.convert(ths.value(fl1[1])) >= 0.0) {
                    result.put("MONOTONIC", Boolean.TRUE);
                }
            }
            catch (IllegalArgumentException ex) {
                logger.fine("rte_1282463981: can't show that result has monotonic timetags because each dataset is not monotonic.");
            }
        }
        CacheTag ct0 = (CacheTag)ths.property("CACHE_TAG");
        CacheTag ct1 = (CacheTag)ds.property("CACHE_TAG");
        if (ct0 != null && ct1 != null) {
            CacheTag newTag = null;
            try {
                newTag = CacheTag.append((CacheTag)ct0, (CacheTag)ct1);
            }
            catch (IllegalArgumentException ex) {
                logger.fine("append of two datasets that have CACHE_TAGs and are not adjacent, dropping CACHE_TAG");
            }
            if (newTag != null) {
                result.put("CACHE_TAG", newTag);
            }
        }
        Number dmin0 = (Number)ths.property("TYPICAL_MIN");
        Number dmax0 = (Number)ths.property("TYPICAL_MAX");
        Number dmin1 = (Number)ds.property("TYPICAL_MIN");
        Number dmax1 = (Number)ds.property("TYPICAL_MAX");
        if (dmin0 != null && dmin1 != null) {
            result.put("TYPICAL_MIN", Math.min(dmin0.doubleValue(), dmin1.doubleValue()));
        }
        if (dmax0 != null && dmax1 != null) {
            result.put("TYPICAL_MAX", Math.max(dmax0.doubleValue(), dmax1.doubleValue()));
        }
        return result;
    }

    public static Object typeFor(Class c) {
        Object result;
        if (c == Byte.TYPE) {
            result = BYTE;
        } else if (c == Short.TYPE) {
            result = SHORT;
        } else if (c == Integer.TYPE) {
            result = INT;
        } else if (c == Long.TYPE) {
            result = LONG;
        } else if (c == Float.TYPE) {
            result = FLOAT;
        } else if (c == Double.TYPE) {
            result = DOUBLE;
        } else {
            throw new IllegalArgumentException("bad class type: " + c);
        }
        return result;
    }

    public static BufferDataSet copy(Object type, QDataSet ds) {
        BufferDataSet result;
        if (ds instanceof BufferDataSet && ((BufferDataSet)ds).getType() == type) {
            return BufferDataSet.ddcopy((BufferDataSet)ds);
        }
        int rank = ds.rank();
        switch (rank) {
            case 0: {
                result = BufferDataSet.createRank0(type);
                result.putValue(ds.value());
                break;
            }
            case 1: {
                result = BufferDataSet.createRank1(type, ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                result = BufferDataSet.createRank2(type, ds.length(), ds.length(0));
                int i0 = ds.length() > 0 ? ds.length(0) : -1;
                for (int i = 0; i < ds.length(); ++i) {
                    if (ds.length(i) != i0) {
                        throw new IllegalArgumentException("Attempt to copy non-qube into ArrayDataSet which must be qube: " + ds);
                    }
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                result = BufferDataSet.createRank3(type, ds.length(), ds.length(0), ds.length(0, 0));
                int i0_ = ds.length() > 0 ? ds.length(0) : -1;
                for (int i = 0; i < ds.length(); ++i) {
                    if (ds.length(i) != i0_) {
                        throw new IllegalArgumentException("Attempt to copy non-qube into ArrayDataSet which must be qube: " + ds);
                    }
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            case 4: {
                result = BufferDataSet.createRank4(type, ds.length(), ds.length(0), ds.length(0, 0), ds.length(0, 0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            for (int l = 0; l < ds.length(i, j, k); ++l) {
                                result.putValue(i, j, k, l, ds.value(i, j, k, l));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(Ops.copyProperties(ds));
        return result;
    }

    public void grow(int newRecCount) {
        if (newRecCount < this.len0) {
            throw new IllegalArgumentException("new recsize for grow smaller than old");
        }
        int newSize = newRecCount * this.len1 * this.len2 * this.len3 * BufferDataSet.byteCount(this.type);
        ByteBuffer lback = this.back.duplicate();
        lback.order(this.back.order());
        int oldSize = this.len0 * this.len1 * this.len2 * this.len3 * BufferDataSet.byteCount(this.type);
        if (newSize < oldSize) {
            return;
        }
        ByteBuffer newBack = BufferDataSet.checkedAllocateDirect(newSize);
        newBack.order(lback.order());
        int recLenBytes = this.len1 * this.len2 * this.len3 * BufferDataSet.byteCount(this.type);
        if (recLenBytes < this.reclen || this.recoffset != 0) {
            for (int i = 0; i < this.len0; ++i) {
                int recStartBytes = this.offset(i);
                lback.limit(recStartBytes + recLenBytes);
                lback.position(recStartBytes);
                newBack.put(lback);
            }
        } else {
            newBack.put(lback);
        }
        newBack.flip();
        this.back = newBack;
        this.recoffset = 0;
    }

    public Object getType() {
        return this.type;
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public int length() {
        return this.len0;
    }

    @Override
    public int length(int i) {
        return this.len1;
    }

    @Override
    public int length(int i0, int i1) {
        return this.len2;
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.len3;
    }

    protected void rangeCheck(int i0, int i1, int i2, int i3) {
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this.toString());
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this.toString());
        }
        if (i2 < 0 || i2 >= this.len2) {
            throw new IndexOutOfBoundsException("i2=" + i2 + " " + this.toString());
        }
        if (i3 < 0 || i3 >= this.len3) {
            throw new IndexOutOfBoundsException("i3=" + i3 + " " + this.toString());
        }
    }

    protected int offset() {
        if (this.rank != 0) {
            throw new IllegalArgumentException("rank error");
        }
        return this.recoffset;
    }

    protected int offset(int i0) {
        this.rangeCheck(i0, 0, 0, 0);
        return this.recoffset + this.recStride * i0;
    }

    protected int offset(int i0, int i1) {
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank error");
        }
        this.rangeCheck(i0, i1, 0, 0);
        return this.recoffset + this.recStride * i0 + this.fieldStride * i1;
    }

    protected int offset(int i0, int i1, int i2) {
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank error");
        }
        this.rangeCheck(i0, i1, i2, 0);
        return this.recoffset + this.recStride * i0 + this.fieldStride * this.len2 * i1 + this.fieldStride * i2;
    }

    protected int offset(int i0, int i1, int i2, int i3) {
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank error");
        }
        this.rangeCheck(i0, i1, i2, i3);
        return this.recoffset + this.recStride * i0 + this.fieldStride * this.len2 * this.len3 * i1 + this.fieldStride * this.len3 * i2 + this.fieldStride * i3;
    }

    @Override
    public abstract double value();

    @Override
    public abstract double value(int var1);

    @Override
    public abstract double value(int var1, int var2);

    @Override
    public abstract double value(int var1, int var2, int var3);

    @Override
    public abstract double value(int var1, int var2, int var3, int var4);

    @Override
    public QDataSet trim(int ist, int ien) {
        int offset = ist < this.len0 ? this.offset(ist) : (ist == this.len0 && ien == this.len0 ? this.recoffset + this.reclen * ist : this.offset(ist));
        BufferDataSet result = BufferDataSet.makeDataSet(this.rank, this.reclen, offset, ien - ist, this.len1, this.len2, this.len3, this.back, this.type);
        DataSetUtil.putProperties(DataSetUtil.trimProperties(this, ist, ien), result);
        if (result instanceof AsciiDataSet) {
            ((AsciiDataSet)result).setUnits(SemanticOps.getUnits(this));
        }
        result.fieldStride = this.fieldStride;
        result.recStride = this.recStride;
        return result;
    }

    @Override
    public QDataSet slice(int i) {
        BufferDataSet result = BufferDataSet.makeDataSet(this.rank - 1, BufferDataSet.byteCount(this.type) * this.len2 * this.len3, this.offset(i), this.len1, this.len2, this.len3, 1, this.back, this.type);
        Map<String, Object> props = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, i, props);
        DataSetUtil.putProperties(props, result);
        if (result instanceof AsciiDataSet) {
            ((AsciiDataSet)result).setUnits(SemanticOps.getUnits(this));
        }
        result.fieldStride = this.fieldStride;
        return result;
    }

    private void copyTo(ByteBuffer buf) {
        if (this.isCompact()) {
            ByteBuffer lback = this.back.duplicate();
            lback.order(this.back.order());
            lback.position(0);
            lback.mark();
            lback.limit(this.reclen * this.len0);
            buf.put(lback);
        } else {
            BufferDataSet c = this.compact();
            c.copyTo(buf);
        }
    }

    protected synchronized void ensureWritable() {
        if (this.isImmutable()) {
            logger.warning("dataset has been marked as immutable, this will soon throw an exception");
        }
        if (this.back.isReadOnly()) {
            ByteBuffer wback = BufferDataSet.checkedAllocateDirect(this.back.capacity());
            wback.order(this.back.order());
            wback.put(this.back);
            wback.flip();
            this.back = wback;
        }
    }

    public int jvmMemory() {
        if (this.back.isDirect()) {
            return 0;
        }
        if (this.back.hasArray()) {
            return this.back.array().length;
        }
        return 0;
    }

    public void about() {
        System.err.println("== " + this.toString() + "==");
        System.err.println("back=" + this.back);
        System.err.println("recoffset=" + this.recoffset);
    }

    public Class getCompatibleComponentType() {
        Object t = this.getType();
        if (t == DOUBLE) {
            return Double.TYPE;
        }
        if (t == FLOAT) {
            return Float.TYPE;
        }
        if (t == LONG) {
            return Long.TYPE;
        }
        if (t == UINT) {
            return Long.TYPE;
        }
        if (t == INT) {
            return Integer.TYPE;
        }
        if (t == USHORT) {
            return Integer.TYPE;
        }
        if (t == SHORT) {
            return Short.TYPE;
        }
        if (t == UBYTE) {
            return Short.TYPE;
        }
        if (t == BYTE) {
            return Byte.TYPE;
        }
        return Double.TYPE;
    }

    public boolean isCompact() {
        int recLenBytes = this.len1 * this.len2 * this.len3 * BufferDataSet.byteCount(this.type);
        return recLenBytes == this.reclen && this.recoffset == 0;
    }

    public BufferDataSet compact() {
        ByteBuffer lback = this.back.duplicate();
        lback.order(this.back.order());
        int recLenBytes = this.len1 * this.len2 * this.len3 * BufferDataSet.byteCount(this.type);
        ByteBuffer newBuf = ByteBuffer.allocate(this.len0 * recLenBytes);
        newBuf.order(this.back.order());
        for (int i = 0; i < this.len0; ++i) {
            int recStartBytes = this.offset(i);
            if (recStartBytes + recLenBytes > this.back.capacity()) {
                logger.info("something is wrong");
            }
            lback.limit(recStartBytes + recLenBytes);
            lback.position(recStartBytes);
            newBuf.put(lback);
        }
        newBuf.flip();
        BufferDataSet result = BufferDataSet.makeDataSet(this.rank, recLenBytes, 0, this.len0, this.len1, this.len2, this.len3, newBuf, this.type);
        result.properties.putAll(Ops.copyProperties(this));
        result.fieldStride = this.fieldStride;
        result.recStride = this.recStride;
        return result;
    }
}

