/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.das2.qds.buffer.BufferDataSet;

public class UByteDataSet
extends BufferDataSet {
    public UByteDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, ByteBuffer back) {
        super(rank, reclen, recoffs, len0, len1, len2, len3, UBYTE, back);
    }

    @Override
    public double value() {
        byte b = this.back.get(this.offset());
        return b < 0 ? (double)(b + 256) : (double)b;
    }

    @Override
    public double value(int i0) {
        byte b = this.back.get(this.offset(i0));
        return b < 0 ? (double)(b + 256) : (double)b;
    }

    @Override
    public double value(int i0, int i1) {
        byte b = this.back.get(this.offset(i0, i1));
        return b < 0 ? (double)(b + 256) : (double)b;
    }

    @Override
    public double value(int i0, int i1, int i2) {
        byte b = this.back.get(this.offset(i0, i1, i2));
        return b < 0 ? (double)(b + 256) : (double)b;
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        byte b = this.back.get(this.offset(i0, i1, i2, i3));
        return b < 0 ? (double)(b + 256) : (double)b;
    }

    @Override
    public void putValue(double d) {
        this.ensureWritable();
        this.back.put(this.offset(), (byte)(d > 128.0 ? d - 256.0 : d));
    }

    @Override
    public void putValue(int i0, double d) {
        this.ensureWritable();
        this.back.put(this.offset(i0), (byte)(d > 128.0 ? d - 256.0 : d));
    }

    @Override
    public void putValue(int i0, int i1, double d) {
        this.ensureWritable();
        this.back.put(this.offset(i0, i1), (byte)(d > 128.0 ? d - 256.0 : d));
    }

    @Override
    public void putValue(int i0, int i1, int i2, double d) {
        this.ensureWritable();
        this.back.put(this.offset(i0, i1, i2), (byte)(d > 128.0 ? d - 256.0 : d));
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double d) {
        this.ensureWritable();
        this.back.put(this.offset(i0, i1, i2, i3), (byte)(d > 128.0 ? d - 256.0 : d));
    }

    public String collectString(Charset charset) {
        if (this.rank != 1) {
            throw new IllegalArgumentException("data must be rank 1");
        }
        int st = this.offset(0);
        if (this.back.hasArray()) {
            return new String(this.back.array(), st, st + this.len0, charset);
        }
        byte[] array = new byte[this.length()];
        this.back.position(0);
        this.back.limit(st + this.len0);
        this.back.position(st);
        this.back.get(array);
        return new String(array, charset);
    }
}

