/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanelUtil;

public class TotalFilterEditorPanel
extends AbstractFilterEditorPanel
implements FilterEditorPanel {
    static final long t0 = System.currentTimeMillis();
    int[] qube = null;
    private JLabel jLabel2;
    private JComboBox sliceDimensionCB;

    public TotalFilterEditorPanel() {
        this.initComponents();
        this.setName("sliceFilterEditorPanel" + String.format("%04d", (System.currentTimeMillis() - t0) / 100L));
    }

    private void initComponents() {
        this.sliceDimensionCB = new JComboBox();
        this.jLabel2 = new JLabel();
        this.sliceDimensionCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sliceDimensionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TotalFilterEditorPanel.this.sliceDimensionCBActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Total over Dimension:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliceDimensionCB, 0, 253, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sliceDimensionCB, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sliceDimensionCBActionPerformed(ActionEvent evt) {
        String ff = this.getFilter();
        logger.log(Level.FINEST, "0: {0}{1}", new Object[]{ff, this.getName()});
        this.firePropertyChange("filter", null, ff);
    }

    @Override
    public String getFilter() {
        logger.fine("getFilter");
        return String.format("|total%d()", this.sliceDimensionCB.getSelectedIndex());
    }

    @Override
    public void setFilter(String filter) {
        logger.log(Level.FINE, "setFilter {0}", filter);
        Pattern p = Pattern.compile("\\|total(\\d)\\(()\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.sliceDimensionCB.setSelectedIndex(Integer.parseInt(m.group(1)));
        }
    }

    @Override
    public void setInput(QDataSet ds) {
        logger.log(Level.FINE, "setInput {0}", ds.toString());
        String[] depNames1 = FilterEditorPanelUtil.getDimensionNames(ds);
        int idx = this.sliceDimensionCB.getSelectedIndex();
        this.sliceDimensionCB.setModel(new DefaultComboBoxModel<String>(depNames1));
        try {
            this.sliceDimensionCB.setSelectedIndex(idx);
        }
        catch (IllegalArgumentException ex) {
            this.sliceDimensionCB.setSelectedIndex(0);
        }
    }
}

