/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class ValuesTreeModel
extends DefaultTreeModel {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.treemodel");
    private static final int TAIL_COUNT = 3;
    QDataSet ds;
    String dsLabel;
    MutableTreeNode mroot;
    private static TimeParser NANOSECONDS = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=9)Z");
    private static TimeParser MICROSECONDS = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=6)Z");
    private static TimeParser MILLISECONDS = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=3)Z");

    public ValuesTreeModel(QDataSet ds) {
        this(null, ds);
    }

    public ValuesTreeModel(String prefix, QDataSet ds) {
        super(new DefaultMutableTreeNode((prefix == null ? "" : prefix) + DataSetUtil.toString(ds)));
        this.mroot = (MutableTreeNode)this.root;
        ValuesTreeModel.valuesTreeNode("HELP", this.mroot, ds, 10);
    }

    public static TreeNode valuesTreeNode2(final String prefix, final TreeNode parent, final QDataSet ds) {
        final Units units = (Units)ds.property("UNITS");
        final QDataSet wds = DataSetUtil.weightsDataSet(ds);
        final QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        final Units depu = dep0 == null ? null : (Units)dep0.property("UNITS");
        return new TreeNode(){

            @Override
            public TreeNode getChildAt(int i) {
                if (ds.rank() == 1) {
                    String sval;
                    String string = sval = units == null ? String.valueOf(ds.value(i)) : String.valueOf(units.createDatum(ds.value(i)));
                    if (wds.value(i) > 0.0) {
                        sval = "fill (" + ds.value(i) + ")";
                    }
                    return new DefaultMutableTreeNode(prefix + "" + i + ")=" + sval);
                }
                String sdepu = dep0 == null ? String.valueOf(i) : String.valueOf(depu.createDatum(dep0.value(i)));
                DefaultMutableTreeNode sliceNode = new DefaultMutableTreeNode("values @ " + sdepu);
                return sliceNode;
            }

            @Override
            public int getChildCount() {
                return Math.min(ds.length(), 10);
            }

            @Override
            public TreeNode getParent() {
                return parent;
            }

            @Override
            public int getIndex(TreeNode node) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean getAllowsChildren() {
                return true;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            public Enumeration<TreeNode> children() {
                return new Enumeration<TreeNode>(){
                    int i = 0;

                    @Override
                    public boolean hasMoreElements() {
                        return this.i < this.getChildCount();
                    }

                    @Override
                    public TreeNode nextElement() {
                        return this.getChildAt(this.i++);
                    }
                };
            }
        };
    }

    private static String svalRank1(QDataSet wds, QDataSet ds, int i) {
        if (ds.rank() == 2 && ds.property("BINS_1").equals("min,max")) {
            if (wds.value(i, 0) == 0.0 || wds.value(i, 1) == 0.0) {
                return "fill";
            }
            return DataSetUtil.asDatumRange(ds.slice(i), true).toString();
        }
        if (ds.rank() == 3) {
            QDataSet polys = ds.slice(1);
            StringBuilder b = new StringBuilder();
            QDataSet ii = polys.slice(i);
            b.append((int)ii.value(0));
            for (int j = 1; j < ii.length(); ++j) {
                b.append(",");
                b.append((int)ii.value(j));
            }
            return "poly [" + b.toString() + "]";
        }
        try {
            if (wds.value(i) > 0.0) {
                QDataSet bds = (QDataSet)ds.property("BUNDLE_0");
                if (bds != null) {
                    String alt = ds.slice(i).toString();
                    String result = DataSetUtil.getStringValue(ds, ds.value(i), i);
                    if (alt.endsWith("=fill")) {
                        result = result + "(fill)";
                    }
                    return result;
                }
                return DataSetUtil.getStringValue(ds, ds.value(i));
            }
            return "fill (" + ds.value(i) + ")";
        }
        catch (IllegalArgumentException ex) {
            return "Error: " + ex;
        }
    }

    private static String svalRank1(QDataSet wds, QDataSet ds, int i, QDataSet cadence) {
        if (ds.rank() == 2 && ds.property("BINS_1").equals("min,max")) {
            if (wds.value(i, 0) == 0.0 || wds.value(i, 1) == 0.0) {
                return "fill";
            }
            return DataSetUtil.asDatumRange(ds.slice(i), true).toString();
        }
        try {
            if (wds.value(i) > 0.0) {
                Units u;
                QDataSet bds = (QDataSet)ds.property("BUNDLE_0");
                if (bds != null) {
                    String alt = ds.slice(i).toString();
                    String result = DataSetUtil.getStringValue(ds, ds.value(i), i);
                    if (alt.endsWith("=fill")) {
                        result = result + "(fill)";
                    }
                    return result;
                }
                if (cadence != null && (u = SemanticOps.getUnits(cadence)).isConvertibleTo(Units.seconds)) {
                    Datum d = DataSetUtil.asDatum(ds.slice(i));
                    double cadenceUs = DataSetUtil.asDatum(cadence).doubleValue(Units.microseconds);
                    if (UnitsUtil.isTimeLocation((Units)d.getUnits())) {
                        if (cadenceUs < 1.0) {
                            return NANOSECONDS.format(d);
                        }
                        if (cadenceUs < 1000.0) {
                            return MICROSECONDS.format(d);
                        }
                        return MILLISECONDS.format(d);
                    }
                    return DataSetUtil.getStringValue(ds, ds.value(i)) + " " + u;
                }
                return DataSetUtil.getStringValue(ds, ds.value(i));
            }
            return "fill (" + ds.value(i) + ")";
        }
        catch (IllegalArgumentException ex) {
            return "Error: " + ex;
        }
    }

    public static MutableTreeNode valuesTreeNode(String prefix, MutableTreeNode aroot, QDataSet ds, int sizeLimit) {
        Units depu;
        QDataSet dep0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QDataSet bundle = (QDataSet)ds.property("BUNDLE_0");
        Object odep0 = ds.property("DEPEND_0");
        if (odep0 != null) {
            if (odep0 instanceof QDataSet) {
                dep0 = (QDataSet)odep0;
            } else {
                logger.log(Level.WARNING, "dep0 is not a QDataSet: {0}", odep0);
                dep0 = null;
            }
        } else {
            dep0 = null;
        }
        QDataSet wdsDep0 = null;
        if (dep0 != null) {
            wdsDep0 = DataSetUtil.weightsDataSet(dep0);
        }
        Units units = depu = dep0 == null ? Units.dimensionless : (Units)dep0.property("UNITS");
        if (depu == null) {
            depu = Units.dimensionless;
        }
        switch (ds.rank()) {
            case 0: {
                String sval = DataSetUtil.asDatum(ds).toString();
                aroot.insert(new DefaultMutableTreeNode(prefix + ")=" + sval), aroot.getChildCount());
                break;
            }
            case 1: {
                String sval;
                Units u;
                int i;
                Units units2 = (Units)ds.property("UNITS");
                if (units2 == null) {
                    units2 = Units.dimensionless;
                }
                QDataSet plane0 = (QDataSet)ds.property("PLANE_0");
                QDataSet cadenceDs = ds.length() > 1000 ? ds.trim(0, 1000) : ds;
                RankZeroDataSet cadence = DataSetUtil.guessCadenceNew(cadenceDs, null);
                int n = Math.min(ds.length(), sizeLimit);
                for (i = 0; i < n; ++i) {
                    u = units2;
                    if (bundle != null && (u = (Units)bundle.property("UNITS", i)) == null) {
                        u = Units.dimensionless;
                    }
                    if (u instanceof EnumerationUnits) {
                        try {
                            sval = ValuesTreeModel.svalRank1(wds, ds, i);
                        }
                        catch (IllegalArgumentException ex) {
                            sval = "" + ds.value(i) + " (error)";
                        }
                    } else {
                        sval = cadence != null ? ValuesTreeModel.svalRank1(wds, ds, i, cadence) : ValuesTreeModel.svalRank1(wds, ds, i);
                    }
                    if (dep0 != null) {
                        sval = sval + " @ " + ValuesTreeModel.svalRank1(wdsDep0, dep0, i);
                    }
                    if (plane0 != null) {
                        sval = sval + " (" + ValuesTreeModel.svalRank1(wds, plane0, i) + ")";
                    }
                    if (bundle != null) {
                        sval = bundle.property("NAME", i) + " = " + ValuesTreeModel.svalRank1(wds, ds, i);
                        aroot.insert(new DefaultMutableTreeNode(sval), aroot.getChildCount());
                        continue;
                    }
                    aroot.insert(new DefaultMutableTreeNode(prefix + "" + i + ")=" + sval), aroot.getChildCount());
                }
                if (ds.length() > sizeLimit + 4) {
                    aroot.insert(new DefaultMutableTreeNode("..."), aroot.getChildCount());
                    n = Math.max(n, ds.length() - 3);
                }
                for (i = n; i < ds.length(); ++i) {
                    u = units2;
                    if (bundle != null && (u = (Units)bundle.property("UNITS", i)) == null) {
                        u = Units.dimensionless;
                    }
                    if (u instanceof EnumerationUnits) {
                        try {
                            sval = ValuesTreeModel.svalRank1(wds, ds, i);
                        }
                        catch (IllegalArgumentException ex) {
                            sval = "" + ds.value(i) + " (error)";
                        }
                    } else {
                        sval = cadence != null ? ValuesTreeModel.svalRank1(wds, ds, i, cadence) : ValuesTreeModel.svalRank1(wds, ds, i);
                    }
                    if (dep0 != null) {
                        sval = sval + " @ " + ValuesTreeModel.svalRank1(wdsDep0, dep0, i);
                    }
                    if (plane0 != null) {
                        sval = sval + " (" + ValuesTreeModel.svalRank1(wds, plane0, i) + ")";
                    }
                    if (bundle != null) {
                        sval = bundle.property("NAME", i) + " = " + ValuesTreeModel.svalRank1(wds, ds, i);
                        aroot.insert(new DefaultMutableTreeNode(sval), aroot.getChildCount());
                        continue;
                    }
                    aroot.insert(new DefaultMutableTreeNode(prefix + "" + i + ")=" + sval), aroot.getChildCount());
                }
                break;
            }
            default: {
                DefaultMutableTreeNode sliceNode;
                int i;
                if (dep0 == null) {
                    dep0 = Ops.dindgen(ds.length());
                }
                if (depu == null) {
                    depu = Units.dimensionless;
                }
                for (i = 0; i < Math.min(ds.length(), sizeLimit); ++i) {
                    if (dep0.rank() != 1) continue;
                    sliceNode = new DefaultMutableTreeNode("values @ " + depu.createDatum(dep0.value(i)));
                    aroot.insert(sliceNode, aroot.getChildCount());
                    ValuesTreeModel.valuesTreeNode(prefix + i + ",", sliceNode, ds.slice(i), 20);
                }
                if (ds.length() >= sizeLimit) {
                    aroot.insert(new DefaultMutableTreeNode("..."), aroot.getChildCount());
                }
                for (i = Math.max(ds.length() - 3, sizeLimit); i < ds.length(); ++i) {
                    if (dep0.rank() != 1) continue;
                    sliceNode = new DefaultMutableTreeNode("values @ " + depu.createDatum(dep0.value(i)));
                    aroot.insert(sliceNode, aroot.getChildCount());
                    ValuesTreeModel.valuesTreeNode(prefix + i + ",", sliceNode, ds.slice(i), 20);
                }
            }
        }
        return aroot;
    }
}

