/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Random;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class BundleBinsDemo {
    public static QDataSet demo1() {
        DDataSet result = DDataSet.createRank2(10, 6);
        Random r = new Random(12345L);
        for (int i = 0; i < result.length(); ++i) {
            result.putValue(i, 0, (double)i * 3.6E9);
            result.putValue(i, 1, (double)(i + 1) * 3.6E9);
            result.putValue(i, 2, r.nextDouble());
            result.putValue(i, 3, r.nextDouble());
            result.putValue(i, 4, r.nextDouble());
            result.putValue(i, 5, r.nextDouble());
        }
        AbstractDataSet bundleDescriptor = new AbstractDataSet(){

            @Override
            public int rank() {
                return 2;
            }

            @Override
            public int length() {
                return 6;
            }

            @Override
            public int length(int i) {
                switch (i) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("bad index");
            }

            @Override
            public Object property(String name, int i) {
                if ("NAME".equals(name)) {
                    switch (i) {
                        case 0: {
                            return "TimeMin";
                        }
                        case 1: {
                            return "TimeMax";
                        }
                        case 2: {
                            return "BGSM_X";
                        }
                        case 3: {
                            return "BGSM_Y";
                        }
                        case 4: {
                            return "BGSM_Z";
                        }
                        case 5: {
                            return "Speed";
                        }
                    }
                }
                if (i == 0 || i == 1) {
                    if ("BINS_1".equals(name)) {
                        return "min,max";
                    }
                    if ("UNITS".equals(name)) {
                        return Units.us2000;
                    }
                    if ("ELEMENT_NAME".equals(name)) {
                        return "TimeBins";
                    }
                    if ("START_INDEX".equals(name)) {
                        return 0;
                    }
                } else if (i == 2 || i == 3 || i == 4) {
                    if ("DEPEND_1".equals(name)) {
                        return Ops.labelsDataset(new String[]{"B-GSM-X", "B-GSM-Y", "B-GSM-Z"});
                    }
                    if ("DEPENDNAME_0".equals(name)) {
                        return "TimeBins";
                    }
                    if ("UNITS".equals(name)) {
                        return Units.meters;
                    }
                    if ("ELEMENT_NAME".equals(name)) {
                        return "BGSM";
                    }
                    if ("START_INDEX".equals(name)) {
                        return 2;
                    }
                } else if (i == 5) {
                    if ("DEPENDNAME_0".equals(name)) {
                        return "TimeBins";
                    }
                    if ("UNITS".equals(name)) {
                        return Units.cmps;
                    }
                } else {
                    throw new IllegalArgumentException("bad index");
                }
                return null;
            }

            @Override
            public double value(int i, int i1) {
                if (i == 0 || i == 1) {
                    return 2.0;
                }
                if (i == 2 || i == 3 || i == 4) {
                    return 3.0;
                }
                if (i == 5) {
                    throw new IndexOutOfBoundsException("bad index");
                }
                throw new IndexOutOfBoundsException("bad index");
            }
        };
        result.putProperty("BUNDLE_1", bundleDescriptor);
        return result;
    }

    public static void main(String[] args) {
        QDataSet ds = BundleBinsDemo.demo1();
        System.err.println(DataSetOps.unbundle(ds, "TimeBins"));
        System.err.println(DataSetOps.unbundle(ds, "BGSM"));
        System.err.println(DataSetOps.unbundle(ds, "Speed"));
    }
}

