/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.util.Vector;
import org.apache.batik.svggen.font.table.GlyfCompositeComp;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfCompositeDescript
extends GlyfDescript {
    private Vector components = new Vector();

    public GlyfCompositeDescript(GlyfTable parentTable, ByteArrayInputStream bais) {
        super(parentTable, (short)-1, bais);
        GlyfCompositeComp comp;
        int firstIndex = 0;
        int firstContour = 0;
        do {
            comp = new GlyfCompositeComp(firstIndex, firstContour, bais);
            this.components.addElement(comp);
            GlyfDescript desc = parentTable.getDescription(comp.getGlyphIndex());
            if (desc == null) continue;
            firstIndex += desc.getPointCount();
            firstContour += desc.getContourCount();
        } while ((comp.getFlags() & 0x20) != 0);
        if ((comp.getFlags() & 0x100) != 0) {
            this.readInstructions(bais, bais.read() << 8 | bais.read());
        }
    }

    public int getEndPtOfContours(int i) {
        GlyfCompositeComp c = this.getCompositeCompEndPt(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            return gd.getEndPtOfContours(i - c.getFirstContour()) + c.getFirstIndex();
        }
        return 0;
    }

    public byte getFlags(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            return gd.getFlags(i - c.getFirstIndex());
        }
        return 0;
    }

    public short getXCoordinate(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            int n = i - c.getFirstIndex();
            short x = gd.getXCoordinate(n);
            short y = gd.getYCoordinate(n);
            short x1 = (short)c.scaleX(x, y);
            x1 = (short)(x1 + c.getXTranslate());
            return x1;
        }
        return 0;
    }

    public short getYCoordinate(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            int n = i - c.getFirstIndex();
            short x = gd.getXCoordinate(n);
            short y = gd.getYCoordinate(n);
            short y1 = (short)c.scaleY(x, y);
            y1 = (short)(y1 + c.getYTranslate());
            return y1;
        }
        return 0;
    }

    public boolean isComposite() {
        return true;
    }

    public int getPointCount() {
        GlyfCompositeComp c = (GlyfCompositeComp)this.components.elementAt(this.components.size() - 1);
        return c.getFirstIndex() + this.parentTable.getDescription(c.getGlyphIndex()).getPointCount();
    }

    public int getContourCount() {
        GlyfCompositeComp c = (GlyfCompositeComp)this.components.elementAt(this.components.size() - 1);
        return c.getFirstContour() + this.parentTable.getDescription(c.getGlyphIndex()).getContourCount();
    }

    public int getComponentIndex(int i) {
        return ((GlyfCompositeComp)this.components.elementAt(i)).getFirstIndex();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    protected GlyfCompositeComp getCompositeComp(int i) {
        int n = 0;
        while (n < this.components.size()) {
            GlyfCompositeComp c = (GlyfCompositeComp)this.components.elementAt(n);
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            if (c.getFirstIndex() <= i && i < c.getFirstIndex() + gd.getPointCount()) {
                return c;
            }
            ++n;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int i) {
        int j = 0;
        while (j < this.components.size()) {
            GlyfCompositeComp c = (GlyfCompositeComp)this.components.elementAt(j);
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            if (c.getFirstContour() <= i && i < c.getFirstContour() + gd.getContourCount()) {
                return c;
            }
            ++j;
        }
        return null;
    }
}

