/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkImageSequence;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;

public class GridPngWalkView
extends PngWalkView {
    private int thumbSize = 100;
    private int nCols = 1;
    private JScrollPane scrollPane;
    private GridViewCanvas canvas;
    private double restoreScrollPct = -1.0;
    public static final int PAINT_THUMB_TIMEOUT_MS = 200;

    public GridPngWalkView(WalkImageSequence sequence) {
        super(sequence);
        MouseWheelListener[] ll;
        this.setShowCaptions(true);
        this.setLayout(new BorderLayout());
        this.canvas = new GridViewCanvas();
        this.scrollPane = new JScrollPane(this.canvas);
        this.scrollPane.setPreferredSize(new Dimension(640, 640));
        for (MouseWheelListener l : ll = this.scrollPane.getMouseWheelListeners()) {
            this.scrollPane.removeMouseWheelListener(l);
        }
        this.scrollPane.addMouseWheelListener(this.getMouseWheelListener());
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GridPngWalkView.this.seq == null) {
                    return;
                }
                GridPngWalkView.this.selectCellAt(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if (GridPngWalkView.this.seq == null) {
                        return;
                    }
                    GridPngWalkView.this.selectCellAt(e.getX(), e.getY());
                    GridPngWalkView.this.getPopup().show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (e.isPopupTrigger()) {
                    GridPngWalkView.this.getPopup().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.canvas.addMouseListener(ma);
        this.canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GridPngWalkView.this.nCols = GridPngWalkView.this.getWidth() / GridPngWalkView.this.thumbSize;
                if (GridPngWalkView.this.nCols == 0) {
                    GridPngWalkView.this.nCols = 1;
                }
                if (GridPngWalkView.this.restoreScrollPct >= 0.0) {
                    JScrollBar sb = GridPngWalkView.this.scrollPane.getVerticalScrollBar();
                    int newScroll = (int)(GridPngWalkView.this.restoreScrollPct * (double)(sb.getMaximum() - sb.getVisibleAmount()));
                    sb.setValue(newScroll);
                    GridPngWalkView.this.restoreScrollPct = -1.0;
                }
                GridPngWalkView.this.updateLayout();
            }
        });
        this.scrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){
            Timer repaintTimer = new Timer("GridViewRepaintDelay", true);
            TimerTask task;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.task != null) {
                    this.task.cancel();
                }
                if (GridPngWalkView.this.seq == null) {
                    return;
                }
                if (!GridPngWalkView.this.canvas.isShowing()) {
                    return;
                }
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        Rectangle bounds = GridPngWalkView.this.scrollPane.getViewport().getViewRect();
                        int rowMin = bounds.y / GridPngWalkView.this.thumbSize;
                        int rowMax = Math.min((bounds.y + bounds.height) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.seq.size() / GridPngWalkView.this.nCols + 1);
                        int colMin = Math.min(bounds.x / GridPngWalkView.this.thumbSize, GridPngWalkView.this.nCols);
                        int colMax = Math.min((bounds.x + bounds.width) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.nCols);
                        for (int row = rowMin; row < rowMax; ++row) {
                            int n;
                            for (int col = colMin; col < colMax && (n = row * GridPngWalkView.this.nCols + col) < GridPngWalkView.this.seq.size(); ++col) {
                                GridPngWalkView.this.seq.imageAt(n).getThumbnail(true);
                            }
                        }
                    }
                };
                this.repaintTimer.schedule(this.task, 200L);
            }
        });
        this.add(this.scrollPane);
    }

    public BufferedImage paintContactSheet() {
        BufferedImage im;
        int yh;
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        if (h > (yh = this.scrollPane.getViewport().getHeight())) {
            im = new BufferedImage(w, h, 2);
        } else {
            im = new BufferedImage(w, yh, 2);
            Graphics g = im.getGraphics();
            g.setColor(this.getBackground());
            im.getGraphics().fillRect(0, 0, w, yh);
        }
        this.canvas.paint(im.getGraphics());
        int y0 = this.scrollPane.getViewport().getViewRect().y;
        if (im.getHeight() > yh) {
            im = im.getSubimage(0, y0, im.getWidth(), yh);
        }
        return im;
    }

    private void updateLayout() {
        if (this.canvas == null) {
            return;
        }
        if (this.seq != null) {
            this.canvas.setPreferredSize(new Dimension(this.thumbSize * this.nCols, this.thumbSize * (this.seq.size() / this.nCols + 1)));
        } else {
            this.canvas.setPreferredSize(new Dimension(0, 0));
        }
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    @Override
    protected void sequenceChanged() {
        this.updateLayout();
        if (this.scrollPane != null) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    @Override
    protected void thumbnailSizeChanged() {
        JScrollBar sb = this.scrollPane.getVerticalScrollBar();
        this.restoreScrollPct = (double)sb.getValue() / (double)(sb.getMaximum() - sb.getVisibleAmount());
        this.thumbSize = this.getThumbnailSize();
        this.nCols = this.getWidth() / this.thumbSize;
        if (this.nCols == 0) {
            this.nCols = 1;
        }
        this.updateLayout();
        super.thumbnailSizeChanged();
    }

    @Override
    public JComponent getMouseTarget() {
        return this.canvas;
    }

    private void selectCellAt(int x, int y) {
        if (x > this.nCols * this.thumbSize) {
            return;
        }
        int row = y / this.thumbSize;
        int col = x / this.thumbSize;
        int n = row * this.nCols + col;
        if (n >= this.seq.size()) {
            return;
        }
        this.seq.setIndex(n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("index")) {
            int i = (Integer)e.getOldValue();
            int x = i % this.nCols * this.thumbSize;
            int y = i / this.nCols * this.thumbSize;
            this.canvas.repaint(new Rectangle(x, y, this.thumbSize, this.thumbSize));
            i = (Integer)e.getNewValue();
            x = i % this.nCols * this.thumbSize;
            y = i / this.nCols * this.thumbSize;
            this.canvas.repaint(new Rectangle(x, y, this.thumbSize, this.thumbSize));
            int scrollMin = this.scrollPane.getVerticalScrollBar().getValue();
            int scrollMax = scrollMin + this.scrollPane.getVerticalScrollBar().getVisibleAmount();
            int pos = y - this.getHeight() / 2 - this.thumbSize / 2;
            if (scrollMin > y || scrollMax < y + this.thumbSize) {
                this.scrollPane.getVerticalScrollBar().setValue(pos);
            }
        } else if (e.getPropertyName().equals("thumbLoaded") || e.getPropertyName().equals("imageLoaded") || e.getPropertyName().equals("badgeChange")) {
            int i = (Integer)e.getNewValue();
            int y = i / this.nCols * this.thumbSize;
            int x = i % this.nCols * this.thumbSize;
            this.canvas.repaint(new Rectangle(x, y, this.thumbSize, this.thumbSize));
            this.canvas.repaintSoon();
        } else if (e.getPropertyName().equals("sequenceChanged")) {
            this.sequenceChanged();
        }
    }

    @Override
    int getNextInterval(int index) {
        return index + this.nCols;
    }

    @Override
    int getNextPage(int index) {
        return index + this.nCols * 4;
    }

    @Override
    int getPrevInterval(int index) {
        return index - this.nCols;
    }

    @Override
    int getPrevPage(int index) {
        return index - this.nCols * 4;
    }

    private class GridViewCanvas
    extends JPanel
    implements Scrollable {
        private Font smallFont = new Font("Dialog", 0, 6);
        private Font normalFont = new Font("Dialog", 0, 12);
        javax.swing.Timer repaintTimer;

        GridViewCanvas() {
            this.repaintTimer = new javax.swing.Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GridViewCanvas.this.repaint();
                }
            });
            this.repaintTimer.setRepeats(false);
        }

        private void repaintSoon() {
            this.repaintTimer.restart();
        }

        @Override
        public void paintComponent(Graphics g1) {
            long t0 = System.currentTimeMillis();
            super.paintComponent(g1);
            Graphics2D g2 = (Graphics2D)g1;
            if (GridPngWalkView.this.thumbSize < 100) {
                g2.setFont(this.smallFont);
            } else {
                g2.setFont(this.normalFont);
            }
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (GridPngWalkView.this.seq == null) {
                return;
            }
            Rectangle bounds = g2.getClipBounds();
            int rowMin = bounds.y / GridPngWalkView.this.thumbSize;
            int rowMax = Math.min((bounds.y + bounds.height) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.seq.size() / GridPngWalkView.this.nCols + 1);
            int colMin = Math.min(bounds.x / GridPngWalkView.this.thumbSize, GridPngWalkView.this.nCols);
            int colMax = Math.min((bounds.x + bounds.width) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.nCols);
            FontMetrics fm = g2.getFontMetrics();
            List<DatumRange> drs = GridPngWalkView.this.seq.getActiveSubrange();
            boolean outOfTime = false;
            for (int i = 0; i < GridPngWalkView.this.seq.size(); ++i) {
                GridPngWalkView.this.seq.imageAt(i).removeObserver(GridPngWalkView.this);
            }
            for (int row = rowMin; row < rowMax; ++row) {
                int i;
                for (int col = colMin; col < colMax && (i = row * GridPngWalkView.this.nCols + col) < GridPngWalkView.this.seq.size(); ++col) {
                    DatumRange dr;
                    Dimension thumbd;
                    if (GridPngWalkView.this.seq.getIndex() == i) {
                        Color oldColor = g2.getColor();
                        g2.setColor(Color.orange);
                        g2.fillRect(col * GridPngWalkView.this.thumbSize, row * GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize);
                        g2.setColor(oldColor);
                    }
                    WalkImage wimage = GridPngWalkView.this.seq.imageAt(i);
                    wimage.addObserver(GridPngWalkView.this);
                    BufferedImage thumb = wimage.getThumbnail(false);
                    if (thumb == null && wimage.getStatus() != WalkImage.Status.SIZE_THUMB_LOADED) {
                        thumb = wimage.getThumbnail(!GridPngWalkView.this.scrollPane.getVerticalScrollBar().getValueIsAdjusting());
                    }
                    if ((thumbd = wimage.getThumbnailDimension(false)) != null) {
                        double s = Math.min((double)(GridPngWalkView.this.thumbSize - 4) / thumbd.getWidth(), (double)(GridPngWalkView.this.thumbSize - 4 - fm.getHeight()) / thumbd.getHeight());
                        if (s < 1.0) {
                            int h;
                            int w = (int)(s * thumbd.getWidth());
                            BufferedImage whthumb = wimage.getThumbnail(w, h = (int)(s * thumbd.getHeight()), !(outOfTime = outOfTime || System.currentTimeMillis() - t0 > 200L));
                            thumb = whthumb;
                            if (thumb == PngWalkView.loadingImage) {
                                this.repaintSoon();
                            }
                        } else if (GridPngWalkView.this.thumbSize == 400) {
                            int h;
                            int w = (int)thumbd.getWidth();
                            BufferedImage whthumb = wimage.getThumbnail(w, h = (int)thumbd.getHeight(), !(outOfTime = outOfTime || System.currentTimeMillis() - t0 > 200L));
                            thumb = whthumb;
                            if (thumb == PngWalkView.loadingImage) {
                                this.repaintSoon();
                            }
                        } else {
                            thumb = PngWalkView.loadingImage;
                        }
                    } else {
                        thumb = wimage.getStatus() == WalkImage.Status.MISSING ? wimage.getImage() : PngWalkView.loadingImage;
                    }
                    int imgX = col * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize - thumb.getWidth()) / 2;
                    int imgY = row * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize - thumb.getHeight() - fm.getHeight()) / 2;
                    g2.drawImage((Image)thumb, imgX, imgY, null);
                    if (PngWalkTool.isQualityControlEnabled() && GridPngWalkView.this.seq.getQualityControlSequence() != null) {
                        GridPngWalkView.this.paintQualityControlIcon(i, g2, imgX, imgY, true);
                    }
                    if ((dr = GridPngWalkView.this.seq.getTimeSpan()) != null) {
                        try {
                            Shape oldClip;
                            int cy;
                            int ds = 6;
                            if (drs != null && !GridPngWalkView.this.seq.isShowMissing() && i < GridPngWalkView.this.seq.size() - 1 && GridPngWalkView.this.seq.imageAt(i + 1).getDatumRange().min().subtract(wimage.getDatumRange().max()).doubleValue(Units.seconds) > 0.0) {
                                g2.setColor(Color.GRAY);
                                int cx = col * GridPngWalkView.this.thumbSize + GridPngWalkView.this.thumbSize - ds;
                                cy = row * GridPngWalkView.this.thumbSize + GridPngWalkView.this.thumbSize - fm.getHeight() - 3;
                                oldClip = g2.getClip();
                                g2.clip(new Rectangle(cx, row * GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize));
                                g2.fillPolygon(new int[]{cx, cx + ds, cx + ds, cx}, new int[]{cy, cy - ds, cy, cy}, 4);
                                g2.setClip(oldClip);
                            }
                            if (drs != null && i > 0 && !GridPngWalkView.this.seq.isShowMissing() && GridPngWalkView.this.seq.imageAt(i).getDatumRange().min().subtract(GridPngWalkView.this.seq.imageAt(i - 1).getDatumRange().max()).doubleValue(Units.seconds) > 0.0) {
                                g2.setColor(Color.GRAY);
                                int cx = col * GridPngWalkView.this.thumbSize;
                                cy = row * GridPngWalkView.this.thumbSize + GridPngWalkView.this.thumbSize - fm.getHeight() - 3;
                                oldClip = g2.getClip();
                                g2.clip(new Rectangle(cx, row * GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize));
                                g2.fillPolygon(new int[]{cx, cx, cx + ds, cx}, new int[]{cy, cy - ds, cy, cy}, 4);
                                g2.setClip(oldClip);
                            }
                        }
                        catch (NullPointerException ex) {
                            PngWalkView.logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    if (!GridPngWalkView.this.showCaptions || wimage.getCaption() == null) continue;
                    int cx = col * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize - thumb.getWidth()) / 2;
                    int cy = row * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize + thumb.getHeight() + fm.getHeight()) / 2;
                    g2.setColor(Color.BLACK);
                    Shape oldClip = g2.getClip();
                    g2.clip(new Rectangle(cx, row * GridPngWalkView.this.thumbSize, (GridPngWalkView.this.thumbSize + thumb.getWidth()) / 2, GridPngWalkView.this.thumbSize));
                    String s = wimage.getCaption();
                    if (s.startsWith("orbit:")) {
                        s = s.substring(6);
                    }
                    if (s.length() > 20 && GridPngWalkView.this.thumbSize < 400) {
                        g2.setFont(this.smallFont);
                    }
                    g2.drawString(s, cx, cy);
                    g2.setClip(oldClip);
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return GridPngWalkView.this.thumbSize;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            int x = GridPngWalkView.this.scrollPane.getVerticalScrollBar().getVisibleAmount() / GridPngWalkView.this.thumbSize * GridPngWalkView.this.thumbSize;
            return x;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

