/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class EventsStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    EnumerationEditor lineEditor;
    private JCheckBox colorCB;
    private JPanel colorPanel;
    private JTextField fontSizeTF;
    private JCheckBox ganttModeCB;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JPanel lineStylePanel;
    private JComboBox<String> lineThickComboBox;
    private JCheckBox opaqueCheckBox;
    private JCheckBox orbitModeCB;
    private JCheckBox showLabelsCB;
    BindingGroup elementBindingContext;
    Renderer renderer;
    ColorEditor colorEditor1;
    private String control = "";
    public static final String PROP_CONTROL = "control";

    public EventsStylePanel() {
        this.initComponents();
        this.colorEditor1 = new ColorEditor();
        this.colorEditor1.setValue((Object)Color.BLACK);
        this.colorPanel.add(this.colorEditor1.getSmallEditor());
        this.colorEditor1.addPropertyChangeListener(evt -> this.update());
        this.lineEditor = new EnumerationEditor();
        this.lineEditor.addPropertyChangeListener(evt -> this.update());
        this.lineEditor.setValue((Object)PsymConnector.SOLID);
        this.lineStylePanel.add(this.lineEditor.getCustomEditor(), "Center");
    }

    private void initComponents() {
        this.showLabelsCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.fontSizeTF = new JTextField();
        this.orbitModeCB = new JCheckBox();
        this.ganttModeCB = new JCheckBox();
        this.colorPanel = new JPanel();
        this.colorCB = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jLabel3 = new JLabel();
        this.lineStylePanel = new JPanel();
        this.lineThickComboBox = new JComboBox();
        this.opaqueCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Events Bar"));
        this.showLabelsCB.setText("Show Labels");
        this.showLabelsCB.setToolTipText("Show event labels along with bar.");
        this.showLabelsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.showLabelsCBActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Font Size:");
        this.jLabel1.setToolTipText("font size like \"16pt\" or where 0.5em is half the size of the parent font.");
        this.fontSizeTF.setText("1em");
        this.fontSizeTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EventsStylePanel.this.fontSizeTFFocusLost(evt);
            }
        });
        this.fontSizeTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.fontSizeTFActionPerformed(evt);
            }
        });
        this.orbitModeCB.setText("Orbit Mode");
        this.orbitModeCB.setToolTipText("Show the events in special orbit mode along the bottom with labels.");
        this.orbitModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.orbitModeCBActionPerformed(evt);
            }
        });
        this.ganttModeCB.setText("Gantt Mode");
        this.ganttModeCB.setToolTipText("Show events in a Gantt Chart, with instances enumerated along the vertical axis.\n");
        this.ganttModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.ganttModeCBActionPerformed(evt);
            }
        });
        this.colorPanel.setLayout(new BorderLayout());
        this.colorCB.setText("Color:");
        this.colorCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.colorCBActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Line Style:");
        this.jLabel10.setToolTipText("style of the plot trace, or none");
        this.jLabel3.setText("Line Thickness:");
        this.jLabel3.setToolTipText("thickness of the plot trace");
        this.lineStylePanel.setLayout(new BorderLayout());
        this.lineThickComboBox.setEditable(true);
        this.lineThickComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "1pt", "0.5em", "1%"}));
        this.lineThickComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EventsStylePanel.this.lineThickComboBoxFocusLost(evt);
            }
        });
        this.lineThickComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.lineThickComboBoxActionPerformed(evt);
            }
        });
        this.opaqueCheckBox.setText("Opaque");
        this.opaqueCheckBox.setToolTipText("By default events are drawn with some transparency, this instead makes them opaque.");
        this.opaqueCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.opaqueCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showLabelsCB).addComponent(this.orbitModeCB).addComponent(this.ganttModeCB).addGroup(layout.createSequentialGroup().addComponent(this.colorCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.colorPanel, -2, 89, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontSizeTF, -2, 83, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel10).addComponent(this.opaqueCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineStylePanel, -2, 125, -2).addComponent(this.lineThickComboBox, -2, -1, -2)))).addContainerGap(123, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showLabelsCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fontSizeTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orbitModeCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ganttModeCB).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorPanel, GroupLayout.Alignment.TRAILING, -2, 28, -2).addComponent(this.colorCB, GroupLayout.Alignment.TRAILING)).addGap(2, 2, 2).addComponent(this.opaqueCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lineStylePanel, -2, 24, -2).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel10))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.lineThickComboBox, -2, -1, -2)).addContainerGap(30, Short.MAX_VALUE)));
    }

    private void showLabelsCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void fontSizeTFActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void fontSizeTFFocusLost(FocusEvent evt) {
        this.update();
    }

    private void orbitModeCBActionPerformed(ActionEvent evt) {
        if (this.orbitModeCB.isSelected()) {
            this.ganttModeCB.setSelected(false);
        }
        this.update();
    }

    private void ganttModeCBActionPerformed(ActionEvent evt) {
        if (this.ganttModeCB.isSelected()) {
            this.orbitModeCB.setSelected(false);
        }
        this.update();
    }

    private void colorCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void lineThickComboBoxActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void lineThickComboBoxFocusLost(FocusEvent evt) {
        this.update();
    }

    private void opaqueCheckBoxActionPerformed(ActionEvent evt) {
        this.update();
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("fontSize", this.fontSizeTF.getText());
        controls.put("showLabels", Renderer.encodeBooleanControl((boolean)this.showLabelsCB.isSelected()));
        controls.put("orbitMode", Renderer.encodeBooleanControl((boolean)this.orbitModeCB.isSelected()));
        controls.put("ganttMode", Renderer.encodeBooleanControl((boolean)this.ganttModeCB.isSelected()));
        controls.put("lineStyle", Renderer.encodePlotSymbolConnectorControl((PsymConnector)((PsymConnector)this.lineEditor.getCellEditorValue())));
        controls.put("lineThick", this.lineThickComboBox.getSelectedItem().toString());
        if (this.colorCB.isSelected()) {
            controls.put("color", Renderer.encodeColorControl((Color)((Color)this.colorEditor1.getValue())));
        }
        controls.put("opaque", Renderer.encodeBooleanControl((boolean)this.opaqueCheckBox.isSelected()));
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        this.fontSizeTF.setText(renderer.getControl("fontSize", "1em"));
        this.lineThickComboBox.setSelectedItem(renderer.getControl("lineThick", ""));
        this.lineEditor.setAsText(renderer.getControl("lineStyle", this.lineEditor.getValue().toString()));
        this.showLabelsCB.setSelected(renderer.getBooleanControl("showLabels", false));
        this.orbitModeCB.setSelected(renderer.getBooleanControl("orbitMode", false));
        this.ganttModeCB.setSelected(renderer.getBooleanControl("ganttMode", false));
        this.opaqueCheckBox.setSelected(renderer.getBooleanControl("opaque", false));
        if (renderer.hasControl("color")) {
            this.colorCB.setSelected(true);
            this.colorEditor1.setValue((Object)renderer.getColorControl("color", Color.BLACK));
        }
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }
}

