/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.awt.Graphics2D;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.Painter;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;

public class Test014 {
    private static final Set<Integer> usedIds = new HashSet<Integer>();

    public static void doTest(int id, String uri, QDataSet ds) throws Exception {
        MutablePropertyDataSet hist;
        QDataSet diff;
        System.err.println(String.format("== doTest(%d,%s) ==", id, uri));
        if (usedIds.contains(id)) {
            throw new IllegalArgumentException("id " + id + " used twice, test code needs attention");
        }
        usedIds.add(id);
        long t0 = System.currentTimeMillis();
        String label = String.format("test014_%03d", id);
        if (ds == null) {
            ds = Util.getDataSet((String)uri);
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        System.err.printf("Read data in %9.3f seconds (%s): %s\n", t, label, uri);
        if (dep0 == null) {
            dep0 = ds;
        }
        RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)dep0, (QDataSet)ds);
        t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        System.err.printf("Guess cadence in %9.3f seconds (%s): %s\n", t, label, uri);
        String type = cadence == null ? null : (String)cadence.property("SCALE_TYPE");
        String sunits = cadence == null ? null : String.valueOf(SemanticOps.getUnits((QDataSet)cadence));
        System.err.printf("cadence= %s (scale type=%s) (units=%s): \n", String.valueOf(cadence), type, sunits);
        if (ds.rank() == 1 && dep0.rank() == 1) {
            QDataSet r = Ops.where((QDataSet)Ops.valid((QDataSet)ds));
            diff = Ops.diff((QDataSet)DataSetOps.applyIndex((QDataSet)dep0, (int)0, (QDataSet)r, (boolean)false));
        } else {
            diff = Ops.diff((QDataSet)dep0);
        }
        System.err.printf("diffs(dep0)[0:3]= %f %f %f %s\n", diff.value(0), diff.value(1), diff.value(2), String.valueOf(diff.property("UNITS")));
        if ("log".equals(type)) {
            hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)Ops.diff((QDataSet)Ops.log((QDataSet)dep0)));
            ((MutablePropertyDataSet)hist.property("DEPEND_0")).putProperty("UNITS", (Object)Units.logERatio);
        } else {
            hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)diff);
        }
        if ("log".equals(type)) {
            ScriptContext.getDocumentModel().getPlots(0).getXaxis().setRange(DatumRange.newDatumRange((double)0.0, (double)10.0, (Units)Units.seconds));
        }
        ScriptContext.plot((QDataSet)hist);
        hist = Ops.copy((QDataSet)hist);
        ScriptContext.setCanvasSize(600, 600);
        DasCanvas cc = ScriptContext.getDocumentModel().getCanvases(0).getController().getDasCanvas();
        DasAxis xAxis = ScriptContext.getDocumentModel().getPlots(0).getXaxis().getController().getDasAxis();
        xAxis.setLabel("UNITS=%{UNITS}");
        Painter p = new Painter((QDataSet)cadence, cc){
            final /* synthetic */ QDataSet val$cadence;
            final /* synthetic */ DasCanvas val$cc;
            {
                this.val$cadence = qDataSet;
                this.val$cc = dasCanvas;
            }

            public void paint(Graphics2D g) {
                DasAxis xAxis = ScriptContext.getDocumentModel().getPlots(0).getXaxis().getController().getDasAxis();
                if (this.val$cadence != null) {
                    int ix = (int)xAxis.transform(DataSetUtil.asDatum((QDataSet)this.val$cadence));
                    g.drawLine(ix, 0, ix, this.val$cc.getHeight());
                }
            }
        };
        cc.addTopDecorator(p);
        int i = uri.lastIndexOf("/");
        ScriptContext.setTitle(uri.substring(i + 1) + "!c cadence=" + cadence);
        ScriptContext.writeToPng(String.format("test014_%03d.png", id));
        cc.removeTopDecorator(p);
        hist.putProperty("TITLE", (Object)(uri + "!c cadence=" + cadence));
        hist.putProperty("LABEL", (Object)label);
        hist.putProperty("LABEL", (Object)label);
        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
    }

    public static void main(String[] args) throws InterruptedException, IOException, Exception {
        try {
            System.err.println("== datum formatting experiments ==");
            Datum d = DatumUtil.parse((String)"150.00 ms");
            System.err.println("as millisecond unit: " + d);
            d = Units.nanoseconds.createDatum(1.5E8);
            System.err.println("as nanoseconds unit: " + d);
            System.err.println("with asOrderOneUnits call: " + DatumUtil.asOrderOneUnits((Datum)d));
            System.err.println("== done, datum formatting experiments, thanks ==");
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            QDataSet ds = Util.getDataSet((String)"file:///home/jbf/ct/hudson/data/qds/cadence.qds");
            Test014.doTest(9, "file:///home/jbf/ct/hudson/data/qds/cadence.qds", ds);
            ds = Util.getDataSet((String)"vap+cdf:file:///home/jbf/ct/jenkins/data/cdf/LANL_LANL-97A_H3_SOPA_20060505_V01.cdf?FEDU");
            ds = (QDataSet)ds.property("DEPEND_1");
            Test014.doTest(6, "depend 1 of vap+cdf:file:///home/jbf/ct/jenkins/data/cdf/LANL_LANL-97A_H3_SOPA_20060505_V01.cdf?FEDU", ds);
            ds = Util.getDataSet((String)"vap+cdf:http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hydra/hyd_h0/2000/po_h0_hyd_20000109_v01.cdf?ELECTRON_DIFFERENTIAL_ENERGY_FLUX");
            ds = DataSetOps.slice0((QDataSet)ds, (int)10);
            Test014.doTest(4, "slice of Hydra DEF", ds);
            ds = Util.getDataSet((String)"vap+cdf:file:/home/jbf/ct/hudson/data.backup/cdf/c2_waveform_wbd_200704170840_u01.cdf?WBD_Elec[::1090]");
            QDataSet ant = Util.getDataSet((String)"vap+cdf:file:/home/jbf/ct/hudson/data.backup/cdf/c2_waveform_wbd_200704170840_u01.cdf?ANTENNA[::1090]");
            QDataSet r = Ops.where((QDataSet)Ops.eq((QDataSet)ant, (QDataSet)DataSetUtil.asDataSet((double)2.0)));
            ds = DataSetOps.applyIndex((QDataSet)ds, (int)0, (QDataSet)r, (boolean)true);
            Test014.doTest(0, "file:/home/jbf/ct/hudson/data.backup/cdf/c2_waveform_wbd_200704170840_u01.cdf?WBD_Elec[::1090]", ds);
            Test014.doTest(1, "file:/home/jbf/ct/hudson/data.backup/cdf/i8_15sec_mag_19731030_v02.cdf?F1_Average_B_15s", null);
            Test014.doTest(2, "file:/home/jbf/ct/hudson/data.backup/xls/2008-lion and tiger summary.xls?sheet=Samantha+tiger+lp+lofreq&firstRow=53&column=Complex_Modulus&depend0=Frequency", null);
            Test014.doTest(3, "file:/home/jbf/ct/hudson/data.backup/dat/cl_ttag_study.dat?column=field0", null);
            Test014.doTest(5, "file:/home/jbf/ct/hudson/data.backup/dat/power.dat.txt", null);
            Test014.doTest(7, "file:/home/jbf/ct/hudson/data.backup/cdf/rbsp-b_WFR-spectral-matrix_emfisis-L1_20121015120844_v1.2.2.cdf?BuBu[0]", null);
            Test014.doTest(8, "file:/home/jbf/ct/hudson/data.backup/dat/apl/jon/electron_events_safings_and_peaks.csv?column=peak_rate&depend0=begin_UTC", null);
            Test014.doTest(10, "file:/home/jbf/ct/hudson/data.backup/cdf/mms1_fpi_brst_l2_dis-dist_20160111063934_v3.1.0.cdf?mms1_dis_dist_brst", null);
            Test014.doTest(11, "file:/home/jbf/ct/hudson/data/d2s/testStream.d2s", null);
            Test014.doTest(12, "file:/home/jbf/ct/hudson/data/test014/test014_012.qds", null);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

