/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class Test028 {
    private static final String test = "test028";

    public static void doTest(int id, String uri) throws Exception {
        System.err.printf("== %d %s ==\n", id, uri);
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet((String)uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
        hist.putProperty("TITLE", (Object)uri);
        String label = String.format("test028_%03d", id);
        hist.putProperty("LABEL", (Object)label);
        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
            ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        int i = uri.lastIndexOf("/");
        ScriptContext.setTitle(uri.substring(i + 1));
        ScriptContext.writeToPng(String.format("test028_%03d.png", id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) {
        try {
            ScriptContext.setCanvasSize(640, 480);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-7em");
            ScriptContext.setCanvasSize(640, 480);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-7em");
            Test028.doTest(0, "vap+inline:1,2;3,4;5,6;7,2;9,0");
            Test028.doTest(2, "vap+inline:1,3;2,4");
            Test028.doTest(3, "vap+inline:ripples(100,100)");
            Test028.doTest(4, "vap+inline:linspace(0,1,100),linspace(0,1,100),ripples(100,100)");
            Test028.doTest(5, "vap+inline:ripples(100,100)+randomn(0,100,100)/10");
            Test028.doTest(6, "vap+inline:ripples(100,100)+randomn(0,100,100)/10&RENDER_TYPE=nnSpectrogram");
            Test028.doTest(7, "vap+inline:getDataSet('http://autoplot.org/data/autoplot.ncml')&RENDER_TYPE=nnSpectrogram");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

