/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.CString;
import org.apache.poi.hslf.record.ExEmbedAtom;
import org.apache.poi.hslf.record.ExOleObjAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class ExEmbed
extends RecordContainer {
    private byte[] _header = new byte[8];
    private RecordAtom embedAtom;
    private ExOleObjAtom oleObjAtom;
    private CString menuName;
    private CString progId;
    private CString clipboardName;

    protected ExEmbed(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    public ExEmbed() {
        this._children = new Record[5];
        this._header[0] = 15;
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        CString cs1 = new CString();
        CString cs2 = new CString();
        CString cs3 = new CString();
        this._children[0] = new ExEmbedAtom();
        this._children[1] = new ExOleObjAtom();
        this._children[2] = cs1;
        this._children[3] = cs2;
        this._children[4] = cs3;
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        this.embedAtom = this.getEmbedAtom(this._children);
        if (this._children[1] instanceof ExOleObjAtom) {
            this.oleObjAtom = (ExOleObjAtom)this._children[1];
        } else {
            this.logger.log(7, (Object)("Second child record wasn't a ExOleObjAtom, was of type " + this._children[1].getRecordType()));
        }
        for (int i = 2; i < this._children.length; ++i) {
            if (this._children[i] instanceof CString) {
                if (this.menuName == null) {
                    this.menuName = (CString)this._children[i];
                    continue;
                }
                if (this.progId == null) {
                    this.progId = (CString)this._children[i];
                    continue;
                }
                if (this.clipboardName != null) continue;
                this.clipboardName = (CString)this._children[i];
                continue;
            }
            this.logger.log(7, (Object)("Record after atoms wasn't a CString, was of type " + this._children[i].getRecordType()));
        }
    }

    protected RecordAtom getEmbedAtom(Record[] children) {
        ExEmbedAtom atom = null;
        if (this._children[0] instanceof ExEmbedAtom) {
            atom = (ExEmbedAtom)this._children[0];
        } else {
            this.logger.log(7, (Object)("First child record wasn't a ExEmbedAtom, was of type " + this._children[0].getRecordType()));
        }
        return atom;
    }

    public ExEmbedAtom getExEmbedAtom() {
        return (ExEmbedAtom)this.embedAtom;
    }

    public ExOleObjAtom getExOleObjAtom() {
        return this.oleObjAtom;
    }

    public String getMenuName() {
        return this.menuName == null ? null : this.menuName.getText();
    }

    public String getProgId() {
        return this.progId == null ? null : this.progId.getText();
    }

    public String getClipboardName() {
        return this.clipboardName == null ? null : this.clipboardName.getText();
    }

    public long getRecordType() {
        return RecordTypes.ExEmbed.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, out);
    }
}

