/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateTime
extends CoordinateTimeAbstract
implements Coordinate {
    private static final Logger logger = LoggerFactory.getLogger(CoordinateTime.class);
    private final List<Integer> offsetSorted;

    public CoordinateTime(int code, CalendarPeriod timeUnit, CalendarDate refDate, List<Integer> offsetSorted, int[] time2runtime) {
        super(code, timeUnit, refDate, time2runtime);
        this.offsetSorted = Collections.unmodifiableList(offsetSorted);
    }

    CoordinateTime(CoordinateTime org, CalendarDate refDate) {
        super(org.code, org.timeUnit, refDate, null);
        this.offsetSorted = org.getOffsetSorted();
    }

    public List<Integer> getOffsetSorted() {
        return this.offsetSorted;
    }

    @Override
    public List<?> getValues() {
        return this.offsetSorted;
    }

    @Override
    public int getIndex(Object val) {
        return Collections.binarySearch(this.offsetSorted, (Integer)val);
    }

    @Override
    public Object getValue(int idx) {
        return this.offsetSorted.get(idx);
    }

    @Override
    public int getSize() {
        return this.offsetSorted.size();
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.time;
    }

    @Override
    public int estMemorySize() {
        return 320 + this.getSize() * 16;
    }

    @Override
    public CalendarDateRange makeCalendarDateRange(Calendar cal) {
        CalendarDateUnit cdu = CalendarDateUnit.withCalendar(cal, this.periodName + " since " + this.refDate);
        CalendarDate start = cdu.makeCalendarDate(this.timeUnit.getValue() * this.offsetSorted.get(0));
        CalendarDate end = cdu.makeCalendarDate(this.timeUnit.getValue() * this.offsetSorted.get(this.getSize() - 1));
        return CalendarDateRange.of(start, end);
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s:", new Object[]{indent, this.getType()});
        for (Integer cd2 : this.offsetSorted) {
            info.format(" %3d,", cd2);
        }
        info.format(" (%d) %n", this.offsetSorted.size());
        if (this.time2runtime != null) {
            info.format("%stime2runtime: %s", indent, Arrays.toString(this.time2runtime));
        }
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Time offsets: (%s) ref=%s %n", this.getTimeUnit(), this.getRefDate());
        for (Integer cd2 : this.offsetSorted) {
            info.format("   %3d%n", cd2);
        }
    }

    @Override
    public Counters calcDistributions() {
        Counters counters = new Counters();
        counters.add("resol");
        List<Integer> offsets = this.getOffsetSorted();
        for (int i = 0; i < offsets.size() - 1; ++i) {
            int diff = offsets.get(i + 1) - offsets.get(i);
            counters.count("resol", Integer.valueOf(diff));
        }
        return counters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateTime that = (CoordinateTime)o;
        if (this.code != that.code) {
            return false;
        }
        return this.offsetSorted.equals(that.offsetSorted);
    }

    public int hashCode() {
        int result = this.offsetSorted.hashCode();
        result = 31 * result + this.code;
        return result;
    }

    @Override
    protected CoordinateTimeAbstract makeBestFromComplete(int[] best, int n) {
        ArrayList<Integer> offsetSortedBest = new ArrayList<Integer>(this.offsetSorted.size());
        int[] time2runtimeBest = new int[n];
        int count = 0;
        for (int i = 0; i < best.length; ++i) {
            int time = best[i];
            if (time < 0) continue;
            time2runtimeBest[count] = time;
            offsetSortedBest.add(this.offsetSorted.get(i));
            ++count;
        }
        return new CoordinateTime(this.code, this.timeUnit, this.refDate, offsetSortedBest, time2runtimeBest);
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        final Grib1Customizer cust;
        final int code;
        final CalendarPeriod timeUnit;
        final CalendarDate refDate;

        public Builder1(Grib1Customizer cust, int code, CalendarPeriod timeUnit, CalendarDate refDate) {
            this.cust = cust;
            this.code = code;
            this.timeUnit = timeUnit;
            this.refDate = refDate;
        }

        @Override
        public Object extract(Grib1Record gr) {
            Grib1SectionProductDefinition pds = gr.getPDSsection();
            Grib1ParamTime ptime = gr.getParamTime(this.cust);
            int offset = ptime.getForecastTime();
            int tuInRecord = pds.getTimeUnit();
            if (tuInRecord == this.code) {
                return offset;
            }
            CalendarDate validDate = GribUtils.getValidTime(this.refDate, tuInRecord, offset);
            return this.timeUnit.getOffset(this.refDate, validDate);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
            for (Object val : values) {
                offsetSorted.add((Integer)val);
            }
            Collections.sort(offsetSorted);
            return new CoordinateTime(this.code, this.timeUnit, this.refDate, offsetSorted, null);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CalendarDate refDate;

        public Builder2(int code, CalendarPeriod timeUnit, CalendarDate refDate) {
            this.code = code;
            this.timeUnit = timeUnit;
            this.refDate = refDate;
        }

        public Builder2(CoordinateTime from) {
            this.code = from.getCode();
            this.timeUnit = from.getTimeUnit();
            this.refDate = from.getRefDate();
        }

        @Override
        public Object extract(Grib2Record gr) {
            Grib2Pds pds = gr.getPDS();
            int offset = pds.getForecastTime();
            int tuInRecord = pds.getTimeUnit();
            if (tuInRecord == this.code) {
                return offset;
            }
            CalendarPeriod period = Grib2Utils.getCalendarPeriod(tuInRecord);
            if (period == null) {
                logger.warn("Cant find period for time unit=" + tuInRecord);
                return offset;
            }
            CalendarDate validDate = this.refDate.add(period.multiply(offset));
            return this.timeUnit.getOffset(this.refDate, validDate);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
            for (Object val : values) {
                offsetSorted.add((Integer)val);
            }
            Collections.sort(offsetSorted);
            return new CoordinateTime(this.code, this.timeUnit, this.refDate, offsetSorted, null);
        }
    }
}

