/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.qstream.TransferType;
import org.das2.util.FixedWidthFormatter;
import org.das2.util.NumberFormatUtil;

public class AsciiTransferType
extends TransferType {
    final int sizeBytes;
    private final DecimalFormat formatter;
    private String formatStr;

    public AsciiTransferType(int sizeBytes, boolean scientificNotation) {
        this.sizeBytes = sizeBytes;
        this.formatStr = AsciiTransferType.getFormat(sizeBytes - 1, scientificNotation);
        this.formatter = NumberFormatUtil.getDecimalFormat((String)this.formatStr);
    }

    AsciiTransferType(int sizeBytes, boolean scientificNotation, int decimals) {
        this.sizeBytes = sizeBytes;
        if (sizeBytes < 6) {
            throw new IllegalArgumentException("sizeBytes cannot be less than 6");
        }
        if (sizeBytes > 18) {
            throw new IllegalArgumentException("sizeBytes cannot be greater than 18");
        }
        if (decimals == 0) {
            this.formatStr = "0";
        } else if (decimals < 16) {
            String pounds = "################";
            this.formatStr = "0." + pounds.substring(0, decimals);
        } else {
            throw new IllegalArgumentException("decimals cannot be greater than 16");
        }
        if (scientificNotation) {
            this.formatStr = this.formatStr + "E00;-#";
        }
        this.formatter = NumberFormatUtil.getDecimalFormat((String)this.formatStr);
    }

    private static String getFormat(int length, boolean sci) {
        if (length < 9 || !sci) {
            if (length == 9) {
                return "0.####";
            }
            if (length == 8) {
                return "0.###";
            }
            if (length == 7) {
                return "0.##";
            }
            if (length == 6) {
                return "0.#";
            }
            if (length < 6) {
                return "0";
            }
            return "0.####";
        }
        StringBuilder buffer = new StringBuilder(length);
        buffer.append("+0.");
        for (int i = 0; i < length - 7; ++i) {
            buffer.append('0');
        }
        buffer.append("E00;-#");
        return buffer.toString();
    }

    @Override
    public void write(double d, ByteBuffer buffer) {
        String s = this.formatter.format(d);
        if (s.length() < this.sizeBytes) {
            s = s + " ";
        }
        if (s.length() < this.sizeBytes) {
            s = FixedWidthFormatter.format((String)s, (int)this.sizeBytes);
        }
        if (s.charAt(this.sizeBytes - 1) != ' ' && s.charAt(0) == '+') {
            s = s.substring(1) + ' ';
        }
        byte[] bytes = null;
        try {
            bytes = s.getBytes("US-ASCII");
            if (bytes.length != this.sizeBytes) {
                bytes = "***********************".substring(0, this.sizeBytes).getBytes("US-ASCII");
            }
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "write", ex);
        }
        buffer.put(bytes);
    }

    @Override
    public double read(ByteBuffer buffer) {
        byte[] bytes = new byte[this.sizeBytes];
        buffer.get(bytes);
        try {
            String str = new String(bytes, "US-ASCII").trim();
            return Double.parseDouble(str);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "read", ex);
            throw new RuntimeException(ex);
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @Override
    public int sizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public boolean isAscii() {
        return true;
    }

    @Override
    public String name() {
        return "ascii" + this.sizeBytes;
    }

    public static TransferType getByName(String name, Map<String, Object> properties) {
        Pattern p = Pattern.compile("ascii(\\d+)");
        Matcher m = p.matcher(name);
        if (m.matches()) {
            return new AsciiTransferType(Integer.parseInt(m.group(1)), true);
        }
        return null;
    }
}

