/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.AsciiIntegerTransferType;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.FloatTransferType;
import org.das2.qstream.IntegerTransferType;
import org.das2.qstream.LongTransferType;
import org.das2.qstream.TransferSciNotation;
import org.das2.qstream.TransferTimeAtPrecision;
import org.das2.qstream.TransferType;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public abstract class QdsToD2sStream {
    private static final Logger log = LoggerManager.getLogger((String)"qstream");
    public static final String FORMAT_2_2 = "2.2";
    public static final String FORMAT_2_3_BASIC = "2.3/basic";
    public static final String FORMAT_2_4_GENERAL = "2.4/general";
    public static final String[] formats = new String[]{"2.2", "2.3/basic"};
    public static final int DEFAUT_FRAC_SEC = 3;
    public static final int DEFAUT_SIG_DIGIT = 5;
    public static final int FIXED_PKT_TAGS = 0;
    public static final int VAR_PKT_TAGS = 1;
    protected int nSigDigit = 5;
    protected int nSecDigit = 3;
    protected boolean bBinary;
    private static final List<String> lSimpleKeys = new ArrayList<String>();

    public QdsToD2sStream() {
        this.bBinary = true;
    }

    public QdsToD2sStream(int genSigDigits, int fracSecDigits) {
        this.bBinary = false;
        if (genSigDigits > 1) {
            if (genSigDigits > 16) {
                throw new IllegalArgumentException(String.format("Number of significant digits in the output must be between 2 and 17, received %d", genSigDigits));
            }
            this.nSigDigit = genSigDigits;
        }
        if (fracSecDigits >= 0) {
            if (fracSecDigits < 0 || fracSecDigits > 12) {
                throw new IllegalArgumentException(String.format("Number of fractional seconds digits in the output must be between 0 and 12 inclusive, received %d", fracSecDigits));
            }
            this.nSecDigit = fracSecDigits;
        }
    }

    public abstract boolean canWrite(QDataSet var1);

    public abstract boolean write(QDataSet var1, OutputStream var2) throws IOException;

    static void writeHeader(OutputStream os, int nTagType, int nPktId, String sHdr) throws UnsupportedEncodingException, IOException {
        byte[] aHdr = sHdr.getBytes(StandardCharsets.UTF_8);
        String sTag = nTagType == 1 ? (nPktId == 0 ? String.format("|Hs||%d|", aHdr.length) : String.format("|Hx|%d|%d|", nPktId, aHdr.length)) : String.format("[%02d]%06d", nPktId, aHdr.length);
        byte[] aTag = sTag.getBytes(StandardCharsets.US_ASCII);
        os.write(aTag);
        os.write(aHdr);
    }

    protected void writeData(OutputStream out, int nTagType, int iPktId, PacketXferInfo pktXfer) throws IOException {
        WritableByteChannel channel = Channels.newChannel(out);
        String sRecTag = nTagType == 1 ? String.format("|Dx|%d|%d|", iPktId, pktXfer.xSliceBytes()) : String.format(":%02d:", iPktId);
        byte[] aRecTag = sRecTag.getBytes(StandardCharsets.US_ASCII);
        int nBufLen = pktXfer.xSliceBytes() + aRecTag.length;
        byte[] aBuf = new byte[nBufLen];
        ByteBuffer buffer = ByteBuffer.wrap(aBuf);
        buffer.order(ByteOrder.nativeOrder());
        buffer.put(aRecTag);
        int nPkts = pktXfer.lDsXfer.get((int)0).qds.length();
        for (int iPkt = 0; iPkt < nPkts; ++iPkt) {
            QdsXferInfo qi = null;
            block6: for (int iDs = 0; iDs < pktXfer.datasets(); ++iDs) {
                qi = pktXfer.lDsXfer.get(iDs);
                switch (qi.qds.rank()) {
                    case 1: {
                        qi.transtype.write(qi.qds.value(iPkt), buffer);
                        continue block6;
                    }
                    case 2: {
                        int iVal;
                        for (iVal = 0; iVal < qi.qds.length(iPkt); ++iVal) {
                            qi.transtype.write(qi.qds.value(iPkt, iVal), buffer);
                        }
                        continue block6;
                    }
                    case 3: {
                        int iVal;
                        for (iVal = 0; iVal < qi.qds.length(iPkt); ++iVal) {
                            for (int jVal = 0; jVal < qi.qds.length(iPkt, iVal); ++jVal) {
                                qi.transtype.write(qi.qds.value(iPkt, iVal, jVal), buffer);
                            }
                        }
                        continue block6;
                    }
                    default: {
                        assert (false);
                        continue block6;
                    }
                }
            }
            if (qi != null && qi.transtype.isAscii()) {
                buffer.put(nBufLen - 1, (byte)10);
            }
            buffer.flip();
            channel.write(buffer);
            buffer.position(aRecTag.length);
        }
    }

    protected String makeNameFromUnits(Units units) {
        if (units == null) {
            return "";
        }
        if (UnitsUtil.isTimeLocation((Units)units)) {
            return "time";
        }
        if (units.isConvertibleTo(Units.meters)) {
            return "length";
        }
        if (units.isConvertibleTo(Units.hertz)) {
            return "frequnecy";
        }
        if (units.isConvertibleTo(Units.eV)) {
            return "energy";
        }
        if (units.isConvertibleTo(Units.degrees)) {
            return "angle";
        }
        if (units.isConvertibleTo(Units.seconds)) {
            return "interval";
        }
        if (units.isConvertibleTo(Units.bytes)) {
            return "size";
        }
        if (units.isConvertibleTo(Units.cm_2s_1keV_1)) {
            return "flux";
        }
        if (units.isConvertibleTo(Units.kelvin)) {
            return "temperature";
        }
        String sUnits = units.toString();
        if (sUnits.equalsIgnoreCase("mhz")) {
            return "frequency";
        }
        if (sUnits.equalsIgnoreCase("khz")) {
            return "frequency";
        }
        if (sUnits.equalsIgnoreCase("hz")) {
            return "frequency";
        }
        if (sUnits.equalsIgnoreCase("V!a2!nm!a-2!nHz!a-1!n")) {
            return "e_spec_dens";
        }
        if (sUnits.equalsIgnoreCase("nT!a2!nHz!a-1!n")) {
            return "b_spec_dens";
        }
        return "";
    }

    protected boolean _stripDotProps(QDataSet qds) {
        if (qds.property("BUNDLE_1") != null) {
            for (int i = 0; i < qds.length(0); ++i) {
                MutablePropertyDataSet ds = DataSetOps.slice1((QDataSet)qds, (int)i);
                if (ds.rank() == 1) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    static String xmlDocToStr(Document doc) {
        DOMImplementation imp = doc.getImplementation();
        DOMImplementationLS ls = (DOMImplementationLS)imp.getFeature("LS", "3.0");
        LSSerializer serializer = ls.createLSSerializer();
        serializer.getDomConfig().setParameter("format-pretty-print", true);
        serializer.getDomConfig().setParameter("xml-declaration", false);
        String sDoc = serializer.writeToString(doc);
        return sDoc;
    }

    protected Document newXmlDoc() {
        try {
            DocumentBuilder bldr = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return bldr.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    protected Sequence1D getSequenceRank1(QDataSet qds, double rMaxJitter) {
        if (qds.rank() != 1) {
            return null;
        }
        if (qds.length() < 2) {
            return null;
        }
        double rMin = qds.value(0);
        double rInterval = (qds.value(qds.length() - 1) - rMin) / (double)(qds.length() - 1);
        for (int i = 2; i < qds.length(); ++i) {
            double rNextInterval = qds.value(i) - qds.value(i - 1);
            if (rNextInterval == rInterval) continue;
            double rAvg = Math.abs(rNextInterval + rInterval) / 2.0;
            double rDelta = Math.abs(rNextInterval - rInterval);
            if (rDelta == 0.0) continue;
            if (rAvg == 0.0) {
                return null;
            }
            double rJitter = rDelta / rAvg;
            if (!(rJitter > rMaxJitter)) continue;
            return null;
        }
        String sFmt = String.format("%%.%de", this.nSigDigit - 1);
        Sequence1D seq = new Sequence1D();
        seq.sMinval = String.format(sFmt, rMin);
        seq.sInterval = String.format(sFmt, rInterval);
        return seq;
    }

    public static String getQdsAxis(QDataSet qds) {
        if (SemanticOps.isJoin((QDataSet)qds)) {
            qds = DataSetOps.slice0((QDataSet)qds, (int)0);
        }
        if (SemanticOps.isBundle((QDataSet)qds)) {
            if (qds.rank() == 1) {
                qds = DataSetOps.slice0((QDataSet)qds, (int)0);
            } else {
                int nMaxRank = 0;
                for (int i = 0; i < qds.length(); ++i) {
                    MutablePropertyDataSet ds = DataSetOps.slice0((QDataSet)qds, (int)i);
                    int nRank = ds.rank();
                    if (ds.property("PLANE_0") != null) {
                        return null;
                    }
                    if (nRank <= nMaxRank) continue;
                    nMaxRank = ds.rank();
                }
                if (nMaxRank == 1) {
                    return "y";
                }
                if (nMaxRank == 2) {
                    return "z";
                }
                return null;
            }
        }
        switch (qds.rank()) {
            case 0: {
                return "x";
            }
            case 2: {
                return "z";
            }
            case 3: {
                return "w";
            }
            case 1: {
                if (qds.property("DEPEND_0") == null) {
                    return "x";
                }
                if (qds.property("PLANE_0") == null) {
                    return "y";
                }
                return "z";
            }
        }
        return null;
    }

    protected int copySimpleProps(MutablePropertyDataSet dsDest, QDataSet dsSrc) {
        int nAdded = 0;
        for (String sKey : lSimpleKeys) {
            Object oVal = dsSrc.property(sKey);
            if (oVal == null) continue;
            dsDest.putProperty(sKey, oVal);
            ++nAdded;
        }
        return nAdded;
    }

    static {
        lSimpleKeys.add("NAME");
        lSimpleKeys.add("UNITS");
        lSimpleKeys.add("FORMAT");
        lSimpleKeys.add("SCALE_TYPE");
        lSimpleKeys.add("LABEL");
        lSimpleKeys.add("DESCRIPTION");
        lSimpleKeys.add("FILL_VALUE");
        lSimpleKeys.add("VALID_MIN");
        lSimpleKeys.add("VALID_MAX");
        lSimpleKeys.add("TYPICAL_MIN");
        lSimpleKeys.add("TYPICAL_MAX");
        lSimpleKeys.add("USER_PROPERTIES");
    }

    protected static class Sequence1D {
        String sMinval = null;
        String sInterval = null;

        protected Sequence1D() {
        }
    }

    protected static class PacketXferInfo {
        Document doc;
        List<QdsXferInfo> lDsXfer;

        PacketXferInfo(Document _doc, List<QdsXferInfo> _lDsXfer) {
            this.doc = _doc;
            this.lDsXfer = _lDsXfer;
        }

        int datasets() {
            return this.lDsXfer.size();
        }

        int xSliceBytes() throws IOException {
            int nLen = 0;
            for (QdsXferInfo qi : this.lDsXfer) {
                nLen += qi.xSliceBytes(0);
            }
            return nLen;
        }
    }

    protected static class QdsXferInfo {
        QDataSet qds;
        TransferType transtype;

        QdsXferInfo(QDataSet _qds, boolean bBinary, int nGenSigDigit, int nFracSec) {
            Units units;
            this.qds = _qds;
            if (bBinary) {
                nGenSigDigit = -1;
                nFracSec = -1;
            }
            if ((units = (Units)this.qds.property("UNITS")) != null && units instanceof TimeLocationUnits) {
                this.transtype = nFracSec < 0 ? new DoubleTransferType() : new TransferTimeAtPrecision(units, nFracSec);
            } else {
                Class c = DataSetOps.getComponentType((QDataSet)this.qds);
                if (c == Integer.TYPE || c == Long.TYPE) {
                    if (bBinary) {
                        this.transtype = c == Integer.TYPE ? new IntegerTransferType() : new LongTransferType();
                    } else {
                        QDataSet dsExt = Ops.extent((QDataSet)this.qds);
                        double rMax = Math.abs(dsExt.value(0));
                        double rMin = Math.abs(dsExt.value(1));
                        if (rMin > rMax) {
                            rMax = rMin;
                        }
                        int nChars = (int)(Math.ceil(Math.log10(rMax)) + 2.0);
                        this.transtype = new AsciiIntegerTransferType(nChars);
                    }
                } else {
                    this.transtype = nGenSigDigit < 0 ? new FloatTransferType() : new TransferSciNotation(nGenSigDigit);
                }
            }
        }

        public String name() {
            if (this.transtype.name().equals("int8")) {
                return "long";
            }
            return this.transtype.name().replaceAll("\\d", "");
        }

        public int size() {
            return this.transtype.sizeBytes();
        }

        public int xSliceItems(int i) throws IOException {
            int nItems = 0;
            switch (this.qds.rank()) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return this.qds.length(i);
                }
                case 3: {
                    for (int j = 0; j < this.qds.length(i); ++j) {
                        nItems += this.qds.length(i, j);
                    }
                    return nItems;
                }
                case 4: {
                    for (int j = 0; j < this.qds.length(i); ++j) {
                        for (int k = 0; k < this.qds.length(i, j); ++k) {
                            nItems += this.qds.length(i, j, k);
                        }
                    }
                    return nItems;
                }
            }
            throw new IOException(String.format("Can't stream rank %d data with this format.", this.qds.rank()));
        }

        public int xSliceBytes(int i) throws IOException {
            return this.transtype.sizeBytes() * this.xSliceItems(i);
        }
    }
}

