/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.das2.qstream.TransferType;

class TransferSciNotation
extends TransferType {
    final int nLen;
    private String sFmt;

    public TransferSciNotation(int nSigDigits) {
        if (nSigDigits < 2 || nSigDigits > 17) {
            throw new IllegalArgumentException(String.format("Significant digits for output must be between 2 and 17 inclusive, recieved %d", nSigDigits));
        }
        this.nLen = nSigDigits + 7;
        this.sFmt = String.format("%%.%de", nSigDigits - 1);
    }

    @Override
    public void write(double rVal, ByteBuffer buffer) {
        String sVal = String.format(this.sFmt, rVal);
        if (rVal >= 0.0) {
            buffer.put((byte)32);
        }
        buffer.put(sVal.getBytes(StandardCharsets.US_ASCII));
        buffer.put((byte)32);
    }

    @Override
    public double read(ByteBuffer buffer) {
        byte[] bytes = new byte[this.nLen];
        buffer.get(bytes);
        try {
            String str = new String(bytes, StandardCharsets.US_ASCII).trim();
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @Override
    public int sizeBytes() {
        return this.nLen;
    }

    @Override
    public boolean isAscii() {
        return true;
    }

    @Override
    public String name() {
        return "ascii" + this.nLen;
    }
}

