/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.qstream.AsciiHexIntegerTransferType;
import org.das2.qstream.AsciiIntegerTransferType;
import org.das2.qstream.AsciiTimeTransferType;
import org.das2.qstream.AsciiTransferType;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.FloatTransferType;
import org.das2.qstream.IntegerTransferType;
import org.das2.qstream.LongTransferType;
import org.das2.qstream.ShortTransferType;

public abstract class TransferType {
    protected static final Logger logger = Logger.getLogger("qstream");

    public static TransferType getForName(String ttype, Map<String, Object> properties) {
        logger.log(Level.FINEST, "getForName({0})", ttype);
        TransferType tt = DoubleTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = FloatTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = IntegerTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = LongTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = ShortTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = AsciiTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = AsciiIntegerTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = AsciiTimeTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = AsciiHexIntegerTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        return null;
    }

    public abstract void write(double var1, ByteBuffer var3);

    public abstract double read(ByteBuffer var1);

    public abstract int sizeBytes();

    public abstract boolean isAscii();

    public abstract String name();

    public String toString() {
        return this.name();
    }

    public static ByteBuffer allocate(int recordLengthBytes, ByteOrder byteOrder) {
        ByteBuffer buf = ByteBuffer.allocate(recordLengthBytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }
}

