/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream.filter;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.StreamComment;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RenderTypeFilter
implements StreamHandler {
    private static final Logger logger = Logger.getLogger("qstream");
    StreamHandler sink;

    public void setSink(StreamHandler sink) {
        this.sink = sink;
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        this.sink.streamDescriptor(sd);
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        try {
            Element ele = pd.getDomElement();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            NodeList nl = (NodeList)xpath.evaluate("/packet/qdataset", ele, XPathConstants.NODESET);
            if (nl.getLength() == 2) {
                XPathExpression expr = xpath.compile("/packet/qdataset[2]/properties");
                Element props = (Element)expr.evaluate(ele, XPathConstants.NODE);
                Element rt = ele.getOwnerDocument().createElement("property");
                rt.setAttribute("name", "RENDER_TYPE");
                rt.setAttribute("value", "nnSpectrogram");
                rt.setAttribute("type", "String");
                props.appendChild(rt);
            }
            this.sink.packetDescriptor(pd);
        }
        catch (XPathExpressionException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new StreamException(ex);
        }
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
        this.sink.streamClosed(sd);
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        this.sink.streamException(se);
    }

    @Override
    public void streamComment(StreamComment se) throws StreamException {
        this.sink.streamComment(se);
    }

    @Override
    public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        this.sink.packet(pd, data);
    }
}

