/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.TableUtil;
import org.das2.datum.Units;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;

public class FormatBenchmarks {
    public static void main(String[] args) throws ParseException, StreamException, ParserConfigurationException, IOException {
        int nrec = 200000;
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen((String)"2003-09-09", (String)("1 " + Units.days), (int)nrec);
        tags.putProperty("NAME", (Object)"time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.randn((int)nrec, (int)3);
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.findgen((int)3);
        labels.putProperty("NAME", (Object)"dimLabels");
        ds.putProperty("DEPEND_1", (Object)labels);
        for (int j = 1; j < 2; ++j) {
            boolean ascii = j == 0;
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            for (int i = 0; i < 5; ++i) {
                long t0 = System.currentTimeMillis();
                String filename = ascii ? "benchmark1.qds" : "benchmark1.binary.qds";
                format.format((QDataSet)ds, new FileOutputStream(System.getProperty("user.home") + "/temp/" + filename), ascii);
                System.err.println("Time to write " + nrec + " records: " + (System.currentTimeMillis() - t0));
            }
            TableDataSet tds = TableDataSetAdapter.create((QDataSet)ds);
            for (int i = 0; i < 5; ++i) {
                long t0 = System.currentTimeMillis();
                if (ascii) {
                    TableUtil.dumpToAsciiStream((TableDataSet)tds, (OutputStream)new FileOutputStream(System.getProperty("user.home") + "/temp/benchmark1.d2s"));
                } else {
                    TableUtil.dumpToBinaryStream((TableDataSet)tds, (OutputStream)new FileOutputStream(System.getProperty("user.home") + "/temp/benchmark1.binary.d2s"));
                }
                System.err.println("Time to write " + nrec + " records: " + (System.currentTimeMillis() - t0));
            }
        }
    }
}

