/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamTool;

public class QDataSetStreamHandlerTest {
    private static void test1() throws FileNotFoundException, StreamException {
        long t0 = System.currentTimeMillis();
        FileChannel stream = new FileInputStream("/home/jbf/ct/hudson/data.backup/hyd_20000101.qds").getChannel();
        QDataSetStreamHandler handler = new QDataSetStreamHandler();
        StreamTool.readStream(stream, handler);
        System.err.println(handler.getDataSet("ENERGY_ELE"));
        System.err.println(handler.getDataSet("ELECTRON_DIFFERENTIAL_ENERGY_FLUX"));
        System.err.println(String.format("read in %d ms", System.currentTimeMillis() - t0));
    }

    private static void test2() throws FileNotFoundException, StreamException {
        long t0 = System.currentTimeMillis();
        FileChannel stream = new FileInputStream("/home/jbf/ct/hudson/data.backup/qds/2014294.qds").getChannel();
        QDataSetStreamHandler handler = new QDataSetStreamHandler();
        StreamTool.readStream(stream, handler);
        System.err.println(handler.getDataSet("TimeStop"));
        System.err.println(handler.getDataSet("Time"));
        System.err.println(String.format("read in %d ms", System.currentTimeMillis() - t0));
        QDataSet dts = handler.getDataSet("TimeStop");
        QDataSet t = handler.getDataSet("Time");
        for (int i = 0; i < dts.length(); ++i) {
            System.err.printf("%s %s\n", t.slice(i).slice(0), dts.value(i, 0));
        }
    }

    private static void test3() throws FileNotFoundException, StreamException, MalformedURLException, IOException {
        long t0 = System.currentTimeMillis();
        URL url = new URL("http://jfaden.net/~jbf/autoplot/data/hudson_data/qds/agg/2014-02-25_2day.qdst");
        ReadableByteChannel stream = Channels.newChannel(url.openStream());
        QDataSetStreamHandler handler = new QDataSetStreamHandler();
        StreamTool.readStream(stream, handler);
        System.err.println(String.format("read in %d ms", System.currentTimeMillis() - t0));
        QDataSet ds = handler.getDataSet();
        System.err.println(ds);
        ArrayList problems = new ArrayList();
        DataSetUtil.validate((QDataSet)ds, problems);
        QDataSet t = handler.getDataSet("ds_1");
        for (int i = 0; i < ds.length(); ++i) {
            System.err.printf("%s %s\n", t.slice(i), ds.value(i, 0));
        }
    }

    public static void main(String[] args) throws StreamException, IOException {
        QDataSetStreamHandlerTest.test3();
    }
}

