/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import com.csvreader.CsvReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.autoplot.ascii.AsciiTableTableModel;
import org.autoplot.ascii.ColSpanTableCellRenderer;
import org.autoplot.csv.CsvDataSourceFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.ui.TableRowHeader;
import org.das2.qds.util.AsciiParser;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class CsvDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    Map<Integer, String> columns;
    List<String> headers = new ArrayList<String>();
    boolean focusDepend0 = false;
    Map<String, String> params;
    URISplit split;
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.csv");
    Tool currentTool = Tool.NONE;
    JToggleButton currentToolButton;
    protected File file = null;
    public static final String PROP_FILE = "file";
    protected String table;
    public static final String PROP_TABLE = "table";
    public static final String PROP_FIRST_ROW = "firstRow";
    public static final String PROP_COLUMN = "column";
    public static final String PROP_BUNDLE = "bundle";
    public static final String PROP_DEP0 = "depend0";
    public static final String PROP_DELIM = "delim";
    public JComboBox columnsComboBox;
    public JComboBox<String> delimComboBox;
    public JComboBox dep0Columns;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JPanel jPanel1;
    public JScrollPane jScrollPane1;
    public JTable jTable1;
    public JToggleButton jToggleButton2;
    public JToggleButton jToggleButton3;
    public JFormattedTextField skipTextField;

    public boolean reject(String url) throws IOException, URISyntaxException {
        this.split = URISplit.parse((String)url);
        FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL((URI)DataSetURI.toUri((String)this.split.path)).toURI());
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse((String)uri);
        this.params = URISplit.parseParams((String)this.split.params);
        DataSetURI.getFile((URL)new URL(this.split.file), (ProgressMonitor)mon);
        return true;
    }

    public void markProblems(List<String> problems) {
    }

    public CsvDataSourceEditorPanel() {
        this.initComponents();
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                CsvDataSourceEditorPanel.this.doSelect(CsvDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                CsvDataSourceEditorPanel.this.doSelect(CsvDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jScrollPane1.setRowHeaderView((Component)new TableRowHeader(this.jTable1));
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                int col = CsvDataSourceEditorPanel.this.jTable1.getTableHeader().columnAtPoint(e.getPoint());
                String name = CsvDataSourceEditorPanel.this.columns.get(col);
                if (name == null) {
                    name = "field" + String.valueOf(col);
                }
                if (CsvDataSourceEditorPanel.this.currentTool == Tool.DEPEND_0) {
                    CsvDataSourceEditorPanel.this.params.put(CsvDataSourceEditorPanel.PROP_DEP0, name);
                    CsvDataSourceEditorPanel.this.dep0Columns.setSelectedItem(name);
                    CsvDataSourceEditorPanel.this.clearTool();
                } else if (CsvDataSourceEditorPanel.this.currentTool == Tool.COLUMN) {
                    CsvDataSourceEditorPanel.this.params.put(CsvDataSourceEditorPanel.PROP_COLUMN, name);
                    CsvDataSourceEditorPanel.this.columnsComboBox.setSelectedItem(name);
                    CsvDataSourceEditorPanel.this.clearTool();
                }
            }
        });
    }

    private void doSelect(Tool tool) {
        if (tool == Tool.FIRSTROW) {
            if (this.jTable1.getSelectedRow() > 0) {
                this.params.put(PROP_FIRST_ROW, String.valueOf(this.jTable1.getSelectedRow() + 1));
            } else {
                this.params.remove(PROP_FIRST_ROW);
            }
        } else if (this.jTable1.getColumnModel().getSelectedColumnCount() != 0) {
            if (this.jTable1.getColumnModel().getSelectedColumnCount() == 1) {
                int col = this.jTable1.getColumnModel().getSelectedColumns()[0];
                String name = this.columns.get(col);
                if (name == null) {
                    name = "field" + String.valueOf(col);
                }
                if (this.currentTool == Tool.DEPEND_0) {
                    this.params.put(PROP_DEP0, name);
                    this.dep0Columns.setSelectedItem(name);
                } else if (this.currentTool == Tool.COLUMN) {
                    this.params.put(PROP_COLUMN, name);
                    this.columnsComboBox.setSelectedItem(name);
                    this.params.remove(PROP_BUNDLE);
                }
            } else {
                int[] cols = this.jTable1.getColumnModel().getSelectedColumns();
                int first = cols[0];
                int last = cols[cols.length - 1];
                String sfirst = this.columns.get(first);
                if (sfirst == null) {
                    sfirst = "" + first;
                }
                boolean haveColumnNames = true;
                String slast = this.columns.get(last);
                if (slast == null) {
                    slast = "" + last;
                    haveColumnNames = false;
                }
                if (this.currentTool != Tool.DEPEND_0 && this.currentTool == Tool.COLUMN) {
                    if (haveColumnNames) {
                        this.params.put(PROP_BUNDLE, sfirst + "-" + slast);
                    } else {
                        this.params.put(PROP_BUNDLE, "" + first + ":" + (last + 1));
                    }
                    this.params.remove(PROP_COLUMN);
                    this.columnsComboBox.setSelectedItem(this.params.get(PROP_BUNDLE));
                }
            }
        }
        this.clearTool();
    }

    Action createToolAction(String label, final Tool t) {
        return new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    if (CsvDataSourceEditorPanel.this.jTable1.getSelectionModel().isSelectionEmpty()) {
                        CsvDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        CsvDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                        CsvDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        CsvDataSourceEditorPanel.this.currentTool = t;
                    } else {
                        CsvDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        CsvDataSourceEditorPanel.this.currentTool = t;
                        CsvDataSourceEditorPanel.this.doSelect(t);
                        CsvDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        CsvDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                    }
                }
            }
        };
    }

    private void clearTool() {
        if (this.currentTool != Tool.NONE) {
            this.currentTool = Tool.NONE;
            this.currentToolButton.setSelected(false);
            this.currentToolButton = null;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dep0Columns = new JComboBox();
        this.columnsComboBox = new JComboBox();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jLabel1 = new JLabel();
        this.skipTextField = new JFormattedTextField();
        this.jLabel2 = new JLabel();
        this.delimComboBox = new JComboBox();
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel3.setText("Column:");
        this.jLabel3.setToolTipText("Select the column to plot");
        this.jLabel4.setText("Depends On:");
        this.dep0Columns.setEditable(true);
        this.dep0Columns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dep0Columns.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CsvDataSourceEditorPanel.this.dep0ColumnsItemStateChanged(evt);
            }
        });
        this.dep0Columns.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CsvDataSourceEditorPanel.this.dep0ColumnsFocusGained(evt);
            }
        });
        this.columnsComboBox.setEditable(true);
        this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.columnsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CsvDataSourceEditorPanel.this.columnsComboBoxItemStateChanged(evt);
            }
        });
        this.columnsComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CsvDataSourceEditorPanel.this.columnsComboBoxFocusGained(evt);
            }
        });
        this.jToggleButton2.setAction(this.createToolAction(PROP_COLUMN, Tool.COLUMN));
        this.jToggleButton2.setText("Select");
        this.jToggleButton2.setToolTipText("Select the column to plot by pushing this button and then clicking on a column of the table.\n");
        this.jToggleButton3.setAction(this.createToolAction(PROP_DEP0, Tool.DEPEND_0));
        this.jToggleButton3.setText("Select");
        this.jToggleButton3.setToolTipText("Select the column containing the indepenent variable to plot against by pressing this button and then clicking on the table.\n");
        this.jLabel1.setText("Skip:");
        this.jLabel1.setToolTipText("Number of lines to skip before parsing");
        this.skipTextField.setText("0");
        this.skipTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvDataSourceEditorPanel.this.skipTextFieldActionPerformed(evt);
            }
        });
        this.skipTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CsvDataSourceEditorPanel.this.skipTextFieldFocusLost(evt);
            }
        });
        this.jLabel2.setText("Delim:");
        this.delimComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{", (comma)", "; (semicolon)"}));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.dep0Columns, 0, -1, Short.MAX_VALUE).add((Component)this.columnsComboBox, 0, 190, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jToggleButton2).add(18, 18, 18).add((Component)this.jLabel1)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jToggleButton3).add(18, 18, 18).add((Component)this.jLabel2))).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(this.delimComboBox, -2, -1, -2).add((Component)this.skipTextField, -2, 55, -2)).addContainerGap(338, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.columnsComboBox, -2, -1, -2).add((Component)this.jToggleButton2, -2, 27, -2).add((Component)this.jLabel1).add((Component)this.skipTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.dep0Columns, -2, -1, -2).add((Component)this.jToggleButton3, -2, 24, -2).add((Component)this.jLabel2).add(this.delimComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 862, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 381, Short.MAX_VALUE).addContainerGap()));
    }

    private void loadTable(Reader f, File file) {
        try {
            AsciiParser parser = new AsciiParser();
            AsciiTableTableModel model = new AsciiTableTableModel();
            model.setParser(parser);
            this.jTable1.setModel(model);
            model.setFile(file);
            this.jTable1.setDefaultRenderer(Object.class, new ColSpanTableCellRenderer());
            AsciiParser.DelimParser p = parser.guessSkipAndDelimParser(file.getAbsolutePath());
            if (p == null) {
                model.setRecParser(new AsciiParser.RecordParser(){

                    public boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
                        return false;
                    }

                    public int fieldCount() {
                        return 1;
                    }

                    public int fieldCount(String line) {
                        return 1;
                    }

                    public boolean splitRecord(String line, String[] fields) {
                        fields[0] = line;
                        return true;
                    }

                    public String readNextRecord(BufferedReader reader) throws IOException {
                        return reader.readLine();
                    }
                });
            } else {
                model.setRecParser((AsciiParser.RecordParser)p);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CsvDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void updateColumns(JTable jTable1, Map<Integer, String> columns) {
        int n = jTable1.getColumnCount();
        int wide = n < 5 ? 210 : 170;
        int normwide = n < 5 ? 140 : 110;
        int norm = n < 5 ? 100 : 70;
        int narrow = n < 5 ? 60 : 50;
        for (int i = 0; i < jTable1.getColumnCount(); ++i) {
            String label = i < columns.size() ? columns.get(i) : "x";
            jTable1.getColumnModel().getColumn(i).setHeaderValue(label);
            int nrow = jTable1.getRowCount();
            Object o = jTable1.getValueAt(nrow - 1, i);
            String s = String.valueOf(o);
            if (s.length() > 16) {
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(wide);
                continue;
            }
            if (s.length() > 11) {
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(normwide);
                continue;
            }
            if (s.length() < 5) {
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(narrow);
                continue;
            }
            jTable1.getColumnModel().getColumn(i).setPreferredWidth(norm);
        }
        jTable1.getTableHeader().repaint();
    }

    private void resetTable() {
        if (this.file == null) {
            return;
        }
        try {
            String bundle;
            String[] columnHeaders;
            int ncol;
            char delimiter;
            int i;
            int iskip;
            File ff = DataSetURI.getFile((URI)DataSetURI.toUri((String)this.split.file), (ProgressMonitor)new NullProgressMonitor());
            BufferedReader breader = new BufferedReader(new InputStreamReader(new FileInputStream(ff)));
            String skip = this.params.get("skip");
            if (skip != null && skip.length() > 0) {
                try {
                    iskip = Integer.parseInt(skip);
                    for (i = 0; i < iskip; ++i) {
                        breader.readLine();
                    }
                }
                catch (IOException | NumberFormatException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            this.loadTable(breader, ff);
            breader.close();
            breader = new BufferedReader(new InputStreamReader(new FileInputStream(ff)));
            skip = this.params.get("skip");
            if (skip != null && skip.length() > 0) {
                try {
                    iskip = Integer.parseInt(skip);
                    for (i = 0; i < iskip; ++i) {
                        breader.readLine();
                    }
                }
                catch (IOException | NumberFormatException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            CsvReader reader = new CsvReader((Reader)breader);
            String sdelimiter = this.params.get(PROP_DELIM);
            if (sdelimiter == null) {
                sdelimiter = ",";
            }
            if (sdelimiter.equals("COMMA")) {
                sdelimiter = ",";
            }
            if (sdelimiter.equals("SEMICOLON")) {
                sdelimiter = ";";
            }
            if ((delimiter = sdelimiter.charAt(0)) != ',') {
                reader.setDelimiter(delimiter);
            }
            if ((ncol = (columnHeaders = CsvDataSourceFactory.getColumnHeaders(reader)).length) > this.jTable1.getModel().getColumnCount()) {
                ncol = this.jTable1.getModel().getColumnCount();
            }
            this.headers = new ArrayList<String>();
            this.headers.addAll(Arrays.asList(columnHeaders));
            this.columns = new HashMap<Integer, String>();
            for (int i2 = 0; i2 < ncol; ++i2) {
                this.columns.put(i2, this.headers.get(i2));
                this.jTable1.getColumnModel().getColumn(i2).setHeaderValue(this.headers.get(i2));
            }
            CsvDataSourceEditorPanel.updateColumns(this.jTable1, this.columns);
            reader.close();
            String[] hh = new String[this.headers.size() + 1];
            hh[0] = "";
            for (int i3 = 0; i3 < this.headers.size(); ++i3) {
                hh[i3 + 1] = this.headers.get(i3);
            }
            this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(hh));
            String column = this.params.get(PROP_COLUMN);
            if (column != null) {
                this.columnsComboBox.setSelectedItem(this.params.get(PROP_COLUMN));
            }
            if ((bundle = this.params.get(PROP_BUNDLE)) != null) {
                this.columnsComboBox.setSelectedItem(this.params.get(PROP_BUNDLE));
            }
            this.dep0Columns.setModel(new DefaultComboBoxModel<String>(hh));
            String depend0column = this.params.get(PROP_DEP0);
            if (depend0column != null) {
                this.dep0Columns.setSelectedItem(this.params.get(PROP_DEP0));
            }
        }
        catch (IOException ex) {
            this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"(no records found)"}));
            DefaultTableModel dtm = new DefaultTableModel(1, 1);
            dtm.setValueAt("no records found", 0, 0);
            this.jTable1.setModel(dtm);
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void dep0ColumnsItemStateChanged(ItemEvent evt) {
        String v = (String)this.dep0Columns.getSelectedItem();
        if (v.equals("")) {
            this.params.remove(PROP_DEP0);
        } else {
            this.params.put(PROP_DEP0, v);
        }
    }

    private void dep0ColumnsFocusGained(FocusEvent evt) {
    }

    private void columnsComboBoxItemStateChanged(ItemEvent evt) {
        String v = (String)this.columnsComboBox.getSelectedItem();
        if (v.equals("")) {
            this.params.remove(PROP_COLUMN);
            this.params.remove(PROP_BUNDLE);
        } else if (v.contains("-") || v.contains(":")) {
            this.params.put(PROP_BUNDLE, v);
            this.params.remove(PROP_COLUMN);
        } else {
            this.params.put(PROP_COLUMN, v);
            this.params.remove(PROP_BUNDLE);
        }
    }

    private void columnsComboBoxFocusGained(FocusEvent evt) {
    }

    private void skipTextFieldActionPerformed(ActionEvent evt) {
        this.params.put("skip", this.skipTextField.getText());
        this.resetTable();
    }

    private void skipTextFieldFocusLost(FocusEvent evt) {
        if (!this.skipTextField.getText().equals(this.params.get("skip"))) {
            this.params.put("skip", this.skipTextField.getText());
            this.resetTable();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.resetTable();
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        String oldTable = this.table;
        this.table = table;
        this.resetTable();
        this.firePropertyChange(PROP_TABLE, oldTable, table);
    }

    public JPanel getPanel() {
        return this;
    }

    public void setURI(String url) {
        try {
            this.split = URISplit.parse((String)url);
            this.params = URISplit.parseParams((String)this.split.params);
            if ("".equals(this.params.get(PROP_DELIM))) {
                this.params.remove(PROP_DELIM);
            }
            if (this.params.get(PROP_DELIM) != null) {
                String delim = this.params.get(PROP_DELIM);
                if (delim.equals("COMMA")) {
                    delim = ",";
                }
                if (delim.equals("SEMICOLON")) {
                    delim = ";";
                }
                this.delimComboBox.setSelectedIndex(delim.equals(";") ? 1 : 0);
            }
            File f = DataSetURI.getFile((URL)new URL(this.split.file), (ProgressMonitor)new NullProgressMonitor());
            this.setFile(f);
            if ("".equals(this.params.get(PROP_COLUMN))) {
                this.params.remove(PROP_COLUMN);
            }
            if ("".equals(this.params.get(PROP_BUNDLE))) {
                this.params.remove(PROP_BUNDLE);
            }
            if ("".equals(this.params.get(PROP_DEP0))) {
                this.params.remove(PROP_DEP0);
            }
            if (this.params.get(PROP_COLUMN) != null) {
                this.columnsComboBox.setSelectedItem(this.params.get(PROP_COLUMN));
            }
            if (this.params.get(PROP_BUNDLE) != null) {
                this.columnsComboBox.setSelectedItem(this.params.get(PROP_BUNDLE));
            }
            if (this.params.get(PROP_DEP0) != null) {
                this.dep0Columns.setSelectedItem(this.params.get(PROP_DEP0));
            }
            if (this.params.get("skip") != null) {
                try {
                    this.skipTextField.setValue(Integer.parseInt(this.params.get("skip")));
                }
                catch (NumberFormatException ex) {
                    this.skipTextField.setValue(this.params.get("skip"));
                    this.skipTextField.setBackground(Color.YELLOW);
                }
            }
            this.resetTable();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String getURI() {
        String delim = String.valueOf(this.delimComboBox.getSelectedItem());
        if (delim.charAt(0) == ';') {
            this.params.put(PROP_DELIM, delim.substring(0, 1));
        }
        this.split.params = this.params.isEmpty() ? null : URISplit.formatParams(this.params);
        return URISplit.format((URISplit)this.split);
    }

    private static enum Tool {
        NONE,
        FIRSTROW,
        COLUMN,
        DEPEND_0,
        TIMEFORMAT;

    }
}

