/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.json.JSONDataSource;
import org.autoplot.json.JSONJIterator;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONDataSourceFactory
extends AbstractDataSourceFactory {
    private List<CompletionContext> getFieldNames(CompletionContext cc, JSONArray jarray, List<CompletionContext> result) throws JSONException {
        for (int i = 0; i < jarray.length(); ++i) {
            String s = "field" + i;
            String val = String.valueOf(jarray.get(i));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s, s + " (" + val + ")", null));
        }
        return result;
    }

    private List<CompletionContext> getFieldNames(CompletionContext cc, JSONObject jobj, List<CompletionContext> result) throws JSONException {
        Iterator keys = jobj.keys();
        while (keys.hasNext()) {
            String s = (String)keys.next();
            String val = String.valueOf(jobj.get(s));
            CompletionContext cc1 = cc.context == CompletionContext.CONTEXT_PARAMETER_NAME ? new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, s, (DataSourceFactory)this, "arg_0", s + " (" + val + ")", null, true) : new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s, (DataSourceFactory)this, null, s + " (" + val + ")", null, true);
            result.add(cc1);
        }
        return result;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        File f = DataSetURI.getFile((String)cc.surl, (ProgressMonitor)mon);
        JSONObject jobj = null;
        JSONArray jarray = null;
        List<CompletionContext> result = new ArrayList<CompletionContext>();
        FileInputStream ins = new FileInputStream(f);
        Object object = null;
        try {
            JSONJIterator jiter = new JSONJIterator(ins);
            if (jiter.hasNext()) {
                Object obj = jiter.next();
                if (obj instanceof JSONArray) {
                    jarray = (JSONArray)obj;
                } else if (obj instanceof JSONObject) {
                    jobj = (JSONObject)obj;
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ins != null) {
                if (object != null) {
                    try {
                        ((InputStream)ins).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)ins).close();
                }
            }
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            if (jarray != null) {
                result = this.getFieldNames(cc, jarray, result);
            } else if (jobj != null) {
                result = this.getFieldNames(cc, jobj, result);
            } else {
                throw new IllegalArgumentException("Expected to see JSONArray or JSONObject in: " + cc.surl);
            }
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend0=", "Name of the independent variable."));
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            switch (paramName) {
                case "depend0": {
                    if (jarray != null) {
                        result = this.getFieldNames(cc, jarray, result);
                        break;
                    }
                    if (jobj != null) {
                        result = this.getFieldNames(cc, jobj, result);
                        break;
                    }
                    throw new IllegalArgumentException("Expected to see JSONArray or JSONObject in: " + cc.surl);
                }
            }
            return result;
        }
        throw new IllegalArgumentException("not implemented l78");
    }

    public boolean reject(String suri, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)suri);
        return split.params == null;
    }

    public DataSource getDataSource(URI uri) throws Exception {
        return new JSONDataSource(uri);
    }
}

