/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;

public final class DecimalYearConverter
extends UnitsConverter {
    boolean reverse;
    double us2000Min = Double.MAX_VALUE;
    double us2000Max = Double.MAX_VALUE;
    int year;

    public DecimalYearConverter(boolean us2000ToDecimalYear) {
        this.reverse = us2000ToDecimalYear;
        if (this.reverse) {
            this.inverse = new DecimalYearConverter(!this.reverse);
            this.inverse.inverse = this;
        }
    }

    @Override
    public UnitsConverter getInverse() {
        return this.inverse;
    }

    private void reset(double valueUs2000) {
        Datum min = Units.us2000.createDatum(valueUs2000);
        if (valueUs2000 > Units.us2000.vmin) {
            min = TimeUtil.floor(1, min);
        }
        Datum max = min;
        if (valueUs2000 < Units.us2000.vmax) {
            max = TimeUtil.next(1, min);
        }
        this.year = TimeUtil.toTimeStruct((Datum)min).year;
        this.us2000Min = min.doubleValue(Units.us2000);
        this.us2000Max = max.doubleValue(Units.us2000);
    }

    @Override
    public double convert(double value) {
        if (this.reverse) {
            if (value < this.us2000Min || value >= this.us2000Max) {
                this.reset(value);
            }
            double fp = (value - this.us2000Min) / (this.us2000Max - this.us2000Min);
            return (double)this.year + fp;
        }
        if ((int)value != this.year) {
            this.reset(TimeUtil.createTimeDatum((int)value, 1, 1, 0, 0, 0, 0).doubleValue(Units.us2000));
        }
        double fp = value - (double)((int)value);
        double extraMicros = fp * (this.us2000Max - this.us2000Min);
        return this.us2000Min + extraMicros;
    }
}

