/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;

public class LinearDomainDivider
implements DomainDivider {
    private final int incSignificand;
    private final int incExponent;

    public static LinearDomainDivider create(int significand, int exponent) {
        return new LinearDomainDivider(significand, exponent);
    }

    protected LinearDomainDivider() {
        this(1, 0);
    }

    protected LinearDomainDivider(int significand, int exponent) {
        switch (significand) {
            case 1: 
            case 2: 
            case 5: {
                this.incSignificand = significand;
                break;
            }
            default: {
                throw new IllegalArgumentException("significand must be 1,2,or 5.");
            }
        }
        this.incExponent = exponent;
    }

    @Override
    public DomainDivider coarserDivider(boolean superset) {
        int newExponent;
        int newSignificand;
        switch (this.incSignificand) {
            case 1: {
                newSignificand = 2;
                newExponent = this.incExponent;
                break;
            }
            case 2: {
                if (superset) {
                    newSignificand = 1;
                    newExponent = this.incExponent + 1;
                    break;
                }
                newSignificand = 5;
                newExponent = this.incExponent;
                break;
            }
            case 5: {
                newSignificand = 1;
                newExponent = this.incExponent + 1;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state in LinearDomainDivider");
            }
        }
        return new LinearDomainDivider(newSignificand, newExponent);
    }

    @Override
    public DomainDivider finerDivider(boolean superset) {
        int newExponent;
        int newSignificand;
        switch (this.incSignificand) {
            case 1: {
                newSignificand = 5;
                newExponent = this.incExponent - 1;
                break;
            }
            case 2: {
                newSignificand = 1;
                newExponent = this.incExponent;
                break;
            }
            case 5: {
                if (superset) {
                    newSignificand = 1;
                    newExponent = this.incExponent;
                    break;
                }
                newSignificand = 2;
                newExponent = this.incExponent;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state in LinearDomainDivider");
            }
        }
        return new LinearDomainDivider(newSignificand, newExponent);
    }

    @Override
    public DatumVector boundaries(Datum min, Datum max) {
        boolean inv;
        long nb;
        if (!min.isFinite() || !max.isFinite()) {
            System.err.println("min and max must be finite");
        }
        if ((nb = this.boundaryCount(min, max)) > 1000000L) {
            throw new IllegalArgumentException("too many divisions requested (" + this.boundaryCount(min, max) + ")");
        }
        double[] values = new double[(int)nb];
        boolean bl = inv = this.incExponent < 0;
        if (inv) {
            double intervalSize = Math.pow(10.0, -this.incExponent) / (double)this.incSignificand;
            double v = Math.ceil(min.doubleValue() * intervalSize) / intervalSize;
            int i = 0;
            while ((long)i < nb) {
                values[i] = v + (double)i / intervalSize;
                ++i;
            }
        } else {
            double intervalSize = (double)this.incSignificand * Math.pow(10.0, this.incExponent);
            double v = Math.ceil(min.doubleValue() / intervalSize) * intervalSize;
            int i = 0;
            while ((long)i < nb) {
                values[i] = v + (double)i * intervalSize;
                ++i;
            }
        }
        return DatumVector.newDatumVector(values, min.getUnits());
    }

    @Override
    public DatumRange rangeContaining(Datum v) {
        double intervalSize = (double)this.incSignificand * Math.pow(10.0, this.incExponent);
        double min = Math.floor(v.doubleValue() / intervalSize) * intervalSize;
        return new DatumRange(min, min + intervalSize, v.getUnits());
    }

    @Override
    public long boundaryCount(Datum min, Datum max) {
        if (min.gt(max)) {
            return 0L;
        }
        double intervalSize = (double)this.incSignificand * Math.pow(10.0, this.incExponent);
        long mmin = (long)Math.ceil(min.doubleValue() / intervalSize);
        long mmax = (long)Math.floor(max.doubleValue() / intervalSize);
        return mmax - mmin + 1L;
    }

    protected int getSignificand() {
        return this.incSignificand;
    }

    protected int getExponent() {
        return this.incExponent;
    }

    public String toString() {
        return "ldd " + this.incSignificand + "E" + this.incExponent;
    }

    public static void main(String[] args) {
        LinearDomainDivider div = new LinearDomainDivider();
        DatumRange dr = DatumRangeUtil.newDimensionless(0.1, 0.9);
        System.err.println(div.boundaryCount(dr.min(), dr.max()));
        System.err.println(div.boundaries(dr.min(), dr.max()));
        System.err.println(div.rangeContaining(dr.min()));
        DomainDivider div2 = div.coarserDivider(false);
        System.err.println(div2.boundaryCount(dr.min(), dr.max()));
        System.err.println(div2.boundaries(dr.min(), dr.max()));
        div2 = div.finerDivider(false);
        System.err.println(div2.boundaryCount(dr.min(), dr.max()));
        System.err.println(div2.boundaries(dr.min(), dr.max()));
    }
}

