/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.util.ArrayList;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.LinearDomainDivider;
import org.das2.datum.LogDomainDivider;
import org.das2.datum.Units;

public class LogLinDomainDivider
implements DomainDivider {
    private LinearDomainDivider linearDivider;

    public static LogLinDomainDivider create() {
        return new LogLinDomainDivider();
    }

    public static LogLinDomainDivider create(int significand, int exponent) {
        LinearDomainDivider lin = new LinearDomainDivider(significand, exponent);
        return new LogLinDomainDivider(lin);
    }

    protected LogLinDomainDivider() {
        this(new LinearDomainDivider());
    }

    private LogLinDomainDivider(LinearDomainDivider linearDivider) {
        this.linearDivider = linearDivider;
        int significand = linearDivider.getSignificand();
        if (significand != 1 && significand != 2 && significand != 5) {
            throw new IllegalArgumentException("significand must be 1, 2, or 5.");
        }
    }

    @Override
    public DomainDivider coarserDivider(boolean superset) {
        LinearDomainDivider d = (LinearDomainDivider)this.linearDivider.coarserDivider(superset);
        if (d.boundaryCount(Datum.create(1.0), Datum.create(10.0)) < 1L) {
            return new LogDomainDivider();
        }
        return new LogLinDomainDivider(d);
    }

    @Override
    public DomainDivider finerDivider(boolean superset) {
        LinearDomainDivider lin = (LinearDomainDivider)this.linearDivider.finerDivider(superset);
        return new LogLinDomainDivider(lin);
    }

    @Override
    public DatumVector boundaries(Datum min, Datum max) {
        double multiplier;
        if (!min.isFinite() || !max.isFinite()) {
            System.err.println("min and max must be finite");
        }
        if ((multiplier = Math.pow(10.0, -1.0 * Math.floor(Math.log10(min.value())))) < 1.0) {
            multiplier = 1.0;
        }
        min = min.multiply(multiplier);
        max = max.multiply(multiplier);
        ArrayList<Datum> bb = new ArrayList<Datum>();
        double decade = Math.pow(10.0, Math.floor(Math.log10(min.doubleValue())));
        double nextDecade = decade * 10.0;
        DatumRange current = this.linearDivider.rangeContaining(min.divide(decade));
        current = DatumRange.newRange(current.min().multiply(decade), current.max().multiply(decade));
        Datum m = current.min();
        Units u = m.getUnits();
        while (m.le(max)) {
            while (m.value() < nextDecade * 1.00001) {
                if (m.ge(min) && m.le(max)) {
                    bb.add(m.divide(multiplier));
                }
                if (m.gt(max)) break;
                current = current.next();
                m = current.min();
            }
            Datum w = current.width().multiply(10.0);
            int nstep = (int)(Math.floor((decade *= 10.0) * 10.0 - decade) / w.value());
            Datum newMin = u.createDatum(decade * 10.0 - (double)nstep * w.value());
            Datum newMax = newMin.add(w);
            current = new DatumRange(newMin, newMax);
            if (newMin.value() == decade) {
                current = current.next();
            }
            m = current.min();
            nextDecade *= 10.0;
        }
        DatumVector result = DatumVector.newDatumVector(bb.toArray(new Datum[bb.size()]), current.getUnits());
        return result;
    }

    @Override
    public long boundaryCount(Datum min, Datum max) {
        return this.boundaries(min, max).getLength();
    }

    @Override
    public DatumRange rangeContaining(Datum v) {
        LogDomainDivider logDivider = new LogDomainDivider();
        DatumRange decade = logDivider.rangeContaining(v);
        double decadeOffset = decade.min().doubleValue();
        DatumRange range = this.linearDivider.rangeContaining(v.divide(decadeOffset));
        return new DatumRange(range.min().multiply(decadeOffset), range.max().multiply(decadeOffset));
    }

    protected int sigFigs() {
        return 0 - this.linearDivider.getExponent();
    }

    public String toString() {
        return "loglin linearDivider=" + this.linearDivider;
    }

    public static void main(String[] args) {
        int i;
        DomainDivider d = new LogLinDomainDivider();
        DatumRange dr = DatumRangeUtil.newDimensionless(7.9, 218.0);
        System.err.println(d.boundaryCount(dr.min(), dr.max()));
        DatumVector dv = d.boundaries(dr.min(), dr.max());
        for (i = 0; i < dv.getLength(); ++i) {
            System.err.print(dv.get(i).doubleValue() + ", ");
        }
        System.err.println();
        System.err.println(d.rangeContaining(Datum.create(27.3)));
        System.err.println(d.coarserDivider(true).coarserDivider(true).boundaries(dr.min(), dr.max()));
        System.err.println(d.finerDivider(true).finerDivider(true).boundaries(dr.min(), dr.max()));
        d = d.finerDivider(true);
        d = d.finerDivider(true);
        for (i = 0; i < 10; ++i) {
            d = d.coarserDivider(false);
            System.err.println(d);
        }
        for (i = 0; i < 10; ++i) {
            d = d.finerDivider(false);
            System.err.println(d);
        }
    }
}

