/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.Serializable;
import java.util.Arrays;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;

public class MonthDatumRange
extends DatumRange
implements Serializable {
    int width;
    int widthDigit;
    final int[] start = new int[7];
    final int[] end;

    private void init() {
        int i;
        this.widthDigit = -1;
        int[] widthArr = new int[7];
        for (i = 0; i < 7; ++i) {
            widthArr[i] = this.end[i] - this.start[i];
        }
        while (widthArr[1] < 0) {
            widthArr[1] = widthArr[1] + 12;
            widthArr[0] = widthArr[0] - 1;
        }
        for (i = 0; i < 7; ++i) {
            if (widthArr[i] == 0) continue;
            if (this.widthDigit == 0 && i == 1) {
                this.widthDigit = i;
                widthArr[1] = widthArr[1] + widthArr[0] * 12;
                widthArr[0] = 0;
                continue;
            }
            if (this.widthDigit != -1) {
                throw new IllegalArgumentException("MonthDatumRange must only vary in month or year, not both");
            }
            this.widthDigit = i;
            this.width = widthArr[this.widthDigit];
        }
        if (widthArr[0] == 0 && widthArr[1] == 0) {
            System.err.println("*** either month or year must increment, this will be runtime error soon");
        }
    }

    public MonthDatumRange(int[] start, int[] end, Units u) {
        super(TimeUtil.toDatum(start).convertTo(u), TimeUtil.toDatum(end).convertTo(u));
        System.arraycopy(start, 0, this.start, 0, 7);
        this.end = new int[7];
        System.arraycopy(end, 0, this.end, 0, 7);
        this.init();
    }

    public MonthDatumRange(int[] start, int[] end) {
        super(TimeUtil.toDatum(start), TimeUtil.toDatum(end));
        System.arraycopy(start, 0, this.start, 0, 7);
        this.end = new int[7];
        System.arraycopy(end, 0, this.end, 0, 7);
        this.init();
    }

    @Override
    public DatumRange next() {
        int[] end1 = new int[7];
        System.arraycopy(this.end, 0, end1, 0, 7);
        end1[this.widthDigit] = end1[this.widthDigit] + this.width;
        switch (this.widthDigit) {
            case 1: {
                while (end1[1] > 12) {
                    end1[1] = end1[1] - 12;
                    end1[0] = end1[0] + 1;
                }
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented");
            }
        }
        return new MonthDatumRange(this.end, end1);
    }

    @Override
    public DatumRange previous() {
        int[] start1 = new int[7];
        System.arraycopy(this.start, 0, start1, 0, 7);
        start1[this.widthDigit] = start1[this.widthDigit] - this.width;
        switch (this.widthDigit) {
            case 1: {
                while (start1[1] < 1) {
                    start1[1] = start1[1] + 12;
                    start1[0] = start1[0] - 1;
                }
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented");
            }
        }
        return new MonthDatumRange(start1, this.start);
    }

    @Override
    public DatumRange convertTo(Units u) {
        if (u == this.min().getUnits()) {
            return this;
        }
        return new MonthDatumRange(this.start, this.end, u);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MonthDatumRange) {
            MonthDatumRange m = (MonthDatumRange)o;
            return Arrays.equals(this.start, m.start) && Arrays.equals(this.end, m.end);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

