/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import java.text.DecimalFormat;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.NumberFormatUtil;

public class LatinPrefixDatumFormatter
extends DatumFormatter {
    int digits;
    int exponent;

    public LatinPrefixDatumFormatter(int digits) {
        this.digits = digits;
    }

    @Override
    public String format(Datum datum) {
        return this.format(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    @Override
    public String format(Datum datum, Units units) {
        String expString;
        double x = datum.doubleValue(units);
        if (x == 0.0) {
            return "0.";
        }
        int expon = (int)Math.log10(1.000001 * Math.abs(x)) / 3 * 3;
        switch (expon) {
            case -18: {
                expString = "a";
                break;
            }
            case -15: {
                expString = "f";
                break;
            }
            case -12: {
                expString = "p";
                break;
            }
            case -9: {
                expString = "n";
                break;
            }
            case -6: {
                expString = "\u03bc";
                break;
            }
            case -3: {
                expString = "m";
                break;
            }
            case 0: {
                expString = "";
                break;
            }
            case 3: {
                expString = "k";
                break;
            }
            case 6: {
                expString = "M";
                break;
            }
            case 9: {
                expString = "G";
                break;
            }
            case 12: {
                expString = "T";
                break;
            }
            default: {
                expString = "";
                expon = 0;
            }
        }
        double exp = Math.pow(10.0, expon);
        double mant = x / exp;
        int mantFracDigits = this.digits - (int)Math.log10(mant);
        StringBuffer buff = new StringBuffer(this.digits + 2).append("0");
        if (this.digits > 1) {
            buff.append('.');
        }
        for (int i = 0; i < mantFracDigits; ++i) {
            buff.append('0');
        }
        DecimalFormat mantFormat = NumberFormatUtil.getDecimalFormat(buff.toString());
        return mantFormat.format(mant) + expString;
    }

    public String toString() {
        return "EngineeringFormatter(" + this.digits + " sig fig)";
    }
}

