/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;

public class TimeDatumFormatter
extends DatumFormatter {
    private static final int YEAR_FIELD_INDEX = 0;
    private static final int MONTH_FIELD_INDEX = 1;
    private static final int DAY_FIELD_INDEX = 2;
    private static final int DOY_FIELD_INDEX = 3;
    private static final int HOUR_FIELD_INDEX = 4;
    private static final int MINUTE_FIELD_INDEX = 5;
    private static final int SECONDS_FIELD_INDEX = 6;
    private static final int TIMESTAMP_FIELD_COUNT = 7;
    public static final TimeDatumFormatter DEFAULT;
    public static final TimeDatumFormatter DAYS;
    public static final TimeDatumFormatter DAY_OF_YEAR;
    public static final TimeDatumFormatter DOY_DAYS;
    public static final TimeDatumFormatter YEARS;
    public static final TimeDatumFormatter MONTHS;
    public static final TimeDatumFormatter HOURS;
    public static final TimeDatumFormatter MINUTES;
    public static final TimeDatumFormatter SECONDS;
    public static final TimeDatumFormatter MILLISECONDS;
    public static final TimeDatumFormatter MICROSECONDS;
    public static final TimeDatumFormatter NANOSECONDS;
    private final String formatString;
    private final MessageFormat format;
    private int[] scaleSeconds;

    public TimeDatumFormatter(String formatString) throws ParseException {
        this.formatString = formatString;
        this.format = formatString.contains("%") ? new MessageFormat(this.parseTimeFormatStringPercent(formatString)) : new MessageFormat(this.parseTimeFormatString(formatString));
    }

    public static TimeDatumFormatter formatterForScale(int scale, DatumRange context) {
        return TimeDatumFormatter.formatterForScale(scale, context, false);
    }

    public static TimeDatumFormatter guessFormatter(DatumVector ticks, DatumRange context) {
        double width;
        int scale = ticks.getLength() < 2 ? 8 : ((width = ticks.get(1).subtract(ticks.get(0)).doubleValue(Units.microseconds)) >= 6.0E7 ? 5 : (width >= 1000000.0 ? 6 : (width >= 1000.0 ? 7 : 8)));
        return TimeDatumFormatter.formatterForScale(scale, context);
    }

    public static TimeDatumFormatter formatterForScale(int scale, DatumRange context, boolean useDOY) {
        try {
            if (context != null) {
                switch (scale) {
                    case 1: {
                        return YEARS;
                    }
                    case 2: {
                        return useDOY ? DAY_OF_YEAR : MONTHS;
                    }
                    case 3: {
                        return useDOY ? DAY_OF_YEAR : DAYS;
                    }
                    case 4: {
                        return MINUTES;
                    }
                    case 5: {
                        return MINUTES;
                    }
                    case 6: {
                        return SECONDS;
                    }
                    case 7: {
                        return MILLISECONDS;
                    }
                    case 8: {
                        return MICROSECONDS;
                    }
                    case 9: {
                        return NANOSECONDS;
                    }
                }
                throw new IllegalArgumentException("unsupported scale: " + scale);
            }
            if (useDOY) {
                switch (scale) {
                    case 1: {
                        return YEARS;
                    }
                    case 2: {
                        return DAY_OF_YEAR;
                    }
                    case 3: {
                        return DAY_OF_YEAR;
                    }
                    case 4: {
                        return new TimeDatumFormatter("%Y-%j %H:%M");
                    }
                    case 5: {
                        return new TimeDatumFormatter("%Y-%j %H:%M");
                    }
                    case 6: {
                        return new TimeDatumFormatter("%Y-%j %H:%M:%S");
                    }
                    case 7: {
                        return new TimeDatumFormatter("%Y-%j %H:%M:%S.%(subsec,places=3)");
                    }
                    case 8: {
                        return new TimeDatumFormatter("%Y-%j %H:%M:%S.%(subsec,places=6)");
                    }
                    case 9: {
                        return new TimeDatumFormatter("%Y-%j %H:%M:%S.%(subsec,places=9)");
                    }
                }
                throw new IllegalArgumentException("unsupported scale: " + scale);
            }
            switch (scale) {
                case 1: {
                    return YEARS;
                }
                case 2: {
                    return MONTHS;
                }
                case 3: {
                    return DAYS;
                }
                case 4: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm");
                }
                case 5: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm");
                }
                case 6: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss");
                }
                case 7: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss.SSS");
                }
                case 8: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss.SSSSSS");
                }
                case 9: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
                }
            }
            throw new IllegalArgumentException("unsupported scale: " + scale);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.formatString;
    }

    @Override
    public String format(Datum datum) {
        if (datum.isFill()) {
            return "fill";
        }
        int mjd1958 = (int)datum.doubleValue(Units.mj1958);
        TimeUtil.TimeStruct ts = mjd1958 < -349909 ? TimeUtil.toTimeStruct(Units.mj1958.createDatum(-349909)) : (mjd1958 > 2937279 ? TimeUtil.toTimeStruct(Units.mj1958.createDatum(2937279)) : TimeUtil.toTimeStruct(datum));
        Number[] array = this.timeStructToArray(ts);
        if (array.length == 8 && array[7].intValue() == -1) {
            array[7] = 0;
        }
        return this.format.format(array);
    }

    protected Format getFormat() {
        return this.format;
    }

    protected final String parseTimeFormatString(String input) throws ParseException {
        String formatPattern = "(([yMDdHmsS])\\2*)";
        String delimiterPattern = "([-/:.,_ \t]+)";
        String literalPattern = "('(?:[^']|'')*')";
        Pattern token = Pattern.compile("(([yMDdHmsS])\\2*)|([-/:.,_ \t]+)|('(?:[^']|'')*')");
        int from = 0;
        StringBuilder frmtString = new StringBuilder();
        Matcher matcher = token.matcher(input);
        while (matcher.find(from)) {
            int start = matcher.start();
            if (start > from) {
                char[] dots = new char[start + 1];
                Arrays.fill(dots, from, start, '.');
                dots[from] = 94;
                dots[start] = 94;
                StringBuilder errorString = new StringBuilder("Unrecognized sub-pattern\n");
                errorString.append(input).append("\n");
                errorString.append(dots);
                throw new ParseException(errorString.toString(), from);
            }
            String frmt = matcher.group(1);
            String delimiter = matcher.group(3);
            String literal = matcher.group(4);
            if (frmt != null) {
                switch (frmt.charAt(0)) {
                    case 'y': {
                        TimeDatumFormatter.appendSubFormat(frmtString, 0, frmt.length());
                        break;
                    }
                    case 'M': {
                        TimeDatumFormatter.appendSubFormat(frmtString, 1, frmt.length());
                        break;
                    }
                    case 'D': {
                        TimeDatumFormatter.appendSubFormat(frmtString, 3, frmt.length());
                        break;
                    }
                    case 'd': {
                        TimeDatumFormatter.appendSubFormat(frmtString, 2, frmt.length());
                        break;
                    }
                    case 'H': {
                        TimeDatumFormatter.appendSubFormat(frmtString, 4, frmt.length());
                        break;
                    }
                    case 'm': {
                        TimeDatumFormatter.appendSubFormat(frmtString, 5, frmt.length());
                        break;
                    }
                    case 's': {
                        TimeDatumFormatter.appendSubFormat(frmtString, 6, frmt.length());
                        break;
                    }
                    case 'S': {
                        int digitCount = frmt.length();
                        int fieldIndex = this.addScaleFactor(digitCount);
                        TimeDatumFormatter.appendSubFormat(frmtString, fieldIndex, digitCount);
                        break;
                    }
                }
            } else if (delimiter != null) {
                frmtString.append(delimiter);
            } else if (literal != null) {
                literal = literal.substring(1, literal.length() - 1);
                literal = literal.replaceAll("''", "'");
                frmtString.append(literal);
            }
            from = matcher.end();
        }
        return frmtString.toString();
    }

    protected final String parseTimeFormatStringPercent(String format) throws ParseException {
        StringBuilder frmtString = new StringBuilder();
        String[] ss = format.split("%");
        frmtString.append(ss[0]);
        int offset = ss[0].length();
        int lsb = 0;
        for (int i = 1; i < ss.length; ++i) {
            ++offset;
            char c = ss[i].charAt(0);
            int oldLsb = lsb;
            block0 : switch (c) {
                case 'Y': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 0, 4);
                    lsb = 0;
                    break;
                }
                case 'y': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 0, 2);
                    lsb = 0;
                    break;
                }
                case 'j': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 3, 3);
                    lsb = 3;
                    break;
                }
                case 'm': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 1, 2);
                    lsb = 1;
                    break;
                }
                case 'd': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 2, 2);
                    lsb = 2;
                    break;
                }
                case 'H': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 4, 2);
                    lsb = 4;
                    break;
                }
                case 'M': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 5, 2);
                    lsb = 5;
                    break;
                }
                case 'S': {
                    TimeDatumFormatter.appendSubFormat(frmtString, 6, 2);
                    lsb = 6;
                    break;
                }
                case '{': {
                    String spec;
                    int i1 = ss[i].indexOf(125);
                    switch (spec = ss[i].substring(1, i1)) {
                        case "milli": {
                            int digitCount = 3;
                            int fieldIndex = this.addScaleFactor(digitCount);
                            TimeDatumFormatter.appendSubFormat(frmtString, fieldIndex, digitCount);
                            ss[i] = ss[i].substring(i1);
                            break block0;
                        }
                        case "micro": {
                            throw new IllegalArgumentException("This is no longer supported, use subsec");
                        }
                    }
                    throw new ParseException("bad format code: {" + spec + "}", offset);
                }
                default: {
                    throw new ParseException("bad format code: " + c, offset);
                }
            }
            if (oldLsb > 2 && lsb - oldLsb > 1) {
                logger.log(Level.WARNING, "gap in time digits detected: {0}", format);
            }
            frmtString.append(ss[i].substring(1));
            offset += ss[i].length();
        }
        return frmtString.toString();
    }

    private static void appendSubFormat(StringBuilder buffer, int fieldIndex, int count) {
        buffer.append("{").append(fieldIndex).append(",number,");
        for (int i = 0; i < count; ++i) {
            buffer.append('0');
        }
        buffer.append("}");
    }

    private int addScaleFactor(int scale) {
        if (this.scaleSeconds == null) {
            this.scaleSeconds = new int[1];
        } else {
            int[] temp = new int[this.scaleSeconds.length + 1];
            System.arraycopy(this.scaleSeconds, 0, temp, 0, this.scaleSeconds.length);
            this.scaleSeconds = temp;
        }
        this.scaleSeconds[this.scaleSeconds.length - 1] = scale;
        return 7 + this.scaleSeconds.length - 1;
    }

    private Number[] timeStructToArray(TimeUtil.TimeStruct ts) {
        int secondsFieldCount = this.scaleSeconds == null ? 0 : this.scaleSeconds.length;
        int maxScale = this.scaleSeconds == null ? 10 : (int)Math.pow(10.0, TimeDatumFormatter.max(this.scaleSeconds));
        int fieldCount = 7 + secondsFieldCount;
        Number[] array = new Number[fieldCount];
        int seconds = (int)(Math.round(ts.seconds * (double)maxScale) / (long)maxScale);
        double fracSeconds = ts.seconds - (double)seconds;
        ts.seconds = seconds;
        ts.micros = (int)(fracSeconds * 1000000.0);
        if (ts.micros < 0) {
            ts.seconds -= 1.0;
            ts.micros += 1000000;
        }
        TimeUtil.carry(ts);
        if (this.scaleSeconds != null && this.scaleSeconds[0] < 7) {
            ts = TimeUtil.roundNDigits(ts, this.scaleSeconds[0]);
        }
        array[0] = ts.year;
        array[1] = ts.month;
        array[2] = ts.day;
        array[3] = ts.doy;
        array[4] = ts.hour;
        array[5] = ts.minute;
        array[6] = (int)ts.seconds;
        for (int i = 7; i < array.length; ++i) {
            int value = (int)Math.round(fracSeconds * Math.pow(10.0, this.scaleSeconds[i - 7]));
            array[i] = value;
        }
        return array;
    }

    private static int max(int[] list) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < list.length; ++i) {
            max = Math.max(max, list[i]);
        }
        return max;
    }

    static {
        try {
            DEFAULT = new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            YEARS = new TimeDatumFormatter("yyyy");
            MONTHS = new TimeDatumFormatter("yyyy-MM");
            DAYS = new TimeDatumFormatter("yyyy-MM-dd");
            DAY_OF_YEAR = new TimeDatumFormatter("%Y-%j");
            DOY_DAYS = new TimeDatumFormatter("%Y-%m-%d (%j)");
            HOURS = new TimeDatumFormatter("yyyy-MM-dd HH:'00'");
            MINUTES = new TimeDatumFormatter("HH:mm");
            SECONDS = new TimeDatumFormatter("HH:mm:ss");
            MILLISECONDS = new TimeDatumFormatter("HH:mm:ss.SSS");
            MICROSECONDS = new TimeDatumFormatter("HH:mm:ss.SSSSSS");
            NANOSECONDS = new TimeDatumFormatter("HH:mm:ss.SSSSSSSSS");
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }
}

