/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.autoplot.jythonsupport.FunctionSupport;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyString;

public class DatasetCommand
extends PyObject {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.commands.dataset");
    public static final PyString __doc__ = new PyString("<html><H2>dataset(ds,[named parameters])</H2>dataset creates datasets from arrays and adds metadata.\nSee http://autoplot.org/help.datasetCommand<br>\n<br><b>named parameters:</b>\n<table><tr><td>title </td><td>title for the data, which could be used above a plot.</td></tr>\n<tr><td>label </td><td>label for the data, which could be used as an axis label.</td></tr>\n<tr><td>name </td><td>name for the data, which should be a legal Jython variable name.</td></tr>\n<tr><td>units </td><td>units for the data, which string representing the units of the data.</td></tr>\n<tr><td>resetUnits </td><td>assert units for the data, with no attempt to perform the units conversion.</td></tr>\n<tr><td>validMin validMax</td><td>range of valid values for the data.</td></tr>\n<tr><td>typicalMin typicalMax</td><td>typical range dataset, used for suggesting axis ranges.</td></tr>\n<tr><td>scaleType</td><td>'log' or 'linear'</td></tr>\n<tr><td>averageType</td><td>'linear', 'geometric', 'mod360', 'mod24', 'modpi', 'modtau'</td></tr>\n<tr><td>format</td><td>format specifier, like %d or %.2f</td></tr>\n<tr><td>cadence</td><td>nominal cadence, like 60s or 100Hz.  Note this goes with the independent parameter (timetags).</td></tr>\n</table></html>");
    public static final PyString __completions__;

    private static QDataSet datasetValue(PyObject arg0) {
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            return JythonOps.dataset(arg0);
        }
        QDataSet ds = (QDataSet)o;
        if (ds.rank() == 0) {
            return ds;
        }
        return ds;
    }

    private static boolean booleanValue(PyObject arg0) {
        if (arg0.isNumberType()) {
            return arg0.__nonzero__();
        }
        String s = String.valueOf(arg0);
        return s.equals("True") || s.equals("T") || s.equals("1");
    }

    private static Number numberValue(PyObject arg0) {
        if (arg0 instanceof PyInteger) {
            return ((PyInteger)arg0).getValue();
        }
        if (arg0 instanceof PyFloat) {
            return ((PyFloat)arg0).getValue();
        }
        if (arg0 instanceof PyString) {
            return Double.parseDouble(String.valueOf(arg0));
        }
        return arg0.__float__().getValue();
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        QDataSet result;
        PyObject val;
        String kw;
        FunctionSupport fs = new FunctionSupport("dataset", new String[]{"ds", "ds1", "ds2", "ds3", "ds4", "title", "label", "name", "units", "format", "cadence", "resetUnits", "fillValue", "validMin", "validMax", "typicalMin", "typicalMax", "scaleType", "averageType", "renderType", "bins1", "bins0", "cacheTag", "userProperties", "deltaPlus", "deltaMinus", "binPlus", "binMinus", "binMin", "binMax"}, new PyObject[]{Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None});
        fs.args(args, keywords);
        int nparm = args.length - keywords.length;
        Units units = null;
        boolean resetUnits = false;
        for (int i = nparm; i < args.length; ++i) {
            kw = keywords[i - nparm];
            val = args[i];
            if (!kw.equals("units") && !kw.equals("resetUnits")) continue;
            if (kw.equals("resetUnits")) {
                resetUnits = true;
            }
            if (val.__tojava__(Units.class) != Py.NoConversion) {
                units = (Units)val.__tojava__(Units.class);
                continue;
            }
            String svalue = val.toString();
            units = Units.lookupUnits((String)svalue);
        }
        switch (nparm) {
            case 0: {
                throw new IllegalArgumentException("dataset needs at least one argument");
            }
            case 1: {
                if (units != null) {
                    if (resetUnits && args[0] instanceof PyQDataSet) {
                        QDataSet ds = (QDataSet)args[0].__tojava__(QDataSet.class);
                        ds = Ops.putProperty((QDataSet)ds, (String)"UNITS", null);
                        result = Ops.dataset((Object)ds, units);
                        break;
                    }
                    result = JythonOps.dataset(args[0], units);
                    break;
                }
                result = JythonOps.dataset(args[0]);
                break;
            }
            case 2: {
                PyJavaInstance pji;
                Object o;
                if (args[1] instanceof PyJavaInstance && (o = (pji = (PyJavaInstance)args[1]).__tojava__(Units.class)) != Py.NoConversion) {
                    logger.info("legacy script uses second argument for units, use units=... instead");
                    result = Ops.dataset((Object)args[0].__tojava__(Object.class), (Units)((Units)o));
                    break;
                }
                result = JythonOps.dataset(args[1]);
                QDataSet xds = JythonOps.dataset(args[0]);
                result = Ops.link((QDataSet)xds, (QDataSet)result);
                break;
            }
            case 3: {
                result = JythonOps.dataset(args[2]);
                QDataSet xds = JythonOps.dataset(args[0]);
                QDataSet yds = JythonOps.dataset(args[1]);
                result = Ops.link((QDataSet)xds, (QDataSet)yds, (QDataSet)result);
                break;
            }
            case 4: {
                result = JythonOps.dataset(args[3]);
                QDataSet ds0 = JythonOps.dataset(args[0]);
                QDataSet ds1 = JythonOps.dataset(args[1]);
                QDataSet ds2 = JythonOps.dataset(args[2]);
                result = Ops.link((QDataSet)ds0, (QDataSet)ds1, (QDataSet)ds2, (QDataSet)result);
                break;
            }
            case 5: {
                result = JythonOps.dataset(args[4]);
                QDataSet ds0 = JythonOps.dataset(args[0]);
                QDataSet ds1 = JythonOps.dataset(args[1]);
                QDataSet ds2 = JythonOps.dataset(args[2]);
                QDataSet ds3 = JythonOps.dataset(args[3]);
                result = Ops.link((QDataSet)ds0, (QDataSet)ds1, (QDataSet)ds2, (QDataSet)ds3, (QDataSet)result);
                break;
            }
            default: {
                throw new IllegalArgumentException("dataset needs between one and four parameters.");
            }
        }
        block60: for (int i = nparm; i < args.length; ++i) {
            kw = keywords[i - nparm];
            val = args[i];
            String sval = (String)val.__str__().__tojava__(String.class);
            switch (kw) {
                case "description": 
                case "title": 
                case "label": 
                case "name": 
                case "format": {
                    result = Ops.putProperty((QDataSet)result, (String)kw.toUpperCase(), (Object)sval);
                    continue block60;
                }
                case "units": 
                case "resetUnits": {
                    if (val.__tojava__(Units.class) != Py.NoConversion) {
                        result = Ops.putProperty((QDataSet)result, (String)"UNITS", (Object)val.__tojava__(Units.class));
                        continue block60;
                    }
                    result = Ops.putProperty((QDataSet)result, (String)"UNITS", (Object)sval);
                    continue block60;
                }
                case "validMin": {
                    result = Ops.putProperty((QDataSet)result, (String)"VALID_MIN", (Object)DatasetCommand.numberValue(val));
                    continue block60;
                }
                case "validMax": {
                    result = Ops.putProperty((QDataSet)result, (String)"VALID_MAX", (Object)DatasetCommand.numberValue(val));
                    continue block60;
                }
                case "typicalMin": {
                    result = Ops.putProperty((QDataSet)result, (String)"TYPICAL_MIN", (Object)DatasetCommand.numberValue(val));
                    continue block60;
                }
                case "typicalMax": {
                    result = Ops.putProperty((QDataSet)result, (String)"TYPICAL_MAX", (Object)DatasetCommand.numberValue(val));
                    continue block60;
                }
                case "fillValue": {
                    result = Ops.putProperty((QDataSet)result, (String)"FILL_VALUE", (Object)DatasetCommand.numberValue(val));
                    continue block60;
                }
                case "scaleType": {
                    result = Ops.putProperty((QDataSet)result, (String)"SCALE_TYPE", (Object)sval);
                    continue block60;
                }
                case "averageType": {
                    result = Ops.putProperty((QDataSet)result, (String)"AVERAGE_TYPE", (Object)sval);
                    continue block60;
                }
                case "cadence": {
                    result = Ops.putProperty((QDataSet)result, (String)"CADENCE", (Object)sval);
                    continue block60;
                }
                case "renderType": {
                    result = Ops.putProperty((QDataSet)result, (String)"RENDER_TYPE", (Object)sval);
                    continue block60;
                }
                case "bins1": {
                    result = Ops.putProperty((QDataSet)result, (String)"BINS_1", (Object)sval);
                    continue block60;
                }
                case "bins0": {
                    result = Ops.putProperty((QDataSet)result, (String)"BINS_0", (Object)sval);
                    continue block60;
                }
                case "cacheTag": {
                    result = Ops.putProperty((QDataSet)result, (String)"CACHE_TAG", (Object)sval);
                    continue block60;
                }
                case "userProperties": {
                    if (val instanceof PyDictionary) {
                        Map m = JythonUtil.pyDictionaryToMap((PyDictionary)val);
                        result = Ops.putProperty((QDataSet)result, (String)"USER_PROPERTIES", (Object)m);
                        continue block60;
                    }
                    result = Ops.putProperty((QDataSet)result, (String)"USER_PROPERTIES", (Object)val);
                    continue block60;
                }
                case "deltaPlus": {
                    result = Ops.putProperty((QDataSet)result, (String)"DELTA_PLUS", (Object)JythonOps.dataset(val));
                    continue block60;
                }
                case "deltaMinus": {
                    result = Ops.putProperty((QDataSet)result, (String)"DELTA_MINUS", (Object)JythonOps.dataset(val));
                    continue block60;
                }
                case "binPlus": {
                    result = Ops.putProperty((QDataSet)result, (String)"BIN_PLUS", (Object)JythonOps.dataset(val));
                    continue block60;
                }
                case "binMinus": {
                    result = Ops.putProperty((QDataSet)result, (String)"BIN_MINUS", (Object)JythonOps.dataset(val));
                    continue block60;
                }
                case "binMin": {
                    result = Ops.putProperty((QDataSet)result, (String)"BIN_MIN", (Object)JythonOps.dataset(val));
                    continue block60;
                }
                case "binMax": {
                    result = Ops.putProperty((QDataSet)result, (String)"BIN_MAX", (Object)JythonOps.dataset(val));
                    continue block60;
                }
                default: {
                    throw new IllegalArgumentException("bad keyword");
                }
            }
        }
        return new PyQDataSet(result);
    }

    static {
        String text = new BufferedReader(new InputStreamReader(DatasetCommand.class.getResourceAsStream("DatasetCommand.json"), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        __completions__ = new PyString(text);
    }
}

