/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.jythonsupport.JythonUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.python.core.PySyntaxError;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assert;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Compare;
import org.python.parser.ast.Dict;
import org.python.parser.ast.Expr;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Index;
import org.python.parser.ast.List;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Print;
import org.python.parser.ast.Str;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.UnaryOp;
import org.python.parser.ast.VisitorBase;
import org.python.parser.ast.aliasType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class SimplifyScriptSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.simplify");
    private static final String[] okay = new String[]{"range,", "xrange,", "irange,", "map,", "join,", "getParam,", "lower,", "upper,", "URI,", "URL,", "setScriptDescription", "setScriptTitle", "setScriptLabel", "setScriptIcon", "DatumRangeUtil,", "TimeParser,", "str,", "int,", "long,", "float,", "datum,", "datumRange,", "dataset,", "indgen,", "findgen,", "dindgen,", "ones,", "zeros,", "linspace,", "logspace,", "dblarr,", "fltarr,", "strarr,", "intarr,", "bytarr,", "ripples,", "color,", "colorFromString,", "isinstance,"};
    private static final Set<String> okaySet = new HashSet<String>();

    public static String alligatorParse(String script) {
        logger.entering("SimplifyScriptSupport", "alligatorParse");
        String[] ss = JythonUtil.splitCodeIntoLines(null, script);
        String scri = script;
        boolean parseOkay = false;
        for (int lastLine = ss.length; lastLine > 0; --lastLine) {
            scri = JythonUtil.join(Arrays.copyOfRange(ss, 0, lastLine), "\n");
            try {
                parser.parse((String)scri, (String)"exec");
                parseOkay = true;
                break;
            }
            catch (Exception e) {
                logger.finest("fail to parse, no worries.");
                continue;
            }
        }
        if (!parseOkay) {
            scri = "";
        }
        logger.exiting("SimplifyScriptSupport", "alligatorParse");
        return scri;
    }

    public static Object[] tryResolveTupleNode(SimpleNode n, int row, int column, Map<String, Object> env) {
        Tuple t = (Tuple)n;
        Object[] result = new Object[t.elts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SimplifyScriptSupport.tryResolveStringNode((SimpleNode)t.elts[i], row, column, env);
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    public static String tryResolveStringNode(SimpleNode n, int row, int column, Map<String, Object> env) {
        if (n.beginLine == row) {
            if (n instanceof Assign) {
                Assign a = (Assign)n;
                return SimplifyScriptSupport.tryResolveStringNode((SimpleNode)a.value, row, column, env);
            }
            if (n instanceof Str) {
                return ((Str)n).s;
            }
            if (n instanceof Num) {
                return String.valueOf(((Num)n).n);
            }
            if (n instanceof Expr) {
                Expr e = (Expr)n;
                return SimplifyScriptSupport.tryResolveStringNode((SimpleNode)e.value, row, column, env);
            }
            if (n instanceof Call) {
                String s;
                Call e = (Call)n;
                if (e.func instanceof Name && ((Name)e.func).id.equals("getParam")) {
                    String s2;
                    if (e.args.length > 1 && (s2 = SimplifyScriptSupport.tryResolveStringNode((SimpleNode)e.args[1], row, column, env)) != null) {
                        return s2;
                    }
                } else if (e.func instanceof Name && ((Name)e.func).id.equals("str") && e.args.length == 1 && (s = SimplifyScriptSupport.tryResolveStringNode((SimpleNode)e.args[0], row, column, env)) != null) {
                    return s;
                }
                return null;
            }
            if (n instanceof Name) {
                Name na = (Name)n;
                Object o = env.get(na.id);
                if (o instanceof String) {
                    return (String)o;
                }
                return null;
            }
            if (n instanceof BinOp) {
                BinOp e = (BinOp)n;
                String sleft = SimplifyScriptSupport.tryResolveStringNode((SimpleNode)e.left, row, column, env);
                String sright = SimplifyScriptSupport.tryResolveStringNode((SimpleNode)e.right, row, column, env);
                if (sleft != null && sright != null && e.op == 1) {
                    return sleft + sright;
                }
                if (sleft != null && e.right instanceof Tuple && e.op == 5) {
                    Object[] ss = SimplifyScriptSupport.tryResolveTupleNode((SimpleNode)e.right, row, column, env);
                    if (ss != null) {
                        sleft = sleft.replaceAll("\\%d", "%s");
                        try {
                            return String.format(sleft, ss);
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, ex.getMessage(), ex);
                            return null;
                        }
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static String tryResolveStringNode(Module n, int row, int column, Map<String, Object> env) {
        exprType t;
        stmtType thet = null;
        for (stmtType t2 : n.body) {
            String s;
            if (t2.beginLine >= row) {
                thet = t2;
                break;
            }
            if (!(t2 instanceof Assign)) continue;
            Assign a = (Assign)t2;
            if (a.targets.length != 1 || !(a.targets[0] instanceof Name)) continue;
            if (a.value instanceof Str) {
                env.put(((Name)a.targets[0]).id, ((Str)a.value).s);
                continue;
            }
            if (a.value instanceof BinOp) {
                String s2 = SimplifyScriptSupport.tryResolveStringNode((SimpleNode)a.value, a.beginLine, a.beginColumn, env);
                if (s2 == null) continue;
                env.put(((Name)a.targets[0]).id, s2);
                continue;
            }
            if (!(a.value instanceof Call)) continue;
            Call c = (Call)a.value;
            if (!(c.func instanceof Name) || !((Name)c.func).id.equals("getParam") || (s = SimplifyScriptSupport.tryResolveStringNode((SimpleNode)a.value, a.beginLine, a.beginColumn, env)) == null) continue;
            env.put(((Name)a.targets[0]).id, s);
        }
        if (thet instanceof Assign && (t = ((Assign)thet).value) instanceof Call) {
            Call c = (Call)t;
            if (c.func instanceof Name && ((Name)c.func).id.equals("getDataSet")) {
                return SimplifyScriptSupport.tryResolveStringNode((SimpleNode)c.args[0], row, column, env);
            }
        }
        return null;
    }

    public static String removeSideEffects(String script) {
        Module n;
        script = SimplifyScriptSupport.alligatorParse(script);
        String[] ss = JythonUtil.splitCodeIntoLines("# simplifyScriptToGetCompletions", script);
        try {
            n = (Module)parser.parse((String)script, (String)"exec");
        }
        catch (Exception ex) {
            n = (Module)parser.parse((String)script, (String)"exec");
        }
        HashSet variableNames = new HashSet();
        int ilastLine = ss.length - 1;
        return SimplifyScriptSupport.simplifyScriptToGetCompletions(ss, n.body, variableNames, 1, ilastLine, 0);
    }

    private static StringBuilder appendToResult(StringBuilder result, String line) {
        result.append(line);
        return result;
    }

    public static String simplifyScriptToCompletions(String script) throws PySyntaxError {
        if (script.trim().length() == 0) {
            return script;
        }
        script = SimplifyScriptSupport.alligatorParse(script);
        String[] ss = JythonUtil.splitCodeIntoLines("# simplifyScriptToGetCompletions", script);
        int lastLine = ss.length - 1;
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.add("getParam");
        variableNames.add("str");
        variableNames.add("int");
        variableNames.add("long");
        variableNames.add("float");
        variableNames.add("datum");
        variableNames.add("datumRange");
        variableNames.add("dataset");
        variableNames.add("URI");
        variableNames.add("URL");
        variableNames.add("PWD");
        variableNames.add("dom");
        variableNames.add("True");
        variableNames.add("False");
        Module n = null;
        PySyntaxError ex0 = null;
        for (int count = 4; lastLine > 0 && count > 0; --count) {
            try {
                n = (Module)parser.parse((String)script, (String)"exec");
                break;
            }
            catch (PySyntaxError ex) {
                if (ex0 == null) {
                    ex0 = ex;
                }
                script = JythonUtil.join(Arrays.copyOf(ss, --lastLine), "\n");
                continue;
            }
        }
        if (n == null) {
            throw ex0;
        }
        String s = SimplifyScriptSupport.simplifyScriptToGetCompletions(ss, n.body, variableNames, 1, lastLine, 0);
        return s;
    }

    private static String getIfBlock(String[] ss, stmtType[] body, HashSet variableNames, int firstLine, int lastLine1, int depth) {
        StringBuilder result = new StringBuilder();
        String ss1 = SimplifyScriptSupport.simplifyScriptToGetCompletions(ss, body, variableNames, firstLine, lastLine1, depth + 1);
        if (ss1.length() == 0) {
            Pattern p = Pattern.compile("(\\s*)(\\S*).*");
            Matcher m = p.matcher(ss[firstLine]);
            String indent = m.matches() ? m.group(1) : "";
            result.append(indent).append("pass  ## SimplifyScriptSupport.getIfBlock \n");
            logger.fine("things have probably gone wrong...");
        } else {
            SimplifyScriptSupport.appendToResult(result, ss1);
        }
        return result.toString();
    }

    public static String getSourceForStatement(String[] ss, stmtType o) {
        int endLine;
        if (o.beginLine == 0) {
            return "(bad line number)";
        }
        int beginLine = endLine = o.beginLine;
        if (o instanceof Expr) {
            Expr e = (Expr)o;
            if (e.value.beginLine < beginLine) {
                beginLine = e.value.beginLine;
            }
        }
        StringBuilder s = new StringBuilder();
        for (int i = beginLine; i <= endLine; ++i) {
            s.append(ss[i]);
            if (i >= endLine) continue;
            s.append("\n");
        }
        return s.toString();
    }

    public static String getIndent(String line) {
        String s = line.trim();
        return line.substring(0, line.indexOf(s));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String simplifyScriptToGetCompletions(String[] ss, stmtType[] stmts, HashSet variableNames, int beginLine, int lastLine, int depth) {
        if (lastLine >= ss.length) {
            throw new IllegalArgumentException("lastLine is >= number of lines");
        }
        if (!ss[0].equals("# simplifyScriptToGetCompletions")) {
            throw new IllegalArgumentException("first line must be '# simplifyScriptToGetCompletions'");
        }
        LinkedHashMap<String, String> importedNames = new LinkedHashMap<String, String>();
        importedNames.put("Color", "java.awt");
        importedNames.put("DatumRange", "org.das2.datum");
        importedNames.put("Units", "org.das2.datum");
        importedNames.put("DatumRangeUtil", "org.das2.datum");
        importedNames.put("TimeUtil", "org.das2.datum");
        importedNames.put("URL", "java.net");
        importedNames.put("URI", "java.net");
        importedNames.put("TimeParser", "org.das2.datum");
        importedNames.put("DataSetBuilder", "org.das2.qds.util");
        int acceptLine = -1;
        int currentLine = beginLine;
        StringBuilder result = new StringBuilder();
        int istatement = 0;
        while (true) {
            block42: {
                int thisLine;
                block54: {
                    int thisLine2;
                    block52: {
                        block41: {
                            block53: {
                                stmtType o;
                                block50: {
                                    block51: {
                                        String theLine;
                                        block49: {
                                            block45: {
                                                int lastLine1;
                                                boolean includeBlock;
                                                If iff;
                                                block48: {
                                                    block46: {
                                                        int elseLine;
                                                        block47: {
                                                            block43: {
                                                                block44: {
                                                                    if (istatement >= stmts.length) break block41;
                                                                    o = stmts[istatement];
                                                                    theLine = SimplifyScriptSupport.getSourceForStatement(ss, o);
                                                                    int lineCount = theLine.split("\n", -2).length;
                                                                    if (depth == 0) {
                                                                        logger.finest(theLine);
                                                                    }
                                                                    logger.log(Level.FINER, "line {0}: {1}", new Object[]{o.beginLine, theLine});
                                                                    if (o.beginLine > 0) {
                                                                        if (beginLine < 0 && istatement == 0) {
                                                                            acceptLine = o.beginLine;
                                                                        }
                                                                        beginLine = lineCount > 1 ? o.beginLine - (lineCount - 1) : o.beginLine;
                                                                    } else {
                                                                        acceptLine = beginLine;
                                                                    }
                                                                    if (beginLine > lastLine) break block42;
                                                                    if (!(o instanceof Assign)) break block43;
                                                                    if (SimplifyScriptSupport.simplifyScriptToGetCompletionsOkay(o, variableNames, importedNames)) break block44;
                                                                    Assign a = (Assign)o;
                                                                    String cl = SimplifyScriptSupport.maybeIdentifyType(a, importedNames);
                                                                    if (cl == null) break block43;
                                                                    if (acceptLine > -1) {
                                                                        for (int i = acceptLine; i < beginLine; ++i) {
                                                                            SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                                                                        }
                                                                    }
                                                                    if (cl.contains("\n")) {
                                                                        String[] cls;
                                                                        for (String cl1 : cls = cl.split("\n")) {
                                                                            SimplifyScriptSupport.appendToResult(result, SimplifyScriptSupport.getIndent(theLine) + cl1).append("\n");
                                                                        }
                                                                    } else {
                                                                        SimplifyScriptSupport.appendToResult(result, SimplifyScriptSupport.getIndent(theLine) + (String)cl).append("\n");
                                                                    }
                                                                    acceptLine = -1;
                                                                    break block42;
                                                                }
                                                                Assign a = (Assign)o;
                                                                String cl = SimplifyScriptSupport.maybeIdentifyType(a, importedNames);
                                                                if (cl == null) break block43;
                                                                if (acceptLine > -1) {
                                                                    for (int i = acceptLine; i < beginLine; ++i) {
                                                                        SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                                                                    }
                                                                }
                                                                SimplifyScriptSupport.appendToResult(result, SimplifyScriptSupport.getIndent(theLine) + cl).append("\n");
                                                                acceptLine = -1;
                                                                break block42;
                                                            }
                                                            if (o instanceof ImportFrom) {
                                                                ImportFrom i = (ImportFrom)o;
                                                                for (aliasType n : i.names) {
                                                                    importedNames.put(n.name, i.module);
                                                                }
                                                            }
                                                            if (!(o instanceof If)) break block45;
                                                            if (acceptLine > -1) {
                                                                for (int i = acceptLine; i < beginLine; ++i) {
                                                                    SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                                                                }
                                                            }
                                                            iff = (If)o;
                                                            if (SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)iff.test, variableNames)) {
                                                                for (int i = beginLine; i < iff.body[0].beginLine; ++i) {
                                                                    result.append(ss[i]).append("\n");
                                                                }
                                                                includeBlock = true;
                                                            } else {
                                                                includeBlock = false;
                                                            }
                                                            elseLine = -1;
                                                            if (iff.orelse == null || iff.orelse.length <= 0) break block46;
                                                            if (iff.orelse[0].beginLine <= 0) break block47;
                                                            lastLine1 = iff.orelse[0].beginLine - 1;
                                                            if (ss[lastLine1].trim().startsWith("else")) {
                                                                elseLine = lastLine1--;
                                                                break block48;
                                                            } else if (ss[lastLine1].trim().startsWith("elif")) {
                                                                elseLine = lastLine1--;
                                                            }
                                                            break block48;
                                                        }
                                                        if (!(iff.orelse[0] instanceof If)) {
                                                            logger.warning("failure to deal with another day...");
                                                            throw new RuntimeException("this case needs to be dealt with...");
                                                        }
                                                        elseLine = ((If)iff.orelse[0]).test.beginLine;
                                                        lastLine1 = elseLine - 1;
                                                        break block48;
                                                    }
                                                    lastLine1 = istatement + 1 < stmts.length ? stmts[istatement + 1].beginLine - 1 : lastLine;
                                                }
                                                if (includeBlock) {
                                                    HashSet variableNames1 = new HashSet(variableNames);
                                                    String ss1 = SimplifyScriptSupport.getIfBlock(ss, iff.body, variableNames1, Math.min(beginLine + 1, lastLine1), lastLine1, depth + 1);
                                                    SimplifyScriptSupport.appendToResult(result, ss1);
                                                    if (iff.orelse != null) {
                                                        lastLine1 = istatement + 1 >= stmts.length ? lastLine : stmts[istatement + 1].beginLine - 1;
                                                        if (iff.orelse[0].beginLine == 0) {
                                                            result.append("\n");
                                                        } else if (iff.orelse[0].beginLine > 0 && ss[iff.orelse[0].beginLine - 1].trim().startsWith("else:")) {
                                                            result.append(ss[iff.orelse[0].beginLine - 1]).append("\n");
                                                            HashSet variableNames2 = new HashSet(variableNames);
                                                            ss1 = SimplifyScriptSupport.getIfBlock(ss, iff.orelse, variableNames2, iff.orelse[0].beginLine, lastLine1, depth + 1);
                                                            SimplifyScriptSupport.appendToResult(result, ss1);
                                                        } else {
                                                            result.append(ss[iff.orelse[0].beginLine]).append("\n");
                                                        }
                                                    }
                                                }
                                                currentLine = lastLine1;
                                                acceptLine = -1;
                                                break block42;
                                            }
                                            if (!(o instanceof Assert)) break block49;
                                            String m = SimplifyScriptSupport.maybeModelAssert((Assert)o, variableNames);
                                            if (m != null) {
                                                result.append(m).append("\n");
                                                currentLine = acceptLine;
                                            }
                                            break block42;
                                        }
                                        if (!(o instanceof Expr)) break block50;
                                        if (!(((Expr)o).value instanceof Str)) break block51;
                                        result.append(theLine).append("\n");
                                        currentLine = o.beginLine;
                                        acceptLine = -1;
                                        break block42;
                                    }
                                    if (acceptLine <= -1) break block42;
                                    thisLine2 = beginLine;
                                    break block52;
                                }
                                if (!SimplifyScriptSupport.simplifyScriptToGetCompletionsOkay(o, variableNames, importedNames)) break block53;
                                if (acceptLine < 0) {
                                    acceptLine = beginLine;
                                    for (int i = currentLine + 1; i < acceptLine; ++i) {
                                        result.append("\n");
                                        currentLine = acceptLine;
                                    }
                                }
                                break block42;
                            }
                            if (acceptLine <= -1) break block42;
                            thisLine = beginLine;
                            break block54;
                        }
                        if (acceptLine > -1) {
                            int thisLine3 = lastLine = JythonUtil.handleContinue(ss, lastLine);
                            for (int i = acceptLine; i <= thisLine3; ++i) {
                                SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                            }
                            String slastLine = ss[thisLine3].trim();
                            if (slastLine.endsWith(":")) {
                                SimplifyScriptSupport.appendToResult(result, SimplifyScriptSupport.getIndent(slastLine) + "    pass");
                            }
                        }
                        return result.toString();
                    }
                    for (int i = acceptLine; i <= thisLine2; ++i) {
                        if (i < thisLine2) {
                            SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                            continue;
                        }
                        if (ss[i].length() <= 0 || !Character.isWhitespace(ss[i].charAt(0))) continue;
                        SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                    }
                    SimplifyScriptSupport.appendToResult(result, "\n");
                    currentLine = thisLine2;
                    acceptLine = -1;
                    break block42;
                }
                for (int i = acceptLine; i <= thisLine; ++i) {
                    if (i < thisLine) {
                        SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                        continue;
                    }
                    if (ss[i].length() <= 0 || !Character.isWhitespace(ss[i].charAt(0))) continue;
                    SimplifyScriptSupport.appendToResult(result, ss[i]).append("\n");
                }
                SimplifyScriptSupport.appendToResult(result, "\n");
                currentLine = thisLine;
                acceptLine = -1;
            }
            ++istatement;
        }
    }

    private static boolean simplifyScriptToGetCompletionsCanResolve(SimpleNode o, HashSet<String> variableNames) {
        Name c;
        if (o instanceof Name) {
            c = (Name)o;
            if (!variableNames.contains(c.id)) {
                logger.finest(String.format("%04d canResolve->false: %s", o.beginLine, o.toString()));
                return false;
            }
        } else if (o instanceof Attribute) {
            Attribute at = (Attribute)o;
            while (at.value instanceof Attribute || at.value instanceof Subscript) {
                if (at.value instanceof Attribute) {
                    at = (Attribute)at.value;
                    continue;
                }
                exprType[] s = (exprType[])at.value;
                if (s.value instanceof Attribute) {
                    at = (Attribute)s.value;
                    continue;
                }
                return false;
            }
            if (!SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)at.value, variableNames)) {
                return false;
            }
        } else {
            if (o instanceof Compare) {
                Compare c2 = (Compare)o;
                if (SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)c2.left, variableNames)) {
                    for (exprType e : c2.comparators) {
                        if (SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)e, variableNames)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (o instanceof Call) {
                c = (Call)o;
                if (!SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)c.func, variableNames)) {
                    return false;
                }
                for (exprType e : c.args) {
                    if (SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)e, variableNames)) continue;
                    return false;
                }
            } else {
                if (o instanceof Subscript) {
                    return false;
                }
                if (o instanceof Str) {
                    return true;
                }
                if (o instanceof Num) {
                    return true;
                }
            }
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d canResolve->%s: %s", o.beginLine, vb.visitNameFail, o));
            return vb.looksOkay || !vb.visitNameFail;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d canResolve->false: %s", o.beginLine, o));
            return false;
        }
    }

    private static String maybeModelAssert(Assert a, HashSet<String> variableNames) {
        if (a.test instanceof Call) {
            exprType a2;
            exprType a1;
            Call cc = (Call)a.test;
            exprType f = cc.func;
            if (f instanceof Name && ((Name)f).id.equals("isinstance") && cc.args.length == 2 && (a1 = cc.args[0]) instanceof Name && (a2 = cc.args[1]) instanceof Name && variableNames.contains(((Name)a2).id)) {
                return String.format("%s__CLASSTYPE=%s # inserted by maybeModelAssert", ((Name)a1).id, ((Name)a2).id);
            }
            return null;
        }
        return null;
    }

    private static boolean simplifyScriptToGetCompletionsOkay(stmtType o, HashSet<String> variableNames, Map<String, String> importedNames) {
        logger.log(Level.FINEST, "simplify script line: {0}", o.beginLine);
        if (o instanceof ImportFrom) {
            ImportFrom importFrom = (ImportFrom)o;
            for (aliasType a : importFrom.names) {
                if (a.asname != null) {
                    variableNames.add(a.asname);
                    continue;
                }
                variableNames.add(a.name);
            }
            return true;
        }
        if (o instanceof Import) {
            Import imporrt = (Import)o;
            for (aliasType a : imporrt.names) {
                if (a.asname != null) {
                    variableNames.add(a.asname);
                    continue;
                }
                variableNames.add(a.name);
            }
            return true;
        }
        if (o instanceof Expr) {
            Expr e = (Expr)o;
            if (e.value instanceof Call) {
                if (SimplifyScriptSupport.trivialFunctionCall((SimpleNode)((Call)e.value))) {
                    return true;
                }
                Call c = (Call)e.value;
                if (c.func instanceof Attribute) {
                    Attribute aa = (Attribute)c.func;
                    if (aa.value instanceof Name) {
                        Name naa = (Name)aa.value;
                        if (variableNames.contains(naa.id)) {
                            return true;
                        }
                    }
                }
            }
        }
        if (o instanceof ClassDef) {
            return true;
        }
        if (o instanceof FunctionDef) {
            return true;
        }
        if (o instanceof Assign) {
            Assign a = (Assign)o;
            if (SimplifyScriptSupport.simplifyScriptToGetCompletionsOkayNoCalls((SimpleNode)a.value, variableNames)) {
                if (!SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)a.value, variableNames)) {
                    return false;
                }
                for (exprType target : a.targets) {
                    exprType et = target;
                    if (et instanceof Name) {
                        String id = ((Name)target).id;
                        variableNames.add(id);
                        logger.log(Level.FINEST, "assign to variable {0}", id);
                        if (!(a.value instanceof Call)) continue;
                        String type = SimplifyScriptSupport.maybeIdentifyReturnType(id, (Call)a.value, importedNames);
                        logger.log(Level.FINE, "id type: {0}__CLASSTYPE= {1}", new Object[]{id, type});
                        continue;
                    }
                    if (et instanceof Attribute) {
                        return false;
                    }
                    if (et instanceof Subscript) {
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o instanceof If) {
            return SimplifyScriptSupport.simplifyScriptToGetCompletionsOkayNoCalls((SimpleNode)o, variableNames);
        }
        if (o instanceof Print) {
            return false;
        }
        logger.log(Level.FINEST, "not okay to simplify: {0}", o);
        return false;
    }

    private static boolean simplifyScriptToGetCompletionsOkayNoCalls(SimpleNode o, HashSet<String> variableNames) {
        if (o instanceof Call) {
            Call c = (Call)o;
            if (!SimplifyScriptSupport.trivialFunctionCall((SimpleNode)c) && !SimplifyScriptSupport.trivialConstructorCall((SimpleNode)c)) {
                logger.finest(String.format("%04d simplify->false: %s", o.beginLine, o.toString()));
                return false;
            }
        } else {
            if (o instanceof Str) {
                return true;
            }
            if (o instanceof Num) {
                return true;
            }
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d simplify->%s: %s", o.beginLine, vb.looksOkay(), o));
            return vb.looksOkay();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d simplify->false: %s", o.beginLine, o));
            return false;
        }
    }

    private static String getFunctionName(exprType t) {
        if (t instanceof Name) {
            return ((Name)t).id;
        }
        if (t instanceof Attribute) {
            Attribute a = (Attribute)t;
            return SimplifyScriptSupport.getFunctionName(a.value) + "." + a.attr;
        }
        return t.toString();
    }

    private static boolean trivialFunctionCall(SimpleNode sn) {
        if (sn instanceof Call) {
            Call c = (Call)sn;
            boolean klugdyOkay = false;
            String ss = c.func.toString();
            for (String s : okay) {
                if (!ss.contains(s)) continue;
                klugdyOkay = true;
            }
            if (!klugdyOkay && ss.contains("TimeUtil") && ss.contains("now")) {
                klugdyOkay = true;
            }
            logger.log(Level.FINER, "trivialFunctionCall={0} for {1}", new Object[]{klugdyOkay, c.func.toString()});
            return klugdyOkay;
        }
        return false;
    }

    private static boolean trivialConstructorCall(SimpleNode sn) {
        if (sn instanceof Call) {
            Call c = (Call)sn;
            if (c.func instanceof Name) {
                String funcName = ((Name)c.func).id;
                return Character.isUpperCase(funcName.charAt(0));
            }
            if (c.func instanceof Attribute) {
                String funcName = ((Attribute)c.func).attr;
                return Character.isUpperCase(funcName.charAt(0));
            }
            return false;
        }
        return false;
    }

    private static boolean isConstructor(String name, Map<String, String> importedNames) {
        if (importedNames.containsKey(name)) {
            return name.length() > 2 && Character.isUpperCase(name.charAt(0)) && Character.isLowerCase(name.charAt(1));
        }
        return false;
    }

    private static Class getClassFor(String name, Map<String, String> importedNames) {
        String path = importedNames.get(name);
        try {
            return Class.forName(path + "." + name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private static String maybeIndentifyValue(exprType t) {
        if (t instanceof Num) {
            return String.valueOf(((Num)t).n);
        }
        if (t instanceof Str) {
            return "'" + ((Str)t).s + "'";
        }
        if (t instanceof Name) {
            String n = ((Name)t).id;
            if (n.equals("True") || n.equals("False")) {
                return n;
            }
            return null;
        }
        return null;
    }

    private static String maybeIdentifyReturnType(String id, Call c, Map<String, String> importedNames) {
        if (c.func instanceof Name) {
            Method[] funcName;
            switch (funcName = ((Name)c.func).id) {
                case "getApplication": {
                    return "from org.autoplot import AutoplotUI\n" + id + "__CLASSTYPE" + " = AutoplotUI\n";
                }
                case "getApplicationModel": {
                    return "from org.autoplot import ApplicationModel\n" + id + "__CLASSTYPE" + " = ApplicationModel\n";
                }
                case "getDataSource": {
                    return "from org.autoplot.datasource import DataSource\n" + id + "__CLASSTYPE" + " = DataSource\n";
                }
                case "addMouseModule": {
                    return "import org.das2.event.MouseModule\n" + id + "__CLASSTYPE" + " = org.das2.event.MouseModule    # return type from " + (String)funcName + " (spot line898)\n";
                }
                case "createDataPointRecorder": {
                    return "import org.das2.components.DataPointRecorder\n" + id + "__CLASSTYPE" + " = org.das2.components.DataPointRecorder    # return type from " + (String)funcName + " (spot line898)\n";
                }
                case "getParam": {
                    exprType e1 = c.args[1];
                    String vv = SimplifyScriptSupport.maybeIndentifyValue(e1);
                    if (vv != null) {
                        return id + " = " + vv;
                    }
                    if (e1.getImage() == null) {
                        if (e1 instanceof Subscript) {
                            Subscript s = (Subscript)e1;
                            if (s.slice instanceof Index && s.value instanceof Name) {
                                Index i = (Index)s.slice;
                                String ss = SimplifyScriptSupport.maybeIndentifyValue(i.value);
                                String nn = ((Name)s.value).id;
                                return id + " = " + nn + "[" + ss + "]";
                            }
                            return null;
                        }
                        return null;
                    }
                    return id + "__CLASSTYPE" + " = " + e1.getImage();
                }
                case "getDataSet": 
                case "xtags": 
                case "ytags": 
                case "findgen": 
                case "linspace": 
                case "fftPower": 
                case "magnitude": 
                case "link": 
                case "dataset": 
                case "unbundle": {
                    return id + "__CLASSTYPE" + " = QDataSet    # return type from " + (String)funcName + " (spot line789)\n";
                }
                case "datumRange": {
                    return id + "__CLASSTYPE" + " = DatumRange    # return type from " + (String)funcName + " (spot line896)\n";
                }
                case "datum": {
                    return id + "__CLASSTYPE" + " = Datum    # return type from " + (String)funcName + " (spot line898)\n";
                }
            }
            for (Method m : Ops.class.getMethods()) {
                if (!m.getName().equals(funcName) || !QDataSet.class.isAssignableFrom(m.getReturnType())) continue;
                return id + "__CLASSTYPE" + " = QDataSet    # ( spot line 898 )";
            }
            if (SimplifyScriptSupport.isConstructor((String)funcName, importedNames)) {
                return id + "__CLASSTYPE" + " = " + (String)funcName + "  # isConstructor (line794)\n";
            }
            return null;
        }
        if (c.func instanceof Attribute) {
            Attribute at = (Attribute)c.func;
            if (at.value instanceof Name) {
                String attrName = ((Name)at.value).id;
                if (attrName.equals("PngWalkTool") && at.attr.equals("start")) {
                    return "from org.autoplot.pngwalk import PngWalkTool\n" + id + "__CLASSTYPE" + "= PngWalkTool #(spot line802)\n";
                }
                if (importedNames.containsKey(attrName)) {
                    Class claz = SimplifyScriptSupport.getClassFor(attrName, importedNames);
                    if (claz == null) {
                        return null;
                    }
                    Method[] mm = claz.getMethods();
                    String methodName = at.attr;
                    for (Method m : mm) {
                        if (!m.getName().equals(methodName)) continue;
                        Class<?> rclz = m.getReturnType();
                        String rclzn = rclz.getSimpleName();
                        StringBuilder result = new StringBuilder();
                        if (rclz.getPackage() != null) {
                            result.append(String.format("from %s import %s\n", rclz.getPackage().getName(), rclzn));
                        }
                        result.append(String.format("%s%s = %s # (line895)\n", id, "__CLASSTYPE", rclzn));
                        return result.toString();
                    }
                    return null;
                }
            } else if (at.value instanceof Call) {
                String x = SimplifyScriptSupport.maybeIdentifyReturnType("x", (Call)at.value, importedNames);
                if (x != null) {
                    int i = x.indexOf("=");
                    try {
                        String s = x.substring(i + 1);
                        int i2 = s.indexOf(35);
                        if (i2 > -1) {
                            s = s.substring(0, i2);
                        }
                        if (importedNames.containsKey(s = s.trim())) {
                            String packg = importedNames.get(s);
                            Class<?> clz = Class.forName(packg + "." + s);
                            try {
                                Method m = clz.getMethod(at.attr, new Class[0]);
                                Class<?> rclz = m.getReturnType();
                                String rclzn = rclz.getSimpleName();
                                return "from " + rclz.getPackage().getName() + " import " + rclzn + "\n" + id + "__CLASSTYPE" + " = " + rclzn + "   # (spot line826)";
                            }
                            catch (NoSuchMethodException | SecurityException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        return null;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static String maybeIdentifyType(Assign a, Map<String, String> importedNames) {
        if (a.targets.length == 1) {
            exprType target = a.targets[0];
            exprType et = target;
            if (et instanceof Name) {
                String id = ((Name)target).id;
                if (a.value instanceof Call) {
                    Call c = (Call)a.value;
                    return SimplifyScriptSupport.maybeIdentifyReturnType(id, c, importedNames);
                }
                if (a.value instanceof Subscript) {
                    Subscript s = (Subscript)a.value;
                    if (s.value instanceof Attribute) {
                        Attribute att = (Attribute)s.value;
                        if (att.value instanceof Name && ((Name)att.value).id.equals("dom")) {
                            if (att.attr.equals("plots")) {
                                String rclzn = "org.autoplot.dom.Plot";
                                return "import org.autoplot.dom.Plot\n" + id + "__CLASSTYPE" + " = " + rclzn + "  # (spot line955 a)\n";
                            }
                            if (att.attr.equals("canvases")) {
                                String rclzn = "org.autoplot.dom.Canvas";
                                return "import org.autoplot.dom.Canvas\n" + id + "__CLASSTYPE" + " = " + rclzn + "  # (spot line955 b)\n";
                            }
                            if (att.attr.equals("plotElements")) {
                                String rclzn = "org.autoplot.dom.PlotElement";
                                return "import org.autoplot.dom.PlotElement\n" + id + "__CLASSTYPE" + " = " + rclzn + "  # (spot line955 c)\n";
                            }
                        }
                    } else if (s.value instanceof Name) {
                        return id + "__CLASSTYPE" + " = QDataSet  # (spot line1014 a)\n";
                    }
                } else {
                    if (a.value instanceof BinOp) {
                        return id + "__CLASSTYPE" + " = QDataSet  # (spot line1014 b)\n";
                    }
                    if (a.value instanceof Num) {
                        return id + " = " + ((Num)a.value).n;
                    }
                    if (a.value instanceof Str) {
                        return id + " = \"\"\"" + ((Str)a.value).s + "\"\"\"";
                    }
                }
            } else if (et instanceof Tuple && a.value instanceof Tuple) {
                Tuple targetTuple = (Tuple)et;
                Tuple valueTuple = (Tuple)a.value;
                if (targetTuple.elts.length == valueTuple.elts.length) {
                    StringBuilder result = new StringBuilder();
                    for (int i = 0; i < targetTuple.elts.length; ++i) {
                        Assign a1;
                        String line;
                        if (!(targetTuple.elts[i] instanceof Name) || (line = SimplifyScriptSupport.maybeIdentifyType(a1 = new Assign(new exprType[]{targetTuple.elts[i]}, valueTuple.elts[i]), importedNames)) == null) continue;
                        result.append(line).append("\n");
                    }
                    if (result.length() > 0) {
                        return result.toString();
                    }
                }
            }
        }
        return null;
    }

    private static Object Name(exprType func) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        for (String o : okay) {
            okaySet.add(o.substring(0, o.length() - 1));
        }
    }

    private static class MyVisitorBase<R>
    extends VisitorBase {
        boolean looksOkay = true;
        boolean visitNameFail = false;
        HashSet names;

        MyVisitorBase(HashSet names) {
            this.names = names;
        }

        public Object visitName(Name node) throws Exception {
            logger.log(Level.FINER, "visitName({0})", node);
            if (!this.names.contains(node.id)) {
                this.visitNameFail = true;
            }
            return super.visitName(node);
        }

        public Object visitCall(Call node) throws Exception {
            logger.log(Level.FINER, "visitCall({0})", node);
            return super.visitCall(node);
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            logger.log(Level.FINER, "traverse({0})", sn);
            if (sn instanceof Call) {
                this.looksOkay = SimplifyScriptSupport.trivialFunctionCall(sn) || SimplifyScriptSupport.trivialConstructorCall(sn);
                Call c = (Call)sn;
                for (exprType t : c.args) {
                    this.traverse((SimpleNode)t);
                }
                logger.log(Level.FINER, "looksOkay={0}", this.looksOkay);
            } else if (sn instanceof Assign) {
                Assign a = (Assign)sn;
                exprType et = a.value;
                if (et instanceof Call) {
                    this.looksOkay = SimplifyScriptSupport.trivialFunctionCall((SimpleNode)et) || SimplifyScriptSupport.trivialConstructorCall(sn);
                    logger.log(Level.FINER, "looksOkay={0}", this.looksOkay);
                }
            } else if (sn instanceof Name) {
                String t = ((Name)sn).id;
                if (t.length() > 1 && Character.isUpperCase(t.charAt(0))) {
                    logger.log(Level.FINER, "name is assumed to be a constructor call name: {0}", t);
                    return;
                }
                if (!this.names.contains(t) && !okaySet.contains(t)) {
                    this.looksOkay = false;
                    this.visitNameFail = true;
                    logger.log(Level.FINER, "looksOkay={0}", this.looksOkay);
                }
            } else if (sn instanceof Attribute) {
                this.traverse((SimpleNode)((Attribute)sn).value);
            } else if (sn instanceof Subscript) {
                Subscript ss = (Subscript)sn;
                exprType et = ss.value;
                if (et instanceof Name) {
                    this.traverse((SimpleNode)((Name)et));
                }
            } else if (sn instanceof BinOp) {
                BinOp bo = (BinOp)sn;
                this.traverse((SimpleNode)bo.left);
                this.traverse((SimpleNode)bo.right);
            } else if (sn instanceof UnaryOp) {
                UnaryOp bo = (UnaryOp)sn;
                this.traverse((SimpleNode)bo.operand);
            } else if (!(sn instanceof Num) && !(sn instanceof Str)) {
                if (sn instanceof Index) {
                    Index index = (Index)sn;
                    this.traverse((SimpleNode)index.value);
                } else if (sn instanceof Tuple) {
                    Tuple tuple = (Tuple)sn;
                    for (exprType e : tuple.elts) {
                        this.traverse((SimpleNode)e);
                    }
                } else if (sn instanceof List) {
                    List ll = (List)sn;
                    for (exprType e : ll.elts) {
                        this.traverse((SimpleNode)e);
                    }
                } else if (sn instanceof Dict) {
                    Dict dict = (Dict)sn;
                    for (exprType e : dict.keys) {
                        this.traverse((SimpleNode)e);
                    }
                    for (exprType e : dict.values) {
                        this.traverse((SimpleNode)e);
                    }
                } else {
                    logger.log(Level.FINE, "unchecked: {0}", sn);
                    this.looksOkay = false;
                }
            }
        }

        public boolean looksOkay() {
            return this.looksOkay;
        }

        public boolean visitNameFail() {
            return this.visitNameFail;
        }
    }
}

