/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.aggregator.AggregatingDataSourceFactory;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.fsm.FileStorageModel;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.Glob;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyFunction;
import org.python.core.PyObject;

public class Util {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.script");
    private static final Logger dslogger = LoggerManager.getLogger((String)"jython.script.ds");
    private static Map<String, Object> metadata;
    private static String metadataSurl;

    public static String getAutoplotScriptingVersion() throws IOException {
        File ff2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File ff3 = new File(ff2.toString() + "/jython");
        File ff4 = new File(ff3, "autoplot2025.py");
        String vers = null;
        Pattern versPattern = Pattern.compile("# autoplot2025.py v([\\d\\.]+) .*");
        if (ff4.exists()) {
            try (BufferedReader r = new BufferedReader(new FileReader(ff4));){
                Matcher m;
                String line = r.readLine();
                if (line != null && (m = versPattern.matcher(line)).matches()) {
                    vers = m.group(1);
                }
            }
        }
        if (vers == null) {
            throw new IllegalArgumentException("unable to get the scripting version");
        }
        return "v" + vers;
    }

    public static void requireAutoplotScriptingVersion(String v) {
        block6: {
            Pattern p = Pattern.compile("v(\\d+)\\.(\\d\\d)");
            Matcher m = p.matcher(v);
            if (m.matches()) {
                try {
                    int major = Integer.parseInt(m.group(1));
                    int minor = Integer.parseInt(m.group(2));
                    String current = Util.getAutoplotScriptingVersion();
                    Matcher m2 = p.matcher(current);
                    if (m2.matches()) {
                        if (Integer.parseInt(m2.group(1)) < major) {
                            throw new IllegalArgumentException("Autoplot scripting version not supported: " + v + ", current is " + current);
                        }
                        if (Integer.parseInt(m2.group(1)) < minor) {
                            throw new IllegalArgumentException("Autoplot scripting version not supported: " + v + ", current is " + current);
                        }
                        break block6;
                    }
                    throw new IllegalArgumentException("Autoplot scripting version not supported: " + v + ", current is " + current);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("unable to resolve scripting version number supported by Autoplot.", ex);
                }
            }
            throw new IllegalArgumentException("invalid version number, which must be vN.NN");
        }
    }

    public static QDataSet getDataSet(String suri, String stimeRange, ProgressMonitor mon) throws Exception {
        if (stimeRange == null) {
            throw new IllegalArgumentException("stimeRange cannot be null");
        }
        DatumRange timeRange = DatumRangeUtil.parseTimeRange((String)stimeRange);
        return Util.getDataSet(suri, timeRange, mon);
    }

    private static WritableDataSet ensureWritable(QDataSet rds) {
        if (rds instanceof WritableDataSet && !((WritableDataSet)rds).isImmutable()) {
            return (WritableDataSet)rds;
        }
        return Ops.copy((QDataSet)rds);
    }

    public static QDataSet getDataSet(String suri, DatumRange timeRange, ProgressMonitor monitor) throws Exception {
        TimeSeriesBrowse tsb;
        long t0 = System.currentTimeMillis();
        dslogger.log(Level.FINE, "getDataSet(\"{0}\",DatumRangeUtil.parseTimeRange({1}),monitor)", new Object[]{suri, timeRange});
        URI uri = DataSetURI.getURI((String)suri);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        if (factory == null) {
            throw new IllegalArgumentException("Unable to identify data source to handle URI: " + suri);
        }
        DataSource result = factory.getDataSource(uri);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((tsb = (TimeSeriesBrowse)result.getCapability(TimeSeriesBrowse.class)) == null) {
            tsb = (TimeSeriesBrowse)factory.getCapability(TimeSeriesBrowse.class);
        }
        if (tsb != null && timeRange != null) {
            tsb.setTimeRange(timeRange);
        } else {
            logger.fine("TimeSeriesBrowse capability not found, simply returning dataset.");
        }
        QDataSet rds = result.getDataSet(monitor);
        try {
            metadata = result.getMetadata((ProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage(), e);
        }
        metadataSurl = suri;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format(Locale.US, "read in %9.2f sec: ", (double)(System.currentTimeMillis() - t0) / 1000.0));
            logger.finer(String.format("  uri: %s", suri));
            logger.finer(String.format("  ds: %s", String.valueOf(rds)));
            if (logger.isLoggable(Level.FINEST) && rds != null) {
                QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)rds);
                QDataSet xextent = Ops.extent((QDataSet)xds);
                QDataSet yextent = Ops.extent((QDataSet)rds);
                logger.finest(String.format("  extent x: %s y: %s", String.valueOf(xextent), String.valueOf(yextent)));
            }
        }
        if (rds == null && factory instanceof AggregatingDataSourceFactory) {
            logger.info("strange condition where occasional null is returned because of reference caching.  This needs to be studied more.");
            monitor = new NullProgressMonitor();
            monitor.setLabel("strange condition where occasional null...");
            rds = result.getDataSet(monitor);
        }
        if (rds == null) {
            return null;
        }
        if (tsb != null && !Schemes.isTimeSeries((QDataSet)rds) && timeRange != null) {
            logger.fine("trim data to timerange");
            rds = DataSourceUtil.trimScatterToTimeRange((QDataSet)rds, (DatumRange)timeRange);
        }
        rds = Util.ensureWritable(rds);
        return rds;
    }

    public static QDataSet getDataSet(String suri, ProgressMonitor mon) throws Exception {
        long t0 = System.currentTimeMillis();
        dslogger.log(Level.FINE, "getDataSet(\"{0}\",monitor)", suri);
        URI uri = DataSetURI.getURIValid((String)suri);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        if (factory == null) {
            throw new IllegalArgumentException("unsupported extension: " + suri);
        }
        DataSource result = factory.getDataSource(uri);
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        QDataSet rds = result.getDataSet(mon);
        if (!mon.isFinished()) {
            if (!mon.isStarted()) {
                mon.started();
            }
            mon.finished();
        }
        try {
            metadata = result.getMetadata((ProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage(), e);
        }
        metadataSurl = suri;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format(Locale.US, "read in %9.2f sec: ", (double)(System.currentTimeMillis() - t0) / 1000.0));
            logger.finer(String.format("  uri: %s", suri));
            logger.finer(String.format("  ds: %s", String.valueOf(rds)));
            if (logger.isLoggable(Level.FINEST) && rds != null) {
                QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)rds);
                QDataSet xextent = Ops.extent((QDataSet)xds);
                QDataSet yextent = Ops.extent((QDataSet)rds);
                logger.finest(String.format("  extent x: %s y: %s", String.valueOf(xextent), String.valueOf(yextent)));
            }
        }
        if (rds == null) {
            return null;
        }
        TimeSeriesBrowse tsb = (TimeSeriesBrowse)result.getCapability(TimeSeriesBrowse.class);
        if (tsb != null && !Schemes.isTimeSeries((QDataSet)rds)) {
            logger.fine("trim data to timerange");
            rds = DataSourceUtil.trimScatterToTimeRange((QDataSet)rds, (DatumRange)tsb.getTimeRange());
        }
        rds = Util.ensureWritable(rds);
        return rds;
    }

    public static List<QDataSet> getDataSets(List<String> uris, ProgressMonitor mon) throws Exception {
        return Util.getDataSets(uris, null, mon);
    }

    public static List<QDataSet> getDataSets(List<String> uris, final DatumRange timerange, ProgressMonitor mon) throws Exception {
        int i;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        final ArrayList<QDataSet> result = new ArrayList<QDataSet>(uris.size());
        ProgressMonitor[] monitors = new ProgressMonitor[uris.size()];
        mon.setTaskSize((long)(10 * uris.size()));
        mon.started();
        for (int i2 = 0; i2 < uris.size(); ++i2) {
            final String uri = uris.get(i2);
            final int fi = i2;
            result.add(fi, null);
            monitors[i2] = new NullProgressMonitor();
            final ProgressMonitor thisProgressMonitor = monitors[i2];
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        QDataSet ds = Util.getDataSet(uri, timerange, thisProgressMonitor);
                        if (ds == null) {
                            throw new NoDataInIntervalException("data returned was null");
                        }
                        result.set(fi, ds);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                        result.set(fi, ex);
                    }
                }
            };
            RequestProcessor.invokeLater((Runnable)run);
        }
        boolean blocking = true;
        while (blocking) {
            Thread.sleep(250L);
            blocking = false;
            int taskProgress = 0;
            for (i = 0; i < uris.size(); ++i) {
                taskProgress = monitors[i].getTaskSize() > 0L ? (int)((double)taskProgress + 10.0 * (double)monitors[i].getTaskProgress() / (double)monitors[i].getTaskSize()) : (monitors[i].isFinished() ? (taskProgress += 10) : (taskProgress += 2));
                if (result.get(i) != null) continue;
                blocking = true;
            }
            mon.setTaskProgress((long)taskProgress);
        }
        Exception e = null;
        for (i = 0; i < uris.size(); ++i) {
            if (e != null || !(result.get(i) instanceof Exception)) continue;
            e = (Exception)result.get(i);
        }
        mon.finished();
        if (e != null) {
            throw e;
        }
        return result;
    }

    public static List<Object> runInParallel(final PyFunction job, final List<Object> argument, ProgressMonitor mon) throws Exception {
        int pendingJobs;
        boolean allDone;
        logger.entering("org.autoplot.jythonsupport.Util", "runInParallel");
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        ArrayList<2> callables = new ArrayList<2>(argument.size());
        final ArrayList<Object> result = new ArrayList<Object>(argument.size());
        final ArrayList exceptions = new ArrayList(argument.size());
        mon.setTaskSize((long)(argument.size() * 100));
        mon.started();
        int i = 0;
        while (i < argument.size()) {
            final int I = i++;
            result.add(I, null);
            exceptions.add(I, null);
            callables.add(I, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        PyObject result1 = job.__call__(Py.java2py(argument.get(I)));
                        result.set(I, result1);
                        return result1;
                    }
                    catch (Exception e) {
                        exceptions.set(I, e);
                        return null;
                    }
                }
            });
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<2> tasks = callables;
        List futures = executor.invokeAll(tasks);
        do {
            pendingJobs = 0;
            allDone = true;
            for (int i2 = 0; i2 < result.size(); ++i2) {
                Future f = futures.get(i2);
                if (f.isDone() || f.isCancelled()) continue;
                ++pendingJobs;
            }
            mon.setTaskProgress((long)((argument.size() - pendingJobs) * 100));
        } while (!allDone && pendingJobs > 0 && !mon.isCancelled());
        if (mon.isCancelled()) {
            throw new CancelledOperationException("parallel task cancelled");
        }
        mon.finished();
        for (int i3 = 0; i3 < result.size(); ++i3) {
            if (exceptions.get(i3) == null) continue;
            logger.log(Level.WARNING, ((Exception)exceptions.get(i3)).getMessage(), (Throwable)exceptions.get(i3));
            logger.throwing("org.autoplot.jythonsupport.Util", "runInParallel", (Throwable)exceptions.get(i3));
            throw (Exception)exceptions.get(i3);
        }
        logger.exiting("org.autoplot.jythonsupport.Util", "runInParallel");
        return result;
    }

    public static DataSource getDataSource(String suri) throws Exception {
        logger.log(Level.FINE, "getDataSet({0})", suri);
        URI uri = DataSetURI.getURIValid((String)suri);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        DataSource result = factory.getDataSource(uri);
        return result;
    }

    public static TimeSeriesBrowse getTimeSeriesBrowse(DataSource ds) {
        TimeSeriesBrowse tsb = (TimeSeriesBrowse)ds.getCapability(TimeSeriesBrowse.class);
        return tsb;
    }

    public static Map<String, Object> getMetadata(String suri, ProgressMonitor mon) throws Exception {
        logger.log(Level.FINE, "getMetadata(\"{0}\",monitor)", suri);
        if (suri.equals(metadataSurl)) {
            return metadata;
        }
        URI url = DataSetURI.getURIValid((String)suri);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)url, (ProgressMonitor)new NullProgressMonitor());
        DataSource result = factory.getDataSource(url);
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        return result.getMetadata(mon);
    }

    public static QDataSet getDataSet(String suri) throws Exception {
        return Util.getDataSet(suri, (ProgressMonitor)new NullProgressMonitor());
    }

    public static QDataSet getDataSet(String suri, String stimerange) throws Exception {
        return Util.getDataSet(suri, stimerange, (ProgressMonitor)new NullProgressMonitor());
    }

    public static QDataSet getDataSet(String suri, DatumRange timerange) throws Exception {
        return Util.getDataSet(suri, timerange, (ProgressMonitor)new NullProgressMonitor());
    }

    public static QDataSet getDataSetFromStream(String spec, InputStream in, ProgressMonitor mon) throws Exception {
        logger.log(Level.FINE, "getDataSet(\"{0}\",InputStream)", new Object[]{spec});
        String[] ss = spec.split(":", -2);
        int i = ss[0].indexOf("+");
        String ext = i == -1 ? ss[0] : ss[0].substring(i + 1);
        File f = File.createTempFile("autoplot", "." + ext);
        try (ReadableByteChannel chin = Channels.newChannel(in);){
            QDataSet ds;
            try (FileOutputStream fout = new FileOutputStream(f);){
                FileChannel chout = fout.getChannel();
                DataSourceUtil.transfer((ReadableByteChannel)chin, (WritableByteChannel)chout);
            }
            String virtUrl = ss[0] + ":" + f.toURI().toString() + ss[1];
            QDataSet qDataSet = ds = Util.getDataSet(virtUrl, mon);
            return qDataSet;
        }
    }

    public static String[] listDirectory(String suri) throws IOException, URISyntaxException {
        logger.log(Level.FINE, "listDirectory(\"{0}\")", suri);
        String[] ss = FileSystem.splitUrl((String)suri);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri((String)ss[2]));
        String glob = ss[3].substring(ss[2].length());
        Object[] result = glob.length() == 0 ? fs.listDirectory("/") : fs.listDirectory("/", Glob.getRegex((String)glob));
        Arrays.sort(result);
        return result;
    }

    public static String[] getTimeRangesFor(String surl, String timeRange, String format) throws IOException, ParseException {
        DatumRange dr = DatumRangeUtil.parseTimeRange((String)timeRange);
        FileStorageModel fsm = AggregatingDataSourceFactory.getFileStorageModel((String)surl);
        TimeParser tf = TimeParser.create((String)format);
        String[] ss = fsm.getNamesFor(dr);
        String[] result = new String[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            DatumRange dr2 = fsm.getRangeFor(ss[i]);
            result[i] = tf.format(dr2.min(), dr2.max());
        }
        return result;
    }

    public static String[] generateTimeRanges(String spec, String srange) throws ParseException {
        String sstart;
        TimeParser tp = TimeParser.create((String)spec);
        DatumRange range = DatumRangeUtil.parseTimeRange((String)srange);
        try {
            sstart = tp.format(range.min(), null);
        }
        catch (Exception ex) {
            DatumRange dr = tp.getValidRange();
            DatumRange dd = DatumRangeUtil.sloppyIntersection((DatumRange)range, (DatumRange)dr);
            if (dd.width().value() == 0.0) {
                return new String[0];
            }
            sstart = tp.format(dd.min(), null);
        }
        tp.parse(sstart);
        DatumRange curr = tp.getTimeRange();
        if (curr.width().value() == 0.0) {
            throw new IllegalArgumentException("spec first interval width is 0., something has gone terribly wrong.");
        }
        int countLimit = 1000000;
        int approxCount = (int)(1.01 * range.width().divide(curr.width()).value());
        if ((double)approxCount > (double)countLimit * 1.03) {
            throw new IllegalArgumentException("too many intervals would be created, this is limited to about 1000000 intervals.");
        }
        ArrayList<String> result = new ArrayList<String>(approxCount);
        if (!range.intersects(curr)) {
            curr = curr.next();
        }
        while (range.intersects(curr)) {
            String scurr = tp.format(curr.min(), curr.max());
            result.add(scurr);
            DatumRange oldCurr = curr;
            if (!oldCurr.equals((Object)(curr = curr.next()))) continue;
            break;
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean fileExists(String file) {
        if ((file = file.trim()).startsWith("file:")) {
            file = file.substring(5);
        } else if (file.startsWith("http:") || file.startsWith("https:") || file.startsWith("ftp://") || file.startsWith("sftp://")) {
            try {
                URI fileUri = new URI(file);
                URI parent = FileSystemUtil.getParentUri((URI)fileUri);
                FileSystem fs = FileSystem.create((URI)parent);
                FileObject fo = fs.getFileObject(parent.relativize(fileUri).getPath());
                return fo.exists();
            }
            catch (FileNotFoundException | URISyntaxException | UnknownHostException | FileSystem.FileSystemOfflineException ex) {
                return false;
            }
        }
        return new File(file).exists();
    }

    public static boolean fileCanRead(String file) {
        if (file.startsWith("file:")) {
            file = file.substring(5);
        } else if (file.startsWith("http:") || file.startsWith("https:") || file.startsWith("ftp://") || file.startsWith("sftp://")) {
            try {
                URI fileUri = new URI(file);
                URI parent = FileSystemUtil.getParentUri((URI)fileUri);
                FileSystem fs = FileSystem.create((URI)parent);
                FileObject fo = fs.getFileObject(parent.relativize(fileUri).getPath());
                return fo.exists();
            }
            catch (FileNotFoundException | URISyntaxException | UnknownHostException | FileSystem.FileSystemOfflineException ex) {
                return false;
            }
        }
        return new File(file).canRead();
    }

    public static Map<String, Object> readConfiguration(String suri) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        URISplit split = URISplit.parse((String)suri);
        File f = DataSetURI.getFile((String)suri, (boolean)false, (ProgressMonitor)new AlertNullProgressMonitor("loading configuration"));
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i > -1) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).length() == 0) continue;
                i = line.indexOf(61);
                String value = line.substring(i + 1).trim();
                if (value.contains("%{PWD}")) {
                    value = value.replace("%{PWD}", split.path);
                }
                result.put(line.substring(0, i).trim(), value);
            }
        }
        return result;
    }

    public static String[] getCompletions(String file) throws Exception {
        List cc = DataSetURI.getCompletions((String)file, (int)file.length(), (ProgressMonitor)new NullProgressMonitor());
        ArrayList<DataSetURI.CompletionResult> resultList = new ArrayList<DataSetURI.CompletionResult>();
        for (DataSetURI.CompletionResult cc1 : cc) {
            if (!cc1.maybePlot) continue;
            resultList.add(cc1);
        }
        String[] result = new String[resultList.size()];
        for (int i = 0; i < resultList.size(); ++i) {
            result[i] = ((DataSetURI.CompletionResult)resultList.get((int)i)).completion;
        }
        return result;
    }

    public static String[] getAllCompletions(String file) throws Exception {
        List cc = DataSetURI.getCompletions((String)file, (int)file.length(), (ProgressMonitor)new NullProgressMonitor());
        ArrayList<DataSetURI.CompletionResult> resultList = new ArrayList<DataSetURI.CompletionResult>();
        for (DataSetURI.CompletionResult cc1 : cc) {
            resultList.add(cc1);
        }
        String[] result = new String[resultList.size()];
        for (int i = 0; i < resultList.size(); ++i) {
            result[i] = ((DataSetURI.CompletionResult)resultList.get((int)i)).completion;
        }
        return result;
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static boolean isLegacyImports() {
        return true;
    }

    public static String[] guardedSplit(String s, char delim, char exclude1, char exclude2) {
        if (delim == '_') {
            throw new IllegalArgumentException("_ not allowed for delim");
        }
        StringBuilder scopyb = new StringBuilder(s.length());
        char inExclude = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inExclude == '\u0000') {
                if (c == exclude1 || c == exclude2) {
                    inExclude = c;
                }
            } else if (c == inExclude) {
                inExclude = '\u0000';
            }
            if (inExclude > '\u0000') {
                c = '_';
            }
            scopyb.append(c);
        }
        String[] ss = scopyb.toString().split(String.valueOf(delim), -2);
        int i1 = 0;
        for (int i = 0; i < ss.length; ++i) {
            int i2 = i1 + ss[i].length();
            ss[i] = s.substring(i1, i2);
            i1 = i2 + 1;
        }
        return ss;
    }

    public static String popString(String line) {
        boolean doubleQuotes;
        boolean bl = doubleQuotes = line.indexOf("\"") == 0 && line.lastIndexOf("\"") == line.length() - 1;
        boolean singleQuotes = !doubleQuotes ? line.indexOf("'") == 0 && line.lastIndexOf("'") == line.length() - 1 : false;
        if (line.length() > 1 && (doubleQuotes || singleQuotes)) {
            return line.substring(1, line.length() - 1);
        }
        return line;
    }

    public static void main(String[] args) throws Exception {
        DataSetURI.init();
        String uri = "file:///Users/jbf/data/rbsp-a_WFR-spectral-matrix_emfisis-Quick-Look_20120911_v1.2.6.cdf?BuBu[::40]";
        QDataSet ds = Util.getDataSet(uri);
        System.err.println(ds);
    }
}

