/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import ZoeloeSoft.projects.JFontChooser.JFontChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.SyntaxStyles;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.IndentAction;
import jsyntaxpane.actions.RedoAction;
import jsyntaxpane.actions.UndoAction;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.jythonsupport.ClipboardEditorPanel;
import org.autoplot.jythonsupport.JavaJythonConverter;
import org.autoplot.jythonsupport.MathematicaJythonConverter;
import org.autoplot.jythonsupport.ScriptDocumentationPanel;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.SyntaxColorBean;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.jythoncompletion.CompletionSettings;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.Utilities;
import org.das2.util.LoggerManager;

public final class EditorContextMenu {
    private static final Logger logger = Logger.getLogger("jython.editor");
    private EditorTextPane editor;
    private JPopupMenu menu;
    private DataSetSelector dataSetSelector;
    private JMenu examplesMenu;
    private JMenu jumpToMenu;
    private JMenu actionsMenu;
    private JMenu settingsMenu;
    private int jumpToMenuPosition;
    private int menuInsertIndex = 0;
    private int menuInsertCount = 0;
    private static final int BASE_INSERT_INDEX = 5;

    public EditorContextMenu(EditorTextPane edit) {
        this.editor = edit;
        this.doRebuildMenu();
        JythonCompletionProvider.getInstance().settings().addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "editorFont": {
                    this.editor.setFont(Font.decode((String)evt.getNewValue()));
                    break;
                }
                case "tabIsSpaces": {
                    boolean tabIsSpaces = (Boolean)evt.getNewValue();
                    Action get = ActionUtils.getAction((JTextComponent)this.editor, IndentAction.class);
                    if (get == null) {
                        logger.warning("Expected to find IndentAction");
                        break;
                    }
                    ((IndentAction)get).setInsertTab(!tabIsSpaces);
                    break;
                }
                case "tabIsCompletion": {
                    boolean tabIsCompletion = (Boolean)evt.getNewValue();
                    Action get = ActionUtils.getAction((JTextComponent)this.editor, IndentAction.class);
                    if (get == null) {
                        logger.warning("Expected to find IndentAction");
                        break;
                    }
                    ((IndentAction)get).setInsertTab(!tabIsCompletion);
                    break;
                }
                case "showTabs": {
                    SyntaxStyle deflt = SyntaxStyles.getInstance().getStyle(null);
                    boolean value = (Boolean)evt.getNewValue();
                    deflt.setDrawTabs(value);
                    this.editor.repaint();
                    break;
                }
            }
        });
    }

    public void addSettingsMenuItem(JMenuItem menuitem) {
        this.settingsMenu.add(menuitem);
    }

    public void addMenuItem(JMenuItem menuitem) {
        if (this.menuInsertCount == 0) {
            this.menu.add((Component)new JSeparator(), 5);
        }
        this.menu.add((Component)menuitem, 5 + this.menuInsertIndex);
        ++this.menuInsertIndex;
        ++this.menuInsertCount;
    }

    private void doRebuildJumpToMenu() {
        JMenu tree = new JMenu("Jump To");
        String[] ss = this.editor.jumpToList();
        for (int i = 0; i < ss.length; ++i) {
            final String fs = ss[i];
            tree.add(new JMenuItem(new AbstractAction(ss[i]){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (fs) {
                        case "top": {
                            EditorContextMenu.this.editor.setCaretPosition(0);
                            break;
                        }
                        case "bottom": {
                            EditorContextMenu.this.editor.setCaretPosition(EditorContextMenu.this.editor.getDocument().getLength() - 1);
                            break;
                        }
                        default: {
                            int i = fs.indexOf(":");
                            if (i <= -1) break;
                            int line = Integer.parseInt(fs.substring(0, i));
                            Element ee = EditorContextMenu.this.editor.getDocument().getDefaultRootElement().getElement(line - 1);
                            EditorContextMenu.this.editor.setCaretPosition(ee.getStartOffset());
                        }
                    }
                }
            }));
        }
        Runnable run = () -> {
            this.actionsMenu.remove(this.jumpToMenuPosition);
            this.actionsMenu.add((Component)tree, this.jumpToMenuPosition);
        };
        run.run();
    }

    public void setDataSetSelector(DataSetSelector sel) {
        this.dataSetSelector = sel;
    }

    private JMenuItem createInsertMenuItem(String label, final String text) {
        JMenuItem result = new JMenuItem(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                EditorContextMenu.this.insertCode(text);
            }
        });
        String htmlText = text;
        htmlText = htmlText.replaceAll("<", "&lt;");
        htmlText = htmlText.replaceAll(">", "&gt;");
        htmlText = htmlText.replaceAll("\n", "<br>");
        htmlText = htmlText.replaceAll(" ", "&nbsp;");
        result.setToolTipText("<html><tt>" + htmlText + "</tt></html>");
        return result;
    }

    private static String indent(String txt, int amount) {
        try {
            StringBuilder result = new StringBuilder();
            BufferedReader r = new BufferedReader(new StringReader(txt));
            String dedent = amount < 0 ? "         ".substring(0, -1 * amount) : "";
            String indent = amount > 0 ? "         ".substring(0, amount) : "";
            String line = r.readLine();
            while (line != null) {
                if (amount < 0 && line.startsWith(dedent)) {
                    line = line.substring(dedent.length());
                }
                if (amount > 0) {
                    line = indent + line;
                }
                result.append(line);
                line = r.readLine();
                if (line == null) continue;
                result.append("\n");
            }
            return result.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String comment(String txt, int amount) {
        try {
            StringBuilder result = new StringBuilder();
            BufferedReader r = new BufferedReader(new StringReader(txt));
            String line = r.readLine();
            String hash = "#";
            while (line != null) {
                String line1 = line.trim();
                int ind = line.indexOf(line1);
                if (amount < 0 && line1.startsWith(hash)) {
                    line = line.substring(0, ind) + line1.substring(1);
                }
                if (amount > 0) {
                    line = hash + line.substring(0, ind) + line1;
                }
                result.append(line);
                line = r.readLine();
                if (line == null) continue;
                result.append("\n");
            }
            return result.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private int[] roundLines() {
        int j = this.editor.getSelectionEnd();
        try {
            int i;
            int limit = this.editor.getText().length();
            for (i = this.editor.getSelectionStart(); i > 0 && !this.editor.getText(i, 1).equals("\n"); --i) {
            }
            if (i >= 0 && i < limit - 1 && this.editor.getText(i, 1).equals("\n") && !this.editor.getText(i + 1, 1).equals("\n")) {
                ++i;
            }
            while (j < limit && !this.editor.getText(j, 1).equals("\n")) {
                ++j;
            }
            return new int[]{i, j - i};
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encodeFont(Font f) {
        String style = "-";
        if (f.isBold()) {
            style = style + "bold";
        }
        if (f.isItalic()) {
            style = style + "italic";
        }
        String result = f.getFamily();
        if (style.length() > 1) {
            result = result + style;
        }
        return result + "-" + f.getSize();
    }

    private String getVariableNameContext(EditorTextPane editor) {
        int i0;
        int i1;
        int i;
        String s = editor.getSelectedText();
        if (s != null && (i = s.indexOf("=")) > 0) {
            s = s.substring(0, i);
        }
        if (s == null && (i1 = editor.getCaretPosition()) > (i0 = Utilities.getRowStart(editor, i1))) {
            try {
                s = editor.getText(i0, i1 - i0).trim();
                int i2 = s.indexOf("=");
                if (i2 > 0) {
                    s = s.substring(0, i2);
                }
            }
            catch (BadLocationException ex) {
                s = null;
            }
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private void maybeCreateMenu() {
        if (this.menu == null) {
            JMenu submenu;
            this.menu = new JPopupMenu();
            this.menu.setName("t0:" + System.currentTimeMillis());
            JMenu insertCodeMenu = new JMenu("Insert Code");
            AbstractAction a = new AbstractAction("Set Script Documentation"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    ScriptDocumentationPanel p = new ScriptDocumentationPanel();
                    p.initialize(EditorContextMenu.this.editor.getText());
                    if (0 == JOptionPane.showConfirmDialog(EditorContextMenu.this.menu, p, "Set Script Description", 2)) {
                        String src = p.implement(EditorContextMenu.this.editor.getText());
                        EditorContextMenu.this.editor.setText(src);
                    }
                }
            };
            JMenuItem item = new JMenuItem(a);
            item.setToolTipText("<html>Add title and description to the script</html>");
            insertCodeMenu.add(item);
            JMenu getParamMenu = new JMenu("Get Parameter");
            getParamMenu.setToolTipText("<html>Parameters provide a consistent and clean method for passing parameters into scripts.");
            a = new AbstractAction("getParam()"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String var = EditorContextMenu.this.getVariableNameContext(EditorContextMenu.this.editor);
                    logger.log(Level.FINE, "editor.getdoc: {0}", EditorContextMenu.this.editor.getDocument());
                    if (var == null || var.length() == 0) {
                        EditorContextMenu.this.insertLine("p1= getParam( 'p1', 0.0, 'parameter p1 (default=0.0)' )\n");
                    } else {
                        EditorContextMenu.this.insertLine(var + "= getParam( '" + var + "', 0.0, 'parameter " + var + " (default=0.0)' )\n");
                    }
                }
            };
            item = new JMenuItem(a);
            item.setToolTipText("<html>get a parameter for the script, for example, from the URI or command line depending on context<br>The first argument is the parameter name,<br>second is the default value and type,<br>optional third is description</html>");
            getParamMenu.add(item);
            a = new AbstractAction("getParam() with enumeration"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String var = EditorContextMenu.this.getVariableNameContext(EditorContextMenu.this.editor);
                    logger.log(Level.FINE, "editor.getdoc: {0}", EditorContextMenu.this.editor.getDocument());
                    if (var == null || var.length() == 0) {
                        EditorContextMenu.this.insertLine("sc= getParam( 'sc', 'A', 'the spacecraft name', ['A','B'] )\n");
                    } else {
                        EditorContextMenu.this.insertLine(var + "= getParam( '" + var + "', 'A', 'the spacecraft name', ['A','B'] )\n");
                    }
                }
            };
            item = new JMenuItem(a);
            item.setToolTipText("<html>get a parameter for the script, constraining the list of values to an enumeration.</html>");
            getParamMenu.add(item);
            a = new AbstractAction("getParam() for boolean checkbox"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String var = EditorContextMenu.this.getVariableNameContext(EditorContextMenu.this.editor);
                    logger.log(Level.FINE, "editor.getdoc: {0}", EditorContextMenu.this.editor.getDocument());
                    if (var == null || var.length() == 0) {
                        EditorContextMenu.this.insertLine("filt= getParam( 'filter', False, 'filter data', [True,False] )\n");
                    } else {
                        EditorContextMenu.this.insertLine(var + "= getParam( '" + var + "', False, 'filter data', [True,False] )\n");
                    }
                }
            };
            item = new JMenuItem(a);
            item.setToolTipText("<html>get a parameter for the script, constraining the list of values to be True or False.  A checkbox is used when a GUI is generated.</html>");
            getParamMenu.add(item);
            a = new AbstractAction("getParam() for timerange to support time series browse"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String var = EditorContextMenu.this.getVariableNameContext(EditorContextMenu.this.editor);
                    if (var == null || var.length() == 0) {
                        EditorContextMenu.this.insertLine("tr= getParam( 'timerange', '2014-01-09', 'timerange to load' )\n");
                    } else {
                        EditorContextMenu.this.insertLine(var + "= getParam( 'timerange', '2014-01-09', 'timerange to load' )\n");
                    }
                }
            };
            item = new JMenuItem(a);
            item.setToolTipText("<html>When getParam timerange is read, then the script will the time axis to be set to any time.</html>");
            getParamMenu.add(item);
            a = new AbstractAction("getParam() to get the resource URI"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.insertLine("resourceURI= getParam( 'resourceURI', 'http://autoplot.org/data/rainfall_KIOW_20120522_0252.html', 'example file to load' )\n");
                }
            };
            item = new JMenuItem(a);
            item.setToolTipText("<html>This special variable is the vap+jyds:&lt;resourceURI&gt;?script=&lt;script&gt;");
            getParamMenu.add(item);
            insertCodeMenu.add(getParamMenu);
            JMenu fragmentsMenu = new JMenu("Code Fragments");
            fragmentsMenu.add(this.createInsertMenuItem("procedure", "def myproc(x,y):\n  z=x+y\n  return z\n"));
            fragmentsMenu.add(this.createInsertMenuItem("if block", "x=0\nif (x<0):\n  print 'x<0'\nelif (x==0):\n  print 'x==0'\nelse:\n  print 'x>0'\n"));
            fragmentsMenu.add(this.createInsertMenuItem("for loop with index", "a= sin( linspace(0,PI,100) )\nfor i in xrange(len(a)):\n  print i, a[i]\n"));
            fragmentsMenu.add(this.createInsertMenuItem("monitor for feedback", "from java.lang.Thread import sleep\nmonitor.setTaskSize(100)\nmonitor.started()\nfor i in xrange(100):\n  monitor.setTaskProgress(i)\n  if monitor.getTaskProgress()==80: monitor.setProgressMessage('almost done')\n  if monitor.isCancelled(): break\n  sleep(120)\nmonitor.finished()"));
            fragmentsMenu.add(this.createInsertMenuItem("for loop over dataset", "a= sin( linspace(0,PI,100) )\nfor i in a:\n  print i\n"));
            fragmentsMenu.add(this.createInsertMenuItem("try-except", "try:\n  fil=downloadResourceAsTempFile(URL('http://autoplot.org/data/nofile.dat'),monitor)\nexcept java.io.IOException,ex:\n  print 'file not found'\n"));
            fragmentsMenu.add(this.createInsertMenuItem("except-traceback", "try:\n  fil=downloadResourceAsTempFile(URL('http://autoplot.org/data/nofile.dat'),monitor)\nexcept:\n  import traceback\n  traceback.print_exc()\n"));
            fragmentsMenu.add(this.createInsertMenuItem("raise exception", "if ( ds.length()==0 ):\n  raise Exception('Dataset is empty')"));
            fragmentsMenu.add(this.createInsertMenuItem("raise NoDataInIntervalException", "from org.das2.dataset import NoDataInIntervalException\nraise NoDataInIntervalException('no files found')"));
            fragmentsMenu.add(this.createInsertMenuItem("documentation block", "setScriptDescription('''Multi-line description''')\nsetScriptTitle('One-Line Title')\nsetScriptLabel('Terse Label')\n"));
            fragmentsMenu.add(this.createInsertMenuItem("multi-argument procedure", "# return a set of datasets which are synchronized to the same timetags.\ndef mysynchronize( ds1, *dss ):\n    \"the first dataset's timetags are used to interpolate the list of datasets\"\n    tt= ds1.property( QDataSet.DEPEND_0 )\n    result= []\n    for ds in dss:\n        tt1= ds.property( QDataSet.DEPEND_0 )\n        ff= findex( tt1, tt )\n        ds= interpolate( ds, ff )\n        result.append( ds )\n    return result\n( mlat, MLT ) = mysynchronize( hfr_spectra, mlat, MLT )"));
            fragmentsMenu.add(this.createInsertMenuItem("logger", "from org.das2.util import LoggerManager\nfrom java.util.logging import Level\nlogger= LoggerManager.getLogger( 'aascript' )\nlogger.log( Level.INFO, 'created logger for {0}', 'aascript')"));
            insertCodeMenu.add(fragmentsMenu);
            a = new AbstractAction("getDataSet()"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String var = EditorContextMenu.this.getVariableNameContext(EditorContextMenu.this.editor);
                    String surl = EditorContextMenu.this.dataSetSelector.getValue();
                    if (var == null || var.length() == 0) {
                        String name = DataSourceUtil.guessNameFor((String)surl);
                        EditorContextMenu.this.insertLine(name + "= getDataSet('" + surl + "')\n");
                    } else {
                        EditorContextMenu.this.insertLine(var + "= getDataSet('" + surl + "')\n");
                    }
                }
            };
            item = new JMenuItem(a);
            item.setToolTipText("<html>load the dataset from the specified URI into a variable.  An example URI is grabbed from the dataset selector.</html>");
            insertCodeMenu.add(item);
            this.menu.add(insertCodeMenu);
            this.examplesMenu = submenu = new JMenu("Example Scripts");
            this.menu.add(submenu);
            this.actionsMenu = new JMenu("Actions");
            this.jumpToMenu = new JMenu("Jump To");
            this.jumpToMenu.setToolTipText("Jump To Position in code");
            this.jumpToMenuPosition = this.actionsMenu.getItemCount();
            this.actionsMenu.add(this.jumpToMenu);
            JMenu developerMenu = new JMenu("Developer");
            developerMenu.setToolTipText("Special actions for developers");
            this.actionsMenu.add(developerMenu);
            JMenuItem printMenuItem = new JMenuItem("Print");
            printMenuItem.setToolTipText("Print to printer");
            printMenuItem.addActionListener(e -> {
                try {
                    this.editor.print();
                }
                catch (PrinterException ex) {
                    Logger.getLogger(EditorContextMenu.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            this.actionsMenu.add(printMenuItem);
            JMenuItem runMenuItem = new JMenuItem("Run Selected");
            runMenuItem.setToolTipText("Run Selected Commands");
            runMenuItem.addActionListener(e -> {
                String[] sss;
                String doThis = this.editor.getSelectedText();
                if (doThis == null) {
                    JOptionPane.showMessageDialog(this.editor, "Select portion of the code to execute");
                    return;
                }
                for (String s : sss = doThis.split("\n")) {
                    if (s.length() <= 0 || !Character.isWhitespace(s.charAt(0))) continue;
                    JOptionPane.showMessageDialog(this.menu, "Sorry no indents");
                    return;
                }
                JythonInterpreterProvider pp = (JythonInterpreterProvider)this.editor.getClientProperty("JYTHON_INTERPRETER_PROVIDER");
                if (pp == null) {
                    JOptionPane.showMessageDialog(this.menu, "Sorry no Jython session to run commands");
                    return;
                }
                Runnable run = () -> {
                    try {
                        pp.createInterpreter().exec(doThis);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                };
                new Thread(run).start();
            });
            this.actionsMenu.add(runMenuItem);
            JMenuItem mi = new JMenuItem(new AbstractAction("Convert To Java"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String doThis = EditorContextMenu.this.editor.getSelectedText();
                    if (doThis == null || doThis.length() == 0) {
                        doThis = EditorContextMenu.this.editor.getText();
                    }
                    try {
                        JavaJythonConverter cc = new JavaJythonConverter(EditorContextMenu.this.editor, 2);
                        cc.setPythonSource(doThis);
                        JDialog d = new JDialog();
                        d.setContentPane(cc);
                        d.pack();
                        d.setVisible(true);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(EditorContextMenu.this.menu, ex.toString());
                    }
                }
            });
            developerMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Convert Java To Jython"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String doThis = EditorContextMenu.this.editor.getSelectedText();
                    if (doThis == null || doThis.length() == 0) {
                        doThis = EditorContextMenu.this.editor.getText();
                    }
                    try {
                        JavaJythonConverter cc = new JavaJythonConverter(EditorContextMenu.this.editor);
                        cc.setJavaSource(doThis);
                        JDialog d = new JDialog();
                        d.setContentPane(cc);
                        d.pack();
                        d.setVisible(true);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(EditorContextMenu.this.menu, ex.toString());
                    }
                }
            });
            developerMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Convert Mathematica To Jython"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String doThis = EditorContextMenu.this.editor.getSelectedText();
                    if (doThis == null || doThis.length() == 0) {
                        doThis = EditorContextMenu.this.editor.getText();
                    }
                    try {
                        MathematicaJythonConverter cc = new MathematicaJythonConverter(EditorContextMenu.this.editor);
                        cc.setJavaSource(doThis);
                        JDialog d = new JDialog();
                        d.setContentPane(cc);
                        d.pack();
                        d.setVisible(true);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(EditorContextMenu.this.menu, ex.toString());
                    }
                }
            });
            developerMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Show Simplified Script Used for Completions"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.editor.showCompletionsView();
                }
            });
            developerMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Show Simplified Script Used for Parameters"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.editor.showParametersView();
                }
            });
            mi.setAccelerator(KeyStroke.getKeyStroke(123, 192));
            developerMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Plot"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.editor.plotItem();
                }
            });
            mi.setToolTipText("Plot dataset reference in a second Autoplot with its server port open");
            mi.setAccelerator(KeyStroke.getKeyStroke(67, 192));
            this.actionsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Inspect URI"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.editor.inspectURI();
                }
            });
            mi.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/fileMag.png")));
            mi.setToolTipText("Use the data source editor panel to modify URI");
            this.actionsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Indent Block"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    int[] il = EditorContextMenu.this.roundLines();
                    try {
                        String txt = EditorContextMenu.this.editor.getText(il[0], il[1]);
                        txt = EditorContextMenu.indent(txt, 4);
                        EditorContextMenu.this.editor.getDocument().remove(il[0], il[1]);
                        EditorContextMenu.this.editor.getDocument().insertString(il[0], txt, null);
                        EditorContextMenu.this.editor.setSelectionStart(il[0]);
                        EditorContextMenu.this.editor.setSelectionEnd(il[0] + txt.length());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            mi.setToolTipText("indent the selected block of lines");
            this.actionsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Unindent Block"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    int[] il = EditorContextMenu.this.roundLines();
                    try {
                        String txt = EditorContextMenu.this.editor.getText(il[0], il[1]);
                        txt = EditorContextMenu.indent(txt, -4);
                        EditorContextMenu.this.editor.getDocument().remove(il[0], il[1]);
                        EditorContextMenu.this.editor.getDocument().insertString(il[0], txt, null);
                        EditorContextMenu.this.editor.setSelectionStart(il[0]);
                        EditorContextMenu.this.editor.setSelectionEnd(il[0] + txt.length());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            mi.setToolTipText("indent the selected block of lines");
            this.actionsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Comment Block"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    int[] il = EditorContextMenu.this.roundLines();
                    try {
                        String txt = EditorContextMenu.this.editor.getText(il[0], il[1]);
                        txt = EditorContextMenu.comment(txt, 1);
                        EditorContextMenu.this.editor.getDocument().remove(il[0], il[1]);
                        EditorContextMenu.this.editor.getDocument().insertString(il[0], txt, null);
                        EditorContextMenu.this.editor.setSelectionStart(il[0]);
                        EditorContextMenu.this.editor.setSelectionEnd(il[0] + txt.length());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            mi.setToolTipText("comment the selected block of lines");
            this.actionsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Uncomment Block"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    int[] il = EditorContextMenu.this.roundLines();
                    try {
                        String txt = EditorContextMenu.this.editor.getText(il[0], il[1]);
                        txt = EditorContextMenu.comment(txt, -1);
                        EditorContextMenu.this.editor.getDocument().remove(il[0], il[1]);
                        EditorContextMenu.this.editor.getDocument().insertString(il[0], txt, null);
                        EditorContextMenu.this.editor.setSelectionStart(il[0]);
                        EditorContextMenu.this.editor.setSelectionEnd(il[0] + txt.length());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            mi.setToolTipText("uncomment the selected block of lines");
            this.actionsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Show Usages"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.editor.showUsages();
                }
            });
            mi.setToolTipText("highlite use of name");
            mi.setAccelerator(KeyStroke.getKeyStroke(85, 192));
            this.actionsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Import Java Code"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.editor.doImports();
                }
            });
            mi.setToolTipText("search for and add import");
            mi.setAccelerator(KeyStroke.getKeyStroke(73, 576));
            this.actionsMenu.add(mi);
            this.menu.add(this.actionsMenu);
            this.settingsMenu = new JMenu("Settings");
            mi = new JMenuItem(new AbstractAction("Edit Settings"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    CompletionSettings settings = JythonCompletionProvider.getInstance().settings();
                    PropertyEditor p = new PropertyEditor((Object)settings);
                    p.showModalDialog((Component)EditorContextMenu.this.editor);
                }
            });
            mi.setToolTipText("Settings for the editor");
            this.settingsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Pick Font..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(EditorContextMenu.this.editor);
                    JFontChooser chooser = new JFontChooser((Frame)parent);
                    chooser.setLocationRelativeTo((Component)EditorContextMenu.this.editor);
                    chooser.setExampleText("ds= getDataSet('http://autoplot.org/data/data.dat')");
                    chooser.setFont(EditorContextMenu.this.editor.getFont());
                    if (chooser.showDialog() == 0) {
                        CompletionSettings settings = JythonCompletionProvider.getInstance().settings();
                        settings.setEditorFont(EditorContextMenu.encodeFont(chooser.getFont()));
                    }
                }
            });
            mi.setToolTipText("Pick Font for editor");
            this.settingsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Reload Syntax Colors"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String s = EditorContextMenu.this.editor.getText();
                    EditorContextMenu.this.editor.setEditorKit(null);
                    EditorContextMenu.this.editor.getInitializeRunnable().run();
                    EditorContextMenu.this.editor.setText(s);
                }
            });
            mi.setToolTipText("Reload editor colors from autoplot_data/config/jsyntaxpane.properties");
            this.settingsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Edit Syntax Colors"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        File configFile = new File(AutoplotSettings.settings().resolveProperty("autoplotData") + "/config/jsyntaxpane.properties");
                        SyntaxColorBean bean = new SyntaxColorBean();
                        bean.readFromConfig(configFile);
                        PropertyEditor edit = new PropertyEditor((Object)bean);
                        JPanel p = new JPanel();
                        p.setLayout(new BorderLayout());
                        p.add((Component)edit, "Center");
                        JButton loadButton = new JButton("Load...");
                        JButton saveButton = new JButton("Save...");
                        JPanel actionsPanel = new JPanel();
                        actionsPanel.setLayout(new FlowLayout(0));
                        actionsPanel.add(loadButton);
                        actionsPanel.add(saveButton);
                        p.add((Component)actionsPanel, "South");
                        loadButton.addActionListener(e1 -> {
                            JFileChooser choose = new JFileChooser();
                            choose.setCurrentDirectory(configFile.getParentFile());
                            int returnValue = choose.showOpenDialog(p);
                            if (returnValue == 0) {
                                try {
                                    bean.readFromConfig(choose.getSelectedFile());
                                    edit.refresh();
                                }
                                catch (IOException ex) {
                                    logger.log(Level.SEVERE, null, ex);
                                }
                            }
                        });
                        saveButton.addActionListener(e1 -> {
                            JFileChooser choose = new JFileChooser();
                            choose.setCurrentDirectory(configFile.getParentFile());
                            int returnValue = choose.showSaveDialog(p);
                            if (returnValue == 0) {
                                try {
                                    bean.writeToConfig(choose.getSelectedFile());
                                }
                                catch (IOException ex) {
                                    logger.log(Level.SEVERE, null, ex);
                                }
                            }
                        });
                        if (0 == JOptionPane.showConfirmDialog((Component)e.getSource(), p, "Editor Colors", 2)) {
                            String s = EditorContextMenu.this.editor.getText();
                            bean.writeToConfig(configFile);
                            EditorContextMenu.this.editor.setEditorKit(null);
                            EditorContextMenu.this.editor.getInitializeRunnable().run();
                            EditorContextMenu.this.editor.setText(s);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(EditorContextMenu.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            mi.setToolTipText("Edit the colors used in autoplot_data/config/jsyntaxpane.properties");
            this.settingsMenu.add(mi);
            mi = new JMenuItem(new AbstractAction("Keyboard Shortcuts..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String msg = "<html><table><tr><td><b>Keyboard Shortcuts:</b></td><td></td><br></tr><tr><td>META-Z</td><td> undo </td><br></tr><tr><td>META-Y</td><td> redo</td>  <br></tr><tr><td>META-EQUALS</td><td> biggerFont </td> <br></tr><tr><td>META-MINUS</td><td> smallerFont </td> <br></tr><tr><td>SHIFT-F5</td><td> settings </td> <br></tr><tr><td>CTRL-SHIFT-C</td><td> plot expression via server mode (See [menubar]->Options->Enable Feature->Server)\" </td> <br></tr><tr><td>CTRL-SHIFT-U</td><td> show usages of a variable<br></td></tr><tr><td>ALT-SHIFT-U</td><td>import the symbol<br></td></tr><tr><td>CTRL-S</td><td>  Save<br></td></tr><tr><td>F6</td><td> Execute<br></td> </tr><tr><td>SHIFT-F6</td><td> Execute with Parameters Dialog<br></td> </tr><tr><td>CRTL-SHIFT-F12</td><td> Used for script editor development<br></td> </tr><tr><td>CTRL-SPACE</td><td> Show completions<br></td> </tr><tr><td>CTRL-F</td><td> Show Search bar<br></td> </tr></table></html>";
                    JOptionPane.showMessageDialog(EditorContextMenu.this.actionsMenu, msg);
                }
            });
            mi.setToolTipText("Show shortcuts");
            this.settingsMenu.add(mi);
            this.menu.add(this.settingsMenu);
            JSeparator sep = new JSeparator();
            sep.setName("customMenuItems");
            this.menu.add(sep);
            mi = new JMenuItem(new AbstractAction("Static Code Analysis"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    EditorContextMenu.this.editor.doStaticCodeAnalysis();
                }
            });
            mi.setToolTipText("Run Static Code Analysis, looking for unused symbols which might hint at a semmantic error.");
            this.menu.add(mi);
            this.menu.addSeparator();
            mi = new JMenuItem(new AbstractAction("Search..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    JOptionPane.showMessageDialog(EditorContextMenu.this.menu, "Ctrl-F is Search");
                }
            });
            JMenu editMenu = new JMenu("Edit");
            editMenu.add((Action)new UndoAction()).setText("Undo");
            editMenu.add((Action)new RedoAction()).setText("Redo");
            editMenu.add(mi).setText("Find");
            this.menu.add(editMenu);
            this.menu.addSeparator();
            JMenuItem cutItem = this.menu.add(new DefaultEditorKit.CutAction());
            cutItem.setText("Cut");
            JMenuItem copyItem = this.menu.add(new DefaultEditorKit.CopyAction());
            copyItem.setText("Copy");
            JMenuItem pasteItem = this.menu.add(new DefaultEditorKit.PasteAction());
            pasteItem.setText("Paste");
            AbstractAction editClipboardAction = new AbstractAction("Edit Clipboard before Paste"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClipboardEditorPanel ep = new ClipboardEditorPanel();
                    ep.setTextFromClipboard();
                    if (0 == JOptionPane.showConfirmDialog(EditorContextMenu.this.editor, ep, "Edit Text before Paste", 2)) {
                        try {
                            if (EditorContextMenu.this.editor.getSelectionStart() < EditorContextMenu.this.editor.getSelectionEnd()) {
                                EditorContextMenu.this.editor.getDocument().remove(EditorContextMenu.this.editor.getSelectionStart(), EditorContextMenu.this.editor.getSelectionEnd() - EditorContextMenu.this.editor.getSelectionStart());
                            }
                            EditorContextMenu.this.editor.getDocument().insertString(EditorContextMenu.this.editor.getCaretPosition(), ep.getText(), null);
                        }
                        catch (BadLocationException ex) {
                            logger.log(Level.SEVERE, null, ex);
                        }
                    }
                }
            };
            JMenuItem editClipboard = new JMenuItem(editClipboardAction);
            this.menu.add(editClipboard);
        }
    }

    private void insertLine(String code) {
        int i = this.editor.getCaretPosition();
        int i1 = Utilities.getRowEnd(this.editor, i);
        int i0 = Utilities.getRowStart(this.editor, i);
        this.editor.setSelectionStart(i0);
        this.editor.setSelectionEnd(i1);
        this.editor.replaceSelection(code);
    }

    private void insertCode(String code) {
        try {
            this.editor.getDocument().insertString(this.editor.getCaretPosition(), code, null);
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void addExampleAction(Action a) {
        this.examplesMenu.add(a);
    }

    public void doRebuildMenu() {
        this.menu = null;
        this.menuInsertCount = 0;
        this.menuInsertIndex = 0;
        this.maybeCreateMenu();
        this.editor.setComponentPopupMenu(this.menu);
        this.menu.addPropertyChangeListener("visible", evt -> this.doRebuildJumpToMenu());
    }
}

