/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.SyntaxStyles;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.IndentAction;
import jsyntaxpane.syntaxkits.PythonSyntaxKit;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.jythonsupport.JythonToJavaConverter;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.PyQDataSet;
import org.autoplot.jythonsupport.SimplifyScriptSupport;
import org.autoplot.jythonsupport.StaticCodeAnalysis;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.das2.DasApplication;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.CompletionSettings;
import org.das2.jythoncompletion.CompletionSupport;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.Utilities;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.QDataSet;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.util.LoggerManager;
import org.python.core.PyObject;
import org.python.core.PySyntaxError;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Name;
import org.python.parser.ast.aliasType;

public class EditorTextPane
extends JEditorPane {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.editor");
    protected static final String PROP_FONT = "font";
    private EditorAnnotationsSupport support = new EditorAnnotationsSupport(this);
    private boolean initialized = false;
    JEditorPane completionsEditorPane = null;

    public EditorTextPane() {
        Runnable run = this.getInitializeRunnable();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            SwingUtilities.invokeLater(run);
        }
    }

    public final Runnable getInitializeRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                String v;
                final UndoManager undo = new UndoManager();
                EditorTextPane.this.getActionMap().put("undo", new AbstractAction(undo.getUndoPresentationName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (undo.canUndo()) {
                            undo.undo();
                        }
                    }
                });
                EditorTextPane.this.getActionMap().put("redo", new AbstractAction(undo.getRedoPresentationName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (undo.canRedo()) {
                                undo.redo();
                            }
                        }
                        catch (CannotRedoException cannotRedoException) {
                            // empty catch block
                        }
                    }
                });
                EditorTextPane.this.getActionMap().put("biggerFont", new AbstractAction("Text Size Bigger"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Font f = EditorTextPane.this.getFont();
                        float size = f.getSize2D();
                        float step = size < 14.0f ? 1.0f : 2.0f;
                        EditorTextPane.this.setFont(f.deriveFont(Math.min(40.0f, size + step)));
                    }
                });
                EditorTextPane.this.getActionMap().put("smallerFont", new AbstractAction("Text Size Smaller"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Font f = EditorTextPane.this.getFont();
                        float size = f.getSize2D();
                        float step = size < 14.0f ? 1.0f : 2.0f;
                        EditorTextPane.this.setFont(f.deriveFont(Math.max(4.0f, size - step)));
                    }
                });
                EditorTextPane.this.getActionMap().put("settings", new AbstractAction("settings"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CompletionSettings settings = JythonCompletionProvider.getInstance().settings();
                        PropertyEditor p = new PropertyEditor((Object)settings);
                        p.showModalDialog((Component)EditorTextPane.this);
                    }
                });
                EditorTextPane.this.getActionMap().put("plotItem", new AbstractAction("plotItem"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        EditorTextPane.this.plotItem();
                    }
                });
                EditorTextPane.this.getActionMap().put("developer1", new AbstractAction("developer1"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        EditorTextPane.this.showParametersView();
                    }
                });
                EditorTextPane.this.getActionMap().put("showUsages", new AbstractAction("showUsages"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        EditorTextPane.this.showUsages();
                    }
                });
                EditorTextPane.this.getActionMap().put("importCode", new AbstractAction("importCode"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        EditorTextPane.this.doImports();
                    }
                });
                Toolkit tk = Toolkit.getDefaultToolkit();
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(90, tk.getMenuShortcutKeyMask()), "undo");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(89, tk.getMenuShortcutKeyMask()), "redo");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "biggerFont");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "smallerFont");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(116, 64), "settings");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(67, 192), "plotItem");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(85, 192), "showUsages");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(73, 576), "importCode");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(123, 192), "developer1");
                EditorTextPane.this.doLayout();
                DefaultSyntaxKit.initKit();
                JPopupMenu oldPopup = EditorTextPane.this.getComponentPopupMenu();
                EditorTextPane.this.setContentType("text/python");
                Properties p = new Properties();
                String f = AutoplotSettings.settings().resolveProperty("autoplotData");
                File config = new File(new File(f), "config");
                EditorKit k = EditorTextPane.this.getEditorKit();
                if (config.exists() && k instanceof PythonSyntaxKit) {
                    try {
                        File syntaxPropertiesFile = new File(config, "jsyntaxpane.properties");
                        logger.log(Level.FINE, "Resetting editor colors using {0}", syntaxPropertiesFile);
                        try (FileInputStream ins = new FileInputStream(syntaxPropertiesFile);){
                            p.load(ins);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                    ((PythonSyntaxKit)k).setConfig(p);
                    String s = p.getProperty("Background", "0xFFFFFF");
                    EditorTextPane.this.setBackground(Color.decode(s));
                    s = p.getProperty("CaretColor", "0x000000");
                    EditorTextPane.this.setCaretColor(Color.decode(s));
                    s = p.getProperty("SelectionColor", "0x99ccff");
                    EditorTextPane.this.setSelectionColor(Color.decode(s));
                    SyntaxStyle deft = SyntaxStyles.getInstance().getStyle(null);
                    if (EditorTextPane.this.getBackground().getRed() < 128) {
                        deft.setColorString("0xFFFFFF");
                    } else {
                        deft.setColorString("0x000000");
                    }
                }
                if (!(v = System.getProperty("java.version")).startsWith("1.8") && !v.startsWith("1.7")) {
                    ((SyntaxDocument)EditorTextPane.this.getDocument()).setUndoManager(new UndoManager());
                }
                if (!JythonCompletionProvider.getInstance().settings().isTabIsCompletion()) {
                    Action get = ActionUtils.getAction((JTextComponent)EditorTextPane.this, IndentAction.class);
                    if (get == null) {
                        logger.warning("Expected to find IndentAction");
                    } else {
                        ((IndentAction)get).setInsertTab(true);
                    }
                }
                EditorTextPane.this.getDocument().addUndoableEditListener(undo);
                if (oldPopup != null) {
                    EditorTextPane.this.setComponentPopupMenu(oldPopup);
                }
                String sf = JythonCompletionProvider.getInstance().settings().getEditorFont();
                EditorTextPane.this.setFont(Font.decode(sf));
                EditorTextPane.this.initialized = true;
            }
        };
    }

    private void showInCompletionsEditorPane(String scriptPrime, String label) {
        JDialog d;
        JEditorPane a;
        if (this.completionsEditorPane == null) {
            this.completionsEditorPane = a = new JEditorPane();
            DefaultSyntaxKit.initKit();
            Properties p = new Properties();
            String f = AutoplotSettings.settings().resolveProperty("autoplotData");
            File config = new File(new File(f), "config");
            if (config.exists()) {
                try {
                    File syntaxPropertiesFile = new File(config, "jsyntaxpane.properties");
                    logger.log(Level.FINE, "Resetting editor colors using {0}", syntaxPropertiesFile);
                    try (FileInputStream in = new FileInputStream(syntaxPropertiesFile);){
                        p.load(in);
                    }
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                String s = p.getProperty("Background", "0xFFFFFF");
                a.setBackground(Color.decode(s));
                s = p.getProperty("CaretColor", "0x000000");
                a.setCaretColor(Color.decode(s));
                s = p.getProperty("SelectionColor", "0x99ccff");
                this.setSelectionColor(Color.decode(s));
                SyntaxStyle deft = SyntaxStyles.getInstance().getStyle(null);
                if (a.getBackground().getRed() < 128) {
                    deft.setColorString("0xFFFFFF");
                } else {
                    deft.setColorString("0x000000");
                }
                this.completionsEditorPane.setFont(this.completionsEditorPane.getFont().deriveFont(10.0f));
            }
            a.setContentType("text/python");
            d = new JDialog();
            d.setTitle(label + " Peek Editor");
            a.setMinimumSize(new Dimension(600, 800));
            a.setPreferredSize(new Dimension(600, 800));
            d.getContentPane().add(new JScrollPane(a));
            d.pack();
        } else {
            a = this.completionsEditorPane;
            d = (JDialog)SwingUtilities.getWindowAncestor(this.completionsEditorPane);
            d.setTitle(label + " Peek Editor");
        }
        a.setText(scriptPrime);
        a.setFont(this.getFont());
        d.setVisible(true);
    }

    public void showCompletionsView() {
        String doThis = this.getSelectedText();
        if (doThis == null || doThis.length() == 0) {
            doThis = this.getText();
            doThis = doThis.substring(0, this.getCaretPosition());
        }
        try {
            String scriptPrime = SimplifyScriptSupport.simplifyScriptToCompletions(doThis);
            this.showInCompletionsEditorPane(scriptPrime, "Completions");
        }
        catch (NumberFormatException | PySyntaxError ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            JOptionPane.showMessageDialog(this, ex.toString());
        }
    }

    public void showParametersView() {
        String script = this.getText();
        String scriptPrime = JythonUtil.simplifyScriptToGetParams(script, true);
        this.showInCompletionsEditorPane(scriptPrime, "Parameters");
    }

    @Override
    public void setDocument(Document doc) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.fine("called from off the event queue.");
        }
        super.setDocument(doc);
    }

    protected void showUsages() {
        String script = this.getText();
        String var = this.getSelectedText();
        if (var == null || var.length() == 0) {
            var = EditorAnnotationsSupport.getSymbolAt(this, this.getCaretPosition());
        }
        this.support.clearAnnotations();
        this.setSelectionEnd(this.getSelectionStart());
        List<SimpleNode> usages = StaticCodeAnalysis.showUsage(script, var);
        for (SimpleNode use : usages) {
            this.support.annotateChars(use.beginLine, use.beginColumn, use.beginColumn + var.length(), "usage", var, null);
        }
        this.showWriteWithoutRead();
        this.showReadButNotAssigned();
    }

    void doStaticCodeAnalysis() {
        this.support.clearAnnotations();
        this.showWriteWithoutRead();
        this.showReadButNotAssigned();
    }

    protected void showWriteWithoutRead() {
        String script = this.getText();
        this.setSelectionEnd(this.getSelectionStart());
        List<SimpleNode> writeWithoutRead = StaticCodeAnalysis.showWriteWithoutRead(script);
        for (SimpleNode n : writeWithoutRead) {
            int len = 1;
            if (n instanceof Name) {
                len = ((Name)n).id.length();
                if (len == 1 && ((Name)n).id.equals("_")) continue;
                this.support.annotateChars(n.beginLine, n.beginColumn, n.beginColumn + len, "codeHint", "assigned but not read", null);
                continue;
            }
            if (n instanceof aliasType) {
                aliasType a = (aliasType)n;
                len = a.asname != null ? a.asname.length() : a.name.length();
                this.support.annotateChars(n.beginLine, n.beginColumn, n.beginColumn + len, "codeHint", "import not used", null);
                continue;
            }
            this.support.annotateChars(n.beginLine, n.beginColumn, n.beginColumn + len, "codeHint", "assigned but not read", null);
        }
    }

    protected void showReadButNotAssigned() {
        String script = this.getText();
        this.setSelectionEnd(this.getSelectionStart());
        List<SimpleNode> writeWithoutRead = StaticCodeAnalysis.showReadButNotAssigned(script, true, "");
        for (SimpleNode n : writeWithoutRead) {
            int len = 1;
            if (n instanceof Name) {
                len = ((Name)n).id.length();
            }
            this.support.annotateChars(n.beginLine, n.beginColumn, n.beginColumn + len, "warning", "name not assigned", null);
        }
    }

    protected void doImports() {
        String pkg;
        String var = this.getSelectedText();
        if (var == null || var.length() == 0) {
            var = EditorAnnotationsSupport.getSymbolAt(this, this.getCaretPosition());
        }
        if ((pkg = JythonToJavaConverter.guessPackage(var)) != null) {
            String src2;
            String src = this.getText();
            if (src.equals(src2 = JythonToJavaConverter.addImport(src, pkg, var))) {
                JOptionPane.showMessageDialog(this, "\"" + var + "\" is already imported.");
            }
            if (0 == JOptionPane.showConfirmDialog(this, "Add import for " + var + " in " + pkg + "?", "Import", 2)) {
                src = JythonToJavaConverter.addImport(src, pkg, var);
                this.setText(src);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No suggestions found.");
        }
    }

    protected void plotItem() {
        String doThis = this.getSelectedText();
        if (doThis == null || doThis.length() == 0) {
            doThis = EditorAnnotationsSupport.getSymbolAt(this, this.getCaretPosition());
        }
        logger.log(Level.FINE, "plotItem: {0}", doThis);
        try {
            this.plotSoon(doThis);
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(this, "<html>A debugging session must be active.  Insert stop to halt script execution.</html>");
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.support.getToolTipText(event);
    }

    public void setEditorAnnotationsSupport(EditorAnnotationsSupport support) {
        this.support = support;
    }

    public EditorAnnotationsSupport getEditorAnnotationsSupport() {
        return this.support;
    }

    private void doInspectURIFormat(int lineStart, String line, String suri) {
        int uri0 = line.indexOf(suri);
        int uri1 = uri0 + suri.length();
        JPanel parent = new JPanel();
        parent.setLayout(new BorderLayout());
        URISplit split = URISplit.parse((String)suri);
        suri = URISplit.format((URISplit)split);
        int i = suri.indexOf(63);
        String ss = i > -1 ? suri.substring(0, i) : suri;
        Object oeditorPanel = DataSourceRegistry.getInstance().getDataSourceFormatEditorByExt(ss);
        if (oeditorPanel == null) {
            logger.log(Level.WARNING, "unable to find editor for: {0}", ss);
        }
        DataSourceFormatEditorPanel editorPanel = (DataSourceFormatEditorPanel)DataSourceRegistry.getInstanceFromClassName((String)((String)oeditorPanel));
        editorPanel.setURI(suri);
        parent.add(editorPanel.getPanel());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/fileMag.png"));
        if (0 == WindowManager.showConfirmDialog((Component)this, (Object)parent, (String)"Editing URI", (int)2, (int)3, (Icon)icon)) {
            String newUri = editorPanel.getURI();
            this.setSelectionStart(lineStart + uri0);
            this.setSelectionEnd(lineStart + uri1);
            this.replaceSelection(newUri);
        }
    }

    protected void inspectURI() {
        try {
            int pos = this.getCaretPosition();
            int i0 = Utilities.getRowStart(this, pos);
            int i2 = Utilities.getRowEnd(this, pos);
            int lineStart = i0;
            String line = this.getText(i0, i2 - i0);
            int i1 = i0;
            i2 = pos -= i0;
            i1 -= i0;
            i0 = 0;
            if (line.trim().startsWith("formatDataSet")) {
                int i4;
                int i3;
                if (pos < line.length() && line.charAt(pos) == '\'') {
                    --pos;
                }
                if ((i3 = line.lastIndexOf("'", pos)) > -1) {
                    ++i3;
                }
                if ((i4 = line.indexOf("'", i3)) == -1) {
                    i4 = line.length();
                }
                String s = line.substring(i3, i4);
                this.doInspectURIFormat(lineStart, line, s);
                return;
            }
            CompletionContext cc = CompletionSupport.getCompletionContext(line, pos, i0, i1, i2);
            if (cc == null) {
                JOptionPane.showMessageDialog(this, "<html>String URI argument must start with vap+cdaweb:, vap+inline:, etc", "URI needed", 1);
                return;
            }
            String oldUri = cc.completable;
            if (oldUri.startsWith("'")) {
                oldUri = oldUri.substring(1);
            }
            if (oldUri.endsWith("'")) {
                oldUri = oldUri.substring(0, oldUri.length() - 1);
            }
            if (oldUri.startsWith("\"")) {
                oldUri = oldUri.substring(1);
            }
            if (oldUri.endsWith("\"")) {
                oldUri = oldUri.substring(0, oldUri.length() - 1);
            }
            if (oldUri.length() == 0 || !oldUri.contains(":")) {
                JOptionPane.showMessageDialog(this, "<html>String URI argument must start with vap+cdaweb:, vap+inline:,etc", "URI needed", 1);
                return;
            }
            int uri0 = line.indexOf(oldUri);
            int uri1 = uri0 + oldUri.length();
            JPanel parent = new JPanel();
            parent.setLayout(new BorderLayout());
            DataSourceEditorPanel p = DataSourceEditorPanelUtil.getDataSourceEditorPanel((JPanel)parent, (String)oldUri);
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/fileMag.png"));
            if (0 == WindowManager.showConfirmDialog((Component)this, (Object)parent, (String)"Editing URI", (int)2, (int)3, (Icon)icon)) {
                String newUri = p.getURI();
                this.setSelectionStart(lineStart + uri0);
                this.setSelectionEnd(lineStart + uri1);
                this.replaceSelection(newUri);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(EditorTextPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void plot(String doThis) {
        block33: {
            EditorAnnotationsSupport.ExpressionLookup l = EditorAnnotationsSupport.getExpressionLookup();
            if (l == null) {
                throw new IllegalArgumentException("No interpreter available to evaluate expression");
            }
            try {
                PyObject po = l.lookup(doThis);
                if (po instanceof PyQDataSet) {
                    try {
                        PyQDataSet pds = (PyQDataSet)po;
                        File tmpDir = File.createTempFile("autoplot", ".qds").getParentFile();
                        File tmpfile = new File(tmpDir, "autoplot.qds");
                        String cmd = "plot( 'file:" + tmpfile.toString() + "' );";
                        ArrayDataSet mpds = ArrayDataSet.copy((QDataSet)pds.getQDataSet());
                        String oldTitle = (String)mpds.property("TITLE");
                        mpds.putProperty("TITLE", (Object)(oldTitle == null ? doThis : doThis + ": " + oldTitle));
                        try (FileOutputStream fout = new FileOutputStream(tmpfile);){
                            new SimpleStreamFormatter().format((QDataSet)mpds, (OutputStream)fout, true);
                        }
                        Socket s = new Socket("localhost", 12345);
                        try (OutputStream out = s.getOutputStream();){
                            out.write("plot(None)\n".getBytes());
                            out.write((cmd + "\n").getBytes());
                            break block33;
                        }
                    }
                    catch (StreamException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (IOException ex) {
                        if (ex instanceof ConnectException) {
                            JOptionPane.showMessageDialog(this, "<html>Unable to connect to socket 12345.<br>Start a second Autoplot and<br>enable the Server feature using<br>[Menubar]&rarr;Options&rarr;Enable Feature&rarr;Server</html>");
                            return;
                        }
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    break block33;
                }
                JOptionPane.showMessageDialog(this, "Selected item is not a dataset");
            }
            catch (HeadlessException e) {
                JOptionPane.showMessageDialog(this, "Selected item caused exception: " + e.toString());
            }
        }
    }

    void plotSoon(final String doThis) {
        EditorAnnotationsSupport.ExpressionLookup l = EditorAnnotationsSupport.getExpressionLookup();
        if (l == null) {
            throw new IllegalArgumentException("Session is not running.  There must be an active debugger to plot variables.");
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                EditorTextPane.this.plot(doThis);
            }
        };
        new Thread(run, "plotExpression").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFileToString(File f) throws FileNotFoundException, IOException {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader r = null;){
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String s = r.readLine();
            while (s != null) {
                buf.append(s).append("\n");
                s = r.readLine();
            }
        }
        return buf.toString();
    }

    public void loadFile(File f) throws FileNotFoundException, IOException {
        try {
            final String s = EditorTextPane.loadFileToString(f);
            if (this.initialized) {
                Document d = this.getDocument();
                d.remove(0, d.getLength());
                d.insertString(0, s, null);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document d = EditorTextPane.this.getDocument();
                            d.remove(0, d.getLength());
                            d.insertString(0, s, null);
                        }
                        catch (BadLocationException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                });
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] jumpToList() {
        ArrayList<String> jumpToList = new ArrayList<String>();
        jumpToList.add("1:top");
        try {
            Document d = this.getDocument();
            String s = d.getText(0, d.getLength());
            LineNumberReader reader = new LineNumberReader(new StringReader(s));
            String line = "";
            int length = -1;
            try {
                while (line != null) {
                    int i;
                    if (line.trim().startsWith("def ") && line.contains("(")) {
                        i = line.indexOf("(");
                        jumpToList.add(reader.getLineNumber() + ":" + line.substring(0, i));
                    } else if (line.startsWith("class ") && line.contains(":")) {
                        i = line.indexOf("(");
                        if (i > -1) {
                            jumpToList.add(reader.getLineNumber() + ":" + line.substring(0, i));
                        } else {
                            jumpToList.add(reader.getLineNumber() + ":" + line);
                        }
                    }
                    length = reader.getLineNumber() + 1;
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
            jumpToList.add(String.format(Locale.US, "%d:bottom", length));
            return jumpToList.toArray(new String[jumpToList.size()]);
        }
        catch (IOException ex) {
            return jumpToList.toArray(new String[jumpToList.size()]);
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return jumpToList.toArray(new String[jumpToList.size()]);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }
}

