/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.WindowManager;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.Param;
import org.autoplot.jythonsupport.Util;
import org.autoplot.jythonsupport.ui.JLinkyLabel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.ColorUtil;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.util.PythonInterpreter;

public class ParametersFormPanel {
    FormData fd = new FormData();
    Map<String, String> params;
    private static final Logger logger = LoggerManager.getLogger((String)"jython.form");

    private static boolean isBoolean(List<Object> parms) {
        return parms.size() == 2 && (parms.contains("T") && parms.contains("F") || parms.contains(0) && parms.contains(1));
    }

    private static JComponent getSpacer() {
        JLabel spacer = new JLabel("  ");
        spacer.setSize(new Dimension(20, 16));
        spacer.setMinimumSize(new Dimension(20, 16));
        spacer.setPreferredSize(new Dimension(20, 16));
        return spacer;
    }

    private static boolean appearsToBeUrl(String s) {
        return (s = s.trim()).startsWith("vap+") || s.startsWith("file:") || s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:") || s.startsWith("sftp:");
    }

    public static void resetVariables(FormData fd, Map<String, String> params) {
        block8: for (int j = 0; j < fd.paramsList.size(); ++j) {
            String value;
            String name = fd.paramsList.get(j);
            JComponent jc = fd.tflist.get(j);
            if (jc instanceof JTextField) {
                value = ((JTextField)jc).getText();
            } else if (jc instanceof DataSetSelector) {
                value = ((DataSetSelector)jc).getValue();
            } else if (jc instanceof JComboBox) {
                int i;
                value = String.valueOf(((JComboBox)jc).getSelectedItem());
                if (jc instanceof RecentComboBox) {
                    ((RecentComboBox)jc).addToRecent(value);
                }
                if ((i = value.indexOf(58)) > -1) {
                    if (ParametersFormPanel.appearsToBeUrl(value)) {
                        value = value.trim();
                    } else {
                        switch (fd.typesList.get(j).charValue()) {
                            case 'T': {
                                value = value.trim();
                                break;
                            }
                            case 'A': {
                                if (fd.deftsList.get(j).contains(":")) {
                                    value = value.trim();
                                    break;
                                }
                                value = value.substring(0, i).trim();
                                break;
                            }
                            default: {
                                value = value.substring(0, i).trim();
                            }
                        }
                    }
                }
            } else if (jc instanceof JCheckBox) {
                value = ((JCheckBox)jc).isSelected() ? "T" : "F";
            } else {
                throw new IllegalArgumentException("the code needs attention: component for " + name + " not supported ");
            }
            String deft = fd.deftsList.get(j);
            char type = fd.typesList.get(j).charValue();
            if (type == 'F') {
                if (value.equals("F")) {
                    value = "False";
                } else if (value.equals("T")) {
                    value = "True";
                }
            }
            if (value.equals(deft) && !params.containsKey(name) && !name.equals("timerange")) continue;
            switch (type) {
                case 'A': {
                    value = value.replaceAll("'", "");
                    if (!value.startsWith("'") || !value.endsWith("'")) {
                        value = "'" + value + "'";
                    }
                    params.put(name, value);
                    continue block8;
                }
                case 'L': 
                case 'R': {
                    if (!value.startsWith("'") || !value.endsWith("'")) {
                        value = "'" + value + "'";
                    }
                    params.put(name, value);
                    continue block8;
                }
                default: {
                    params.put(name, value);
                }
            }
        }
    }

    public FormData doVariables(Map<String, Object> env, File f, Map<String, String> params, JPanel paramsPanel) throws IOException {
        String src = FileUtil.readFileToString((File)f);
        return this.doVariables(env, src, params, paramsPanel);
    }

    public void redoVariables(Map<String, Object> env, String src, Map<String, String> params, JPanel paramsPanel) {
        paramsPanel.removeAll();
        ParametersFormPanel.resetVariables(this.fd, params);
        this.doVariables(env, src, params, paramsPanel);
        paramsPanel.revalidate();
        paramsPanel.repaint();
    }

    private JComponent getSpacer(int size) {
        JLabel spacer = new JLabel(" ");
        spacer.setSize(new Dimension(size, 16));
        spacer.setMinimumSize(new Dimension(size, 16));
        spacer.setPreferredSize(new Dimension(size, 16));
        return spacer;
    }

    public FormData doVariables(String src, Map<String, String> params, JPanel zparamsPanel) {
        return this.doVariables(null, src, params, zparamsPanel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormData doVariables(Map<String, Object> env, String src, Map<String, String> params, JPanel zparamsPanel) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        this.params = new HashMap<String, String>(params);
        logger.entering("ParametersFormPanel", "doVariables", new Object[]{env, src, params});
        this.fd.tflist = new ArrayList();
        this.fd.paramsList = new ArrayList();
        this.fd.deftsList = new ArrayList();
        this.fd.deftObjectList = new ArrayList();
        this.fd.typesList = new ArrayList();
        JScrollPane jp = new JScrollPane();
        if (zparamsPanel != null) {
            zparamsPanel.add(jp);
        }
        JPanel paramsPanel = new JPanel();
        jp.getViewport().add(paramsPanel);
        paramsPanel.setLayout(new BoxLayout(paramsPanel, 1));
        try {
            boolean hasVars;
            JythonUtil.ScriptDescriptor sd = JythonUtil.describeScript(env, src, params);
            List<Param> parms = sd.getParams();
            boolean hasMeta = false;
            if (sd.getTitle().length() > 0) {
                paramsPanel.add(new JLabel("<html><H2>" + sd.getTitle() + "</H2></html>"));
                hasMeta = true;
            }
            if (sd.getDescription().length() > 0) {
                Iterator<Param> opwd = env.get("PWD");
                URL context = null;
                if (opwd != null) {
                    context = new URL(String.valueOf(opwd));
                }
                paramsPanel.add(new JLinkyLabel(context, "<html><div width=600>" + sd.getDescription() + "</div></html>"));
                hasMeta = true;
            }
            if (!hasMeta) {
                paramsPanel.add(new JLabel("<html>This script has the following input parameters.  Buttons on the right show default values.<br><br></html>"));
            } else {
                paramsPanel.add(new JLabel("<html><br><br></html>"));
            }
            for (Param parm : parms) {
                String fdeft;
                JComponent ctf;
                String label;
                String colon;
                boolean isBool;
                String vname = parm.name;
                if (parm.enums != null && parm.deft.getClass() != parm.enums.get(0).getClass()) {
                    logger.warning("type of enumeration doesn't match default value.");
                }
                boolean hasLabels = parm.constraints != null && parm.constraints.containsKey("labels");
                boolean bl = isBool = parm.enums != null && ParametersFormPanel.isBoolean(parm.enums) && !hasLabels;
                if (parm.enums != null) {
                    boolean okay = false;
                    if (!Py.java2py((Object)parm.enums.get(0)).getClass().isAssignableFrom(Py.java2py((Object)parm.deft).getClass())) {
                        logger.log(Level.WARNING, "parameter enumeration does not match type of default (" + parm.enums.get(0).getClass() + ") for \"{0}\"", vname);
                    } else {
                        for (Object o : parm.enums) {
                            if (!parm.deft.equals(o)) continue;
                            okay = true;
                        }
                        if (!okay) {
                            logger.log(Level.WARNING, "parameter enumeration does not contain the default for \"{0}\"", vname);
                        }
                    }
                }
                String string = colon = isBool ? "" : ":";
                if (parm.doc == null) {
                    label = vname + colon;
                } else {
                    String doc = parm.doc;
                    if (doc.startsWith("'")) {
                        doc = doc.substring(1, doc.length() - 1);
                    }
                    if (!parm.label.equals(parm.name)) {
                        doc = doc + " (" + parm.label + " inside the script)";
                    }
                    label = doc.length() > 0 ? "<html>" + parm.name + ", <i>" + doc + "</i>" + colon + "</html>" : "<html>" + parm.name + colon + "</html>";
                }
                if (!isBool) {
                    JPanel labelPanel = new JPanel();
                    labelPanel.setLayout(new BoxLayout(labelPanel, 0));
                    JLabel l = new JLabel(label);
                    labelPanel.add(ParametersFormPanel.getSpacer());
                    labelPanel.add(l);
                    labelPanel.setAlignmentX(0.0f);
                    paramsPanel.add(labelPanel);
                } else {
                    paramsPanel.add(Box.createVerticalStrut(paramsPanel.getFont().getSize() / 2));
                }
                JPanel valuePanel = new JPanel();
                valuePanel.setLayout(new BoxLayout(valuePanel, 0));
                if (!isBool) {
                    valuePanel.add(ParametersFormPanel.getSpacer());
                }
                List<Object> values = parm.examples != null ? parm.examples : parm.enums;
                int type = parm.type;
                if (type == 83 && UnitsUtil.isTimeLocation((Units)((DatumRange)parm.deft).getUnits())) {
                    type = 84;
                }
                switch (type) {
                    case 85: {
                        String val;
                        DataSetSelector sel = new DataSetSelector();
                        sel.setPlotItButtonVisible(false);
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (val.startsWith("'")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("'")) {
                                val = val.substring(0, val.length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, val);
                        }
                        sel.setRecent(DataSetSelector.getDefaultRecent());
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(7));
                        valuePanel.add((Component)sel);
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(10));
                        ctf = sel;
                        break;
                    }
                    case 76: 
                    case 82: {
                        String val;
                        DataSetSelector sel = new DataSetSelector();
                        sel.setPlotItButtonVisible(false);
                        sel.setSuggestFiles(true);
                        sel.setSuggestFsAgg(false);
                        sel.setDisableDataSources(true);
                        String surl = parm.deft.toString();
                        int i = surl.lastIndexOf(".");
                        int j = surl.lastIndexOf("/");
                        if (i > j) {
                            String ext = surl.substring(i);
                            sel.setAcceptPattern(".*\\" + ext);
                        }
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (val.startsWith("'")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("'")) {
                                val = val.substring(0, val.length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, val);
                        }
                        sel.setRecent(DataSetSelector.getDefaultRecent());
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(7));
                        valuePanel.add((Component)sel);
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(10));
                        ctf = sel;
                        break;
                    }
                    case 84: {
                        Object val;
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (((String)val).startsWith("'")) {
                                val = ((String)val).substring(1);
                            }
                            if (((String)val).endsWith("'")) {
                                val = ((String)val).substring(0, ((String)val).length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, (String)val);
                        }
                        RecentComboBox tcb = new RecentComboBox();
                        tcb.setPreferenceNode("timerange");
                        if (values != null && !values.isEmpty()) {
                            ArrayList<String> svalues = new ArrayList<String>();
                            for (Object o : values) {
                                svalues.add(String.valueOf(o));
                            }
                            tcb.addAdditionalToRecentItems(svalues);
                        }
                        Dimension x = tcb.getPreferredSize();
                        x.width = Integer.MAX_VALUE;
                        tcb.setMaximumSize(x);
                        tcb.setAlignmentX(0.0f);
                        tcb.setText((String)val);
                        ctf = tcb;
                        ImageIcon fileIcon = new ImageIcon(org.autoplot.jythonsupport.ui.Util.class.getResource("/org/autoplot/datasource/calendar.png"));
                        JButton button = new JButton(fileIcon);
                        button.addActionListener(e -> {
                            TimeRangeTool tt = new TimeRangeTool();
                            tt.setSelectedRange(tcb.getSelectedItem().toString());
                            int r = WindowManager.showConfirmDialog((Component)paramsPanel, (Object)tt, (String)"Select Time Range", (int)2);
                            if (r == 0) {
                                tcb.setSelectedItem((Object)tt.getSelectedRange());
                            }
                        });
                        button.setToolTipText("Time Range Tool");
                        valuePanel.add((Component)tcb);
                        button.setAlignmentX(0.0f);
                        valuePanel.add(button);
                        break;
                    }
                    case 67: {
                        Dimension x;
                        JTextField tf;
                        Dimension x2;
                        JComboBox<Object> jcb;
                        List labelsList;
                        Object olabels;
                        Object[] labels;
                        Object val;
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (((String)val).startsWith("'")) {
                                val = ((String)val).substring(1);
                            }
                            if (((String)val).endsWith("'")) {
                                val = ((String)val).substring(0, ((String)val).length() - 1);
                            }
                        } else {
                            val = ColorUtil.encodeColor((Color)((Color)parm.deft));
                            params.put(vname, (String)val);
                        }
                        if (values != null && !values.isEmpty()) {
                            labels = parm.examples != null ? parm.examples.toArray() : values.toArray();
                            if (hasLabels && (olabels = parm.constraints.get("labels")) instanceof List) {
                                int i;
                                labelsList = (List)olabels;
                                boolean useLabels = false;
                                for (i = 0; i < values.size(); ++i) {
                                    if (String.valueOf(values.get(i)).equals(labelsList.get(i))) continue;
                                    useLabels = true;
                                }
                                labels = new String[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    labels[i] = useLabels ? values.get(i) + ": " + labelsList.get(i) : values.get(i);
                                }
                            }
                            for (int i = 0; i < labels.length; ++i) {
                                labels[i] = ColorUtil.encodeColor((Color)((Color)labels[i]));
                            }
                            jcb = new JComboBox<Object>(labels);
                            jcb.setEditable(false);
                            int index = values.indexOf(ColorUtil.decodeColor((String)val));
                            if (index > -1) {
                                jcb.setSelectedIndex(index);
                            } else {
                                jcb.setSelectedItem(val);
                            }
                            if (!jcb.getSelectedItem().toString().startsWith((String)val)) {
                                logger.fine("uh-oh.");
                            }
                            ctf = jcb;
                            jcb.addActionListener(e -> this.redoVariables(env, src, this.params, zparamsPanel));
                            x2 = ctf.getPreferredSize();
                            x2.width = Integer.MAX_VALUE;
                            ctf.setMaximumSize(x2);
                            ctf.setAlignmentX(0.0f);
                        } else {
                            tf = new JTextField();
                            x = tf.getPreferredSize();
                            x.width = Integer.MAX_VALUE;
                            tf.setMaximumSize(x);
                            tf.setAlignmentX(0.0f);
                            tf.setText((String)val);
                            ctf = tf;
                        }
                        JTextField fjcf = ctf;
                        valuePanel.add(ctf);
                        if (values != null && !values.isEmpty()) break;
                        ImageIcon fileIcon = new ImageIcon(org.autoplot.jythonsupport.ui.Util.class.getResource("/org/autoplot/datasource/calendar.png"));
                        JButton button = new JButton(fileIcon);
                        button.addActionListener(e -> {
                            Color c;
                            String t = fjcf instanceof JComboBox ? (String)((JComboBox)((Object)fjcf)).getSelectedItem() : ((JTextField)fjcf).getText();
                            try {
                                c = ColorUtil.decodeColor((String)t);
                            }
                            catch (IllegalArgumentException ex) {
                                c = Color.GRAY;
                            }
                            c = JColorChooser.showDialog(paramsPanel, "color", c);
                            if (c != null) {
                                if (fjcf instanceof JComboBox) {
                                    ((JComboBox)((Object)fjcf)).setSelectedItem(ColorUtil.encodeColor((Color)c));
                                } else {
                                    ((JTextField)fjcf).setText(ColorUtil.encodeColor((Color)c));
                                }
                            }
                        });
                        button.setToolTipText("Colorpicker");
                        button.setAlignmentX(0.0f);
                        valuePanel.add(button);
                        break;
                    }
                    default: {
                        FileFilter filt;
                        Dimension x;
                        JTextField tf;
                        Dimension x2;
                        JComboBox<Object> jcb;
                        List labelsList;
                        Object olabels;
                        Object[] labels;
                        Object val;
                        Object oval = params.get(vname);
                        if (oval != null) {
                            if (!(oval instanceof String)) throw new IllegalArgumentException("param should be a string: " + vname);
                            val = oval;
                            if (((String)val).startsWith("'")) {
                                val = ((String)val).substring(1);
                            }
                            if (((String)val).endsWith("'")) {
                                val = ((String)val).substring(0, ((String)val).length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, (String)val);
                        }
                        if (values != null && !values.isEmpty()) {
                            if (isBool) {
                                JCheckBox jcb2 = new JCheckBox(label);
                                jcb2.setSelected(((String)val).equals("T") || ((String)val).equals("1") || ((String)val).equals("True"));
                                jcb2.addActionListener(e -> this.redoVariables(env, src, this.params, zparamsPanel));
                                ctf = jcb2;
                            } else {
                                labels = values.toArray();
                                if (hasLabels && (olabels = parm.constraints.get("labels")) instanceof List) {
                                    int i;
                                    labelsList = (List)olabels;
                                    boolean useLabels = false;
                                    for (i = 0; i < values.size(); ++i) {
                                        if (String.valueOf(values.get(i)).equals(labelsList.get(i))) continue;
                                        useLabels = true;
                                    }
                                    labels = new String[values.size()];
                                    for (i = 0; i < values.size(); ++i) {
                                        labels[i] = useLabels ? values.get(i) + ": " + labelsList.get(i) : String.valueOf(values.get(i));
                                    }
                                }
                                jcb = new JComboBox<Object>(labels);
                                if (parm.examples == null || parm.examples.isEmpty()) {
                                    jcb.setEditable(false);
                                } else {
                                    jcb.setEditable(true);
                                }
                                oval = parm.deft instanceof Long ? Long.valueOf((String)val) : (parm.deft instanceof Integer ? Integer.valueOf((String)val) : (parm.deft instanceof Double ? Double.valueOf((String)val) : (parm.deft instanceof Float ? Float.valueOf((String)val) : val)));
                                int index = values.indexOf(oval);
                                if (index > -1) {
                                    jcb.setSelectedIndex(index);
                                } else {
                                    jcb.setSelectedItem(oval);
                                }
                                if (parm.examples == null && !jcb.getSelectedItem().toString().startsWith(oval.toString())) {
                                    logger.fine("uh-oh.");
                                }
                                ctf = jcb;
                                jcb.addActionListener(e -> this.redoVariables(env, src, this.params, zparamsPanel));
                                x2 = ctf.getPreferredSize();
                                x2.width = Integer.MAX_VALUE;
                                ctf.setMaximumSize(x2);
                                ctf.setAlignmentX(0.0f);
                            }
                        } else {
                            tf = new JTextField();
                            x = tf.getPreferredSize();
                            x.width = Integer.MAX_VALUE;
                            tf.setMaximumSize(x);
                            tf.setAlignmentX(0.0f);
                            tf.setText((String)val);
                            ctf = tf;
                        }
                        valuePanel.add(ctf);
                        Map<String, Object> c = parm.constraints;
                        final String stringType = String.valueOf(c.get("stringType"));
                        if (type != 77 && !stringType.equals("file") && !stringType.equals("directory")) break;
                        URL fileUrl = ParametersFormPanel.class.getResource("/resources/file.png");
                        ImageIcon icon = new ImageIcon(fileUrl);
                        JButton b = new JButton(icon);
                        if (c.containsKey("regex")) {
                            final String regex = c.get("regex").toString();
                            final Pattern p = Pattern.compile(regex);
                            filt = new FileFilter(){

                                @Override
                                public boolean accept(File f) {
                                    return p.matcher(f.getPath()).matches();
                                }

                                @Override
                                public String getDescription() {
                                    if (stringType.equals("file")) {
                                        return "Files matching " + regex;
                                    }
                                    return "Directories matching " + regex;
                                }
                            };
                        } else {
                            filt = null;
                        }
                        b.addActionListener(e -> {
                            JFileChooser c1 = new JFileChooser();
                            if (filt != null) {
                                c1.addChoosableFileFilter(filt);
                            }
                            if (stringType.equals("directory")) {
                                c1.setFileSelectionMode(1);
                            }
                            c1.setSelectedFile(new File(((JTextField)ctf).getText()));
                            if (c1.showOpenDialog((JTextField)ctf) == 0) {
                                ((JTextField)ctf).setText(c1.getSelectedFile().toString());
                            }
                        });
                        valuePanel.add(b);
                        break;
                    }
                }
                boolean shortLabel = parm.type == 'R' || String.valueOf(parm.deft).length() > 22;
                String string2 = fdeft = shortLabel ? "default" : String.valueOf(parm.deft);
                final String fvalue = isBool && parm.deft instanceof Integer ? (parm.deft.equals(0) ? "F" : "T") : String.valueOf(parm.deft);
                final JComponent ftf = ctf;
                JButton defaultButton = new JButton(new AbstractAction(isBool ? fvalue : fdeft){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ftf instanceof DataSetSelector) {
                            ((DataSetSelector)ftf).setValue(fvalue);
                        } else if (ftf instanceof JComboBox) {
                            JComboBox jcb = (JComboBox)ftf;
                            for (int i = 0; i < jcb.getItemCount(); ++i) {
                                String item = jcb.getItemAt(i).toString();
                                if (item.contains(":")) {
                                    if (!item.startsWith(fvalue + ":")) continue;
                                    jcb.setSelectedIndex(i);
                                    continue;
                                }
                                if (!fvalue.equals(jcb.getItemAt(i).toString())) continue;
                                jcb.setSelectedIndex(i);
                            }
                        } else if (ftf instanceof JCheckBox) {
                            ((JCheckBox)ftf).setSelected(fvalue.startsWith("T"));
                        } else {
                            ((JTextField)ftf).setText(fvalue);
                        }
                    }
                });
                defaultButton.setToolTipText(shortLabel ? String.valueOf(parm.deft) : "Click to reset to default");
                valuePanel.add(defaultButton);
                valuePanel.add(ParametersFormPanel.getSpacer());
                valuePanel.setAlignmentX(0.0f);
                paramsPanel.add(valuePanel);
                this.fd.tflist.add(ctf);
                this.fd.paramsList.add(parm.name);
                if (parm.type == 'C') {
                    this.fd.deftsList.add(ColorUtil.encodeColor((Color)((Color)parm.deft)));
                } else {
                    this.fd.deftsList.add(String.valueOf(parm.deft));
                }
                this.fd.deftObjectList.add(parm.deft);
                this.fd.typesList.add(Character.valueOf(parm.type));
            }
            boolean bl = hasVars = parms.size() > 0;
            if (!hasVars) {
                JLabel l = new JLabel("<html><i>(no input parameters)</i></html>");
                l.setToolTipText("This looks through the code for getParam calls, and no conforming calls were found");
                paramsPanel.add(l);
            }
            paramsPanel.add(Box.createVerticalStrut(paramsPanel.getFont().getSize() * 2));
            paramsPanel.revalidate();
            this.fd.count = this.fd.paramsList.size();
            return this.fd;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return this.fd;
    }

    public FormData getFormData() {
        return this.fd;
    }

    public static class FormData {
        ArrayList<JComponent> tflist;
        ArrayList<String> paramsList;
        ArrayList<String> deftsList;
        ArrayList<Object> deftObjectList;
        ArrayList<Character> typesList;
        public int count;

        public void implement(PythonInterpreter interp, String param, String value) throws ParseException {
            PyDictionary paramsDictionary = (PyDictionary)interp.get("params");
            for (int i = 0; i < this.paramsList.size(); ++i) {
                if (!this.paramsList.get(i).equals(param)) continue;
                Object deft = this.deftObjectList.get(i);
                Character type = this.typesList.get(i);
                if (type.equals(Character.valueOf('T')) && value.length() > 1 && value.charAt(0) != '\'' && value.charAt(value.length() - 1) != '\'') {
                    paramsDictionary.__setitem__(param, Py.java2py((Object)value));
                } else if (type.equals(Character.valueOf('D'))) {
                    paramsDictionary.__setitem__(param, Py.java2py((Object)((Datum)deft).getUnits().parse(value)));
                } else if (type.equals(Character.valueOf('S'))) {
                    paramsDictionary.__setitem__(param, Py.java2py((Object)DatumRangeUtil.parseDatumRange((String)value, (DatumRange)((DatumRange)deft))));
                } else if (type.equals(Character.valueOf('U'))) {
                    try {
                        paramsDictionary.__setitem__(param, Py.java2py((Object)new URI(value)));
                    }
                    catch (URISyntaxException ex) {
                        throw new ParseException("URI is not formed properly", 0);
                    }
                } else if (type.equals(Character.valueOf('L'))) {
                    try {
                        paramsDictionary.__setitem__(param, Py.java2py((Object)new URL(value)));
                    }
                    catch (MalformedURLException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                } else if (type.equals(Character.valueOf('M'))) {
                    paramsDictionary.__setitem__(param, Py.java2py((Object)new File(value)));
                } else if (type.equals(Character.valueOf('A'))) {
                    value = Util.popString(value);
                    paramsDictionary.__setitem__(param, Py.java2py((Object)value));
                } else if (type.equals(Character.valueOf('R'))) {
                    value = Util.popString(value);
                    try {
                        paramsDictionary.__setitem__(param, Py.java2py((Object)new URI(value)));
                    }
                    catch (URISyntaxException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                } else if (type.equals(Character.valueOf('C'))) {
                    value = Util.popString(value);
                    paramsDictionary.__setitem__(param, Py.java2py((Object)ColorUtil.decodeColor((String)value)));
                } else {
                    interp.exec(String.format("params['%s']=%s", param, value));
                }
                return;
            }
            logger.log(Level.WARNING, "unable to find variable ''{0}''", param);
        }
    }
}

