/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.autoplot.jythonsupport.DatasetCommand;
import org.autoplot.jythonsupport.GetDataSetCommand;
import org.autoplot.jythonsupport.GetDataSetsCommand;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.JythonToJavaConverter;
import org.autoplot.jythonsupport.SimplifyScriptSupport;
import org.autoplot.jythonsupport.Util;
import org.das2.graph.GraphUtil;
import org.das2.jythoncompletion.ClassImportCompletionItem;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.CompletionSupport;
import org.das2.jythoncompletion.DataSetUrlCompletionTask;
import org.das2.jythoncompletion.DefaultCompletionItem;
import org.das2.jythoncompletion.JavadocLookup;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.MessageCompletionItem;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.python.core.PyArray;
import org.python.core.PyClass;
import org.python.core.PyClassPeeker;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaClassPeeker;
import org.python.core.PyJavaInstance;
import org.python.core.PyJavaInstancePeeker;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyMethodPeeker;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedField;
import org.python.core.PyReflectedFunction;
import org.python.core.PyReflectedFunctionPeeker;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTableCode;
import org.python.util.PythonInterpreter;

public class JythonCompletionTask
implements CompletionTask {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.editor.completion");
    private static final ImageIcon LOCALVARICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/localVariable.png"));
    private static final ImageIcon JAVA_CLASS_ICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/javaClass.png"));
    private static final ImageIcon JYTHONCOMMANDICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/jythonCommand.png"));
    private static final ImageIcon JAVA_JYTHON_METHOD_ICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/javaJythonMethod.png"));
    private static final ImageIcon JAVA_FIELD_ICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/javaStaticField.png"));
    private static final ImageIcon JAVA_METHOD_ICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/javaMethod.png"));
    private static final ImageIcon JAVA_STATIC_METHOD_ICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/javaStaticMethod.png"));
    private static final ImageIcon JAVA_CONSTRUCTOR_ICON = new ImageIcon(JythonCompletionTask.class.getResource("ui/javaConstructor.png"));
    private static final int JYTHONCOMMAND_SORT = 2;
    private static final int JAVAMETHOD_SORT = 1;
    private static final int JAVACLASS_SORT = 1;
    private static final int PYREFLECTEDFIELD_SORT = 3;
    private static final int PYCLASS_SORT = 3;
    private static final int LOCALVAR_SORT = -10;
    private static final int AUTOVAR_SORT = -3;
    private static final int AUTOCOMMAND_SORT = -2;
    private static final int AUTOVARHIDE_SORT = 9;
    private static final int JAVASTATICFIELD_SORT = 1;
    public static final String CLIENT_PROPERTY_INTERPRETER_PROVIDER = "JYTHON_INTERPRETER_PROVIDER";
    public static final String CLIENT_PROPERTY_PWD = "JYTHON_INTERPRETER_PWD";
    JTextComponent editor;
    private final JythonInterpreterProvider jythonInterpreterProvider;
    public static final String __CLASSTYPE = "__CLASSTYPE";

    public JythonCompletionTask(JTextComponent t) {
        this.editor = t;
        this.jythonInterpreterProvider = (JythonInterpreterProvider)t.getClientProperty(CLIENT_PROPERTY_INTERPRETER_PROVIDER);
    }

    private Method getReadMethod(PyObject context, PyObject po, Class dc, String propName) {
        try {
            String methodName = "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Method m = dc.getMethod(methodName, new Class[0]);
            return m;
        }
        catch (NoSuchMethodException ex) {
            if (po instanceof PyInteger) {
                String methodName = "is" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                try {
                    Method m = dc.getMethod(methodName, new Class[0]);
                    return m;
                }
                catch (NoSuchMethodException | SecurityException ex2) {
                    return null;
                }
            }
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public void query(CompletionResultSet arg0) throws PyException {
        try {
            JythonCompletionProvider.getInstance().setMessage("busy: getting completions");
            CompletionContext cc = CompletionSupport.getCompletionContext(this.editor);
            if (cc == null) {
                logger.fine("no completion context");
            } else {
                this.doQuery(cc, arg0);
            }
        }
        catch (BadLocationException ex) {
            logger.log(Level.WARNING, null, ex);
            arg0.addItem(new MessageCompletionItem(ex.getMessage()));
        }
        finally {
            JythonCompletionProvider.getInstance().setMessage("done getting completions");
            arg0.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doQuery(CompletionContext cc, CompletionResultSet resultSet) {
        int c = 0;
        try {
            switch (cc.contextType) {
                case "module": {
                    c = this.queryModules(cc, resultSet);
                    break;
                }
                case "package": {
                    c = this.queryPackages(cc, resultSet);
                    break;
                }
                case "default": {
                    c = this.queryNames(cc, resultSet);
                    break;
                }
                case "method": {
                    c = this.queryMethods(cc, resultSet);
                    break;
                }
                case "stringLiteralArgument": {
                    c = this.queryStringLiteralArgument(cc, resultSet);
                    break;
                }
                case "commandArgument": {
                    c = this.queryCommandArgument(cc, resultSet);
                    c += this.queryNames(cc, resultSet);
                    break;
                }
                case "classMethod": {
                    c = this.queryClassMethods(cc, resultSet);
                    break;
                }
            }
        }
        catch (BadLocationException ex) {
            logger.log(Level.WARNING, null, ex);
            if (resultSet != null) {
                resultSet.addItem(new MessageCompletionItem(ex.getMessage()));
            }
        }
        return c;
    }

    private Method getJavaMethod(PyMethod m, int i) {
        PyMethodPeeker mpeek = new PyMethodPeeker(m);
        return new PyReflectedFunctionPeeker(mpeek.getReflectedFunction()).getMethod(i);
    }

    private int getMethodCount(PyMethod m) {
        PyMethodPeeker mpeek = new PyMethodPeeker(m);
        return new PyReflectedFunctionPeeker(mpeek.getReflectedFunction()).getArgsCount();
    }

    private int queryClassMethods(CompletionContext cc, CompletionResultSet rs) {
        int count = 0;
        for (Class c = cc.getContextObjectClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            Method[] mm;
            for (Method m : mm = c.getDeclaredMethods()) {
                if (!m.getName().startsWith(cc.completable)) continue;
                String signature = JythonCompletionTask.methodSignature(m);
                String args = JythonCompletionTask.methodArgs(m);
                String ss = m.getName();
                String label = ss + args;
                String link = JythonCompletionTask.getLinkForJavaSignature(signature);
                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link));
                ++count;
            }
        }
        return count;
    }

    private List<String> reduceGetterSetters(PyObject lcontext, PyList po2, boolean cullGetterSetters) {
        LinkedHashMap<String, String> mm = new LinkedHashMap<String, String>();
        for (int i = 0; i < po2.__len__(); ++i) {
            PyString s = (PyString)po2.__getitem__(i);
            mm.put(s.toString(), s.toString());
        }
        if (cullGetterSetters) {
            ArrayList ss = new ArrayList(mm.keySet());
            for (String s : ss) {
                String propName;
                String prop;
                if (!s.startsWith("set") || (prop = s.substring(3)).length() == 0) continue;
                if (mm.get("get" + prop) != null) {
                    propName = Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
                    if (!mm.containsKey(propName)) continue;
                    mm.remove("get" + prop);
                    mm.remove("set" + prop);
                    continue;
                }
                if (mm.get("is" + prop) == null || !mm.containsKey(propName = Character.toLowerCase(prop.charAt(0)) + prop.substring(1))) continue;
                mm.remove("is" + prop);
                mm.remove("set" + prop);
            }
        }
        return new ArrayList<String>(mm.keySet());
    }

    private int queryMethods(CompletionContext cc, CompletionResultSet rs) throws BadLocationException {
        PyList po2;
        boolean fromArray;
        PyJavaClass lcontextClass;
        PyObject lcontext;
        block67: {
            String eval;
            logger.fine("queryMethods");
            PythonInterpreter interp = this.getInterpreter();
            if (JythonCompletionProvider.getInstance().settings().isSafeCompletions()) {
                String eval1;
                eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
                eval = eval1 = SimplifyScriptSupport.removeSideEffects(eval);
            } else {
                eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
            }
            if (eval.endsWith(":\n")) {
                eval = eval + "  pass\n";
            }
            try {
                interp.exec(JythonRefactory.fixImports(eval));
            }
            catch (PyException ex) {
                String eval1;
                eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
                eval = eval1 = SimplifyScriptSupport.removeSideEffects(eval);
                if (eval.endsWith(":\n")) {
                    eval = eval + "  pass\n";
                }
                try {
                    eval = JythonCompletionTask.sanitizeLeaveImports(eval);
                    interp.exec(eval);
                }
                catch (PyException ex2) {
                    rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex2.toString()));
                    return 0;
                }
            }
            catch (IOException ex) {
                rs.addItem(new MessageCompletionItem("Exception occurred: " + ex.toString()));
                return 0;
            }
            lcontext = null;
            lcontextClass = null;
            fromArray = false;
            try {
                lcontext = interp.eval(cc.contextString);
            }
            catch (PyException ex) {
                try {
                    PyArray pa;
                    Object o;
                    Class<?> oc;
                    PyObject occ;
                    int k;
                    if (cc.contextString.endsWith("]") && (k = cc.contextString.lastIndexOf("[")) > -1 && (occ = interp.eval(cc.contextString.substring(0, k))) instanceof PyArray && (oc = (o = (pa = (PyArray)occ).getArray()).getClass()).isArray()) {
                        lcontextClass = PyJavaClass.lookup(oc.getComponentType());
                        try {
                            lcontext = new PyJavaInstance(oc.getComponentType().getDeclaredConstructors()[0].newInstance(new Object[0]));
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex1) {
                            Logger.getLogger(JythonCompletionTask.class.getName()).log(Level.SEVERE, null, ex1);
                        }
                        fromArray = true;
                    }
                    if (lcontextClass != null) break block67;
                    PyObject occ2 = interp.eval(cc.contextString + __CLASSTYPE);
                    if (occ2 != null && occ2 instanceof PyJavaClass) {
                        lcontextClass = (PyJavaClass)occ2;
                    }
                    rs.addItem(new MessageCompletionItem("EVAL error: " + cc.contextString, ex.toString()));
                    return 0;
                }
                catch (PyException ex2) {
                    rs.addItem(new MessageCompletionItem("Eval error: " + cc.contextString, ex.toString()));
                    return 0;
                }
            }
        }
        if (lcontext == null) {
            logger.log(Level.FINE, "completions have the class but not the instance to work with: {0}", lcontextClass.__name__);
            lcontext = lcontextClass;
        }
        try {
            po2 = (PyList)lcontext.__dir__();
        }
        catch (PyException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return 0;
        }
        List<String> po3 = this.reduceGetterSetters(lcontext, po2, fromArray || lcontext != lcontextClass);
        int count = 0;
        for (int i = 0; i < po3.size(); ++i) {
            ImageIcon icon;
            String args;
            String signature;
            String label;
            boolean notAlreadyAdded;
            String ss;
            block68: {
                Class dc;
                Object peek;
                Object m;
                PyObject po;
                ss = po3.get(i);
                logger.log(Level.FINEST, "does {0} start {1}", new Object[]{cc.completable, ss});
                if (!ss.startsWith(cc.completable)) continue;
                notAlreadyAdded = true;
                try {
                    po = lcontext.__getattr__(ss);
                }
                catch (PyException e) {
                    logger.log(Level.FINE, "PyException from \"{0}\":", ss);
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                label = ss;
                signature = null;
                args = "";
                icon = null;
                if (lcontext instanceof PyJavaClass) {
                    if (po.getClass().toString().equals("class org.python.core.PyReflectedConstructor")) {
                        args = "()";
                        signature = "";
                    } else if (po instanceof PyReflectedFunction) {
                        m = new PyReflectedFunctionPeeker((PyReflectedFunction)po).getMethod(0);
                        if (Modifier.isStatic(((Method)m).getModifiers())) {
                            signature = JythonCompletionTask.methodSignature((Method)m);
                            icon = JythonCompletionTask.getIconFor(m);
                            args = JythonCompletionTask.methodArgs((Method)m);
                        } else {
                            if (lcontext != lcontextClass) continue;
                            signature = JythonCompletionTask.methodSignature((Method)m);
                            icon = JythonCompletionTask.getIconFor(m);
                            args = JythonCompletionTask.methodArgs((Method)m);
                        }
                    } else if (po instanceof PyString || po instanceof PyInteger || po instanceof PyJavaInstance) {
                        Class c = new PyClassPeeker((PyClass)((PyJavaClass)lcontext)).getJavaClass();
                        try {
                            Field f = c.getField(ss);
                            signature = this.fieldSignature(f);
                            icon = JythonCompletionTask.getIconFor(f);
                        }
                        catch (NoSuchFieldException f) {}
                    }
                } else if (lcontext instanceof PyJavaPackage) {
                    if (po instanceof PyJavaClass) {
                        Class dc2 = JythonCompletionTask.getJavaClass((PyJavaClass)po);
                        if (dc2.getConstructors().length > 0) {
                            Constructor<?> constructor = dc2.getConstructors()[0];
                            signature = this.constructorSignature(constructor);
                            args = JythonCompletionTask.argsList(constructor.getParameterTypes());
                            signature = signature + args;
                        } else {
                            signature = dc2.getCanonicalName().replaceAll("\\.", "/") + ".html";
                        }
                    } else if (po instanceof PyJavaPackage) {
                        // empty if block
                    }
                } else if (lcontext instanceof PyClass) {
                    peek = new PyClassPeeker((PyClass)lcontext);
                    dc = ((PyClassPeeker)peek).getJavaClass();
                    if (dc == null) {
                        logger.fine("unable to identify JavaClass");
                        signature = "" + lcontext.__getattr__(label);
                    } else {
                        Field f = null;
                        try {
                            f = dc.getField(label);
                        }
                        catch (NoSuchFieldException | SecurityException exception) {
                            // empty catch block
                        }
                        if (f == null) continue;
                        signature = this.fieldSignature(f);
                    }
                } else if (lcontext instanceof PyJavaInstance) {
                    if (po instanceof PyMethod) {
                        m = (PyMethod)po;
                        try {
                            for (int im = 0; im < this.getMethodCount((PyMethod)m); ++im) {
                                Method jm = this.getJavaMethod((PyMethod)m, im);
                                signature = JythonCompletionTask.methodSignature(jm);
                                args = JythonCompletionTask.methodArgs(jm);
                                label = ss + args;
                                icon = JythonCompletionTask.getIconFor(jm);
                                String link = JythonCompletionTask.getLinkForJavaSignature(signature);
                                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, 1, icon));
                                ++count;
                                notAlreadyAdded = false;
                            }
                            break block68;
                        }
                        catch (RuntimeException ex) {
                            logger.fine(ex.toString());
                            continue;
                        }
                    }
                    peek = new PyJavaInstancePeeker((PyJavaInstance)lcontext);
                    dc = ((PyJavaInstancePeeker)peek).getInstanceClass();
                    Method propReadMethod = this.getReadMethod(lcontext, po, dc, label);
                    if (propReadMethod != null) {
                        signature = JythonCompletionTask.methodSignature(propReadMethod);
                        args = "";
                        String type = propReadMethod.getReturnType().getCanonicalName();
                        label = ss + " <i>(" + type + ")</i>";
                    } else {
                        Field f = null;
                        try {
                            f = dc.getField(label);
                        }
                        catch (NoSuchFieldException ex) {
                            logger.log(Level.FINEST, "NoSuchFieldException for item {0}", ss);
                        }
                        catch (SecurityException ex) {
                            logger.log(Level.FINEST, "SecurityException for item {0}", ss);
                        }
                        if (f == null) continue;
                        icon = JythonCompletionTask.getIconFor(f);
                        signature = this.fieldSignature(f);
                        boolean showValues = false;
                        label = showValues ? (po instanceof PyInteger ? ss + " = " + po.toString() : (po instanceof PyFloat ? ss + " = " + po.toString() : (po instanceof PyString ? ss + " = " + po.toString() : ss))) : ss;
                    }
                } else {
                    label = ss;
                    signature = null;
                    if (po instanceof PyMethod) {
                        PyObject doc;
                        PyMethod pm = (PyMethod)po;
                        PyObject pm2 = pm.im_func;
                        if (pm2 instanceof PyFunction && (doc = ((PyFunction)pm2).__doc__) != null) {
                            signature = doc instanceof PyNone ? "(No documentation)" : doc.toString();
                            String[] ss2 = signature.split("\n");
                            if (ss2.length > 1) {
                                for (int jj = 0; jj < ss2.length; ++jj) {
                                    ss2[jj] = JythonCompletionTask.escapeHtml(ss2[jj]);
                                }
                                String sig = JythonCompletionTask.getPyFunctionSignature((PyFunction)pm2);
                                signature = !signature.startsWith("<html>") ? "<html><b>" + sig + "</b><br><br>" + JythonCompletionTask.join(ss2, "<br>") + "</html>" : "<html><b>" + sig + "</b><br><br>" + signature.substring(6) + "</html>";
                            }
                            signature = "inline:" + signature;
                        }
                    }
                }
            }
            if (!notAlreadyAdded) continue;
            if (signature != null && signature.startsWith("inline:")) {
                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, signature));
            } else {
                String link = JythonCompletionTask.getLinkForJavaSignature(signature);
                if (icon == null) {
                    rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, 1, null));
                } else {
                    rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, 1, icon));
                }
            }
            ++count;
        }
        return count;
    }

    private int queryModules(CompletionContext cc, CompletionResultSet rs) {
        logger.fine("queryModules");
        PythonInterpreter interp = this.getInterpreter();
        String eval = "targetComponents = '" + cc.contextString + "'.split('.')\nbase = targetComponents[0]\nbaseModule = __import__(base, globals(), locals())\nmodule = baseModule    \nfor component in targetComponents[1:]:\n    module = getattr(module, component)\nlist = dir(module)\nif ( list.count('__name__')>0 ):\n    list.remove('__name__')\nlist.append('*')\nlist";
        try {
            interp.exec(eval);
        }
        catch (PyException ex) {
            if (rs != null) {
                rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
            }
            return 0;
        }
        int count = 0;
        PyList po2 = (PyList)interp.eval("list");
        for (int i = 0; i < po2.__len__(); ++i) {
            String link;
            String signature;
            PyString s = (PyString)po2.__getitem__(i);
            String ss = s.toString();
            if (!ss.startsWith(cc.completable)) continue;
            String javaClass = cc.contextString + "." + ss;
            if (ss.length() > 0 && Character.isUpperCase(ss.charAt(0))) {
                signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + ".html";
                link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
            } else {
                signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + "/package-summary.html";
                link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
            }
            if (link != null) {
                link = link + "#skip.navbar.top";
            }
            if (rs != null) {
                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss, ss, link));
            }
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryPackages(CompletionContext cc, CompletionResultSet rs) {
        logger.fine("queryPackages");
        PythonInterpreter interp = this.getInterpreter();
        HashSet<String> results = new HashSet<String>();
        int count = 0;
        if (cc.completable.equals("import")) {
            if (rs != null) {
                rs.addItem(new DefaultCompletionItem(" ", 0, " ", "space", null));
            }
            return 1;
        }
        if (!cc.contextString.equals(cc.completable)) {
            String eval = "import " + cc.contextString + "\ntargetComponents = '" + cc.contextString + "'.split('.')\nbase = targetComponents[0]\nbaseModule = __import__(base, globals(), locals(), [], -1 )\nmodule = baseModule    \nname= base\nfor component in targetComponents[1:]:\n    name= name + '.' + component\n    baseModule = __import__( name, None, None )\n    module = getattr(module, component)\nlist = dir(module)\nif ( '__name__' in list ): list.remove('__name__')\nlist\n";
            try {
                interp.exec(eval);
            }
            catch (PyException ex) {
                if (rs != null) {
                    rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
                }
                return 0;
            }
            PyList po2 = (PyList)interp.eval("list");
            for (int i = 0; i < po2.__len__(); ++i) {
                String link;
                String signature;
                PyString s = (PyString)po2.__getitem__(i);
                String ss = s.toString();
                if (!ss.startsWith(cc.completable)) continue;
                String javaClass = cc.contextString + "." + ss;
                if (ss.length() > 0 && Character.isUpperCase(ss.charAt(0))) {
                    signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + ".html";
                    link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
                } else {
                    signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + "/package-summary.html";
                    link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
                }
                if (link != null) {
                    link = link + "#skip.navbar.top";
                }
                if (rs != null) {
                    rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss, ss, link));
                }
                ++count;
                results.add(ss);
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(JythonCompletionTask.class.getResourceAsStream("packagelist.txt")));
            String ss = reader.readLine();
            String search = cc.contextString + "." + cc.completable;
            int plen = cc.contextString.length() + 1;
            if (cc.contextString.equals(cc.completable)) {
                search = cc.contextString;
                plen = search.length();
            }
            while (ss != null) {
                if (!ss.startsWith("#") && ss.length() > 0 && ss.startsWith(search) && !results.contains(ss.substring(plen))) {
                    String link = "http://www-pw.physics.uiowa.edu/~jbf/autoplot/javadoc2018/" + ss.replaceAll("\\.", "/") + "/package-summary.html";
                    if (rs != null) {
                        rs.addItem(new DefaultCompletionItem(ss, search.length(), ss, ss, link));
                    }
                    ++count;
                }
                ss = reader.readLine();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
        return count;
    }

    private static String join(String[] list, String delim) {
        return JythonCompletionTask.join(Arrays.asList(list), delim);
    }

    private static String join(List<String> list, String delim) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            result.append(delim).append(list.get(i));
        }
        return result.toString();
    }

    private static String popOffComments(String s) {
        char inString = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            if (inString == '\u0000' && s.charAt(i) == '#') {
                return s.substring(0, i);
            }
            if (s.charAt(i) != '\'' && s.charAt(i) != '\"') continue;
            inString = s.charAt(i) == inString ? (char)'\u0000' : s.charAt(i);
        }
        return s;
    }

    private static String popDoc(String line, BufferedReader read) throws IOException {
        String lin = line.trim();
        if (lin.startsWith("\"") && lin.endsWith("\"")) {
            return line;
        }
        if (lin.startsWith("'") && lin.endsWith("'")) {
            return line;
        }
        if (lin.startsWith("\"\"\"") || lin.startsWith("'''")) {
            String term = lin.substring(0, 3);
            if (lin.endsWith(term)) {
                return line;
            }
            StringBuilder build = new StringBuilder(line);
            build.append("\n");
            line = read.readLine();
            while (line != null) {
                build.append(line).append("\n");
                lin = line.trim();
                if (lin.endsWith(term)) break;
                line = read.readLine();
            }
            if (line == null) {
                throw new IllegalArgumentException("unterminated string");
            }
            return build.toString();
        }
        return null;
    }

    private static String sanitizeLeaveImports(String src) {
        return SimplifyScriptSupport.simplifyScriptToCompletions(src);
    }

    private void putInGetDataSetStub(PythonInterpreter interp) {
        String ss2 = "def getDataSet( st, tr=None, mon=None ):\n   return findgen(100)\n\n";
        logger.finer(ss2);
        interp.exec(ss2);
    }

    public static String getLastLine(String script) {
        int i = script.lastIndexOf("\n");
        if (i == -1) {
            return script;
        }
        String l = script.substring(i + 1);
        String s = l.trim();
        if (s.length() == 0) {
            return "";
        }
        LinkedList<String> lastLine = new LinkedList<String>();
        int i1 = script.indexOf(s, i);
        String indent = script.substring(i + 1, i1);
        lastLine.add(0, l);
        int i2 = script.lastIndexOf("\n", i - 1);
        String l2 = script.substring(i2 + 1, i);
        lastLine.add(0, l2);
        while (l2.startsWith(indent)) {
            i = i2;
            i2 = script.lastIndexOf("\n", i - 1);
            l2 = script.substring(i2 + 1, i);
            lastLine.add(0, l2);
        }
        return String.join((CharSequence)"\n", lastLine);
    }

    public static String trimLinesToMakeValid(String script) {
        return SimplifyScriptSupport.alligatorParse(script);
    }

    private int queryNames(CompletionContext cc, CompletionResultSet rs) throws BadLocationException {
        String[] keywords;
        logger.fine("queryNames");
        int count = 0;
        for (String kw : keywords = new String[]{"def", "elif", "except", "from", "for", "finally", "import", "while", "print", "raise"}) {
            if (!kw.startsWith(cc.completable)) continue;
            if (rs != null) {
                rs.addItem(new DefaultCompletionItem(kw, cc.completable.length(), kw, kw, null, 2, JYTHONCOMMANDICON));
            }
            ++count;
        }
        PythonInterpreter interp = this.getInterpreter();
        int eolnCarot = Utilities.getRowStart(this.editor, this.editor.getCaretPosition());
        String eval = this.editor.getText(0, eolnCarot);
        eval = JythonCompletionTask.trimLinesToMakeValid(eval);
        if (eolnCarot > 0) {
            int startLastLine = Utilities.getRowStart(this.editor, eolnCarot - 1);
            String lastLine = this.editor.getText(startLastLine, eolnCarot - startLastLine);
            Matcher m = Pattern.compile("(\\s*)(\\S+).*(\\s)*").matcher(lastLine);
            if (m.matches()) {
                int i = m.group(1).length();
                String indent = lastLine.substring(0, i);
                eval = !eval.endsWith("\n") ? eval + "\n" + indent + "__dummy__=1\n" : eval + indent + "__dummy__=1\n";
            }
        }
        if (JythonCompletionProvider.getInstance().settings().isSafeCompletions()) {
            try {
                eval = JythonCompletionTask.sanitizeLeaveImports(eval);
            }
            catch (Exception ex) {
                eval = this.editor.getText(0, eolnCarot);
                eval = JythonCompletionTask.trimLinesToMakeValid(eval);
                eval = JythonCompletionTask.sanitizeLeaveImports(eval);
            }
        }
        try {
            interp.exec(JythonRefactory.fixImports(eval));
        }
        catch (PyException ex) {
            String message = "<html><p>Code completions couldn't run on a simplified version of the script.  This may due to a bug in the simplification process, or there may be a bug in the script. The error is shown below, and the simplified script can be reveiwed using Actions&rarr;Developer&rarr;\"Show Simplified Script used for Completions.\"</p><br><hr><code>" + ex.toString() + "</code>";
            if (rs != null) {
                rs.addItem(new MessageCompletionItem("Eval error in code before current position", message));
            }
            int nlocal = JythonCompletionTask.getLocalsCompletions(interp, cc, rs);
            int nimportable = cc.completable.length() > 0 ? JythonCompletionTask.getImportableCompletions(eval, cc, rs) : 0;
            return count + nlocal + nimportable + 1;
        }
        catch (IOException ex) {
            if (rs != null) {
                rs.addItem(new MessageCompletionItem("Error with completions", ex.toString()));
            }
            return 0;
        }
        int nlocal = JythonCompletionTask.getLocalsCompletions(interp, cc, rs);
        int nimportable = cc.completable.length() > 0 ? JythonCompletionTask.getImportableCompletions(eval, cc, rs) : 0;
        return count + nlocal + nimportable;
    }

    private static String argsList(Class[] classes) {
        String LPAREN = "(";
        String RPAREN = ")";
        String SPACE = " ";
        StringBuilder sig = new StringBuilder();
        sig.append(LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class arg : classes) {
            sargs.add(arg.getSimpleName());
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private static String methodArgs(Method javaMethod) {
        return JythonCompletionTask.argsList(javaMethod.getParameterTypes());
    }

    private static String constructorSignatureNew(Constructor c) {
        String n = c.getName();
        String javadocPath = JythonCompletionTask.join(n.split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        String LPAREN = "(";
        String RPAREN = ")";
        String name = c.getName();
        int i = name.lastIndexOf(".");
        if (i > -1) {
            name = name.substring(i + 1);
        }
        sig.append("#").append(name).append(LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class<?> arg : c.getParameterTypes()) {
            sargs.add(arg.getCanonicalName());
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private static String methodSignature(Method javaMethod) {
        String n = javaMethod.getDeclaringClass().getCanonicalName();
        if (n == null) {
            return "<inner>";
        }
        String javadocPath = JythonCompletionTask.join(n.split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        String LPAREN = "(";
        String RPAREN = ")";
        String SPACE = " ";
        sig.append("#").append(javaMethod.getName()).append(LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class<?> arg : javaMethod.getParameterTypes()) {
            sargs.add(arg.getCanonicalName());
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private String fieldSignature(Field f) {
        String javadocPath = JythonCompletionTask.join(f.getDeclaringClass().getCanonicalName().split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        sig.append("#").append(f.getName());
        return sig.toString();
    }

    private String constructorSignature(Constructor f) {
        String javadocPath = JythonCompletionTask.join(f.getDeclaringClass().getCanonicalName().split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        int i = f.getName().lastIndexOf(".");
        sig.append("#").append(f.getName().substring(i + 1));
        return sig.toString();
    }

    private int queryStringLiteralArgument(CompletionContext cc, CompletionResultSet arg0) {
        String method = cc.contextString;
        int[] pos = new int[2];
        Map<String, Object> r = DataSetUrlCompletionTask.popString(this.editor, pos);
        String s = (String)r.get("string");
        String pwd = null;
        if (this.editor != null && (pwd = (String)this.editor.getClientProperty(CLIENT_PROPERTY_PWD)) != null && !pwd.endsWith("/")) {
            pwd = null;
        }
        if (method.equals("getDataSet") || method.equals("getFile") || method.equals("plot") || method.equals("plotx") || method.equals("getCompletions")) {
            DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
            task.query(arg0);
        } else if (method.equals("'resourceURI'")) {
            DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
            task.query(arg0);
        } else if (method.equals("PWD")) {
            if (this.editor != null) {
                if (pwd != null) {
                    DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
                    task.query(arg0);
                }
                return 0;
            }
        } else {
            if (method.startsWith("/") || method.startsWith("http")) {
                DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
                task.query(arg0);
                return 0;
            }
            if (s.startsWith("/") || s.startsWith("http://") || s.startsWith("https://") || s.startsWith("file:/") || s.startsWith("sftp://")) {
                DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
                task.query(arg0);
            }
        }
        return 0;
    }

    private int queryCommandArgument(CompletionContext cc, CompletionResultSet result) throws BadLocationException {
        block14: {
            logger.fine("queryCommandArgument");
            String method = cc.contextString;
            PythonInterpreter interp = this.getInterpreter();
            String eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
            if (JythonCompletionProvider.getInstance().settings().isSafeCompletions()) {
                eval = JythonCompletionTask.sanitizeLeaveImports(eval);
            }
            try {
                interp.exec(eval);
            }
            catch (PyException ex) {
                result.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
                return 0;
            }
            try {
                PyObject completions;
                PyObject po = interp.eval(method);
                PyObject doc = interp.eval(method + ".__doc__");
                try {
                    completions = interp.eval(method + ".__completions__");
                }
                catch (PyException ex) {
                    completions = null;
                }
                if (po instanceof PyFunction) {
                    method = JythonCompletionTask.getPyFunctionSignature((PyFunction)po);
                    String signature = JythonCompletionTask.makeInlineSignature(po, doc);
                    result.addItem(new MessageCompletionItem(method, signature));
                    break block14;
                }
                if (po instanceof PyReflectedFunction) {
                    PyReflectedFunction prf = (PyReflectedFunction)po;
                    ArrayList<String> labels = new ArrayList<String>();
                    ArrayList<String> signatures = new ArrayList<String>();
                    ArrayList<String> argss = new ArrayList<String>();
                    JythonCompletionTask.doPyReflectedFunction(eval, prf, labels, signatures, argss);
                    for (int jj = 0; jj < labels.size(); ++jj) {
                        String signature = (String)signatures.get(jj);
                        if (signature == null) continue;
                        String link = JythonCompletionTask.getLinkForJavaSignature(signature);
                        DefaultCompletionItem item = new DefaultCompletionItem(method, 0, signature, (String)labels.get(jj), link);
                        item.setReferenceOnly(true);
                        result.addItem(item);
                    }
                    break block14;
                }
                String signature = JythonCompletionTask.makeInlineSignature(po, doc);
                if (completions != null) {
                    try {
                        JSONObject jo = new JSONObject(completions.toString());
                        JSONArray kws = jo.getJSONArray("keywords");
                        for (int i = 0; i < kws.length(); ++i) {
                            JSONObject kw = kws.getJSONObject(i);
                            String name = kw.getString("name");
                            if (!name.startsWith(cc.completable)) continue;
                            String docs = kw.optString("description");
                            DefaultCompletionItem item = new DefaultCompletionItem(name, cc.completable.length(), name, name, "inline:" + docs);
                            item.sortPriority = -100;
                            item.icon = JAVA_JYTHON_METHOD_ICON;
                            result.addItem(item);
                        }
                    }
                    catch (JSONException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                MessageCompletionItem item = new MessageCompletionItem(method, signature);
                result.addItem(item);
            }
            catch (RuntimeException ex) {
                return 0;
            }
        }
        return 1;
    }

    private PythonInterpreter getInterpreter() {
        try {
            PythonInterpreter interp = this.jythonInterpreterProvider != null ? this.jythonInterpreterProvider.createInterpreter() : new PythonInterpreter();
            if (Util.isLegacyImports()) {
                URL imports = JythonOps.class.getResource("/imports2025.py");
                try (InputStream in = imports.openStream();){
                    interp.execfile(in, "imports2025.py");
                }
            }
            interp.set("PWD", (Object)"file:/tmp/");
            interp.set("dataset", (PyObject)new DatasetCommand());
            interp.set("getDataSet", (PyObject)new GetDataSetCommand());
            interp.set("getDataSets", (PyObject)new GetDataSetsCommand());
            interp.set("monitor", (Object)new NullProgressMonitor());
            return interp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void refresh(CompletionResultSet arg0) {
    }

    @Override
    public void cancel() {
    }

    public static int getLocalsCompletions(PythonInterpreter interp, CompletionContext cc, CompletionResultSet rs) {
        int count = 0;
        List<DefaultCompletionItem> rr = JythonCompletionTask.getLocalsCompletions(interp, cc);
        for (DefaultCompletionItem item : rr) {
            if (rs != null) {
                rs.addItem(item);
            }
            ++count;
        }
        return count;
    }

    public static int getImportableCompletions(String source, CompletionContext cc, CompletionResultSet result) {
        int count = 0;
        List<String> completions = JythonToJavaConverter.guessCompletions(cc.completable);
        for (String ss : completions) {
            String pkg = JythonToJavaConverter.guessPackage(ss);
            if (!JythonToJavaConverter.hasImport(source, pkg, ss)) {
                String javaClass = pkg + "." + ss;
                String signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + ".html";
                String link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
                ClassImportCompletionItem ci = new ClassImportCompletionItem(cc.completable, cc.completable.length(), ss, ss + " and import from " + pkg, link, 0, JAVA_CLASS_ICON, pkg, ss);
                result.addItem(ci);
            }
            ++count;
        }
        return count;
    }

    private static String hideJavaPaths(String label) {
        StringBuffer build = new StringBuffer();
        Pattern p = Pattern.compile("(org.das2.qds.QDataSet|java.lang.String|java.lang.Object|org.das2.util.monitor.ProgressMonitor|org.das2.datum.DatumRange|org.das2.datum.Datum)");
        Matcher m = p.matcher(label);
        while (m.find()) {
            String s;
            switch (s = m.group(1)) {
                case "org.das2.qds.QDataSet": {
                    m.appendReplacement(build, "QDataSet");
                    break;
                }
                case "java.lang.String": {
                    m.appendReplacement(build, "String");
                    break;
                }
                case "java.lang.Object": {
                    m.appendReplacement(build, "Object");
                    break;
                }
                case "org.das2.util.monitor.ProgressMonitor": {
                    m.appendReplacement(build, "Monitor");
                    break;
                }
                case "org.das2.datum.DatumRange": {
                    m.appendReplacement(build, "DatumRange");
                    break;
                }
                case "org.das2.datum.Datum": {
                    m.appendReplacement(build, "Datum");
                    break;
                }
            }
        }
        m.appendTail(build);
        return build.toString();
    }

    public static String escapeHtml(String s) {
        StringBuffer out = new StringBuffer();
        Pattern p = Pattern.compile("([\\<\\>])");
        Matcher m = p.matcher(s);
        while (m.find()) {
            m.appendReplacement(out, "");
            String ss = m.group(1);
            if (ss.equals("<")) {
                out.append("&lt;");
                continue;
            }
            if (!ss.equals(">")) continue;
            out.append("&gt;");
        }
        m.appendTail(out);
        return out.toString();
    }

    private static String getPyJavaClassSignature(PyJavaClass pf) {
        Class javaClass = JythonCompletionTask.getJavaClass(pf);
        return javaClass.getCanonicalName().replaceAll("\\.", "/");
    }

    private static String getPyFunctionSignature(PyFunction pf) {
        PyObject[] defaults = pf.func_defaults;
        String[] vars = ((PyTableCode)pf.func_code).co_varnames;
        int count = ((PyTableCode)pf.func_code).co_argcount;
        StringBuilder sig = new StringBuilder(pf.__name__ + "(");
        if (count > 0) {
            if (defaults.length == vars.length) {
                sig.append(vars[0]).append("=").append(defaults[0]);
            } else {
                sig.append(vars[0]);
            }
        }
        int nreq = vars.length - defaults.length;
        for (int i = 1; i < count; ++i) {
            if (i >= nreq) {
                sig.append(",").append(vars[i]).append("=").append(defaults[i - nreq]);
                continue;
            }
            sig.append(",").append(vars[i]);
        }
        if (count + defaults.length == vars.length - 2) {
            sig.append(",...");
        }
        sig.append(")");
        return sig.toString();
    }

    private static String makeInlineSignature(PyObject po, PyObject doc) {
        String[] ss2;
        String signature;
        String sig = po instanceof PyFunction ? JythonCompletionTask.getPyFunctionSignature((PyFunction)po) : "";
        String string = signature = doc instanceof PyNone ? "(No documentation)" : doc.toString();
        if (sig.length() > 0) {
            sig = "<b>" + sig + "</b><br><br>";
        }
        if ((ss2 = signature.split("\n")).length > 1) {
            for (int jj = 0; jj < ss2.length; ++jj) {
                ss2[jj] = JythonCompletionTask.escapeHtml(ss2[jj]);
            }
            signature = !signature.startsWith("<html>") ? "<html>" + sig + JythonCompletionTask.join(ss2, "<br>") + "</html>" : "<html>" + sig + signature.substring(6) + "</html>";
        } else {
            signature = "<html>" + sig + signature + "</html>";
        }
        signature = "inline:" + signature;
        return signature;
    }

    private static void doPyReflectedFunction(String ss, PyReflectedFunction prf, List<String> labels, List<String> signatures, List<String> argss) {
        PyReflectedFunctionPeeker peek = new PyReflectedFunctionPeeker(prf);
        for (int jj = 0; jj < peek.getArgsCount(); ++jj) {
            Method method1 = peek.getMethod(jj);
            String signature = JythonCompletionTask.methodSignature(method1);
            String args = JythonCompletionTask.methodArgs(method1);
            int j = signature.indexOf("#");
            String label = ss + "() JAVA";
            if (j > -1) {
                label = signature.substring(j + 1);
                label = JythonCompletionTask.hideJavaPaths(label);
                Class<?> ret = method1.getReturnType();
                label = label + "->" + JythonCompletionTask.hideJavaPaths(ret.getCanonicalName());
            }
            signatures.add(signature);
            labels.add(label);
            argss.add(args);
        }
    }

    private static void doPyMethod(String ss, PyMethod pm, List<String> labels, List<String> signatures, List<String> argss) {
        if (pm.im_func instanceof PyReflectedFunction) {
            PyReflectedFunction prf = (PyReflectedFunction)pm.im_func;
            PyReflectedFunctionPeeker peek = new PyReflectedFunctionPeeker(prf);
            for (int jj = 0; jj < peek.getArgsCount(); ++jj) {
                Method method1 = peek.getMethod(jj);
                String signature = JythonCompletionTask.methodSignature(method1);
                String args = JythonCompletionTask.methodArgs(method1);
                int j = signature.indexOf("#");
                String label = ss + "() JAVA";
                if (j > -1) {
                    label = signature.substring(j + 1);
                    label = JythonCompletionTask.hideJavaPaths(label);
                    Class<?> ret = method1.getReturnType();
                    label = label + "->" + JythonCompletionTask.hideJavaPaths(ret.getCanonicalName());
                }
                signatures.add(signature);
                labels.add(label);
                argss.add(args);
            }
        } else {
            System.err.println("here");
        }
    }

    private static void doConstructors(Constructor[] constructors, List<String> labels, List<String> signatures, String ss, List<String> argss) {
        for (Constructor constructor : constructors) {
            String signature = JythonCompletionTask.constructorSignatureNew(constructor);
            if (signature.contains("$")) {
                signature = signature.replaceAll("\\$", ".");
            }
            int j = signature.indexOf("#");
            String label = ss + "() JAVA";
            if (j > -1) {
                label = signature.substring(j + 1);
                label = JythonCompletionTask.hideJavaPaths(label);
                Class ret = constructor.getDeclaringClass();
                label = label + "->" + JythonCompletionTask.hideJavaPaths(ret.getCanonicalName());
            }
            signatures.add(signature);
            labels.add(label);
            argss.add(JythonCompletionTask.argsList(constructor.getParameterTypes()));
        }
    }

    public static <T extends Comparable<T>> void keySort(final List<T> key, List<?> ... lists) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < key.size(); ++i) {
            indices.add(i);
        }
        Collections.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                return ((Comparable)key.get(i)).compareTo(key.get(j));
            }
        });
        HashMap<Integer, Integer> swapMap = new HashMap<Integer, Integer>(indices.size());
        ArrayList<Integer> swapFrom = new ArrayList<Integer>(indices.size());
        ArrayList<Integer> swapTo = new ArrayList<Integer>(indices.size());
        for (int i = 0; i < key.size(); ++i) {
            int k = (Integer)indices.get(i);
            while (i != k && swapMap.containsKey(k)) {
                k = (Integer)swapMap.get(k);
            }
            swapFrom.add(i);
            swapTo.add(k);
            swapMap.put(i, k);
        }
        for (List<?> list : lists) {
            for (int i = 0; i < list.size(); ++i) {
                Collections.swap(list, (int)((Integer)swapFrom.get(i)), (int)((Integer)swapTo.get(i)));
            }
        }
    }

    private static boolean methodIsSuperset(String m1, String m2) {
        Pattern p0 = Pattern.compile("([a-zA-Z0-9/]*\\.html)#([a-zA-Z0-9]*)\\((([a-zA-Z0-9\\.\\[\\]]+)?(,([a-zA-Z0-9\\.\\[\\]]+))*)\\)");
        Matcher m8 = p0.matcher(m1);
        Matcher m9 = p0.matcher(m2);
        if (m8.matches() && m9.matches()) {
            String[] s9;
            String s1 = m8.group(3);
            String s2 = m9.group(3);
            String[] s8 = s1.split(",", -2);
            if (s8.length == (s9 = s2.split(",", -2)).length) {
                boolean superSet = true;
                for (int i = 0; i < s8.length; ++i) {
                    if (s8[i].equals("java.lang.Object") || s8[i].equals(s9[i])) continue;
                    superSet = false;
                }
                return superSet;
            }
        }
        return false;
    }

    public static void reduceObject(List<String> signatures, List<String> labels, List<String> argss) {
        if (signatures.size() > 1) {
            for (int i = 1; i < signatures.size(); ++i) {
                if (!JythonCompletionTask.methodIsSuperset(signatures.get(0), signatures.get(i))) continue;
                signatures.remove(0);
                labels.remove(0);
                argss.remove(0);
                break;
            }
        }
    }

    public static List<DefaultCompletionItem> getLocalsCompletions(PythonInterpreter interp, CompletionContext cc) {
        logger.log(Level.FINE, "get local completions for completable: {0}", cc.completable);
        ArrayList<DefaultCompletionItem> result = new ArrayList<DefaultCompletionItem>();
        PyStringMap locals = (PyStringMap)interp.getLocals();
        PyList po2 = locals.keys();
        block25: for (int i = 0; i < po2.__len__(); ++i) {
            String args;
            ArrayList<String> labels;
            String label;
            PyObject po;
            boolean allStatic;
            ArrayList<String> argss;
            ArrayList<String> signatures;
            String signature;
            String ss;
            ImageIcon icon;
            block64: {
                icon = null;
                PyString s = (PyString)po2.__getitem__(i);
                ss = s.toString();
                signature = null;
                signatures = new ArrayList<String>();
                argss = new ArrayList<String>();
                if (!ss.startsWith(cc.completable)) continue;
                if (ss.endsWith(__CLASSTYPE)) {
                    if (!(ss = ss.substring(0, ss.length() - __CLASSTYPE.length())).startsWith(cc.completable)) continue;
                    result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss, ss, null, -10, LOCALVARICON));
                    continue;
                }
                logger.log(Level.FINER, "found completion item: {0}", ss);
                allStatic = false;
                po = locals.get((PyObject)s);
                label = ss;
                labels = new ArrayList<String>();
                args = "";
                if (po instanceof PyReflectedFunction) {
                    PyReflectedFunction prf = (PyReflectedFunction)po;
                    JythonCompletionTask.doPyReflectedFunction(ss, prf, labels, signatures, argss);
                } else if (po instanceof PyMethod) {
                    PyMethod pm = (PyMethod)po;
                    JythonCompletionTask.doPyMethod(ss, pm, labels, signatures, argss);
                } else {
                    if (po.isCallable()) {
                        label = ss + "() ";
                        if (po instanceof PyFunction) {
                            label = JythonCompletionTask.getPyFunctionSignature((PyFunction)po);
                            args = label.substring(ss.length());
                        }
                        try {
                            PyObject doc = interp.eval(ss + ".__doc__");
                            signature = JythonCompletionTask.makeInlineSignature(po, doc);
                            break block64;
                        }
                        catch (RuntimeException ex) {
                            logger.fine("Callable PyFunction doesn't have __doc__: " + ss);
                            continue;
                        }
                    }
                    if (po.isNumberType()) {
                        switch (po.getType().getFullName()) {
                            case "javaclass": 
                            case "javainnerclass": {
                                Method[] mm;
                                label = ss;
                                Class jclass = JythonCompletionTask.getJavaClass((PyJavaClass)po);
                                String n = jclass.getCanonicalName();
                                allStatic = true;
                                logger.log(Level.FINER, "check for non-static methods: {0}", n);
                                for (Method m : mm = jclass.getMethods()) {
                                    if (m.getDeclaringClass().equals(Object.class) || Modifier.isStatic(m.getModifiers())) continue;
                                    logger.log(Level.FINEST, "not static: {0}", m.getName());
                                    allStatic = false;
                                }
                                logger.log(Level.FINER, "  class is all static methods: {0}", allStatic);
                                if (allStatic) {
                                    JythonCompletionTask.doConstructors(jclass.getConstructors(), labels, signatures, n, argss);
                                    for (int i1 = 0; i1 < argss.size(); ++i1) {
                                        argss.set(i1, "");
                                    }
                                } else {
                                    JythonCompletionTask.doConstructors(jclass.getConstructors(), labels, signatures, n, argss);
                                }
                                icon = JAVA_CONSTRUCTOR_ICON;
                                break;
                            }
                            case "javapackage": {
                                label = ss;
                                break;
                            }
                            default: {
                                String sss = po.toString();
                                if (po instanceof PyJavaInstance) {
                                    Object jo = po.__tojava__(Object.class);
                                    sss = jo instanceof QDataSet ? "dataset" : jo.toString();
                                }
                                if (sss.contains("<")) {
                                    label = ss;
                                    break;
                                }
                                label = ss + " = " + sss;
                                break;
                            }
                        }
                    } else if (!(po instanceof PyJavaClass)) {
                        logger.log(Level.FINE, "skipping {0}", ss);
                    }
                }
            }
            JythonCompletionTask.keySort(signatures, signatures, labels, argss);
            if (!signatures.isEmpty()) {
                String objectRemoved = "";
                int n = signatures.size();
                JythonCompletionTask.reduceObject(signatures, labels, argss);
                if (signatures.size() != n) {
                    objectRemoved = "*";
                }
                for (int jj = 0; jj < signatures.size(); ++jj) {
                    signature = (String)signatures.get(jj);
                    label = (String)labels.get(jj) + objectRemoved;
                    String link = null;
                    if (signature != null) {
                        link = JythonCompletionTask.getLinkForJavaSignature(signature);
                    }
                    if (ss.equals("dom")) {
                        link = "https://autoplot.org/developer.scripting#DOM";
                    }
                    logger.log(Level.FINER, "DefaultCompletionItem({0},{1},\n{2}{3},\n{4},\n{5})", new Object[]{ss, cc.completable.length(), ss, argss.get(jj), label, link});
                    result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + (String)argss.get(jj), label, link, 1, icon));
                }
                continue;
            }
            String link = null;
            if (signature != null && signature.startsWith("inline:")) {
                link = signature;
            } else if (ss.equals("dom")) {
                link = "https://autoplot.org/developer.scripting#DOM";
            } else if (signature != null) {
                link = JythonCompletionTask.getLinkForJavaSignature(signature);
            } else if (po instanceof PyJavaClass) {
                link = JythonCompletionTask.getLinkForJavaSignature(JythonCompletionTask.getPyJavaClassSignature((PyJavaClass)po));
            }
            if (po instanceof PyString) {
                String svalue = po.toString();
                if (svalue.length() > 50) {
                    svalue = svalue.startsWith("http") || svalue.startsWith("file") ? svalue.substring(0, 10) + "..." + svalue.substring(svalue.length() - 37) : svalue.substring(0, 37) + "..." + svalue.substring(svalue.length() - 10);
                }
                if (ss.equals("PWD")) {
                    result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, -10, LOCALVARICON));
                    continue;
                }
                if (!ss.equals("__name__")) {
                    result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label + " -> " + svalue + "", link, -10, LOCALVARICON));
                    continue;
                }
                result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label + " -> " + svalue + "", link, 1, null));
                continue;
            }
            if (allStatic) {
                result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args + ".", label, link, 1, JAVA_CLASS_ICON));
                continue;
            }
            if (po instanceof PyJavaClass) {
                result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, 1, JAVA_CONSTRUCTOR_ICON));
                continue;
            }
            if (po.getType().toString().contains("Command")) {
                if (ss.equals("plotx")) continue;
                result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, -2, JAVA_JYTHON_METHOD_ICON));
                continue;
            }
            if (po instanceof PyFunction) {
                result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, -2, JAVA_JYTHON_METHOD_ICON));
                continue;
            }
            if (po instanceof PyClass) {
                result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, 3, JAVA_JYTHON_METHOD_ICON));
                continue;
            }
            if (po instanceof PyReflectedField) {
                result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, 3, JAVA_JYTHON_METHOD_ICON));
                continue;
            }
            switch (ss) {
                case "monitor": 
                case "dom": 
                case "PI": 
                case "TAU": 
                case "E": {
                    result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, -3, LOCALVARICON));
                    continue block25;
                }
                case "params": 
                case "outputParams": 
                case "__doc__": {
                    result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, 9, LOCALVARICON));
                    continue block25;
                }
                default: {
                    result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link, -10, LOCALVARICON));
                }
            }
        }
        logger.log(Level.FINE, "getLocalsCompletions found {0} completions", new Object[]{result.size()});
        return result;
    }

    private static Class getJavaClass(PyJavaClass po) {
        PyJavaClassPeeker peek = new PyJavaClassPeeker(po);
        Class jclass = peek.getProxyClass();
        return jclass;
    }

    private static String getLinkForJavaSignature(String signature) {
        return JavadocLookup.getInstance().getLinkForJavaSignature(signature);
    }

    public static ImageIcon getIconFor(Object jm) {
        ImageIcon icon = null;
        if (jm instanceof Method) {
            Method m = (Method)jm;
            icon = Modifier.isStatic(m.getModifiers()) ? JAVA_STATIC_METHOD_ICON : JAVA_METHOD_ICON;
        } else if (jm instanceof Field) {
            Field m = (Field)jm;
            if (Modifier.isStatic(m.getModifiers())) {
                try {
                    Object o = m.get(Color.class);
                    if (o instanceof Color) {
                        Color testColor = (Color)o;
                        return GraphUtil.colorImageIcon((Color)testColor, (int)16, (int)16);
                    }
                    return JAVA_FIELD_ICON;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    logger.log(Level.FINE, null, ex);
                    return JAVA_FIELD_ICON;
                }
            }
            icon = JAVA_FIELD_ICON;
        }
        return icon;
    }
}

