/*
 * Decompiled with CFR 0.152.
 */
package org.das2;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.beans.BeansUtil;

public class NameContext {
    private static final String SIMPLE_NAME_STRING = "[A-Za-z][A-Za-z0-9_]*";
    private static final String INDEX_STRING = "0|[1-9][0-9]*";
    private static final String INDEXED_NAME_STRING = "([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\]";
    private static final String QUALIFIED_NAME_STRING = "[A-Za-z][A-Za-z0-9_]*(\\.[A-Za-z][A-Za-z0-9_]*|\\.([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\])*";
    public static final Pattern SIMPLE_NAME = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    public static final Pattern INDEXED_NAME = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\]");
    public static final Pattern QUALIFIED_NAME = Pattern.compile("[A-Za-z][A-Za-z0-9_]*(\\.[A-Za-z][A-Za-z0-9_]*|\\.([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\])*");
    private Map nameMap = new HashMap();
    private Map propertyMap = new HashMap();

    NameContext() {
    }

    public void put(String name, Object value) throws DasNameException {
        Matcher m = SIMPLE_NAME.matcher(name);
        if (!m.matches()) {
            throw new DasNameException(name + " must match " + SIMPLE_NAME_STRING);
        }
        this.nameMap.put(name, new WeakReference<Object>(value));
    }

    public Object get(String name) throws DasPropertyException, InvocationTargetException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Matcher m = SIMPLE_NAME.matcher(name);
        if (m.matches()) {
            return ((WeakReference)this.nameMap.get(name)).get();
        }
        int index = name.lastIndexOf(46);
        Object obj = this.get(name.substring(0, index));
        String property = name.substring(index + 1);
        m = INDEXED_NAME.matcher(property);
        if (m.matches()) {
            property = m.group(1);
            index = Integer.parseInt(m.group(2));
            return this.getIndexedPropertyValue(obj, property, index);
        }
        return this.getPropertyValue(obj, property);
    }

    public void set(String name, Object value) throws InvocationTargetException, DasPropertyException, DasNameException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Matcher m = SIMPLE_NAME.matcher(name);
        if (m.matches()) {
            this.put(name, value);
        }
        int index = name.lastIndexOf(46);
        Object obj = this.get(name.substring(0, index));
        String property = name.substring(index + 1);
        m = INDEXED_NAME.matcher(property);
        if (m.matches()) {
            property = m.group(1);
            index = Integer.parseInt(m.group(2));
            this.setIndexedPropertyValue(obj, property, index, value);
        } else {
            this.setPropertyValue(obj, property, value);
        }
    }

    public Object getPropertyValue(Object obj, String property) throws DasPropertyException, InvocationTargetException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            Method readMethod = pd.getReadMethod();
            return readMethod.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public Object getIndexedPropertyValue(Object obj, String property, int index) throws DasPropertyException, InvocationTargetException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            if (!(pd instanceof IndexedPropertyDescriptor)) {
                throw new DasPropertyException(DasPropertyException.NOT_INDEXED, null, property);
            }
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Method readMethod = ipd.getIndexedReadMethod();
            return readMethod.invoke(obj, index);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public void setPropertyValue(Object obj, String property, Object value) throws InvocationTargetException, DasPropertyException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            Method writeMethod = pd.getWriteMethod();
            if (writeMethod == null) {
                throw new DasPropertyException(DasPropertyException.READ_ONLY, null, property);
            }
            Class<?> propertyType = pd.getPropertyType();
            if (value instanceof String) {
                throw new RuntimeException("not implemented");
            }
            if (!(propertyType.isInstance(value) || propertyType == Boolean.TYPE && value instanceof Boolean || propertyType == Character.TYPE && value instanceof Character || propertyType == Double.TYPE && value instanceof Double || propertyType == Short.TYPE && value instanceof Short || propertyType == Integer.TYPE && value instanceof Integer || propertyType == Float.TYPE && value instanceof Float || propertyType == Byte.TYPE && value instanceof Byte || propertyType == Long.TYPE && value instanceof Long)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, null, property);
            }
            writeMethod.invoke(obj, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public void setIndexedPropertyValue(Object obj, String property, int index, Object value) throws InvocationTargetException, DasPropertyException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            if (!(pd instanceof IndexedPropertyDescriptor)) {
                throw new DasPropertyException(DasPropertyException.NOT_INDEXED, null, property);
            }
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Method writeMethod = ipd.getIndexedWriteMethod();
            if (writeMethod == null) {
                throw new DasPropertyException(DasPropertyException.READ_ONLY, null, property);
            }
            Class<?> propertyType = pd.getPropertyType();
            if (value instanceof String) {
                throw new RuntimeException("not implemented");
            }
            if (!(propertyType.isInstance(value) || propertyType == Boolean.TYPE && value instanceof Boolean || propertyType == Character.TYPE && value instanceof Character || propertyType == Double.TYPE && value instanceof Double || propertyType == Short.TYPE && value instanceof Short || propertyType == Integer.TYPE && value instanceof Integer || propertyType == Float.TYPE && value instanceof Float || propertyType == Byte.TYPE && value instanceof Byte || propertyType == Long.TYPE && value instanceof Long)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, null, property);
            }
            writeMethod.invoke(obj, index, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private void maybeLoadPropertiesForClass(Class cl) {
        try {
            if (this.propertyMap.get(cl) == null) {
                BeanInfo info = BeansUtil.getBeanInfo(cl);
                HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] properties = info.getPropertyDescriptors();
                for (int i = 0; i < properties.length; ++i) {
                    IndexedPropertyDescriptor ipd;
                    if (properties[i].getReadMethod() == null || properties[i] instanceof IndexedPropertyDescriptor && (ipd = (IndexedPropertyDescriptor)properties[i]).getIndexedReadMethod() == null) continue;
                    map.put(properties[i].getName(), properties[i]);
                }
                this.propertyMap.put(cl, map);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public void remove(String name) {
        this.nameMap.remove(name);
    }

    public String toString() {
        return this.getClass().getName() + this.nameMap.keySet().toString();
    }
}

