/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.event.TimeRangeSelectionEvent;
import org.das2.event.TimeRangeSelectionListener;
import org.das2.system.DasLogger;

public class DasTimeRangeSelector
extends JPanel
implements TimeRangeSelectionListener {
    private DatumRange range = null;
    JTextField idStart = null;
    JTextField idStop = null;
    JButton viewButton = null;
    JPanel startStopModePane = null;
    CardLayout cardLayout = null;
    boolean updateRangeString = false;
    private EventListenerList listenerList = null;
    protected final Action previousAction = new AbstractAction("<<"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedPrevious();
        }
    };
    protected final Action nextAction = new AbstractAction(">>"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedNext();
        }
    };
    protected final Action rangeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelected();
        }
    };
    private boolean favoritesEnabled = false;
    private List favoritesList = null;
    private JPopupMenu favoritesMenu = null;
    private final int FAVORITES_LIST_SIZE = 5;
    private String favoritesGroup;
    private JButton favoritesButton;
    private JPanel timesPane;
    private JComboBox rangeComboBox;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DasTimeRangeSelector() {
        this.updateRangeString = Preferences.userNodeForPackage(this.getClass()).getBoolean("updateRangeString", false);
        this.buildComponents();
        Datum tnow = TimeUtil.prevMidnight((Datum)TimeUtil.now().convertTo((Units)Units.us2000));
        this.range = new DatumRange(tnow, TimeUtil.next((int)3, (Datum)tnow));
        this.update();
    }

    private Action getModeAction() {
        return new AbstractAction("mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DasTimeRangeSelector.this.updateRangeString = !DasTimeRangeSelector.this.updateRangeString;
                Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", DasTimeRangeSelector.this.updateRangeString);
                DasTimeRangeSelector.this.revalidateUpdateMode();
                DasTimeRangeSelector.this.update();
            }
        };
    }

    private void revalidateUpdateMode() {
        if (this.updateRangeString) {
            this.idStart.setColumns(28);
            this.idStop.setVisible(false);
            this.viewButton.setVisible(true);
        } else {
            this.idStart.setColumns(18);
            this.idStop.setVisible(true);
        }
        this.startStopModePane.revalidate();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout());
        JButton b = new JButton();
        b.setAction(this.previousAction);
        b.setActionCommand("previous");
        b.setToolTipText("Scan back in time");
        this.add(b);
        this.startStopModePane = new JPanel(new FlowLayout());
        this.cardLayout = new CardLayout();
        this.timesPane = new JPanel(this.cardLayout);
        JPanel startStopPane2 = new JPanel(new FlowLayout());
        this.idStart = new JTextField(18);
        this.idStart.setAction(this.rangeAction);
        this.idStart.setActionCommand("startTime");
        startStopPane2.add(this.idStart);
        this.idStop = new JTextField(18);
        this.idStop.addActionListener(this.rangeAction);
        this.idStop.setActionCommand("endTime");
        startStopPane2.add(this.idStop);
        this.timesPane.add((Component)startStopPane2, "startStop");
        this.startStopModePane.add(this.timesPane);
        this.favoritesButton = new JButton("v");
        this.favoritesButton.setToolTipText("recent entry times");
        this.favoritesButton.setPreferredSize(new Dimension(20, 20));
        this.favoritesButton.setVisible(false);
        this.startStopModePane.add(this.favoritesButton);
        this.viewButton = new JButton(this.getModeAction());
        this.viewButton.setToolTipText("input mode: start/end vs time range string");
        this.viewButton.setPreferredSize(new Dimension(20, 20));
        this.startStopModePane.add(this.viewButton);
        this.add(this.startStopModePane);
        b = new JButton();
        b.setAction(this.nextAction);
        b.setActionCommand("next");
        b.setToolTipText("Scan forward in time");
        this.add(b);
        this.revalidateUpdateMode();
    }

    public DasTimeRangeSelector(Datum startTime, Datum endTime) {
        this(new DatumRange(startTime, endTime));
    }

    public DasTimeRangeSelector(DatumRange range) {
        this();
        this.range = range;
        this.update();
    }

    private void parseRange() {
        boolean updateRangeString0 = this.updateRangeString;
        if (this.idStop.getText().equals("")) {
            try {
                String rangeString = this.idStart.getText();
                if (rangeString.equals("")) {
                    rangeString = (String)this.rangeComboBox.getEditor().getItem();
                }
                DatumRange dr = DatumRangeUtil.parseTimeRange((String)rangeString);
                DatumRange oldRange = this.range;
                this.range = dr;
                this.updateRangeString = true;
                this.firePropertyChange("range", oldRange, this.range);
            }
            catch (ParseException e) {
                DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)e);
            }
        } else {
            this.updateRangeString = false;
            try {
                Datum s1 = TimeUtil.create((String)this.idStart.getText());
                Datum s2 = TimeUtil.create((String)this.idStop.getText());
                DatumRange oldRange = this.range;
                this.range = new DatumRange(s1, s2);
                this.firePropertyChange("range", oldRange, this.range);
            }
            catch (ParseException e) {
                DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)e);
            }
        }
        if (this.updateRangeString != updateRangeString0) {
            Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", this.updateRangeString);
        }
    }

    private void refreshFavorites() {
        this.favoritesMenu.removeAll();
        for (final String fav : this.favoritesList) {
            AbstractAction favAction = new AbstractAction(fav){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DasTimeRangeSelector.this.setRange(DatumRangeUtil.parseTimeRangeValid((String)fav));
                    DasTimeRangeSelector.this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, DasTimeRangeSelector.this.range));
                }
            };
            this.favoritesMenu.add(favAction);
        }
    }

    private void buildFavorites() {
        String favorites = Preferences.userNodeForPackage(this.getClass()).get("timeRangeSelector.favorites." + this.favoritesGroup, "");
        String[] ss = favorites.split("\\|\\|");
        this.favoritesList = new ArrayList();
        for (int i = 0; i < ss.length; ++i) {
            if ("".equals(ss[i])) continue;
            this.favoritesList.add(ss[i]);
        }
        this.favoritesMenu = new JPopupMenu();
        this.refreshFavorites();
        this.favoritesButton.add(this.favoritesMenu);
        this.favoritesButton.addActionListener(this.getFavoritesListener());
    }

    private ActionListener getFavoritesListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DasTimeRangeSelector.this.favoritesMenu.show(DasTimeRangeSelector.this, DasTimeRangeSelector.this.favoritesButton.getX(), DasTimeRangeSelector.this.favoritesButton.getY());
            }
        };
    }

    public void enableFavorites(String group) {
        if (group == null) {
            group = "default";
        }
        this.favoritesGroup = group;
        this.favoritesEnabled = true;
        this.favoritesButton.setVisible(true);
        this.buildFavorites();
    }

    public Datum getStartTime() {
        this.parseRange();
        return this.range.min();
    }

    public Datum getEndTime() {
        this.parseRange();
        return this.range.max();
    }

    public DatumRange getRange() {
        return this.range;
    }

    public void setRange(DatumRange range) {
        DatumRange oldRange = range;
        this.range = range;
        this.update();
        this.propertyChangeSupport.firePropertyChange("range", oldRange, range);
    }

    private void update() {
        if (this.range != null) {
            if (this.updateRangeString) {
                String rangeString = DatumRangeUtil.formatTimeRange((DatumRange)this.range);
                this.idStart.setText(rangeString);
                this.idStop.setText("");
            } else {
                this.idStart.setText(this.range.min().toString());
                this.idStop.setText(this.range.max().toString());
            }
        }
    }

    public void setStartTime(Datum s1) {
        if (this.range == null) {
            return;
        }
        Datum endTime = this.range.max();
        if (endTime.le(s1)) {
            endTime = s1.add(1.0, Units.seconds);
        }
        this.range = new DatumRange(s1, endTime);
        this.update();
    }

    public void setEndTime(Datum s2) {
        if (this.range == null) {
            return;
        }
        Datum startTime = this.range.min();
        if (startTime.ge(s2)) {
            startTime = s2.subtract(1.0, Units.seconds);
        }
        this.range = new DatumRange(startTime, s2);
        this.update();
    }

    public boolean isWithin(Datum s1, Datum s2) {
        Datum startTime = this.getStartTime();
        Datum endTime = this.getEndTime();
        return s1.compareTo(startTime) <= 0 && endTime.compareTo(s2) <= 0;
    }

    @Override
    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        DatumRange range = e.getRange();
        if (!range.equals((Object)this.range)) {
            this.setRange(e.getRange());
            this.fireTimeRangeSelected(e);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(TimeRangeSelectionListener.class, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.listenerList.remove(TimeRangeSelectionListener.class, listener);
    }

    protected void fireTimeRangeSelectedPrevious() {
        this.range = this.range.previous();
        this.update();
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelectedNext() {
        this.range = this.range.next();
        this.update();
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected() {
        this.parseRange();
        this.update();
        if (this.favoritesEnabled) {
            String store = this.range.toString();
            if (this.favoritesList.contains(store)) {
                this.favoritesList.remove(store);
            }
            this.favoritesList.add(0, store);
            for (int i = 5; i < this.favoritesList.size(); ++i) {
                this.favoritesList.remove(i);
            }
            this.refreshFavorites();
            this.saveFavorites();
        }
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TimeRangeSelectionListener.class) continue;
            String logmsg = "fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event;
            DasLogger.getLogger(DasLogger.GUI_LOG).fine(logmsg);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    private void saveFavorites() {
        if (this.favoritesList.size() == 0) {
            return;
        }
        StringBuffer favorites = new StringBuffer((String)this.favoritesList.get(0));
        for (int i = 1; i < this.favoritesList.size(); ++i) {
            favorites.append("||" + this.favoritesList.get(i));
        }
        Preferences.userNodeForPackage(this.getClass()).put("timeRangeSelector." + this.favoritesGroup, favorites.toString());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }
}

