/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.das2.DasApplication;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;

public class DatumRangeEditor
extends JComponent
implements PropertyEditor,
TableCellEditor {
    private JTextField editor;
    private JButton unitsButton;
    private Units units = Units.dimensionless;
    private ActionListener actionListener;
    private DatumRange value;
    private EventListenerList listeners;
    private String lastErrorText = null;
    private long lastErrorTime = 0L;
    private boolean allowZeroWidth = true;
    public static final String PROP_ALLOWZEROWIDTH = "allowZeroWidth";
    private ChangeEvent evt;

    public DatumRangeEditor() {
        this.initComponents();
        this.installListeners();
        this.initToolTips();
        this.unitsButton.setVisible(false);
        this.setFocusable(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.editor = new JTextField(8);
        this.editor.setFocusable(false);
        this.add((Component)this.editor, "Center");
        this.unitsButton = new JButton();
        this.unitsButton.setFocusable(false);
        this.unitsButton.setToolTipText("units selection");
        this.add((Component)this.unitsButton, "East");
    }

    private void installListeners() {
        UniversalListener ul = new UniversalListener();
        this.editor.addMouseListener(ul);
        this.unitsButton.addMouseListener(ul);
        this.addKeyListener(ul);
        this.addFocusListener(ul);
    }

    private void initToolTips() {
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setColumns(int columns) {
        this.editor.setColumns(columns);
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof DatumRange)) {
            throw new IllegalArgumentException();
        }
        this.setDatumRange((DatumRange)value);
    }

    private void setDatumRange(DatumRange datumRange) {
        DatumRange oldValue = this.value;
        this.value = datumRange;
        Units u = datumRange.getUnits();
        String text = datumRange.toString();
        if (!UnitsUtil.isTimeLocation((Units)this.units) && text.endsWith(u.toString()) && u.toString().length() > 7) {
            int n = text.length();
            text = text.substring(0, n - u.toString().length());
        }
        this.editor.setText(text);
        this.setUnits(u);
        if (oldValue != this.value && oldValue != null && !oldValue.equals((Object)this.value)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setDatumRange(this.parseText(text));
        }
        catch (ParseException pe) {
            IllegalArgumentException iae = new IllegalArgumentException(pe);
            throw iae;
        }
    }

    @Override
    public Object getValue() {
        return this.getDatumRange();
    }

    private DatumRange parseText(String text) throws ParseException {
        DatumRange result = null;
        result = this.units instanceof TimeLocationUnits ? DatumRangeUtil.parseTimeRange((String)text) : DatumRangeUtil.parseDatumRange((String)text, (DatumRange)this.value);
        return result;
    }

    private void showErrorUsage(String text, String why) {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            if (text != null && text.equals(this.lastErrorText) && System.currentTimeMillis() - this.lastErrorTime < 5000L) {
                return;
            }
            if (why != null) {
                JOptionPane.showMessageDialog(this, "<html>Unable to accept \"" + text + "\"<br>" + why + "<html>");
            } else {
                JOptionPane.showMessageDialog(this, "<html>Unable to accept \"" + text + "\"</html>");
            }
            this.lastErrorText = text;
            this.lastErrorTime = System.currentTimeMillis();
        }
    }

    public DatumRange getDatumRange() {
        String text = this.editor.getText();
        try {
            DatumRange dr = this.parseText(text);
            if (!Double.isFinite(dr.min().doubleValue(dr.getUnits()))) {
                if (!Double.isFinite(this.value.min().doubleValue(this.value.getUnits()))) {
                    this.editor.setText("1 to 100");
                    dr = this.parseText(text);
                } else {
                    this.editor.setText(this.value.toString());
                    return this.value;
                }
            }
            if (!this.allowZeroWidth && dr.width().value() == 0.0) {
                this.showErrorUsage(text, "zero-width ranges are not allowed.");
                return this.value;
            }
            if (!dr.equals((Object)this.value)) {
                DatumRange oldValue = this.value;
                this.value = dr;
                this.firePropertyChange("value", oldValue, this.value);
            }
            return this.value;
        }
        catch (ParseException e) {
            if (this.value != null) {
                this.setDatumRange(this.value);
                if (UnitsUtil.isTimeLocation((Units)this.value.getUnits())) {
                    this.showErrorUsage(text, "String cannot be parsed to time range");
                } else {
                    this.showErrorUsage(text, "String cannot be parsed to range with units \"" + this.value.getUnits() + "\"");
                }
                return this.value;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (this.value != null) {
                this.setDatumRange(this.value);
                if (e.getMessage().contains("min > max")) {
                    this.showErrorUsage(text, "Min cannot be greater than max");
                } else {
                    this.showErrorUsage(text, e.getMessage());
                }
                return this.value;
            }
            return null;
        }
    }

    @Override
    public String getAsText() {
        DatumRange value = this.getDatumRange();
        if (value == null) {
            return null;
        }
        return this.editor.getText();
    }

    public void setUnits(Units units) {
        this.unitsButton.setVisible(false);
        this.units = units;
    }

    public Units getUnits() {
        return this.units;
    }

    public boolean isAllowZeroWidth() {
        return this.allowZeroWidth;
    }

    public void setAllowZeroWidth(boolean allowZeroWidth) {
        boolean oldAllowZeroWidth = this.allowZeroWidth;
        this.allowZeroWidth = allowZeroWidth;
        this.firePropertyChange(PROP_ALLOWZEROWIDTH, oldAllowZeroWidth, allowZeroWidth);
    }

    private void fireActionPerformed() {
        this.setDatumRange(this.getDatumRange());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "DatumEditor"));
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.unitsButton.getBounds().contains(event.getX(), event.getY())) {
            return this.unitsButton.getToolTipText();
        }
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public String getJavaInitializationString() {
        return "???";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics g, Rectangle r) {
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setValue(value);
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (this.listeners != null) {
            this.listeners.remove(CellEditorListener.class, l);
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getDatumRange();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.getDatumRange() == null) {
            return false;
        }
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private void fireEditingStopped() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingCanceled(this.evt);
        }
    }

    private class UniversalListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        private UniversalListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            DatumRangeEditor.this.editor.getCaret().setVisible(true);
            DatumRangeEditor.this.editor.getCaret().setSelectionVisible(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            DatumRangeEditor.this.editor.getCaret().setVisible(false);
            DatumRangeEditor.this.editor.getCaret().setSelectionVisible(false);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                DatumRangeEditor.this.fireActionPerformed();
            } else {
                this.forwardKeyEvent(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        private void forwardKeyEvent(KeyEvent e) {
            e.setSource(DatumRangeEditor.this.editor);
            DatumRangeEditor.this.editor.dispatchEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DatumRangeEditor.this.requestFocusInWindow();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

