/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.das2.util.ColorUtil;
import org.das2.util.DesktopColorChooserPanel;
import org.das2.util.Entities;
import org.das2.util.FontChooser;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.NamedColorChooserPanel;
import org.das2.util.StringSchemeEditor;
import org.das2.util.TickleTimer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class GrannyTextEditor
extends JPanel
implements StringSchemeEditor {
    public static final String EDITOR_TITLE = "Granny Text Editor";
    JPanel canvas;
    GrannyTextRenderer gtr;
    TickleTimer tickleTimer;
    JButton myEntityButton;
    private JButton aButton;
    private JButton bButton;
    private JButton boldButton;
    private JButton colorButton;
    private ButtonGroup connectButtonGroup;
    private JButton exclaimationPointButton;
    private JPanel extensionsTab;
    private ButtonGroup fillStyleButtonGroup;
    private JPanel greekTab;
    private JPanel hersheyTab;
    private JButton imageButton;
    private JPanel imagePanel;
    private JCheckBox imageSizeCB;
    private JTextField imageSizeTF;
    private JTextField imageUrlTF;
    private JLabel instructionalLabel;
    private JButton italicButton;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton11;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton8;
    private JRadioButton jRadioButton9;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JTextField lineThicknessTF;
    private JPanel miscTab;
    private JButton nButton;
    private JRadioButton noneConnectorRB;
    private JRadioButton noneFillStyleRB;
    private JRadioButton outlineFillStyleRB;
    private JTextField peNumber;
    private JButton plotElementButton;
    private JPanel plotElementPanel;
    private ButtonGroup plotSymbolButtonGroup;
    private JButton psymButton;
    private JCheckBox psymColorCB;
    private JTextField psymColorTextField;
    private JPanel psymPanel;
    private JButton rButton;
    private JPanel renderPanel;
    private JButton sButton;
    private JTextField sizeTextField;
    private JRadioButton solidConnectRB;
    private JButton underlineButton;
    private BindingGroup bindingGroup;

    public GrannyTextEditor() {
        this.initComponents();
        this.plotElementButton.setVisible(false);
        this.canvas = new JPanel(){

            @Override
            protected void paintComponent(Graphics g1) {
                super.paintComponent(g1);
                Graphics2D g = (Graphics2D)g1;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle r = g.getClipBounds(GrannyTextEditor.this.renderPanel.getBounds());
                g.setColor(Color.WHITE);
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setColor(Color.BLACK);
                GrannyTextEditor.this.gtr.draw((Graphics)g, 10.0f, 14.0f);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRect(10, 14 - (int)GrannyTextEditor.this.gtr.getAscent(), (int)GrannyTextEditor.this.gtr.getWidth(), (int)GrannyTextEditor.this.gtr.getHeight());
            }
        };
        this.renderPanel.setLayout(new BorderLayout());
        this.renderPanel.add((Component)this.canvas, "Center");
        this.gtr = new GrannyTextRenderer();
        this.gtr.setString(this.canvas.getFont(), "");
        this.tickleTimer = new TickleTimer(300L, evt -> SwingUtilities.invokeLater(() -> this.updateImage()));
        this.jTextArea1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GrannyTextEditor.this.tickleTimer.tickle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GrannyTextEditor.this.tickleTimer.tickle();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GrannyTextEditor.this.tickleTimer.tickle();
            }
        });
        String[] greek = new String[]{"&alpha;", "&beta;", "&Gamma;", "&Delta;", "&Theta;", "&eta;", "&Lambda;", "&mu;", "&pi;", "&rho;", "&epsilon;", "&omega;", "&Phi;", "&tau;", "&chi;"};
        for (int i = 0; i < 15; ++i) {
            if (i < greek.length) {
                this.greekTab.add(this.miscButton(greek[i]));
                continue;
            }
            this.greekTab.add(new JLabel(" "));
        }
        String[] misc = new String[]{"&rarr;", "&uarr;", "&#0229;", "&infin;", "&cong;", "&le;", "&ne;", "&ge;", "&sup2;", "&sup3;", "&dagger;", "&deg;", "&int;", "", "More..."};
        for (int i = 0; i < 15; ++i) {
            if (i < misc.length) {
                JButton b = this.miscButton(misc[i]);
                if (misc[i].length() == 0) {
                    this.myEntityButton = b;
                }
                this.miscTab.add(b);
                continue;
            }
            this.miscTab.add(new JLabel(" "));
        }
    }

    public void addPainter(String id, GrannyTextRenderer.Painter p) {
        this.gtr.addPainter(id, p);
        if (id.equals("psym")) {
            this.psymButton.setVisible(true);
            this.psymButton.setEnabled(true);
        } else if (id.equals("img")) {
            this.imageButton.setVisible(true);
            this.imageButton.setEnabled(true);
        } else if (id.equals("plotElement")) {
            this.plotElementButton.setVisible(true);
            this.plotElementButton.setEnabled(true);
        } else if (!id.equals("block")) {
            System.err.println("not supported: " + id);
        }
    }

    public void addButton(String tabName, String id, final String insert) {
        Component c;
        int i;
        JPanel tabPanel = null;
        for (i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            if (!this.jTabbedPane1.getTitleAt(i).equals(tabName)) continue;
            tabPanel = (JPanel)this.jTabbedPane1.getComponentAt(i);
        }
        if (tabPanel == null) {
            tabPanel = new JPanel();
            tabPanel.setLayout(new GridLayout(3, 5));
            for (i = 0; i < 15; ++i) {
                tabPanel.add(new JLabel(" "));
            }
            this.jTabbedPane1.add(tabName, tabPanel);
        }
        for (i = 0; i < 15 && !((c = tabPanel.getComponent(i)) instanceof JLabel); ++i) {
        }
        JButton customButton = new JButton(id);
        tabPanel.add((Component)customButton, i);
        customButton.setVisible(true);
        customButton.setEnabled(true);
        customButton.setAction(new AbstractAction(id){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrannyTextEditor.this.doInsert(insert, "");
            }
        });
    }

    private JButton miscButton(String s) {
        JButton result = new JButton("<html>" + s);
        result.addActionListener(e -> {
            String sel = result.getText().substring(6);
            if (sel.equals("More...")) {
                sel = Entities.pickEntityGUI();
                if (sel.isEmpty()) {
                    return;
                }
                if (this.myEntityButton != null) {
                    this.myEntityButton.setText("<html>" + sel);
                    this.myEntityButton.repaint();
                }
            }
            if ((e.getModifiers() & 2) == 2) {
                String s1 = Entities.decode((String)sel);
                if (s1.length() == 0) {
                    this.doInsert(sel, null);
                } else {
                    this.doInsert(s1, null);
                }
            } else {
                this.doInsert(sel, null);
            }
        });
        return result;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.psymPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.solidConnectRB = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.lineThicknessTF = new JTextField();
        this.jRadioButton11 = new JRadioButton();
        this.noneConnectorRB = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.psymColorCB = new JCheckBox();
        this.psymColorTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.sizeTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jRadioButton9 = new JRadioButton();
        this.outlineFillStyleRB = new JRadioButton();
        this.noneFillStyleRB = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.jRadioButton8 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.plotSymbolButtonGroup = new ButtonGroup();
        this.connectButtonGroup = new ButtonGroup();
        this.fillStyleButtonGroup = new ButtonGroup();
        this.imagePanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.imageUrlTF = new JTextField();
        this.imageSizeCB = new JCheckBox();
        this.imageSizeTF = new JTextField();
        this.jLabel8 = new JLabel();
        this.plotElementPanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.peNumber = new JTextField();
        this.renderPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jTabbedPane1 = new JTabbedPane();
        this.hersheyTab = new JPanel();
        this.aButton = new JButton();
        this.bButton = new JButton();
        this.sButton = new JButton();
        this.rButton = new JButton();
        this.exclaimationPointButton = new JButton();
        this.nButton = new JButton();
        this.extensionsTab = new JPanel();
        this.colorButton = new JButton();
        this.italicButton = new JButton();
        this.boldButton = new JButton();
        this.underlineButton = new JButton();
        this.psymButton = new JButton();
        this.imageButton = new JButton();
        this.plotElementButton = new JButton();
        this.jButton2 = new JButton();
        this.greekTab = new JPanel();
        this.miscTab = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.instructionalLabel = new JLabel();
        this.psymPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel6.setText("Connector:");
        this.connectButtonGroup.add(this.solidConnectRB);
        this.solidConnectRB.setText("solid");
        this.jLabel10.setText("Line Thickness:");
        this.lineThicknessTF.setText("1.0");
        this.connectButtonGroup.add(this.jRadioButton11);
        this.jRadioButton11.setText("dots");
        this.connectButtonGroup.add(this.noneConnectorRB);
        this.noneConnectorRB.setSelected(true);
        this.noneConnectorRB.setText("none");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lineThicknessTF, -2, -1, -2)).addComponent(this.jLabel10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton11).addComponent(this.solidConnectRB).addComponent(this.noneConnectorRB)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.solidConnectRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noneConnectorRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton11, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lineThicknessTF, -2, -1, -2).addContainerGap(8, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jRadioButton11, this.noneConnectorRB, this.solidConnectRB);
        this.jButton1.setText("Pick...");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.psymColorCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.jButton1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.psymColorCB.setText("Color:");
        this.psymColorCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.psymColorCBActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.psymColorCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.psymColorTextField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.psymColorCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psymColorTextField, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addGap(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.psymColorCB).addComponent(this.psymColorTextField, -2, -1, -2)).addGap(0, 78, Short.MAX_VALUE)));
        this.jLabel4.setText("Size:");
        this.sizeTextField.setText("0.5em");
        this.jLabel5.setText("Fill Style:");
        this.fillStyleButtonGroup.add(this.jRadioButton9);
        this.jRadioButton9.setSelected(true);
        this.jRadioButton9.setText("solid");
        this.fillStyleButtonGroup.add(this.outlineFillStyleRB);
        this.outlineFillStyleRB.setText("outline");
        this.fillStyleButtonGroup.add(this.noneFillStyleRB);
        this.noneFillStyleRB.setText("none");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noneFillStyleRB).addComponent(this.jRadioButton9).addComponent(this.outlineFillStyleRB))).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.sizeTextField, -2, 79, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel5, -2, 20, -2).addGap(1, 1, 1).addComponent(this.jRadioButton9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outlineFillStyleRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noneFillStyleRB).addContainerGap(9, Short.MAX_VALUE)));
        this.plotSymbolButtonGroup.add(this.jRadioButton8);
        this.jRadioButton8.setText("stars");
        this.plotSymbolButtonGroup.add(this.jRadioButton5);
        this.jRadioButton5.setText("exes");
        this.plotSymbolButtonGroup.add(this.jRadioButton4);
        this.jRadioButton4.setText("diamonds");
        this.plotSymbolButtonGroup.add(this.jRadioButton3);
        this.jRadioButton3.setText("crosses");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.plotSymbolButtonGroup.add(this.jRadioButton2);
        this.jRadioButton2.setText("circles");
        this.plotSymbolButtonGroup.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("boxes");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.plotSymbolButtonGroup.add(this.jRadioButton6);
        this.jRadioButton6.setText("triangles");
        this.plotSymbolButtonGroup.add(this.jRadioButton7);
        this.jRadioButton7.setText("none");
        this.jRadioButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.jRadioButton7ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Plot Symbol:");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2).addComponent(this.jRadioButton1).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5).addComponent(this.jRadioButton8).addComponent(this.jRadioButton6).addComponent(this.jRadioButton7)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton8).addContainerGap(28, Short.MAX_VALUE)));
        GroupLayout psymPanelLayout = new GroupLayout(this.psymPanel);
        this.psymPanel.setLayout(psymPanelLayout);
        psymPanelLayout.setHorizontalGroup(psymPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psymPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addGroup(psymPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psymPanelLayout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)).addComponent(this.jPanel2, -2, -1, -2)).addContainerGap(42, Short.MAX_VALUE)));
        psymPanelLayout.setVerticalGroup(psymPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psymPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(psymPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, -1, -2).addGroup(psymPanelLayout.createSequentialGroup().addGroup(psymPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)))));
        this.jLabel7.setText("URL of image:");
        this.imageUrlTF.setText("https://autoplot.org/Logo32.png");
        this.imageSizeCB.setText("Size:");
        this.imageSizeTF.setText("50%");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.imageSizeCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.imageSizeTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel8.setText("<html><i>50% means half of original size; 2em means two em heights; 20 or 20px means 20 pixels");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.imageSizeCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.jLabel8, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout imagePanelLayout = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.imageSizeTF, -2, 86, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(imagePanelLayout.createSequentialGroup().addContainerGap().addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addComponent(this.jLabel7).addContainerGap(603, Short.MAX_VALUE)).addGroup(imagePanelLayout.createSequentialGroup().addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel8, -2, -1, -2)).addComponent(this.imageSizeCB)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(imagePanelLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.imageUrlTF).addContainerGap()));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageUrlTF, -2, -1, -2).addGap(18, 18, 18).addComponent(this.imageSizeCB).addGap(5, 5, 5).addComponent(this.jLabel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageSizeTF, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel9.setText("Plot Element Number:");
        this.peNumber.setText(" ");
        GroupLayout plotElementPanelLayout = new GroupLayout(this.plotElementPanel);
        this.plotElementPanel.setLayout(plotElementPanelLayout);
        plotElementPanelLayout.setHorizontalGroup(plotElementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotElementPanelLayout.createSequentialGroup().addContainerGap().addGroup(plotElementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotElementPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.peNumber, -2, 91, -2)).addComponent(this.jLabel9)).addContainerGap(-1, Short.MAX_VALUE)));
        plotElementPanelLayout.setVerticalGroup(plotElementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotElementPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peNumber, -2, -1, -2).addContainerGap(48, Short.MAX_VALUE)));
        this.renderPanel.setLayout(new BorderLayout());
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
            }

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
                GrannyTextEditor.this.jTextArea1CaretPositionChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GrannyTextEditor.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.aButton.setText("A - Shift Up");
        this.aButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.aButtonActionPerformed(evt);
            }
        });
        this.bButton.setText("B - Shift Down");
        this.bButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.bButtonActionPerformed(evt);
            }
        });
        this.sButton.setText("S - Save Position");
        this.sButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.sButtonActionPerformed(evt);
            }
        });
        this.rButton.setText("R - Restore Position");
        this.rButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.rButtonActionPerformed(evt);
            }
        });
        this.exclaimationPointButton.setText("! Character");
        this.exclaimationPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.exclaimationPointButtonActionPerformed(evt);
            }
        });
        this.nButton.setText("N - Normal");
        this.nButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.nButtonActionPerformed(evt);
            }
        });
        GroupLayout hersheyTabLayout = new GroupLayout(this.hersheyTab);
        this.hersheyTab.setLayout(hersheyTabLayout);
        hersheyTabLayout.setHorizontalGroup(hersheyTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hersheyTabLayout.createSequentialGroup().addGroup(hersheyTabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.nButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.aButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(hersheyTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rButton, -1, 186, Short.MAX_VALUE).addComponent(this.sButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exclaimationPointButton).addGap(0, 0, Short.MAX_VALUE)));
        hersheyTabLayout.setVerticalGroup(hersheyTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hersheyTabLayout.createSequentialGroup().addGroup(hersheyTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aButton).addComponent(this.sButton).addComponent(this.exclaimationPointButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(hersheyTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bButton).addComponent(this.rButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.nButton)));
        this.jTabbedPane1.addTab("Granny", this.hersheyTab);
        this.colorButton.setText("Color");
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.colorButtonActionPerformed(evt);
            }
        });
        this.italicButton.setText("<html><i>Italic");
        this.italicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.italicButtonActionPerformed(evt);
            }
        });
        this.boldButton.setText("<html><b>Bold");
        this.boldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.boldButtonActionPerformed(evt);
            }
        });
        this.underlineButton.setText("<html><u>Underline</u>");
        this.underlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.underlineButtonActionPerformed(evt);
            }
        });
        this.psymButton.setText("Psym");
        this.psymButton.setToolTipText("Add a symbol with given color and shape");
        this.psymButton.setEnabled(false);
        this.psymButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.psymButtonActionPerformed(evt);
            }
        });
        this.imageButton.setText("Image");
        this.imageButton.setToolTipText("Insert an image from a url");
        this.imageButton.setEnabled(false);
        this.imageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.imageButtonActionPerformed(evt);
            }
        });
        this.plotElementButton.setText("PlotElement");
        this.plotElementButton.setToolTipText("insert a symbol based on a plot element");
        this.plotElementButton.setEnabled(false);
        this.plotElementButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.plotElementButtonActionPerformed(evt);
            }
        });
        this.jButton2.setText("Font");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrannyTextEditor.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout extensionsTabLayout = new GroupLayout(this.extensionsTab);
        this.extensionsTab.setLayout(extensionsTabLayout);
        extensionsTabLayout.setHorizontalGroup(extensionsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extensionsTabLayout.createSequentialGroup().addGroup(extensionsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extensionsTabLayout.createSequentialGroup().addComponent(this.colorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.boldButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.italicButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.underlineButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)).addGroup(extensionsTabLayout.createSequentialGroup().addComponent(this.psymButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotElementButton))).addGap(0, 121, Short.MAX_VALUE)));
        extensionsTabLayout.setVerticalGroup(extensionsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extensionsTabLayout.createSequentialGroup().addGroup(extensionsTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colorButton).addComponent(this.boldButton, -2, -1, -2).addComponent(this.italicButton, -2, -1, -2).addComponent(this.underlineButton, -2, -1, -2).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(extensionsTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psymButton).addComponent(this.imageButton).addComponent(this.plotElementButton)).addContainerGap(29, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Extensions", this.extensionsTab);
        this.greekTab.setLayout(new GridLayout(3, 5));
        this.jTabbedPane1.addTab("Greek", this.greekTab);
        this.miscTab.setLayout(new GridLayout(3, 5));
        this.jTabbedPane1.addTab("Misc", this.miscTab);
        this.jLabel1.setText("Preview:");
        this.jLabel2.setText("Granny Text:");
        this.instructionalLabel.setText("Press buttons from palette below to insert into text.");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.renderPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.instructionalLabel)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renderPanel, -1, 78, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionalLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, 112, -2)));
        this.bindingGroup.bind();
    }

    private void doInsert(String text, String endt) {
        String theText = this.jTextArea1.getText();
        String ext = this.getExtension();
        if (ext != null) {
            int i2;
            boolean sameKind;
            int i = theText.lastIndexOf(ext, this.jTextArea1.getCaretPosition());
            if (i == -1) {
                i = theText.indexOf(ext);
            }
            if (i == -1) {
                i = this.jTextArea1.getCaretPosition();
            }
            if (sameKind = ext.substring(0, i2 = ext.indexOf(";")).equals(text.substring(0, Math.min(i2, text.length())))) {
                this.jTextArea1.replaceRange(text, i, i + ext.length());
            } else {
                int i3 = theText.lastIndexOf("!(", i);
                if (i3 > -1) {
                    this.jTextArea1.insert(text, i);
                } else {
                    this.jTextArea1.insert(text, i3);
                }
            }
            if (this.jTextArea1.getSelectionStart() != this.jTextArea1.getSelectionEnd() && endt != null) {
                this.jTextArea1.insert(endt, this.jTextArea1.getSelectionEnd());
            }
        } else if (this.jTextArea1.getSelectionStart() != this.jTextArea1.getSelectionEnd() && endt != null) {
            this.jTextArea1.insert(endt, this.jTextArea1.getSelectionEnd());
            this.jTextArea1.insert(text, this.jTextArea1.getSelectionStart());
        } else {
            this.jTextArea1.insert(text, this.jTextArea1.getSelectionStart());
        }
    }

    private String getExtension() {
        String ss = this.jTextArea1.getText();
        int i1 = ss.lastIndexOf("!(", this.jTextArea1.getCaretPosition());
        if (i1 == -1) {
            return null;
        }
        int i2 = ss.indexOf(")", i1);
        if (i2 == -1) {
            return null;
        }
        if (i2 >= this.jTextArea1.getCaretPosition() - 1) {
            return ss.substring(i1, i2 + 1);
        }
        return null;
    }

    private void jTextArea1CaretPositionChanged(InputMethodEvent evt) {
        this.tickleTimer.tickle();
    }

    private void colorButtonActionPerformed(ActionEvent evt) {
        String extension = this.getExtension();
        JColorChooser chooser = new JColorChooser();
        if (extension != null) {
            String[] ss = extension.substring(2, extension.length() - 1).split(";");
            chooser.setColor(ColorUtil.decodeColor((String)ss[ss.length - 1]));
        }
        chooser.addChooserPanel((AbstractColorChooserPanel)new NamedColorChooserPanel());
        chooser.addChooserPanel((AbstractColorChooserPanel)new DesktopColorChooserPanel());
        if (JOptionPane.showConfirmDialog(this, chooser, "Color Chooser", 2) == 0) {
            Color color = chooser.getColor();
            String colorName = ColorUtil.nameForColor((Color)color);
            this.doInsert("!(color;" + colorName + ")", "!(color)");
        }
    }

    private void bButtonActionPerformed(ActionEvent evt) {
        this.doInsert("!B", "!n");
    }

    private void aButtonActionPerformed(ActionEvent evt) {
        this.doInsert("!A", "!n");
    }

    private void boldButtonActionPerformed(ActionEvent evt) {
        this.doInsert("<b>", "</b>");
    }

    private void italicButtonActionPerformed(ActionEvent evt) {
        this.doInsert("<i>", "</i>");
    }

    private void underlineButtonActionPerformed(ActionEvent evt) {
        this.doInsert("<u>", "</u>");
    }

    private void exclaimationPointButtonActionPerformed(ActionEvent evt) {
        this.doInsert("!!", null);
    }

    private void sButtonActionPerformed(ActionEvent evt) {
        this.doInsert("!S", null);
    }

    private void rButtonActionPerformed(ActionEvent evt) {
        this.doInsert("!R", null);
    }

    private void nButtonActionPerformed(ActionEvent evt) {
        this.doInsert("!N", null);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() > 1) {
            this.instructionalLabel.setText("Press to insert, and holding control will insert the actual character.");
        } else {
            this.instructionalLabel.setText("Press buttons from palette below to insert into text.");
        }
    }

    private void setPsymPanelSettings(String settings) {
        settings = settings.substring(2, settings.length() - 1);
        String[] ss = settings.split(";");
        this.psymColorCB.setSelected(false);
        this.psymColorTextField.setBackground(ColorUtil.BLACK);
        this.sizeTextField.setText("1.0");
        block17: for (String s : ss) {
            String v;
            String n;
            int i = s.indexOf("=");
            if (i > -1) {
                n = s.substring(0, i);
                v = s.substring(i + 1);
            } else {
                n = s;
                v = null;
            }
            switch (n) {
                case "painter": 
                case "psym": {
                    continue block17;
                }
                case "size": {
                    this.sizeTextField.setText(v);
                    continue block17;
                }
                case "fillStyle": {
                    if (v.equals("outline")) {
                        this.outlineFillStyleRB.setSelected(true);
                        continue block17;
                    }
                    if (v.equals("none")) {
                        this.noneFillStyleRB.setSelected(true);
                        continue block17;
                    }
                    this.jRadioButton9.setSelected(true);
                    continue block17;
                }
                case "connect": {
                    if (v.equals("solid")) {
                        this.solidConnectRB.setSelected(true);
                        continue block17;
                    }
                    if (v.equals("dots")) {
                        this.jRadioButton11.setSelected(true);
                        continue block17;
                    }
                    this.noneConnectorRB.setSelected(true);
                    continue block17;
                }
                case "color": {
                    this.psymColorTextField.setBackground(ColorUtil.decodeColor((String)v));
                    this.psymColorCB.setSelected(true);
                    continue block17;
                }
                case "lineThick": {
                    this.lineThicknessTF.setText(v);
                    continue block17;
                }
                default: {
                    Enumeration<AbstractButton> bbs = this.plotSymbolButtonGroup.getElements();
                    while (bbs.hasMoreElements()) {
                        AbstractButton b = bbs.nextElement();
                        if (!b.getText().equals(n)) continue;
                        b.setSelected(true);
                    }
                    break block9;
                }
            }
        }
    }

    private void setImagePanelSettings(String settings) {
        settings = settings.substring(2, settings.length() - 1);
        String[] ss = settings.split(";");
        String surl = ss[2];
        String scale = ss.length == 4 ? ss[3] : "";
        this.imageSizeCB.setSelected(scale.length() > 0);
        this.imageSizeTF.setText(scale);
        this.imageUrlTF.setText(surl);
    }

    private void psymButtonActionPerformed(ActionEvent evt) {
        String extension = this.getExtension();
        if (extension != null && extension.startsWith("!(painter;psym")) {
            this.setPsymPanelSettings(extension);
        }
        if (0 == JOptionPane.showConfirmDialog(this, this.psymPanel, "Psym Options", 2)) {
            StringBuilder textb = new StringBuilder("!(painter;psym;");
            Enumeration<AbstractButton> bbs = this.plotSymbolButtonGroup.getElements();
            while (bbs.hasMoreElements()) {
                AbstractButton b = bbs.nextElement();
                if (!b.isSelected()) continue;
                textb.append(b.getText()).append(";");
            }
            textb.append("size=").append(this.sizeTextField.getText().trim());
            if (this.outlineFillStyleRB.isSelected()) {
                textb.append(";fillStyle=outline");
            } else if (this.noneFillStyleRB.isSelected()) {
                textb.append(";fillStyle=none");
            }
            if (!this.noneConnectorRB.isSelected()) {
                if (this.solidConnectRB.isSelected()) {
                    textb.append(";connect=solid");
                } else {
                    textb.append(";connect=dots");
                }
            }
            if (this.psymColorCB.isSelected()) {
                textb.append(";color=").append(this.psymColorTextField.getText().trim());
            }
            if (Double.parseDouble(this.lineThicknessTF.getText()) != 1.0) {
                textb.append(";lineThick=").append(this.lineThicknessTF.getText());
            }
            textb.append(")");
            this.doInsert(textb.toString(), null);
        }
    }

    private void imageButtonActionPerformed(ActionEvent evt) {
        String extension = this.getExtension();
        if (extension != null && extension.startsWith("!(painter;img")) {
            this.setImagePanelSettings(extension);
        }
        if (0 == JOptionPane.showConfirmDialog(this, this.imagePanel, "Image Options", 2)) {
            StringBuilder textb = new StringBuilder("!(painter;img");
            textb.append(";").append(this.imageUrlTF.getText());
            if (this.imageSizeCB.isSelected()) {
                textb.append(";").append(this.imageSizeTF.getText().trim());
            }
            textb.append(")");
            this.doInsert(textb.toString(), null);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JColorChooser chooser = new JColorChooser();
        chooser.addChooserPanel((AbstractColorChooserPanel)new NamedColorChooserPanel());
        chooser.addChooserPanel((AbstractColorChooserPanel)new DesktopColorChooserPanel());
        if (JOptionPane.showConfirmDialog(this, chooser, "Color Chooser", 2) == 0) {
            Color color = chooser.getColor();
            String colorName = ColorUtil.nameForColor((Color)color);
            this.psymColorTextField.setText(colorName);
            this.psymColorTextField.setBackground(color);
        }
    }

    private void psymColorCBActionPerformed(ActionEvent evt) {
        if (!this.psymColorCB.isSelected()) {
            JTextField s = new JTextField();
            this.psymColorTextField.setBackground(s.getBackground());
        } else {
            String s = this.psymColorTextField.getText();
            Color c = ColorUtil.decodeColor((String)s);
            this.psymColorTextField.setBackground(c);
        }
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
    }

    private void plotElementButtonActionPerformed(ActionEvent evt) {
        if (0 == JOptionPane.showConfirmDialog(this, this.plotElementPanel, "Plot Element Options", 2)) {
            String textb = "!(painter;legend;plotElement=" + this.peNumber.getText() + ")";
            this.doInsert(textb, null);
        }
    }

    private void peNumberActionPerformed(ActionEvent evt) {
    }

    private void imageSizeCBActionPerformed(ActionEvent evt) {
    }

    private void jRadioButton7ActionPerformed(ActionEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String extension = this.getExtension();
        FontChooser chooser = new FontChooser();
        chooser.setCurrentFont(this.renderPanel.getFont());
        if (extension != null) {
            String[] ss = extension.substring(2, extension.length() - 1).split(";");
            chooser.setFont(Font.decode(ss[ss.length - 1]));
        }
        if (this.jTextArea1.getText().trim().length() > 0) {
            String s = this.jTextArea1.getText().trim();
            s = Entities.decodeEntities((String)s);
            chooser.setExampleText(s);
        }
        JOptionPane p = new JOptionPane(chooser, -1, 2);
        JDialog dialog = p.createDialog("Font Chooser");
        dialog.setResizable(true);
        dialog.setVisible(true);
        if ((Integer)p.getValue() == 0) {
            Font font = chooser.getCurrentFont();
            this.doInsert("!(font;" + font.getFontName() + ")", "!(font)");
        }
    }

    private void updateImage() {
        String oldString = this.gtr.getString();
        try {
            this.gtr.setString(this.canvas.getFont(), this.getValue());
            this.canvas.setBackground(Color.WHITE);
        }
        catch (RuntimeException ex) {
            this.gtr.setString(this.canvas.getFont(), oldString);
            this.canvas.setBackground(Color.RED);
        }
        this.canvas.repaint();
    }

    public String getValue() {
        String text = this.jTextArea1.getText();
        text = text.replaceAll("\n", "<br>");
        return text;
    }

    public void setValue(String text) {
        text = text.replaceAll("\\<br\\>", "\n");
        text = text.replaceAll("\\![cC]", "\n");
        this.jTextArea1.setText(text);
        this.updateImage();
    }

    public Component getComponent() {
        return this;
    }

    public void setContext(Object o) {
    }

    public static void main(String[] args) {
        GrannyTextEditor edit = new GrannyTextEditor();
        edit.setValue("Happy !(color;Blue)Day!!");
        edit.addPainter("psym", null);
        edit.addPainter("img", null);
        edit.addButton("Macros", "%{CONTEXT}", "%{CONTEXT,format=%d,id=}");
        edit.addButton("Macros", "%{TIMERANGE}", "%{TIMERANGE,format=%d,id=}");
        JOptionPane.showMessageDialog(null, edit);
    }

    public String getLabel() {
        return EDITOR_TITLE;
    }
}

