/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.table.TableCellEditor;
import org.das2.components.propertyeditor.ColorCellRenderer;
import org.das2.util.DesktopColorChooserPanel;
import org.das2.util.NamedColorChooserPanel;

public final class ColorEditor
extends AbstractCellEditor
implements PropertyEditor,
TableCellEditor {
    private static final List colors = new ArrayList();
    private JColorChooser custom = null;
    private final transient PropertyEditorSupport editorSupport = new PropertyEditorSupport(this){};
    private JComboBox choice = new JComboBox(new ColorChoiceModel()){

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Dimension preferred = this.getPreferredSize();
            super.setBounds(x, y, width, preferred.height);
        }
    };

    public static void addColor(Color c, String name) {
        if (colors.contains(c)) {
            return;
        }
        colors.add(colors.size() - 1, c);
        ColorCellRenderer.addName(c, name);
    }

    public ColorEditor() {
        this.choice.setRenderer(new ColorCellRenderer());
        this.choice.setBorder(null);
        this.choice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ColorEditor.this.choice.isDisplayable()) {
                    ColorEditor.this.stopCellEditing();
                }
            }
        });
    }

    public ColorEditor(Color init) {
        this();
        this.setValue(init);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getAsText() {
        int rgb = ((Color)this.editorSupport.getValue()).getRGB();
        String hex = rgb == 0 ? "#000000" : "#" + Integer.toHexString(rgb).substring(2);
        return hex;
    }

    private void initCustom() {
        this.custom = new JColorChooser();
        this.custom.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ColorEditor.this.setValue(e.getNewValue());
            }
        });
        this.custom.setColor((Color)this.getValue());
        this.custom.addChooserPanel((AbstractColorChooserPanel)new NamedColorChooserPanel());
        this.custom.addChooserPanel((AbstractColorChooserPanel)new DesktopColorChooserPanel());
    }

    @Override
    public Component getCustomEditor() {
        Color c = (Color)this.getValue();
        if (this.custom == null) {
            this.initCustom();
        }
        this.custom.setColor(c);
        return this.custom;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.editorSupport.addPropertyChangeListener(l);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorSupport.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        return "???";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.editorSupport.getValue();
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.editorSupport.removePropertyChangeListener(l);
    }

    @Override
    public void setAsText(String str) throws IllegalArgumentException {
        Color c = Color.decode(str);
        this.setValue(c);
    }

    @Override
    public void setValue(Object obj) {
        Object oldValue = this.editorSupport.getValue();
        this.editorSupport.setValue(obj);
        if (oldValue != obj) {
            this.choice.setSelectedItem(obj);
            ColorChoiceModel model = new ColorChoiceModel();
            model.setSelectedItem(obj);
            this.choice.setModel(model);
            this.choice.repaint();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        this.setValue(value);
        ((ColorChoiceModel)this.choice.getModel()).setSelectedItem(value);
        this.choice.setForeground(table.getForeground());
        this.choice.setBackground(table.getBackground());
        return this.choice;
    }

    public Component getSmallEditor() {
        ((ColorChoiceModel)this.choice.getModel()).setSelectedItem(this.getValue());
        return this.choice;
    }

    static {
        colors.add(Color.BLACK);
        colors.add(Color.BLUE);
        colors.add(Color.RED);
        colors.add(Color.GREEN.darker());
        colors.add(Color.DARK_GRAY);
        colors.add(Color.GRAY);
        colors.add(Color.LIGHT_GRAY);
        colors.add(Color.WHITE);
        colors.add(new Color(128, 128, 255));
        colors.add(Color.PINK);
        colors.add(Color.GREEN);
        colors.add(Color.CYAN);
        colors.add(Color.YELLOW);
        colors.add(Color.MAGENTA);
        colors.add(Color.ORANGE);
        colors.add(new Color(0, true));
    }

    private class ColorChoiceModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final String CUSTOM_LABEL = "custom...";

        private ColorChoiceModel() {
        }

        @Override
        public Object getElementAt(int index) {
            if (index < colors.size()) {
                return colors.get(index);
            }
            if (index == colors.size()) {
                return CUSTOM_LABEL;
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        @Override
        public Object getSelectedItem() {
            return ColorEditor.this.getValue();
        }

        @Override
        public int getSize() {
            return colors.size() + 1;
        }

        @Override
        public void setSelectedItem(Object obj) {
            if (obj instanceof Color) {
                ColorEditor.this.setValue(obj);
            } else if (CUSTOM_LABEL.equals(obj)) {
                if (ColorEditor.this.custom == null) {
                    ColorEditor.this.initCustom();
                }
                if (0 == JOptionPane.showConfirmDialog(ColorEditor.this.choice, ColorEditor.this.custom, "Color Editor", 2)) {
                    ColorEditor.this.setValue(ColorEditor.this.custom.getColor());
                }
            } else {
                throw new IllegalArgumentException(String.valueOf(obj));
            }
        }
    }
}

