/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;

public class ClippedTableDataSet
extends AbstractDataSet {
    QDataSet source;
    int xoffset;
    int xlength;

    final void calculateXOffset(Datum xmin, Datum xmax) {
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)this.source);
        this.xoffset = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)xmin);
        int ix1 = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)xmax);
        this.xlength = ix1 - this.xoffset + 1;
    }

    public ClippedTableDataSet(QDataSet source, Datum xmin, Datum xmax, Datum ymin, Datum ymax) {
        this(source, new DatumRange(xmin, xmax), new DatumRange(ymin, ymax));
    }

    public ClippedTableDataSet(QDataSet source, DatumRange xrange, DatumRange yrange) {
        QDataSet dep1;
        QDataSet dep0;
        this.source = source;
        this.calculateXOffset(xrange.min(), xrange.max());
        Boolean t = (Boolean)source.property("QUBE");
        if (t != null && t.booleanValue()) {
            this.putProperty("QUBE", t);
        }
        if ((dep0 = (QDataSet)source.property("DEPEND_0")) != null) {
            this.putProperty("DEPEND_0", dep0.trim(this.xoffset, this.xoffset + this.xlength));
        }
        if ((dep1 = (QDataSet)source.property("DEPEND_1")) != null) {
            this.putProperty("DEPEND_1", dep1);
        }
    }

    public ClippedTableDataSet(QDataSet source, int xoffset, int xlength, int yoffset, int ylength) {
        if (source.rank() > 2) {
            throw new IllegalArgumentException("this ClippedTableDataSet constructor requires that there be only one table");
        }
        if (source.length() < xoffset + xlength) {
            throw new IllegalArgumentException("xoffset + xlength greater than the number of XTags in source");
        }
        if (source.length(0) < yoffset + ylength) {
            throw new IllegalArgumentException("yoffset + ylength greater than the number of YTags in source");
        }
        if (yoffset < 0 || xoffset < 0) {
            throw new IllegalArgumentException("yoffset(" + yoffset + ") or xoffset(" + xoffset + ") is negative");
        }
        this.source = source;
        this.xoffset = xoffset;
        this.xlength = xlength;
    }

    public double value(int i, int j) {
        return this.source.value(i + this.xoffset, j);
    }

    public int rank() {
        return 2;
    }

    public int length() {
        return this.xlength;
    }

    public int length(int i) {
        return this.source.length(i + this.xoffset);
    }
}

