/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Arrays;
import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.SimpleTableDataSet;
import org.das2.dataset.TableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.system.DasLogger;

public class NewAverageTableRebinner {
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG);
    private boolean interpolate = true;
    private boolean enlargePixels = true;
    private final int ny;
    private final int nx;
    TableDataSet tds;
    RebinDescriptor ddX;
    RebinDescriptor ddY;

    public NewAverageTableRebinner(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) {
        if (ds == null) {
            throw new NullPointerException("null data set");
        }
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException("Data set must be an instanceof TableDataSet: " + ds.getClass().getName());
        }
        this.tds = (TableDataSet)ds;
        this.ddX = ddX;
        this.ddY = ddY;
        this.nx = ddX == null ? this.tds.getXLength() : ddX.numberOfBins();
        this.ny = ddY == null ? this.tds.getYLength(0) : ddY.numberOfBins();
    }

    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException, DasException {
        Units resultYUnits;
        double[] yTags;
        double[] xTags;
        if (ds != this.tds) {
            throw new IllegalArgumentException("already set for another dataset");
        }
        if (ddX != this.ddX) {
            throw new IllegalArgumentException("already set for another X rebin descriptor");
        }
        if (ddY != this.ddY) {
            throw new IllegalArgumentException("already set for another Y rebin descriptor");
        }
        TableDataSet weights = (TableDataSet)this.tds.getPlanarView("weights");
        if (ddX != null && this.tds.getXLength() > 0) {
            double start = this.tds.getXTagDouble(0, ddX.getUnits());
            double end = this.tds.getXTagDouble(this.tds.getXLength() - 1, ddX.getUnits());
            if (start > ddX.end) {
                throw new NoDataInIntervalException("data starts after range");
            }
            if (end < ddX.start) {
                throw new NoDataInIntervalException("data ends before range");
            }
        }
        long timer = System.currentTimeMillis();
        Units xunits = ddX.getUnits();
        logger.finest("Allocating rebinData and rebinWeights: " + this.nx + " x " + this.ny);
        double[] rebinData = new double[this.nx * this.ny];
        double[] rebinWeights = new double[this.nx * this.ny];
        this.average(this.tds, weights, rebinData, rebinWeights, ddX, ddY);
        if (ddX != null) {
            xTags = ddX.binCenters();
        } else {
            xTags = new double[this.nx];
            for (int i = 0; i < this.nx; ++i) {
                xTags[i] = this.tds.getXTagDouble(i, this.tds.getXUnits());
            }
        }
        if (ddY != null) {
            yTags = ddY.binCenters();
        } else {
            yTags = new double[this.ny];
            for (int j = 0; j < this.ny; ++j) {
                yTags[j] = this.tds.getYTagDouble(0, j, this.tds.getYUnits());
            }
        }
        Units resultXUnits = ddX == null ? this.tds.getXUnits() : ddX.getUnits();
        Units units = resultYUnits = ddY == null ? this.tds.getYUnits() : ddY.getUnits();
        if (this.interpolate) {
            Datum xTagWidth = (Datum)ds.getProperty("xTagWidth");
            if (xTagWidth == null) {
                xTagWidth = DataSetUtil.guessXTagWidth(this.tds);
            }
            double xTagWidthDouble = xTagWidth.doubleValue(ddX.getUnits().getOffsetUnits());
            Datum yTagWidth = (Datum)ds.getProperty("yTagWidth");
            if (ddX != null) {
                this.fillInterpolateX(rebinData, rebinWeights, xTags, xTagWidthDouble);
            }
            if (ddY != null) {
                this.fillInterpolateY(rebinData, rebinWeights, ddY, yTagWidth);
            }
        } else if (this.enlargePixels) {
            this.enlargePixels(rebinData, rebinWeights);
        }
        SimpleTableDataSet weightsTDS = new SimpleTableDataSet(xTags, yTags, rebinWeights, resultXUnits, resultYUnits, Units.dimensionless);
        SimpleTableDataSet result = new SimpleTableDataSet(xTags, yTags, rebinData, resultXUnits, resultYUnits, Units.dimensionless, "weights", weightsTDS);
        return result;
    }

    private final int indexOf(int i, int j) {
        return i * this.ny + j;
    }

    void average(TableDataSet tds, TableDataSet weights, double[] rebinData, double[] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY) {
        double[] ycoordinate;
        int i;
        Units xUnits = tds.getXUnits();
        Units zUnits = tds.getZUnits();
        double[][] hInterpData = new double[this.nx][2];
        double[][] hInterpWeights = new double[this.nx][2];
        int[][] hInterpIndex = new int[this.nx][2];
        double[][] vInterpData = new double[2][this.ny];
        double[][] vInterpWeights = new double[2][this.ny];
        int[][] vInterpIndex = new int[2][this.ny];
        for (i = 0; i < hInterpIndex.length; ++i) {
            Arrays.fill(hInterpIndex[i], -1);
        }
        for (i = 0; i < vInterpIndex.length; ++i) {
            Arrays.fill(vInterpIndex[i], -1);
        }
        if (ddY != null) {
            ycoordinate = ddY.binCenters();
        } else {
            ycoordinate = new double[tds.getYLength(0)];
            for (int j = 0; j < ycoordinate.length; ++j) {
                ycoordinate[j] = tds.getDouble(0, j, zUnits);
            }
        }
        int nTables = tds.tableCount();
        for (int iTable = 0; iTable < nTables; ++iTable) {
            int yLength = tds.getYLength(iTable);
            int[] ibiny = new int[tds.getYLength(iTable)];
            for (int j = 0; j < ibiny.length; ++j) {
                ibiny[j] = ddY != null ? ddY.whichBin(tds.getYTagDouble(iTable, j, tds.getYUnits()), tds.getYUnits()) : j;
            }
            for (int i2 = tds.tableStart(iTable); i2 < tds.tableEnd(iTable); ++i2) {
                double w;
                double z;
                int j;
                int ibinx = ddX != null ? ddX.whichBin(tds.getXTagDouble(i2, xUnits), xUnits) : i2;
                if (ibinx < 0) {
                    for (j = 0; j < yLength; ++j) {
                        if (ibiny[j] < 0 || ibiny[j] >= this.ny) continue;
                        z = tds.getDouble(i2, j, zUnits);
                        double d = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : (w = weights.getDouble(i2, j, Units.dimensionless));
                        if (vInterpIndex[0][ibiny[j]] == -1 || ibinx > vInterpIndex[0][ibiny[j]]) {
                            vInterpData[0][ibiny[j]] = z * w;
                            vInterpWeights[0][ibiny[j]] = w;
                            vInterpIndex[0][ibiny[j]] = ibinx;
                            continue;
                        }
                        if (ibinx != vInterpIndex[0][ibiny[j]]) continue;
                        double[] dArray = vInterpData[0];
                        int n = ibiny[j];
                        dArray[n] = dArray[n] + z * w;
                        double[] dArray2 = vInterpWeights[0];
                        int n2 = ibiny[j];
                        dArray2[n2] = dArray2[n2] + w;
                    }
                    continue;
                }
                if (ibinx >= this.nx) {
                    for (j = 0; j < yLength; ++j) {
                        if (ibiny[j] < 0 || ibiny[j] >= this.ny) continue;
                        z = tds.getDouble(i2, j, zUnits);
                        double d = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : (w = weights.getDouble(i2, j, Units.dimensionless));
                        if (vInterpIndex[1][ibiny[j]] == -1 || ibinx < vInterpIndex[1][ibiny[j]]) {
                            vInterpData[1][ibiny[j]] = z * w;
                            vInterpWeights[1][ibiny[j]] = w;
                            vInterpIndex[1][ibiny[j]] = ibinx;
                            continue;
                        }
                        double[] dArray = vInterpData[1];
                        int n = ibiny[j];
                        dArray[n] = dArray[n] + z * w;
                        double[] dArray3 = vInterpWeights[1];
                        int n3 = ibiny[j];
                        dArray3[n3] = dArray3[n3] + w;
                    }
                    continue;
                }
                for (j = 0; j < yLength; ++j) {
                    z = tds.getDouble(i2, j, zUnits);
                    double d = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : (w = weights.getDouble(i2, j, Units.dimensionless));
                    if (ibiny[j] < 0) {
                        if (hInterpIndex[ibinx][0] == -1 || ibiny[j] > hInterpIndex[ibinx][0]) {
                            hInterpData[ibinx][0] = z * w;
                            hInterpWeights[ibinx][0] = w;
                            hInterpIndex[ibinx][0] = ibiny[j];
                            continue;
                        }
                        if (ibiny[j] != hInterpIndex[ibinx][0]) continue;
                        double[] dArray = hInterpData[ibinx];
                        dArray[0] = dArray[0] + z * w;
                        double[] dArray4 = hInterpWeights[ibinx];
                        dArray4[0] = dArray4[0] + w;
                        continue;
                    }
                    if (ibiny[j] >= this.ny) {
                        if (hInterpIndex[ibinx][1] == -1 || ibiny[j] < hInterpIndex[ibinx][1]) {
                            hInterpData[ibinx][1] = z * w;
                            hInterpWeights[ibinx][1] = w;
                            hInterpIndex[ibinx][1] = ibiny[j];
                            continue;
                        }
                        if (ibiny[j] != hInterpIndex[ibinx][1]) continue;
                        double[] dArray = hInterpData[ibinx];
                        dArray[1] = dArray[1] + z * w;
                        double[] dArray5 = hInterpWeights[ibinx];
                        dArray5[1] = dArray5[1] + w;
                        continue;
                    }
                    int n = this.indexOf(ibinx, ibiny[j]);
                    rebinData[n] = rebinData[n] + z * w;
                    int n4 = this.indexOf(ibinx, ibiny[j]);
                    rebinWeights[n4] = rebinWeights[n4] + w;
                }
            }
        }
        this.multiplyWeights(rebinData, rebinWeights, zUnits);
    }

    private final double linearlyInterpolate(int i0, double z0, int i1, double z1, int i) {
        double r = (double)(i - i0) / (double)(i1 - i0);
        return z0 + r * (z1 - z0);
    }

    private final void multiplyWeights(double[] data, double[] weights, Units zUnits) {
        for (int index = 0; index < data.length; ++index) {
            data[index] = weights[index] > 0.0 ? data[index] / weights[index] : zUnits.getFillDouble();
        }
    }

    void fillInterpolateX(double[] data, double[] weights, double[] xTags, double xSampleWidth) {
        int[] i1 = new int[this.nx];
        int[] i2 = new int[this.nx];
        for (int j = 0; j < this.ny; ++j) {
            int i;
            int ii1 = -1;
            int ii2 = -1;
            for (i = 0; i < this.nx; ++i) {
                if (weights[this.indexOf(i, j)] > 0.0 && ii1 == i - 1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    continue;
                }
                if (weights[this.indexOf(i, j)] > 0.0 && ii1 == -1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    continue;
                }
                if (weights[this.indexOf(i, j)] > 0.0 && ii1 < i - 1) {
                    if (ii1 <= -1) continue;
                    i1[i] = -1;
                    i2[i] = -1;
                    for (int ii = i - 1; ii >= ii1; --ii) {
                        ii2 = i;
                        i1[ii] = ii1;
                        i2[ii] = ii2;
                    }
                    ii1 = i;
                    continue;
                }
                i1[i] = -1;
                i2[i] = -1;
            }
            for (i = 0; i < this.nx; ++i) {
                if (i1[i] == -1 || !(xTags[i2[i]] - xTags[i1[i]] < xSampleWidth * 1.5)) continue;
                double a2 = (float)((xTags[i] - xTags[i1[i]]) / (xTags[i2[i]] - xTags[i1[i]]));
                double a1 = 1.0 - a2;
                data[this.indexOf((int)i, (int)j)] = data[this.indexOf(i1[i], j)] * a1 + data[this.indexOf(i2[i], j)] * a2;
                weights[this.indexOf((int)i, (int)j)] = weights[this.indexOf(i1[i], j)] * a1 + weights[this.indexOf(i2[i], j)] * a2;
            }
        }
    }

    void fillInterpolateY(double[] data, double[] weights, RebinDescriptor ddY, Datum yTagWidth) {
        int j;
        double d;
        int j2;
        int[] i1 = new int[this.ny];
        int[] i2 = new int[this.ny];
        double[] y_temp = new double[ddY.numberOfBins()];
        double[] yTags = ddY.binCenters();
        Units yTagUnits = ddY.getUnits();
        boolean log = ddY.isLog();
        if (log) {
            for (j2 = 0; j2 < this.ny; ++j2) {
                y_temp[j2] = Math.log(yTags[j2]);
            }
        } else {
            for (j2 = 0; j2 < this.ny; ++j2) {
                y_temp[j2] = yTags[j2];
            }
        }
        double[] ySampleWidth = new double[this.ny];
        double fudge = 2.0;
        if (yTagWidth == null) {
            d = 4.4942328371557893E307;
            for (j = 0; j < this.ny; ++j) {
                ySampleWidth[j] = d;
            }
        } else if (UnitsUtil.isRatiometric((Units)yTagWidth.getUnits())) {
            double perc = yTagWidth.doubleValue(Units.percentIncrease);
            for (j = 0; j < this.ny; ++j) {
                ySampleWidth[j] = yTags[j] * perc / 100.0 * fudge;
            }
        } else {
            d = yTagWidth.doubleValue(yTagUnits.getOffsetUnits());
            for (j = 0; j < this.ny; ++j) {
                ySampleWidth[j] = d * fudge;
            }
        }
        for (int i = 0; i < this.nx; ++i) {
            int j3;
            int ii1 = -1;
            int ii2 = -1;
            for (j3 = 0; j3 < this.ny; ++j3) {
                if (weights[this.indexOf(i, j3)] > 0.0 && ii1 == j3 - 1) {
                    i1[j3] = -1;
                    i2[j3] = -1;
                    ii1 = j3;
                    continue;
                }
                if (weights[this.indexOf(i, j3)] > 0.0 && ii1 == -1) {
                    i1[j3] = -1;
                    i2[j3] = -1;
                    ii1 = j3;
                    continue;
                }
                if (weights[this.indexOf(i, j3)] > 0.0 && ii1 < j3 - 1) {
                    if (ii1 <= -1) continue;
                    i1[j3] = -1;
                    i2[j3] = -1;
                    for (int jj = j3 - 1; jj >= ii1; --jj) {
                        ii2 = j3;
                        i1[jj] = ii1;
                        i2[jj] = ii2;
                    }
                    ii1 = j3;
                    continue;
                }
                i1[j3] = -1;
                i2[j3] = -1;
            }
            for (j3 = 0; j3 < this.ny; ++j3) {
                if (i1[j3] == -1 || !(yTags[i2[j3]] - yTags[i1[j3]] < ySampleWidth[j3])) continue;
                float a2 = (float)((y_temp[j3] - y_temp[i1[j3]]) / (y_temp[i2[j3]] - y_temp[i1[j3]]));
                float a1 = 1.0f - a2;
                data[this.indexOf((int)i, (int)j3)] = data[this.indexOf(i, i1[j3])] * (double)a1 + data[this.indexOf(i, i2[j3])] * (double)a2;
                weights[this.indexOf((int)i, (int)j3)] = weights[this.indexOf(i, i1[j3])] * (double)a1 + weights[this.indexOf(i, i2[j3])] * (double)a2;
            }
        }
    }

    private void enlargePixels(double[] rebinData, double[] rebinWeights) {
        int ii;
        int jj;
        int jj2;
        int ii2;
        for (ii2 = 0; ii2 < this.nx - 1; ++ii2) {
            for (jj2 = 0; jj2 < this.ny; ++jj2) {
                if (rebinWeights[this.indexOf(ii2, jj2)] != 0.0) continue;
                rebinData[this.indexOf((int)ii2, (int)jj2)] = rebinData[this.indexOf(ii2 + 1, jj2)];
                rebinWeights[this.indexOf((int)ii2, (int)jj2)] = rebinWeights[this.indexOf(ii2 + 1, jj2)];
            }
        }
        for (ii2 = this.nx - 1; ii2 > 0; --ii2) {
            for (jj2 = 0; jj2 < this.ny; ++jj2) {
                if (rebinWeights[this.indexOf(ii2, jj2)] != 0.0) continue;
                rebinData[this.indexOf((int)ii2, (int)jj2)] = rebinData[this.indexOf(ii2 - 1, jj2)];
                rebinWeights[this.indexOf((int)ii2, (int)jj2)] = rebinWeights[this.indexOf(ii2 - 1, jj2)];
            }
        }
        for (jj = 0; jj < this.nx - 1; ++jj) {
            for (ii = 0; ii < this.ny; ++ii) {
                if (rebinWeights[this.indexOf(ii, jj)] != 0.0) continue;
                rebinData[this.indexOf((int)ii, (int)jj)] = rebinData[this.indexOf(ii, jj + 1)];
                rebinWeights[this.indexOf((int)ii, (int)jj)] = rebinWeights[this.indexOf(ii, jj + 1)];
            }
        }
        for (jj = this.ny - 1; jj > 0; --jj) {
            for (ii = 0; ii < rebinData.length; ++ii) {
                if (rebinWeights[this.indexOf(ii, jj)] != 0.0) continue;
                rebinData[this.indexOf((int)ii, (int)jj)] = rebinData[this.indexOf(ii, jj - 1)];
                rebinWeights[this.indexOf((int)ii, (int)jj)] = rebinWeights[this.indexOf(ii, jj - 1)];
            }
        }
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setEnlargePixels(boolean enlargePixels) {
        this.enlargePixels = enlargePixels;
    }

    public boolean isEnlargePixels() {
        return this.enlargePixels;
    }
}

