/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class SingleVectorDataSet
implements VectorDataSet {
    Datum x;
    Datum y;
    HashMap properties;

    public SingleVectorDataSet(Datum x, Datum y, HashMap properties) {
        this.x = x;
        this.y = y;
        this.properties = new HashMap(properties);
    }

    @Override
    public Datum getDatum(int i) {
        return this.y;
    }

    @Override
    public double getDouble(int i, Units units) {
        return this.y.doubleValue(units);
    }

    @Override
    public int getInt(int i, Units units) {
        return this.y.intValue(units);
    }

    @Override
    public DataSet getPlanarView(String planeID) {
        return null;
    }

    @Override
    public String[] getPlaneIds() {
        return new String[]{""};
    }

    @Override
    public int getXLength() {
        return 1;
    }

    @Override
    public Datum getXTagDatum(int i) {
        return this.x;
    }

    @Override
    public double getXTagDouble(int i, Units units) {
        return this.x.doubleValue(units);
    }

    @Override
    public int getXTagInt(int i, Units units) {
        return this.x.intValue(units);
    }

    @Override
    public Map getProperties() {
        return new HashMap(this.properties);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Units getXUnits() {
        return this.x.getUnits();
    }

    @Override
    public Units getYUnits() {
        return this.y.getUnits();
    }
}

