/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.test;

import javax.swing.JFrame;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.SeriesRenderer;
import org.das2.util.monitor.ProgressMonitor;

public class PolynomialDataSetDescriptor
extends DataSetDescriptor {
    private Units xUnits;
    private Units yUnits;
    private double[] c;
    private double minDx;
    private double xOffset;
    private double ymin = Double.NEGATIVE_INFINITY;

    public PolynomialDataSetDescriptor(double[] c, Units xUnits, Units yUnits, Datum resolution) {
        this.xUnits = xUnits;
        this.yUnits = yUnits;
        this.c = (double[])c.clone();
        this.minDx = resolution.doubleValue(xUnits.getOffsetUnits());
        this.xOffset = 0.0;
    }

    public PolynomialDataSetDescriptor(double[] c, Units xUnits, Units yUnits, Datum resolution, Datum xOffset) {
        this(c, xUnits, yUnits, resolution);
        this.xOffset = xOffset.doubleValue(xUnits);
    }

    public void setYMin(Datum ymin) {
        this.ymin = ymin.doubleValue(this.yUnits);
    }

    @Override
    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor dasProgressMonitor) throws DasException {
        double x0 = start.doubleValue(this.xUnits) - this.xOffset;
        double x1 = end.doubleValue(this.xUnits) - this.xOffset;
        double dx = resolution == null ? this.minDx : Math.max(this.minDx, resolution.doubleValue(this.xUnits.getOffsetUnits()));
        VectorDataSetBuilder builder = new VectorDataSetBuilder(this.xUnits, this.yUnits);
        double x = x0;
        int i = 0;
        while (x < x1) {
            double y = this.eval(x);
            if (y > this.ymin) {
                builder.insertY(x, this.eval(x));
            }
            x = x0 + (double)(++i) * dx;
        }
        if (this.eval(x1) > this.ymin) {
            builder.insertY(x1, this.eval(x1));
        }
        return builder.toVectorDataSet();
    }

    private double eval(double x) {
        double y = 0.0;
        for (int ic = this.c.length - 1; ic >= 0; --ic) {
            y = this.c[ic] + x * y;
        }
        return y;
    }

    @Override
    public Units getXUnits() {
        return this.xUnits;
    }

    public static void main(String[] args) {
        double[] c = new double[]{90.0, 3.0, -1.0};
        PolynomialDataSetDescriptor dsd = new PolynomialDataSetDescriptor(c, Units.dimensionless, Units.dimensionless, Datum.create((double)1.0));
        DasAxis xAxis = new DasAxis(Datum.create((double)-10.0), Datum.create((double)10.0), 2);
        DasAxis yAxis = new DasAxis(Datum.create((double)0.0), Datum.create((double)100.0), 3);
        DasPlot plot = new DasPlot(xAxis, yAxis);
        SeriesRenderer rend = new SeriesRenderer();
        rend.setDataSetDescriptor(dsd);
        plot.addRenderer(rend);
        DasCanvas canvas = new DasCanvas(400, 400);
        canvas.add(plot, new DasRow(canvas, 0.1, 0.9), new DasColumn(canvas, 0.1, 0.9));
        JFrame frame = new JFrame("Polynomial");
        frame.setContentPane(canvas);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }
}

