/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.test;

import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;

public class RipplesDataSetDescriptor
extends DataSetDescriptor {
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;
    int nx;
    int ny;

    public RipplesDataSetDescriptor() {
        this(14.0, 17.0, 10.0, 20.0, 60.0, 15.0, 100, 100);
    }

    public RipplesDataSetDescriptor(double x1, double y1, double p1, double x2, double y2, double p2, int nx, int ny) {
        this.x1 = x1;
        this.y1 = y1;
        this.p1 = p1;
        this.x2 = x2;
        this.y2 = y2;
        this.p2 = p2;
        this.nx = nx;
        this.ny = ny;
    }

    @Override
    public Units getXUnits() {
        return Units.dimensionless;
    }

    public Units getYUnits() {
        return Units.dimensionless;
    }

    public Units getZUnits() {
        return Units.dimensionless;
    }

    @Override
    public DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        double[] x = new double[this.nx];
        double[] y = new double[this.ny];
        double[][] z = new double[this.nx][this.ny];
        monitor.setTaskSize((long)x.length);
        monitor.started();
        for (int i = 0; i < x.length; ++i) {
            x[i] = i;
            for (int j = 0; j < y.length; ++j) {
                double rad1 = Math.sqrt(((double)i - this.x1) * ((double)i - this.x1) + ((double)j - this.y1) * ((double)j - this.y1));
                double exp1 = Math.exp(-rad1 / this.p1) * Math.cos(Math.PI * rad1 / this.p1);
                double rad2 = Math.sqrt(((double)i - this.x2) * ((double)i - this.x2) + ((double)j - this.y2) * ((double)j - this.y2));
                double exp2 = Math.exp(-rad2 / this.p2) * Math.cos(Math.PI * rad2 / this.p2);
                z[i][j] = exp1 + exp2;
                if (22 >= i || i >= 24) continue;
                z[i][j] = -1.0E31f;
            }
            if (monitor.isCancelled()) break;
            monitor.setTaskProgress((long)i);
        }
        for (int j = 0; j < y.length; ++j) {
            y[j] = j;
        }
        return DefaultTableDataSet.createSimple(x, y, z);
    }
}

