/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.ParseException;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Editable;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.datum.format.EnumerationDatumFormatter;
import org.das2.event.DragRenderer;
import org.das2.event.LabelDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;

public class CrossHairRenderer
extends LabelDragRenderer
implements DragRenderer,
Editable {
    protected int xInitial;
    protected int yInitial;
    protected DasAxis XAxis;
    protected DasAxis YAxis;
    protected DasPlot parent;
    private DatumFormatter nfx;
    private DatumFormatter nfy;
    private DatumFormatter nfz;
    private FontMetrics fm;
    private Rectangle hDirtyBounds;
    private Rectangle vDirtyBounds;
    private Point crossHairLocation = null;
    private DataSetConsumer dataSetConsumer;
    private boolean allPlanesReport;
    private boolean debugging;
    private boolean snapping;
    private boolean multiLine = false;

    public CrossHairRenderer(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent);
        this.XAxis = xAxis;
        this.YAxis = yAxis;
        this.parent = parent;
        this.dataSetConsumer = dataSetConsumer;
        this.hDirtyBounds = new Rectangle();
        this.vDirtyBounds = new Rectangle();
    }

    private DatumFormatter addResolutionToFormat(DatumFormatter nfz) throws ParseException {
        String[] ss;
        String formatString = nfz.toString();
        String result = formatString.indexOf(69) == -1 ? (formatString.indexOf(46) == -1 ? formatString + ".00" : formatString + "00") : ((ss = formatString.split("E"))[0].indexOf(46) == -1 ? ss[0] + ".00E0" : ss[0] + "00E0");
        try {
            return DefaultDatumFormatterFactory.getInstance().newFormatter(result);
        }
        catch (IllegalArgumentException ex) {
            return nfz;
        }
    }

    private String getZComponentsString(QDataSet tds, Datum x, Datum y) {
        assert (tds.rank() == 3);
        try {
            int j;
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds);
            int i = DataSetUtil.closestIndex((QDataSet)xds, (Datum)x);
            WritableDataSet tds1 = Ops.copy((QDataSet)tds.slice(i));
            QDataSet yds = (QDataSet)tds1.property("DEPEND_0");
            if (yds == null) {
                yds = Ops.indgen((int)tds1.length());
            }
            try {
                yds = Ops.copy((QDataSet)yds);
                j = DataSetUtil.closestIndex((QDataSet)yds, (Datum)y);
            }
            catch (IllegalArgumentException ex) {
                return ex.getMessage();
            }
            QDataSet rgb = tds1.slice(j);
            return DataSetUtil.toString((QDataSet)rgb);
        }
        catch (InconvertibleUnitsException ex) {
            return "N/A";
        }
    }

    private String getZString(QDataSet tds, Datum x, Datum y, int[] ij) {
        int j;
        int i;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds);
        try {
            i = DataSetUtil.closestIndex((QDataSet)xds, (Datum)x);
        }
        catch (InconvertibleUnitsException ex) {
            Units u = SemanticOps.getUnits((QDataSet)xds);
            i = DataSetUtil.closestIndex((QDataSet)xds, (double)x.value(), (Units)u);
        }
        QDataSet tds1 = tds.slice(i);
        QDataSet yds = SemanticOps.xtagsDataSet((QDataSet)tds1);
        try {
            j = DataSetUtil.closestIndex((QDataSet)yds, (Datum)y);
        }
        catch (InconvertibleUnitsException ex) {
            Units u = SemanticOps.getUnits((QDataSet)yds);
            if (UnitsUtil.isIntervalOrRatioMeasurement((Units)u)) {
                j = DataSetUtil.closestIndex((QDataSet)yds, (double)y.value(), (Units)u);
            }
            return "";
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        double d = tds1.value(j);
        Datum zValue = SemanticOps.getDatum((QDataSet)tds1, (double)d);
        if (ij != null) {
            ij[0] = i;
            ij[1] = j;
        }
        try {
            if (this.dataSetConsumer instanceof TableDataSetConsumer) {
                if (!UnitsUtil.isIntervalOrRatioMeasurement((Units)zValue.getUnits())) {
                    this.nfz = new EnumerationDatumFormatter();
                } else {
                    this.nfz = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis().getDatumFormatter();
                    this.nfz = this.addResolutionToFormat(this.nfz);
                }
            } else {
                this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter("0.000");
            }
        }
        catch (ParseException pe) {
            DasProperties.getLogger().severe("failure to create formatter");
            DasAxis axis = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis();
            axis.getUnits().getDatumFormatterFactory().defaultFormatter();
        }
        StringBuilder result = zValue.isFill() ? new StringBuilder("fill") : new StringBuilder(this.nfz.grannyFormat(zValue));
        if (this.allPlanesReport) {
            QDataSet plane;
            if (this.debugging) {
                result.append("!c").append(tds.toString());
            }
            for (int iplane = 0; iplane < 50 && (plane = (QDataSet)tds.property("PLANE_" + iplane)) != null; ++iplane) {
                result.append("!c");
                String s = Ops.guessLabel((QDataSet)plane, (String)("PLANE_" + iplane));
                if (plane.rank() == 2) {
                    if (SemanticOps.isBundle((QDataSet)plane)) {
                        for (int k = 0; k < plane.length(0); ++k) {
                            result.append(s).append(": ").append(plane.slice(i).slice(k).svalue());
                        }
                    } else {
                        result.append(s).append(": ").append(this.nfz.grannyFormat(SemanticOps.getDatum((QDataSet)plane, (double)plane.value(i, j))));
                    }
                } else {
                    result.append(s).append(": ").append(this.nfz.grannyFormat(SemanticOps.getDatum((QDataSet)plane, (double)plane.value(i))));
                }
                if (!this.debugging) continue;
                result.append(" ").append(plane.toString());
            }
            if (this.debugging) {
                result.append("!ci: ").append(i).append(" j: ").append(j);
            }
        }
        return result.toString();
    }

    private int closestPointVector(QDataSet ds, Datum x, Datum y) {
        int end;
        int start;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
        DasAxis xa = this.XAxis == null ? this.parent.getXAxis() : this.XAxis;
        DasAxis ya = this.YAxis == null ? this.parent.getYAxis() : this.YAxis;
        Point2D.Double me = new Point2D.Double(xa.transform(x), ya.transform(y));
        if (xmono) {
            start = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)xa.getDataMinimum());
            end = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)xa.getDataMaximum());
        } else {
            start = 0;
            end = xds.length();
        }
        int bestIndex = -1;
        double bestXDist = Double.POSITIVE_INFINITY;
        double bestDist = Double.POSITIVE_INFINITY;
        for (int i = start; i < end; i += 100) {
            double x1 = xa.transform(xds.value(i), xunits);
            double dist = Math.abs(x1 - me.getX());
            if (!(dist < bestXDist)) continue;
            bestXDist = dist;
        }
        Units units = SemanticOps.getUnits((QDataSet)ds);
        for (int i = start; i < end; ++i) {
            Point2D.Double them;
            double dist;
            double x1 = xa.transform(xds.value(i), xunits);
            if (!(Math.abs(x1 - me.getX()) <= bestXDist) || !((dist = me.distance(them = new Point2D.Double(x1, ya.transform(ds.value(i), units)))) < bestDist)) continue;
            bestIndex = i;
            bestDist = dist;
            bestXDist = Math.abs(x1 - me.getX());
        }
        return bestIndex;
    }

    private static Datum closestCorner(DatumRange r, Datum d) {
        if (r.contains(d)) {
            return d;
        }
        if (r.min().gt(d)) {
            return r.min();
        }
        return r.max();
    }

    int getClosestTable(QDataSet r3table, Datum x, Datum y) {
        double bestDist = Double.MAX_VALUE;
        int bestDistIndex = -1;
        for (int i = 0; i < r3table.length(); ++i) {
            QDataSet table = r3table.slice(i);
            QDataSet bounds = SemanticOps.bounds((QDataSet)table);
            Datum closex = CrossHairRenderer.closestCorner(DataSetUtil.asDatumRange((QDataSet)bounds.slice(0)), x);
            Datum closey = CrossHairRenderer.closestCorner(DataSetUtil.asDatumRange((QDataSet)bounds.slice(1)), y);
            double distx = Math.abs(this.XAxis.transform(closex) - this.XAxis.transform(x));
            double disty = Math.abs(this.YAxis.transform(closey) - this.YAxis.transform(y));
            double dist = Math.sqrt(Math.pow(distx, 2.0) + Math.pow(disty, 2.0));
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            bestDistIndex = i;
        }
        return bestDistIndex;
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        DasAxis ya;
        Renderer r;
        Renderer[] rends;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHints(DasProperties.getRenderingHints());
        Object ds = this.dataSetConsumer != null ? this.dataSetConsumer.getConsumedDataSet() : ((rends = this.parent.getRenderers()).length > 0 ? rends[0].getConsumedDataSet() : null);
        if (this.dataSetConsumer instanceof Renderer && (!(r = (Renderer)this.dataSetConsumer).isActive() || r.getParent() == null)) {
            ds = null;
        }
        Datum x = null;
        Datum y = null;
        DasAxis xa = this.XAxis == null ? this.parent.getXAxis() : this.XAxis;
        DasAxis dasAxis = ya = this.YAxis == null ? this.parent.getYAxis() : this.YAxis;
        if (this.crossHairLocation == null) {
            x = xa.invTransform(p2.x);
            y = ya.invTransform(p2.y);
            this.nfy = y.getFormatter();
            this.nfx = x.getFormatter();
            String xAsString = this.nfx.format(x);
            String yAsString = this.nfy.format(y);
            String nl = this.multiLine ? "!c" : " ";
            String report = "x:" + xAsString + nl + "y:" + yAsString;
            if (ds != null) {
                QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
                if (SemanticOps.isTableDataSet((QDataSet)ds)) {
                    String zAsString;
                    QDataSet tds;
                    if (SemanticOps.isSimpleTableDataSet((QDataSet)ds)) {
                        tds = ds;
                    } else if (Schemes.isCompositeImage((QDataSet)ds)) {
                        tds = ds;
                    } else {
                        tds = SemanticOps.getSimpleTableContaining((QDataSet)ds, (Datum)x, (Datum)y);
                        if (tds == null) {
                            int i = this.getClosestTable((QDataSet)ds, x, y);
                            tds = ds.slice(i);
                        }
                    }
                    QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)tds);
                    if (this.snapping) {
                        int[] ij = new int[2];
                        zAsString = this.getZString(tds, x, y, ij);
                        x = SemanticOps.getDatum((QDataSet)xds, (double)xds.value(ij[0]));
                        xAsString = this.nfx.format(x);
                        y = SemanticOps.getDatum((QDataSet)yds, (double)yds.value(ij[1]));
                        yAsString = this.nfy.format(y);
                    } else {
                        zAsString = Schemes.isCompositeImage((QDataSet)ds) ? "!c" + this.getZComponentsString(tds, x, y) : this.getZString(tds, x, y, null);
                    }
                    report = "x:" + xAsString + nl + "y:" + yAsString + nl + "z:" + zAsString;
                } else {
                    if (this.snapping) {
                        QDataSet vds = ds;
                        if (vds.length() == 0) {
                            yAsString = "(empty dataset)";
                        } else {
                            int i = this.closestPointVector(vds, x, y);
                            if (i == -1) {
                                return new Rectangle[0];
                            }
                            x = SemanticOps.getDatum((QDataSet)xds, (double)xds.value(i));
                            y = SemanticOps.getDatum((QDataSet)vds, (double)vds.value(i));
                            xAsString = this.nfx.format(x);
                            yAsString = this.nfy.format(y);
                            if (this.allPlanesReport) {
                                QDataSet plane;
                                StringBuilder result = new StringBuilder(yAsString);
                                for (int iplane = 0; iplane < 50 && (plane = (QDataSet)vds.property("PLANE_" + iplane)) != null; ++iplane) {
                                    result.append("!c");
                                    if (plane.rank() == 1) {
                                        String n = Ops.guessLabel((QDataSet)plane, (String)("PLANE_" + iplane));
                                        String s = plane.slice(i).svalue();
                                        result.append(n).append(":").append(s);
                                        if (!this.debugging) continue;
                                        result.append(" ").append(plane.toString());
                                        continue;
                                    }
                                    if (plane.rank() != 2) continue;
                                    for (int j = 0; j < plane.length(0); ++j) {
                                        if (j > 0) {
                                            result.append("!c");
                                        }
                                        String n = Ops.guessLabel((QDataSet)Ops.slice1((QDataSet)plane, (int)j), (String)("PLANE_" + iplane));
                                        String s = plane.slice(i).slice(j).svalue();
                                        result.append(n).append(":").append(s);
                                        if (!this.debugging) continue;
                                        result.append(" ").append(plane.toString());
                                    }
                                }
                                yAsString = result.toString();
                            }
                        }
                    }
                    report = "x:" + xAsString + nl + "y:" + yAsString;
                }
            }
            this.setLabel(report);
            super.renderDrag(g, p1, p2);
        }
        if (this.snapping && x != null && y != null) {
            Point p3 = new Point((int)xa.transform(x), (int)ya.transform(y));
            this.drawCrossHair(g, p3);
        } else {
            this.drawCrossHair(g, p2);
        }
        return new Rectangle[]{this.hDirtyBounds, this.vDirtyBounds, this.dirtyBounds};
    }

    private void drawCrossHair(Graphics g0, Point p) {
        Graphics2D g = (Graphics2D)g0.create();
        g.setClip(null);
        Color color0 = Color.black;
        g.setColor(color0);
        Dimension d = this.parent.getCanvas().getSize();
        this.hDirtyBounds.setBounds(0, p.y - 1, d.width, 3);
        Stroke stroke0 = g.getStroke();
        g.setColor(ghostColor);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(0, p.y, d.width, p.y);
        g.drawLine(p.x, 0, p.x, d.height);
        g.setColor(color0);
        g.setStroke(stroke0);
        g.drawLine(0, p.y, d.width, p.y);
        this.vDirtyBounds.setBounds(p.x - 1, 0, 3, d.height);
        g.drawLine(p.x, 0, p.x, d.height);
        g.dispose();
    }

    @Override
    public void clear(Graphics g) {
        super.clear(g);
        this.parent.paintImmediately(this.hDirtyBounds);
        this.parent.paintImmediately(this.vDirtyBounds);
    }

    @Override
    public boolean isPointSelection() {
        return true;
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isAllPlanesReport() {
        return this.allPlanesReport;
    }

    public void setAllPlanesReport(boolean allPlanesReport) {
        this.allPlanesReport = allPlanesReport;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    @Override
    public Rectangle[] getDirtyBounds() {
        return new Rectangle[]{this.dirtyBounds, this.hDirtyBounds, this.vDirtyBounds};
    }

    public boolean isSnapping() {
        return this.snapping;
    }

    public void setSnapping(boolean b) {
        this.snapping = b;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }
}

