/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import org.das2.event.LabelDragRenderer;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasCanvasComponent;

public class LengthMouseModule
extends MouseModule {
    public LengthMouseModule(DasCanvasComponent parent, LengthDragRenderer dragRenderer, String label) {
        super(parent, dragRenderer, label);
    }

    @Override
    public String getDirections() {
        LengthDragRenderer r = (LengthDragRenderer)super.getDragRenderer();
        r.setNCycles(1);
        return "Press P to pin, C to copy data to clipboard, 1-9 set divisor.";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        logger.log(Level.FINE, "keyTyped {0} {1}", new Object[]{Character.valueOf(keyEvent.getKeyChar()), keyEvent.isMetaDown()});
        if (keyEvent.getKeyChar() >= '1' && keyEvent.getKeyChar() <= '9') {
            LengthDragRenderer r = (LengthDragRenderer)super.getDragRenderer();
            r.setNCycles(keyEvent.getKeyChar() - 48);
            this.parent.repaint();
        } else if (keyEvent.getKeyChar() == 'c') {
            LabelDragRenderer r = (LabelDragRenderer)this.dragRenderer;
            String text = r.label.replaceAll("!c", " ");
            StringSelection stringSelection = new StringSelection(text);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, (clipboard1, contents) -> {});
            logger.log(Level.FINE, "copied to mouse buffer: {0}", text);
        }
    }
}

