/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseRangeSelectionEvent;
import org.das2.graph.DasCanvasComponent;

public class VerticalDragRangeRenderer
implements DragRenderer {
    private Rectangle dirtyBounds;
    DasCanvasComponent parent;
    boolean updating;

    public VerticalDragRangeRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
        this.updating = true;
    }

    public VerticalDragRangeRenderer(DasCanvasComponent parent, boolean updating) {
        this(parent);
        this.updating = updating;
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        int y2 = p2.y;
        int y1 = p1.y;
        if (y2 < y1) {
            int t = y2;
            y2 = y1;
            y1 = t;
        }
        int height = y2 - y1;
        int x = p2.x;
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        if (height > 6) {
            g.drawLine(x, y1 + 3, x, y2 - 3);
        }
        g.drawLine(x + 2, y1, x - 2, y1);
        g.drawLine(x + 2, y2, x - 2, y2);
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        if (height > 6) {
            g.drawLine(x, y1 + 3, x, y2 - 3);
        }
        g.drawLine(x + 2, y1, x - 2, y1);
        g.drawLine(x + 2, y2, x - 2, y2);
        this.dirtyBounds.setLocation(x - 4, y1 - 2);
        this.dirtyBounds.add(x + 4, y2 + 2);
        return new Rectangle[]{this.dirtyBounds};
    }

    @Override
    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        MouseRangeSelectionEvent me = new MouseRangeSelectionEvent(source, p1.y, p2.y, isModified);
        return me;
    }

    @Override
    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    @Override
    public boolean isPointSelection() {
        return true;
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return this.updating;
    }
}

