/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.Datum;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.event.VerticalSliceSelectionRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.QDataSet;

public class VerticalSlicerMouseModule
extends MouseModule {
    private QDataSet ds;
    private DasAxis xaxis;
    private DasAxis yaxis;
    private Datum xlocation;
    private DataSetConsumer dataSetConsumer;
    private DataPointSelectionEvent de;
    private EventListenerList listenerList = new EventListenerList();

    public VerticalSlicerMouseModule(DasCanvasComponent parent, DataSetConsumer dataSetConsumer, DasAxis xaxis, DasAxis yaxis) {
        super(parent, new VerticalSliceSelectionRenderer(parent), "Vertical Slice");
        this.dataSetConsumer = dataSetConsumer;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static VerticalSlicerMouseModule create(DasPlot parent) {
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new VerticalSlicerMouseModule(parent, null, xaxis, yaxis);
    }

    public static VerticalSlicerMouseModule create(Renderer renderer) {
        DasPlot parent = renderer.getParent();
        return new VerticalSlicerMouseModule(parent, renderer, parent.getXAxis(), parent.getYAxis());
    }

    @Override
    public void mousePointSelected(MousePointSelectionEvent e) {
        this.de.birthMilli = System.currentTimeMillis();
        this.ds = this.dataSetConsumer.getConsumedDataSet();
        this.de.set(this.xaxis.invTransform(e.getX()), this.yaxis.invTransform(e.getY()));
        this.xlocation = this.xaxis.invTransform(e.getX());
        this.de.setDataSet(this.ds);
        this.fireDataPointSelectionListenerDataPointSelected(this.de);
    }

    @Override
    public String getDirections() {
        return "C to copy slice location to clipboard";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        logger.log(Level.FINE, "keyTyped {0} {1}", new Object[]{Character.valueOf(keyEvent.getKeyChar()), keyEvent.isMetaDown()});
        if (keyEvent.getKeyChar() == 'c') {
            String text = this.xlocation.toString();
            StringSelection stringSelection = new StringSelection(text);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, (clipboard1, contents) -> {});
            logger.log(Level.FINE, "copied to mouse buffer: {0}", text);
        }
    }

    public void addDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.add(DataPointSelectionListener.class, listener);
    }

    public void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.remove(DataPointSelectionListener.class, listener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerticalSpectrogramSlicer getSlicer() {
        Object[] listeners;
        VerticalSlicerMouseModule verticalSlicerMouseModule = this;
        synchronized (verticalSlicerMouseModule) {
            listeners = this.listenerList.getListenerList();
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof VerticalSpectrogramSlicer)) continue;
            return (VerticalSpectrogramSlicer)listeners[i];
        }
        throw new IllegalArgumentException("slicer not found.");
    }
}

