/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.LinkedHashMap;
import java.util.Scanner;
import java.util.logging.Level;
import org.das2.DasException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatter;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.PlotSymbol;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.monitor.ProgressMonitor;

public class DigitalRenderer
extends Renderer {
    protected Color color = Color.BLACK;
    public static final String PROP_COLOR = "color";
    protected Align align = Align.CENTER;
    public static final String PROP_ALIGN = "align";
    private PlotSymbol plotSymbol = DefaultPlotSymbol.NONE;
    public static final String PROP_PLOTSYMBOL = "plotSymbol";
    public static final String PROP_FORMAT = "format";
    private String format = "";
    public static final String PROP_SIZE = "size";
    double size = 0.0;
    private String fontSize = "";
    public static final String PROP_FONTSIZE = "fontSize";
    private String fillLabel = "fill";
    public static final String PROP_FILLLABEL = "fillLabel";
    Shape selectionArea;
    protected int dataSetSizeLimit = 10000;
    public static final String PROP_DATASETSIZELIMIT = "dataSetSizeLimit";
    private int firstIndex = -1;
    private int lastIndex = -1;
    private boolean dataSetClipped = false;

    public static QDataSet doAutorange(QDataSet ds) {
        if (ds.rank() == 0) {
            JoinDataSet bds = new JoinDataSet(2);
            bds.join((QDataSet)DDataSet.wrap((double[])new double[]{0.0, 1.0}));
            bds.join((QDataSet)DDataSet.wrap((double[])new double[]{0.0, 1.0}));
            return bds;
        }
        if (ds.length() == 0) {
            return null;
        }
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
        QDataSet xrange = DigitalRenderer.doRange(xds);
        QDataSet yrange = DigitalRenderer.doRange(yds);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        if (Ops.valid((QDataSet)yrange.slice(0)).value() == 0.0) {
            bds.join((QDataSet)DDataSet.wrap((double[])new double[]{0.0, 1.0}));
        } else {
            bds.join(yrange);
        }
        return bds;
    }

    private static QDataSet doRange(QDataSet ds) {
        if (UnitsUtil.isNominalMeasurement((Units)SemanticOps.getUnits((QDataSet)ds))) {
            return DataSetUtil.asDataSet((DatumRange)DatumRangeUtil.newDimensionless((double)0.0, (double)10.0));
        }
        QDataSet range = Ops.extent((QDataSet)ds);
        if (range.value(1) == range.value(0)) {
            range = !"log".equals(range.property("SCALE_TYPE")) ? DDataSet.wrap((double[])new double[]{range.value(0) - 1.0, range.value(1) + 1.0}).setUnits(SemanticOps.getUnits((QDataSet)range)) : DDataSet.wrap((double[])new double[]{range.value(0) / 10.0, range.value(1) * 10.0}).setUnits(SemanticOps.getUnits((QDataSet)range));
        }
        if (Ops.valid((QDataSet)range.slice(0)).value() == 1.0) {
            range = Ops.rescaleRangeLogLin((QDataSet)range, (double)-0.1, (double)1.1);
        }
        return range;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, oldColor, color);
        this.propertyChangeSupport.firePropertyChange("control", null, this.getControl());
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        if (align == null) {
            align = Align.CENTER;
        }
        Align oldAlign = this.align;
        this.align = align;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_ALIGN, (Object)oldAlign, (Object)align);
        this.propertyChangeSupport.firePropertyChange("control", null, this.getControl());
    }

    public PlotSymbol getPlotSymbol() {
        return this.plotSymbol;
    }

    public void setPlotSymbol(PlotSymbol plotSymbol) {
        PlotSymbol oldPlotSymbol = this.plotSymbol;
        this.plotSymbol = plotSymbol;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTSYMBOL, oldPlotSymbol, plotSymbol);
        this.updateCacheImage();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        String oldValue = this.format;
        this.format = value;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_FORMAT, oldValue, value);
        this.propertyChangeSupport.firePropertyChange("control", null, this.getControl());
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        double oldValue = this.size;
        this.size = size;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_FORMAT, oldValue, size);
        this.propertyChangeSupport.firePropertyChange("control", null, this.getControl());
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public String getFillLabel() {
        return this.fillLabel;
    }

    public void setFillLabel(String fillLabel) {
        String oldFillLabel = this.fillLabel;
        this.fillLabel = fillLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_FILLLABEL, oldFillLabel, fillLabel);
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.size = this.getDoubleControl(PROP_SIZE, this.size);
        this.color = this.getColorControl(PROP_COLOR, this.color);
        this.fontSize = this.getControl(PROP_FONTSIZE, this.fontSize);
        this.format = this.getControl(PROP_FORMAT, this.format);
        try {
            this.align = Align.valueOf(this.getControl(PROP_ALIGN, "CENTER"));
        }
        catch (IllegalArgumentException ex) {
            this.align = Align.CENTER;
        }
        this.fillLabel = this.getControl(PROP_FILLLABEL, this.fillLabel);
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_SIZE, String.valueOf(this.size));
        controls.put(PROP_FONTSIZE, this.fontSize);
        controls.put(PROP_COLOR, DigitalRenderer.encodeColorControl(this.color));
        controls.put(PROP_FORMAT, this.format);
        controls.put(PROP_ALIGN, this.align.toString());
        controls.put(PROP_FILLLABEL, this.fillLabel);
        return Renderer.formatControl(controls);
    }

    public Shape selectionArea() {
        return this.selectionArea == null ? SelectionUtil.NULL : this.selectionArea;
    }

    public int getDataSetSizeLimit() {
        return this.dataSetSizeLimit;
    }

    public void setDataSetSizeLimit(int dataSetSizeLimit) {
        int oldDataSetSizeLimit = this.dataSetSizeLimit;
        this.dataSetSizeLimit = dataSetSizeLimit;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASETSIZELIMIT, oldDataSetSizeLimit, dataSetSizeLimit);
    }

    private void updateFirstLast(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet) {
        int index;
        int ixmax;
        int ixmin;
        QDataSet wds;
        if (dataSet == null) {
            return;
        }
        if (!UnitsUtil.isIntervalOrRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)dataSet))) {
            this.firstIndex = 0;
            this.lastIndex = Math.min(dataSet.length(), this.dataSetSizeLimit);
            return;
        }
        if (dataSet.rank() == 0) {
            wds = SemanticOps.weightsDataSet((QDataSet)dataSet);
        } else if (dataSet.rank() == 1) {
            wds = SemanticOps.weightsDataSet((QDataSet)dataSet);
        } else {
            if (Schemes.isBundleDescriptor((QDataSet)dataSet)) {
                this.firstIndex = 0;
                this.lastIndex = dataSet.length();
                return;
            }
            if (SemanticOps.isSimpleTableDataSet((QDataSet)dataSet)) {
                wds = SemanticOps.weightsDataSet((QDataSet)DataSetOps.slice1((QDataSet)dataSet, (int)0));
            } else {
                this.firstIndex = 0;
                this.lastIndex = Math.min(dataSet.length(), this.dataSetSizeLimit);
                return;
            }
        }
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
        boolean xMono = SemanticOps.isMonotonic((QDataSet)xds);
        if (SemanticOps.isBins((QDataSet)dataSet)) {
            ixmin = 0;
            ixmax = dataSet.length();
        } else if (xMono) {
            Rectangle plotBounds;
            DatumRange visibleRange = xAxis.getDatumRange();
            DasPlot parent = this.getParent();
            if (parent != null && parent.isOverSize() && (plotBounds = parent.getUpdateImageBounds()) != null) {
                visibleRange = new DatumRange(xAxis.invTransform(plotBounds.x), xAxis.invTransform(plotBounds.x + plotBounds.width));
            }
            ixmin = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
            ixmax = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1;
        } else {
            ixmin = 0;
            ixmax = dataSet.length();
        }
        double x = Double.NaN;
        Units xUnits = SemanticOps.getUnits((QDataSet)xds);
        for (index = ixmin; index < ixmax; ++index) {
            boolean isValid;
            x = xds.value(index);
            boolean bl = isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
            if (!isValid) continue;
            this.firstIndex = index++;
            break;
        }
        if (this.firstIndex == -1) {
            this.lastIndex = ixmax;
            this.firstIndex = ixmax;
        }
        int pointsPlotted = 0;
        for (index = this.firstIndex; index < ixmax && pointsPlotted < this.dataSetSizeLimit; ++index) {
            boolean isValid;
            boolean bl = isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
            if (!isValid) continue;
            ++pointsPlotted;
        }
        this.dataSetClipped = index < ixmax && pointsPlotted == this.dataSetSizeLimit;
        this.lastIndex = index;
    }

    @Override
    public void render(Graphics2D g, DasAxis xAxis, DasAxis yAxis) {
        g.setColor(this.color);
        DasPlot parent = this.getParent();
        if (this.ds == null) {
            if (this.getLastException() != null) {
                this.renderException(g, xAxis, yAxis, this.lastException);
            } else {
                parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            }
            return;
        }
        if (this.ds.rank() > 0 && this.ds.length() == 0) {
            this.getParent().postMessage((Renderer)this, "dataset is empty", Level.INFO, null, null);
            return;
        }
        try {
            if (this.ds.rank() == 0 || this.ds.rank() == 1 && SemanticOps.isRank1Bundle((QDataSet)this.ds)) {
                this.renderRank0(this.ds, g, xAxis, yAxis);
            } else if (SemanticOps.isBins((QDataSet)this.ds)) {
                this.renderRank0(this.ds, g, xAxis, yAxis);
            } else if (UnitsUtil.isOrdinalMeasurement((Units)SemanticOps.getUnits((QDataSet)this.ds))) {
                this.renderRank0(this.ds, g, xAxis, yAxis);
            } else if (!SemanticOps.isTableDataSet((QDataSet)this.ds)) {
                this.renderRank1(this.ds, g, xAxis, yAxis, this.firstIndex, this.lastIndex);
            } else if (this.ds.rank() == 3) {
                this.renderRank3(this.ds, g, xAxis, yAxis);
            } else if (Schemes.isBundleDescriptor((QDataSet)this.ds)) {
                this.renderRank0(Ops.dataset((Object)Units.nominal().createDatum((Object)this.ds.toString())), g, xAxis, yAxis);
            } else if (this.ds.rank() == 2) {
                this.renderRank2(this.ds, g, xAxis, yAxis);
            } else {
                parent.postMessage((Renderer)this, "unable to render rank " + this.ds.rank() + " data", DasPlot.WARNING, null, null);
            }
        }
        catch (InconvertibleUnitsException ex) {
            parent.postMessage((Renderer)this, "inconvertible units", DasPlot.INFO, null, null);
        }
    }

    private String getFormat(QDataSet zds) {
        String form = this.format;
        String dsformat = (String)zds.property("FORMAT");
        if (form.length() == 0 && dsformat != null) {
            form = dsformat.trim();
        }
        if (form.length() == 0) {
            form = "%.2f";
        }
        return form;
    }

    public static char typeForFormat(String form) {
        int i = form.indexOf("%");
        if (i == -1) {
            throw new IllegalArgumentException("format should contain %");
        }
        form = form.substring(i + 1);
        while (i > 0 && form.length() > 0 && form.charAt(0) == '%') {
            form = form.substring(i + 1);
            i = form.indexOf("%");
        }
        if (i == -1) {
            throw new IllegalArgumentException("format should contain % where the number is inserted, like %f");
        }
        Scanner s = new Scanner(form);
        String sc = s.findInLine("[xXdocCfeE]");
        if (sc == null) {
            throw new IllegalArgumentException("expected format ending in one of: x,X,d,o,c,C,f,e or E");
        }
        return sc.charAt(0);
    }

    public static String formatDatum(String form, Datum d, char type) {
        boolean isLongs = false;
        boolean isInts = false;
        Units u = d.getUnits();
        switch (type) {
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                isLongs = true;
                break;
            }
            case 'C': 
            case 'c': {
                isInts = true;
                break;
            }
        }
        DatumFormatter df = d.getFormatter();
        String s = df instanceof DefaultDatumFormatter ? (isInts ? String.format(form, (int)d.doubleValue(u)) : (isLongs ? String.format(form, (long)d.doubleValue(u)) : String.format(form, d.doubleValue(u)))) : d.getFormatter().format(d, u);
        return s;
    }

    private void renderRank0(QDataSet ds, Graphics2D g, DasAxis xAxis, DasAxis yAxis) {
        int x;
        int y;
        QDataSet ds1;
        StringBuilder sb;
        String s;
        DasPlot parent = this.getParent();
        Font f0 = g.getFont();
        if (this.size > 0.0) {
            Font f = f0.deriveFont((float)this.size);
            g.setFont(f);
        } else {
            this.setUpFont(g, this.fontSize);
        }
        if (ds.rank() == 0) {
            String form = this.getFormat(ds);
            char type = DigitalRenderer.typeForFormat(form);
            s = DigitalRenderer.formatDatum(form, DataSetUtil.asDatum((QDataSet)ds), type);
        } else if (SemanticOps.isBins((QDataSet)ds)) {
            sb = new StringBuilder();
            String label = (String)ds.property("LABEL");
            if (label == null) {
                label = (String)ds.property("NAME");
            }
            if (label != null) {
                sb.append(label).append("=");
            }
            sb.append(DataSetUtil.toString((QDataSet)ds));
            s = sb.toString();
        } else if (SemanticOps.isBundle((QDataSet)ds)) {
            sb = new StringBuilder();
            for (int i = 0; i < Math.min(4, ds.length()); ++i) {
                String label;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((label = (String)(ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i)).property("LABEL")) == null) {
                    label = (String)ds1.property("NAME");
                }
                if (label != null) {
                    sb.append(label).append("=");
                }
                sb.append(DataSetUtil.asDatum((QDataSet)ds1).toString());
            }
            s = sb.toString();
        } else {
            sb = new StringBuilder();
            for (int i = 0; i < Math.min(4, ds.length()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                ds1 = ds.slice(i);
                sb.append(DataSetUtil.asDatum((QDataSet)ds1).toString());
            }
            if (ds.length() > 4) {
                sb.append(", ...");
            }
            s = sb.toString();
        }
        FontMetrics fm = g.getFontMetrics();
        int offs = 5;
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString((Graphics)g, s);
        switch (this.align) {
            case NE: 
            case NW: {
                y = parent.getRow().getDMinimum() + fm.getAscent() + offs;
                break;
            }
            case CENTER: {
                y = parent.getRow().getDMinimum() + fm.getAscent() + offs;
                break;
            }
            default: {
                y = parent.getRow().getDMaximum() - (int)gtr.getDescent() - offs;
            }
        }
        switch (this.align) {
            case NW: 
            case SW: {
                x = parent.getColumn().getDMinimum() + offs;
                break;
            }
            case CENTER: {
                x = parent.getColumn().getDMinimum() + offs;
                break;
            }
            default: {
                x = parent.getColumn().getDMaximum() - offs - (int)gtr.getWidth();
            }
        }
        gtr.draw((Graphics)g, (float)x, (float)y);
    }

    private void renderRank1(QDataSet ds, Graphics2D g, DasAxis xAxis, DasAxis yAxis, int firstIndexx, int lastIndexx) {
        int widthSymbolOffset;
        Font f0 = g.getFont();
        if (this.size > 0.0) {
            Font f = f0.deriveFont((float)this.size);
            g.setFont(f);
        } else {
            this.setUpFont(g, this.fontSize);
        }
        FontMetrics fm = g.getFontMetrics();
        int ha = 0;
        switch (this.align) {
            case NE: 
            case NW: {
                ha = fm.getAscent();
                if (this.plotSymbol == DefaultPlotSymbol.NONE) break;
                ha += 3;
                break;
            }
            case CENTER: {
                ha = fm.getAscent() / 2;
                break;
            }
            default: {
                if (this.plotSymbol == DefaultPlotSymbol.NONE) break;
                ha -= 3;
            }
        }
        float wa = 0.0f;
        switch (this.align) {
            case NE: 
            case SE: {
                wa = 1.0f;
                widthSymbolOffset = -3;
                break;
            }
            case CENTER: {
                wa = 0.5f;
                widthSymbolOffset = 0;
                break;
            }
            default: {
                widthSymbolOffset = 3;
            }
        }
        GeneralPath shape = new GeneralPath();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
        QDataSet zds = (QDataSet)yds.property("PLANE_0");
        if (zds == null && ds.rank() == 2 && ds.length(0) == 3) {
            zds = DataSetOps.unbundle((QDataSet)ds, (int)2);
        }
        if (zds == null) {
            zds = yds;
        }
        Units u = SemanticOps.getUnits((QDataSet)zds);
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        Units yunits = SemanticOps.getUnits((QDataSet)yds);
        String form = this.getFormat(zds);
        DasPlot parent = this.getParent();
        if (!xunits.isConvertibleTo(xAxis.getUnits())) {
            parent.postMessage((Renderer)this, "inconvertible xaxis units", DasPlot.INFO, null, null);
            if (UnitsUtil.isRatioMeasurement((Units)xunits)) {
                xunits = xAxis.getUnits();
            } else {
                return;
            }
        }
        if (!yunits.isConvertibleTo(yAxis.getUnits())) {
            parent.postMessage((Renderer)this, "inconvertible yaxis units", DasPlot.INFO, null, null);
            if (UnitsUtil.isRatioMeasurement((Units)yunits)) {
                yunits = yAxis.getUnits();
            } else {
                return;
            }
        }
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)zds);
        char type = DigitalRenderer.typeForFormat(form);
        Rectangle axisBounds = parent.getAxisClip();
        for (int i = firstIndexx; i < lastIndexx; ++i) {
            int iy;
            String s;
            int ix = (int)xAxis.transform(xds.value(i), xunits);
            if (wds.value(i) > 0.0) {
                Datum d = u.createDatum(zds.value(i));
                Datum y = yunits.createDatum(yds.value(i));
                s = DigitalRenderer.formatDatum(form, d, type);
                iy = (int)yAxis.transform(y);
                if (this.plotSymbol != DefaultPlotSymbol.NONE) {
                    this.plotSymbol.draw(g, ix, yAxis.transform(y), 3.0f, FillStyle.STYLE_SOLID);
                }
                iy += ha;
            } else {
                Datum y = yunits.createDatum(yds.value(i));
                s = this.fillLabel;
                if (y.isFill()) {
                    iy = yAxis.getRow().getDMaximum();
                } else {
                    iy = (int)yAxis.transform(y);
                    if (this.plotSymbol != DefaultPlotSymbol.NONE) {
                        this.plotSymbol.draw(g, ix, yAxis.transform(y), 3.0f, FillStyle.STYLE_SOLID);
                    }
                    iy += ha;
                }
            }
            if ((double)wa > 0.0) {
                ix -= (int)((float)fm.stringWidth(s) * wa);
            }
            gtr.setString((Graphics)g, s);
            Rectangle r = gtr.getBounds();
            r.translate(ix += widthSymbolOffset, iy);
            if (r.intersects(axisBounds)) {
                gtr.draw((Graphics)g, (float)ix, (float)iy);
                shape.append(r, false);
            }
            if (!this.dataSetClipped) continue;
            if (this.getParent() != null) {
                this.getParent().postMessage((Renderer)this, "" + this.dataSetSizeLimit + " data point limit reached", DasPlot.WARNING, null, null);
            }
            return;
        }
        this.selectionArea = shape;
        g.setFont(f0);
    }

    private void renderRank2(QDataSet ds, Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        QDataSet ds1;
        if (this.firstIndex < this.lastIndex) {
            ds1 = ds.trim(this.firstIndex, this.lastIndex);
            if (ds1.property("DEPEND_0") == null) {
                ds1 = Ops.putProperty((QDataSet)ds1, (String)"DEPEND_0", (Object)Ops.linspace((double)this.firstIndex, (double)(this.lastIndex - 1), (int)(this.lastIndex - this.firstIndex)));
            }
            if (ds1.property("DEPEND_1") == null) {
                ds1 = Ops.putProperty((QDataSet)ds1, (String)"DEPEND_1", (Object)IndexGenDataSet.lastindex((QDataSet)ds1));
            }
        } else {
            ds1 = ds;
            if (ds1.property("DEPEND_0") == null) {
                ds1 = Ops.putProperty((QDataSet)ds1, (String)"DEPEND_0", (Object)Ops.linspace((double)this.firstIndex, (double)(this.lastIndex - 1), (int)(this.firstIndex - this.lastIndex)));
            }
            if (ds1.property("DEPEND_1") == null) {
                ds1 = Ops.putProperty((QDataSet)ds1, (String)"DEPEND_1", (Object)IndexGenDataSet.lastindex((QDataSet)ds1));
            }
        }
        QDataSet fds = DataSetOps.flattenRank2((QDataSet)ds1);
        this.renderRank1(fds, g1, xAxis, yAxis, 0, fds.length());
    }

    private void renderRank3(QDataSet ds, Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet ds1 = ds.slice(i);
            QDataSet fds = DataSetOps.flattenRank2((QDataSet)ds1);
            this.renderRank1(fds, g1, xAxis, yAxis, 0, fds.length());
        }
    }

    @Override
    public boolean acceptContext(int x, int y) {
        if (this.selectionArea != null) {
            return this.selectionArea.contains(x, y);
        }
        return false;
    }

    @Override
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        super.incrementUpdateCount();
        QDataSet lds = this.getDataSet();
        if (lds == null) {
            return;
        }
        if (!(lds.rank() == 0 || this.getDataSet().rank() == 1 && SemanticOps.isRank1Bundle((QDataSet)lds) || lds.length() == 0)) {
            try {
                this.updateFirstLast(xAxis, yAxis, lds);
            }
            catch (InconvertibleUnitsException inconvertibleUnitsException) {
                // empty catch block
            }
        }
    }

    public static enum Align {
        SW,
        NW,
        NE,
        SE,
        CENTER;

    }
}

